/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.rest;

import io.meeds.pwa.model.PwaManifestUpdate;
import io.meeds.pwa.service.PwaManifestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import org.exoplatform.portal.branding.model.BrandingFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"manifest"})
@Tag(name="manifest", description="Managing PWA Manifest")
public class PwaManifestRest {
    @Autowired
    private PwaManifestService pwaManifestService;

    @GetMapping
    @Operation(summary="Get PWA Manifest file", description="Get PWA Manifest file", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PWA Manifest retrieved"), @ApiResponse(responseCode="304", description="PWA Manifest not modified")})
    public ResponseEntity<String> getManifest(WebRequest request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @RequestParam(name="v", required=false) String version) {
        String eTag = String.valueOf(this.pwaManifestService.getManifestHash(request.getRemoteUser()));
        if (request.checkNotModified(eTag)) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(String.valueOf(eTag))).lastModified(Instant.now())).cacheControl(CacheControl.maxAge((Duration)Duration.ofMinutes(1L)))).body((Object)this.pwaManifestService.getManifestContent(request.getRemoteUser()));
    }

    @PutMapping
    @Secured(value={"administrators"})
    @Operation(summary="Update Manifest information", description="Update Manifest information", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Manifest information updated")})
    public void updateManifest(WebRequest request, @RequestBody PwaManifestUpdate manifestUpdate) {
        this.pwaManifestService.updateManifest(manifestUpdate, request.getRemoteUser());
    }

    @GetMapping(value={"/largeIcon/{version}/{size}.png"})
    @Operation(summary="Get PWA Manifest large icon file", description="Get PWA Manifest large icon file", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Icon file retrieved"), @ApiResponse(responseCode="304", description="Icon file not modified")})
    public ResponseEntity<InputStreamResource> getManifestLargeIcon(WebRequest request, @Parameter(description="Dimensions of size", required=true) @PathVariable(value="size") String size, @Parameter(description="VersionId of the icon", required=true) @PathVariable(value="version") String version) {
        String realSize = size + "x" + size;
        InputStream inputStream = this.getBrandingFileResponse(request, this.pwaManifestService.getLargeIcon(realSize));
        return inputStream == null ? null : ResponseEntity.ok().contentType(MediaType.IMAGE_PNG).body((Object)new InputStreamResource(inputStream));
    }

    @GetMapping(value={"/smallIcon/{version}/{size}.png"})
    @Operation(summary="Get PWA Manifest small icon file", description="Get PWA Manifest small icon file", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Icon file retrieved"), @ApiResponse(responseCode="304", description="Icon file not modified")})
    public ResponseEntity<InputStreamResource> getManifestSmallIcon(WebRequest request, @Parameter(description="Dimensions of size", required=true) @PathVariable(value="size") String size, @Parameter(description="VersionId of the icon", required=true) @PathVariable(value="version") String version) {
        String realSize = size + "x" + size;
        InputStream inputStream = this.getBrandingFileResponse(request, this.pwaManifestService.getSmallIcon(realSize));
        return inputStream == null ? null : ResponseEntity.ok().contentType(MediaType.IMAGE_PNG).body((Object)new InputStreamResource(inputStream));
    }

    private InputStream getBrandingFileResponse(WebRequest request, BrandingFile iconFile) {
        if (iconFile == null || iconFile.getData() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "pwaManifest.imageFileNotFound");
        }
        long lastUpdated = iconFile.getUpdatedDate();
        String eTag = String.valueOf(lastUpdated);
        if (request.checkNotModified(eTag)) {
            return null;
        }
        return new ByteArrayInputStream(iconFile.getData());
    }
}

