/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.social;

import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationAction;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseActivityPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String PWA_NOTIFICATION_MARK_LIKE_ACTION = "like";
    private static final String PWA_NOTIFICATION_MARK_LIKE_LABEL = "pwa.notification.action.like";
    @Autowired
    protected ResourceBundleService resourceBundleService;
    @Autowired
    protected PermanentLinkService permanentLinkService;
    @Autowired
    protected ActivityManager activityManager;
    @Autowired
    protected IdentityManager identityManager;

    public void handleAction(NotificationInfo notification, String action, String username) {
        if (StringUtils.equals((CharSequence)action, (CharSequence)PWA_NOTIFICATION_MARK_LIKE_ACTION)) {
            String activityId = this.getPostId(notification);
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            Identity identity = this.identityManager.getOrCreateUserIdentity(username);
            this.activityManager.saveLike(activity, identity);
        }
    }

    public void process(PwaNotificationMessage notificationMessage, NotificationInfo notification, LocaleConfig localeConfig) {
        ArrayList<PwaNotificationAction> notificationActions = notificationMessage.getActions();
        if (CollectionUtils.isEmpty((Collection)notificationMessage.getActions()) || notificationActions.stream().noneMatch(a -> StringUtils.equals((CharSequence)a.getAction(), (CharSequence)PWA_NOTIFICATION_MARK_LIKE_ACTION))) {
            String identityId;
            String activityId = this.getPostId(notification);
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            String username = notification.getTo();
            String string = identityId = StringUtils.isBlank((CharSequence)username) ? null : this.identityManager.getOrCreateUserIdentity(username).getId();
            if (StringUtils.isNotBlank(identityId) && !StringUtils.equals((CharSequence)activity.getPosterId(), (CharSequence)identityId) && (activity.getLikeIdentityIds() == null || Stream.of(activity.getLikeIdentityIds()).noneMatch(id -> StringUtils.equals((CharSequence)id, (CharSequence)identityId)))) {
                notificationActions = notificationActions == null ? new ArrayList<PwaNotificationAction>() : new ArrayList(notificationActions);
                notificationActions.add(new PwaNotificationAction(this.resourceBundleService.getSharedString(PWA_NOTIFICATION_MARK_LIKE_LABEL, localeConfig.getLocale()), PWA_NOTIFICATION_MARK_LIKE_ACTION));
                notificationMessage.setActions(notificationActions);
            }
        }
    }

    public String getPostId(NotificationInfo notification) {
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
        String replyToCommentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_REPLY_ID.getKey());
        return Arrays.asList(replyToCommentId, commentId, activityId).stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getPostContent(NotificationInfo notification) {
        ExoSocialActivity post = this.getActivityManager().getActivity(this.getPostId(notification));
        return post == null ? "" : this.getActivityContent(post);
    }

    public String getActivityContent(NotificationInfo notification) {
        ExoSocialActivity activity = this.getActivity(notification);
        return activity == null ? "" : this.getActivityContent(activity);
    }

    public String getCommentContent(NotificationInfo notification) {
        ExoSocialActivity comment = this.getComment(notification);
        return comment == null ? "" : this.getActivityContent(comment);
    }

    private String getActivityContent(ExoSocialActivity activity) {
        String html = this.getActivityManager().getActivityTitle(activity);
        return this.htmlToText(html);
    }

    public ExoSocialActivity getActivity(NotificationInfo notification) {
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = this.getActivityManager().getActivity(activityId);
        if (activity.isComment()) {
            activity = this.getActivityManager().getParentActivity(activity);
        }
        return activity;
    }

    public ExoSocialActivity getComment(NotificationInfo notification) {
        String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
        return commentId == null ? null : this.getActivityManager().getActivity(commentId);
    }

    protected String getSender(NotificationInfo notification) {
        String userId = notification.getFrom();
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("poster");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("username");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("profile");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("sender");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("modifier");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("MODIFIER_ID");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("SENDER_ID");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("request_from");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("likersId");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("creator");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = (String)notification.getOwnerParameter().get("creatorId");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(userId);
        if (identity != null) {
            return identity.getRemoteId();
        }
        if (StringUtils.isNumeric((CharSequence)userId) && (identity = this.identityManager.getIdentity(Long.parseLong(userId))) != null) {
            return identity.getRemoteId();
        }
        return null;
    }

    @Generated
    public ActivityManager getActivityManager() {
        return this.activityManager;
    }

    @Generated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

