/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.application.ResourceRequestFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PwaSwService {
    private static final Log LOG = ExoLogger.getLogger(PwaSwService.class);
    private static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    private static final String DEVELOPMENT_VARIABLE = "@development@";
    private static final String ASSETS_VERSION_VARIABLE = "@assets-version@";
    private static AtomicReference<String> serviceWorkerContent = new AtomicReference();
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${pwa.service.worker.path:jar:/pwa/service-worker.js}")
    private String serviceWorkerPath;

    public String getContent() {
        if (serviceWorkerContent.get() == null || DEVELOPPING) {
            try (InputStream is = this.configurationManager.getInputStream(this.serviceWorkerPath);){
                if (is == null) {
                    LOG.warn("Can't find service worker path: {}", new Object[]{this.serviceWorkerPath});
                } else {
                    String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    content = this.replaceVariables(content);
                    serviceWorkerContent.set(content);
                }
            }
            catch (Exception e) {
                LOG.warn("Can't find service worker path: {}", new Object[]{this.serviceWorkerPath, e});
                return null;
            }
        }
        return serviceWorkerContent.get();
    }

    private String replaceVariables(String content) {
        if (ResourceRequestFilter.version != null) {
            content = content.replace(ASSETS_VERSION_VARIABLE, ResourceRequestFilter.version);
        }
        content = content.replace(DEVELOPMENT_VARIABLE, String.valueOf(DEVELOPPING));
        return content;
    }
}

