/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.rest.PwaNotificationRest;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={PwaNotificationRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class PwaNotificationRestTest {
    private static final String ACTION_PARAM = "action";
    private static final long NOTIFICATION_ID = 155L;
    private static final String REST_PATH = "/notifications";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private PwaNotificationService pwaNotificationService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @Mock
    private PwaNotificationMessage pwaNotificationMessage;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getNotificationWhenNotFound() throws Exception {
        Mockito.when((Object)this.pwaNotificationService.getNotification(155L, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getNotificationWhenNotPermitted() throws Exception {
        Mockito.when((Object)this.pwaNotificationService.getNotification(155L, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getNotification() throws Exception {
        Mockito.when((Object)this.pwaNotificationService.getNotification(155L, SIMPLE_USER)).thenReturn((Object)this.pwaNotificationMessage);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void updateNotificationPropertyWhenNotFound() throws Exception {
        ((PwaNotificationService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.pwaNotificationService)).updateNotification(155L, "markRead", SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()).contentType("application/x-www-form-urlencoded").formField(ACTION_PARAM, new String[]{"markRead"}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateNotificationPropertyWhenNotPermitted() throws Exception {
        ((PwaNotificationService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.pwaNotificationService)).updateNotification(155L, "markRead", SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()).contentType("application/x-www-form-urlencoded").formField(ACTION_PARAM, new String[]{"markRead"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateNotificationProperty() throws Exception {
        Mockito.when((Object)this.pwaNotificationService.getNotification(155L, SIMPLE_USER)).thenReturn((Object)this.pwaNotificationMessage);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/notifications/155", (Object[])new Object[0]).with(this.testSimpleUser()).contentType("application/x-www-form-urlencoded").formField(ACTION_PARAM, new String[]{"markRead"}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PwaNotificationService)Mockito.verify((Object)this.pwaNotificationService)).updateNotification(155L, "markRead", SIMPLE_USER);
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

