/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.pwa.model.PwaNotificationAction;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.plugin.DefaultPwaNotificationPlugin;
import io.meeds.pwa.service.PwaManifestService;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.pwa.service.PwaSubscriptionService;
import io.meeds.pwa.storage.PwaNotificationStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PwaNotificationService.class})
public class PwaNotificationServiceTest {
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    private static final String SUBSCRIPTION_ENDPOINT = "http://localhost/endpoint";
    private static final PluginKey PLUGIN_KEY = PluginKey.key((String)"TestPlugin");
    private static final long NOTIFICATION_ID = 12L;
    private static final String TEST_USER = "testUser";
    @MockBean
    private PwaManifestService pwaManifestService;
    @MockBean
    private PwaSubscriptionService pwaSubscriptionService;
    @MockBean
    private PwaNotificationStorage pwaNotificationStorage;
    @MockBean
    private WebNotificationService webNotificationService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private OrganizationService organizationService;
    @MockBean
    private LocaleConfigService localeConfigService;
    @MockBean
    private ResourceBundleService resourceBundleService;
    @MockBean
    private DefaultPwaNotificationPlugin defaultPwaNotificationPlugin;
    @MockBean
    private PushService pushService;
    @Autowired
    private PwaNotificationService pwaNotificationService;
    @Mock
    private NotificationInfo notification;
    @Mock
    private UserProfile userProfile;
    @Mock
    private UserProfileHandler userProfileHandler;
    @Mock
    private PwaNotificationMessage notificationMessage;
    @Mock
    private UserPushSubscription userPushSubscription;
    @Mock
    private HttpResponse httpResponse;
    @Mock
    private StatusLine statusLine;

    @Test
    public void getNotification() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pwaNotificationService.getNotification(12L, TEST_USER));
        this.mockWebNotificationNoAccess();
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pwaNotificationService.getNotification(12L, TEST_USER));
        this.mockWebNotification();
        this.mockUserLanguage();
        Mockito.when((Object)this.defaultPwaNotificationPlugin.process((NotificationInfo)ArgumentMatchers.eq((Object)this.notification), (LocaleConfig)ArgumentMatchers.any())).thenReturn((Object)this.notificationMessage);
        PwaNotificationMessage result = this.pwaNotificationService.getNotification(12L, TEST_USER);
        Assertions.assertEquals((Object)this.notificationMessage, (Object)result);
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setActions((List)ArgumentMatchers.argThat(list -> list.size() == 1 && ((PwaNotificationAction)list.get(0)).getAction().equals("markRead")));
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setRequireInteraction(true);
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setRenotify(true);
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setSilent(false);
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setLang("fr");
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setDir("ltr");
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setTag(String.valueOf(12L));
        ((PwaNotificationMessage)Mockito.verify((Object)this.notificationMessage)).setUrl("/");
    }

    @Test
    public void updateNotification() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pwaNotificationService.updateNotification(12L, "markRead", TEST_USER));
        this.mockWebNotificationNoAccess();
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pwaNotificationService.updateNotification(12L, "markRead", "testUser2"));
        this.mockWebNotification();
        this.pwaNotificationService.updateNotification(12L, "markRead", TEST_USER);
        ((WebNotificationService)Mockito.verify((Object)this.webNotificationService)).markRead(String.valueOf(12L));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.defaultPwaNotificationPlugin});
        String action = "otherAction";
        this.pwaNotificationService.updateNotification(12L, action, TEST_USER);
        ((DefaultPwaNotificationPlugin)Mockito.verify((Object)this.defaultPwaNotificationPlugin)).handleAction(this.notification, action, TEST_USER);
    }

    @Test
    public void create() throws Exception {
        ScheduledFuture future = this.pwaNotificationService.create(12L);
        Assertions.assertNull((Object)future);
        Mockito.when((Object)this.pwaManifestService.isPwaEnabled()).thenReturn((Object)true);
        future = this.pwaNotificationService.create(12L);
        Assertions.assertNotNull((Object)future);
        Assertions.assertEquals((int)0, (int)((Integer)future.get()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
        this.mockWebNotification();
        Mockito.when((Object)this.pwaSubscriptionService.getSubscriptions(TEST_USER)).thenReturn(Collections.singletonList(this.userPushSubscription));
        Mockito.when((Object)this.userPushSubscription.getEndpoint()).thenReturn((Object)SUBSCRIPTION_ENDPOINT);
        Mockito.when((Object)this.userPushSubscription.getId()).thenReturn((Object)SUBSCRIPTION_ID);
        Mockito.when((Object)this.pushService.send((Notification)ArgumentMatchers.any())).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)401);
        future = this.pwaNotificationService.create(12L);
        Assertions.assertNotNull((Object)future);
        Assertions.assertEquals((int)0, (int)((Integer)future.get()));
        ((PwaSubscriptionService)Mockito.verify((Object)this.pwaSubscriptionService, (VerificationMode)Mockito.never())).deleteSubscription(SUBSCRIPTION_ID, TEST_USER, false);
        ((PushService)Mockito.verify((Object)this.pushService)).send((Notification)ArgumentMatchers.argThat(n -> "WEB_NOTIFICATION:12:open".equals(new String(n.getPayload()))));
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)410);
        future = this.pwaNotificationService.create(12L);
        Assertions.assertNotNull((Object)future);
        Assertions.assertEquals((int)0, (int)((Integer)future.get()));
        ((PwaSubscriptionService)Mockito.verify((Object)this.pwaSubscriptionService)).deleteSubscription(SUBSCRIPTION_ID, TEST_USER, false);
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)200);
        future = this.pwaNotificationService.create(12L);
        Assertions.assertNotNull((Object)future);
        Assertions.assertEquals((int)1, (int)((Integer)future.get()));
        ((PwaSubscriptionService)Mockito.verify((Object)this.pwaSubscriptionService)).deleteSubscription(SUBSCRIPTION_ID, TEST_USER, false);
    }

    @Test
    public void createWithHashmap() throws Exception {
        ScheduledFuture future = this.pwaNotificationService.create(new HashMap());
        Assertions.assertNull((Object)future);
        Mockito.when((Object)this.pwaManifestService.isPwaEnabled()).thenReturn((Object)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("notificationId", 12L);
        params.put("action", "open");
        params.put("username", "john");
        future = this.pwaNotificationService.create(params);
        Assertions.assertNotNull((Object)future);
        Assertions.assertEquals((int)0, (int)((Integer)future.get()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
    }

    private void mockUserLanguage() {
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)this.userProfileHandler);
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName(TEST_USER)).thenReturn((Object)this.userProfile);
        Mockito.when((Object)this.userProfile.getAttribute("user.language")).thenReturn((Object)"fr");
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.FRENCH);
        localeConfig.setOrientation(Orientation.LT);
        Mockito.when((Object)this.localeConfigService.getLocaleConfig("fr")).thenReturn((Object)localeConfig);
    }

    private void mockWebNotification() {
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(String.valueOf(12L))).thenReturn((Object)this.notification);
        Mockito.when((Object)this.notification.getTo()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.notification.getId()).thenReturn((Object)String.valueOf(12L));
    }

    private void mockWebNotificationNoAccess() {
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(String.valueOf(12L))).thenReturn((Object)this.notification);
        Mockito.when((Object)this.notification.getKey()).thenReturn((Object)PLUGIN_KEY);
    }
}

