/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.pwa.model.ManifestIcon;
import io.meeds.pwa.model.PwaManifest;
import io.meeds.pwa.model.PwaManifestUpdate;
import io.meeds.pwa.service.PwaManifestService;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={PwaManifestService.class})
@TestPropertySource(properties={"pwa.manifest.id=manifestId", "pwa.manifest.version=V4", "pwa.manifest.description=manifestDescriptionKey", "pwa.manifest.path=pwaManifestPath"})
@ExtendWith(value={MockitoExtension.class})
public class PwaManifestServiceTest {
    private static final Random RANDOM = new Random();
    private static final String TEST_USER = "testUser";
    private static final String PRIMARY_COLOR = "defaultPrimaryColor";
    private static final String LARGE_ICON_FILE_ID = "15";
    private static final String SMALL_ICON_FILE_ID = "12";
    private static final String MANIFEST_DESCRIPTION = "manifestDescription";
    private static final String THEME_COLOR = "themeColor";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String MANIFEST_NAME = "manifestName";
    private static final String MANIFEST_ID = "manifestId";
    private static final String MANIFEST_VERSION = "V4";
    private static final String MANIFEST_DESCRIPTION_KEY = "manifestDescriptionKey";
    private static final String PWA_MANIFEST_PATH = "pwaManifestPath";
    @MockBean
    private SettingService settingService;
    @MockBean
    private FileService fileService;
    @MockBean
    private UploadService uploadService;
    @MockBean
    private BrandingService brandingService;
    @MockBean
    private ConfigurationManager configurationManager;
    @MockBean
    private ExoFeatureService featureService;
    @MockBean
    private ResourceBundleService resourceBundleService;
    @MockBean
    private ImageThumbnailService imageThumbnailService;
    @MockBean
    private ImageResizeService imageResizeService;
    @MockBean
    private ChannelManager channelManager;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private PwaManifestService pwaManifestService;
    @Mock
    private AbstractChannel channel;
    @Mock
    private FileItem smallIconFileItem;
    @Mock
    private FileInfo smallIconFileInfo;
    @Mock
    private FileItem largeIconFileItem;
    @Mock
    private FileInfo largeIconFileInfo;
    @Mock
    private Branding branding;
    @Mock
    private Logo brandingLogo;
    @Mock
    private Favicon brandingFavicon;

    @Test
    public void initWithMinimalData() {
        Mockito.when((Object)this.channelManager.getChannel(ChannelKey.key((String)"PUSH_CHANNEL"))).thenReturn((Object)this.channel);
        this.pwaManifestService.init();
        Assertions.assertFalse((boolean)this.pwaManifestService.isPwaEnabled());
        ((AbstractChannel)Mockito.verify((Object)this.channel)).setEnabled(true);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifest().getManifestId(), (Object)MANIFEST_ID);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifest().getVersion(), (Object)MANIFEST_VERSION);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifest().getDescriptionKey(), (Object)MANIFEST_DESCRIPTION_KEY);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifestPath(), (Object)PWA_MANIFEST_PATH);
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getName());
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getBackgroundColor());
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getThemeColor());
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getDescription());
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getSmallIconPath());
        Assertions.assertNull((Object)this.pwaManifestService.getPwaManifest().getLargeIconPath());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.atLeast((int)1))).addListener((String)ArgumentMatchers.eq((Object)"branding.updated"), (ListenerBase)ArgumentMatchers.any());
    }

    @Test
    public void initWithFullData() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        Assertions.assertTrue((boolean)this.pwaManifestService.isPwaEnabled());
        ((AbstractChannel)Mockito.verify((Object)this.channel)).setEnabled(false);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifestPath(), (Object)PWA_MANIFEST_PATH);
        PwaManifest pwaManifest = this.pwaManifestService.getPwaManifest();
        Assertions.assertNotNull((Object)pwaManifest);
        Assertions.assertNotNull((Object)pwaManifest.getTemplate());
        Assertions.assertEquals((Object)MANIFEST_ID, (Object)pwaManifest.getManifestId());
        Assertions.assertEquals((Object)MANIFEST_VERSION, (Object)pwaManifest.getVersion());
        Assertions.assertEquals((Object)MANIFEST_DESCRIPTION_KEY, (Object)pwaManifest.getDescriptionKey());
        Assertions.assertEquals((Object)MANIFEST_NAME, (Object)pwaManifest.getName());
        Assertions.assertEquals((Object)BACKGROUND_COLOR, (Object)pwaManifest.getBackgroundColor());
        Assertions.assertEquals((Object)THEME_COLOR, (Object)pwaManifest.getThemeColor());
        Assertions.assertEquals((Object)MANIFEST_DESCRIPTION, (Object)pwaManifest.getDescription());
        Assertions.assertNotNull((Object)pwaManifest.getSmallIconPath());
        Assertions.assertNotNull((Object)pwaManifest.getLargeIconPath());
        Assertions.assertTrue((boolean)pwaManifest.getSmallIconPath().contains("/pwa/rest/manifest/smallIcon"));
        Assertions.assertTrue((boolean)pwaManifest.getLargeIconPath().contains("/pwa/rest/manifest/largeIcon"));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.atLeast((int)1))).addListener((String)ArgumentMatchers.eq((Object)"branding.updated"), (ListenerBase)ArgumentMatchers.any());
    }

    @Test
    public void initWithBrandingData() throws Exception {
        this.mockWithBrandingValues();
        this.pwaManifestService.init();
        Assertions.assertTrue((boolean)this.pwaManifestService.isPwaEnabled());
        ((AbstractChannel)Mockito.verify((Object)this.channel)).setEnabled(false);
        Assertions.assertEquals((Object)this.pwaManifestService.getPwaManifestPath(), (Object)PWA_MANIFEST_PATH);
        PwaManifest pwaManifest = this.pwaManifestService.getPwaManifest();
        Assertions.assertNotNull((Object)pwaManifest);
        Assertions.assertNotNull((Object)pwaManifest.getTemplate());
        Assertions.assertEquals((Object)MANIFEST_ID, (Object)pwaManifest.getManifestId());
        Assertions.assertEquals((Object)MANIFEST_VERSION, (Object)pwaManifest.getVersion());
        Assertions.assertEquals((Object)MANIFEST_DESCRIPTION_KEY, (Object)pwaManifest.getDescriptionKey());
        Assertions.assertEquals((Object)MANIFEST_NAME, (Object)pwaManifest.getName());
        Assertions.assertNull((Object)pwaManifest.getBackgroundColor());
        Assertions.assertNull((Object)pwaManifest.getThemeColor());
        Assertions.assertEquals((Object)MANIFEST_DESCRIPTION, (Object)pwaManifest.getDescription());
        Assertions.assertNotNull((Object)pwaManifest.getSmallIconPath());
        Assertions.assertNotNull((Object)pwaManifest.getLargeIconPath());
        Assertions.assertTrue((boolean)pwaManifest.getSmallIconPath().contains("/pwa/rest/manifest/smallIcon"));
        Assertions.assertTrue((boolean)pwaManifest.getLargeIconPath().contains("/pwa/rest/manifest/largeIcon"));
        Assertions.assertEquals((Object)PRIMARY_COLOR, (Object)this.pwaManifestService.getThemeColor());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.atLeast((int)1))).addListener((String)ArgumentMatchers.eq((Object)"branding.updated"), (ListenerBase)ArgumentMatchers.any());
    }

    @Test
    public void getManifestHash() throws Exception {
        this.mockBrandingAttributes();
        long manifestHash = this.pwaManifestService.getManifestHash();
        Assertions.assertNotEquals((long)0L, (long)manifestHash);
        Assertions.assertEquals((long)manifestHash, (long)this.pwaManifestService.getManifestHash());
        this.mockWithStoredValues();
        this.pwaManifestService.refreshManifest();
        Assertions.assertNotEquals((long)manifestHash, (long)this.pwaManifestService.getManifestHash());
    }

    @Test
    public void getSmallIcon() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        ManifestIcon smallIcon = this.pwaManifestService.getSmallIcon();
        Assertions.assertNotNull((Object)smallIcon);
        Assertions.assertEquals((int)this.smallIconFileItem.getAsByte().length, (int)smallIcon.getData().length);
    }

    @Test
    public void getSmallIconWithNoDimensions() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        ManifestIcon smallIcon = this.pwaManifestService.getSmallIcon(null);
        Assertions.assertNotNull((Object)smallIcon);
        Assertions.assertEquals((int)this.smallIconFileItem.getAsByte().length, (int)smallIcon.getData().length);
        smallIcon = this.pwaManifestService.getSmallIcon("test");
        Assertions.assertNotNull((Object)smallIcon);
        Assertions.assertEquals((int)this.smallIconFileItem.getAsByte().length, (int)smallIcon.getData().length);
    }

    @Test
    public void getLargeIcon() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        ManifestIcon largeIcon = this.pwaManifestService.getLargeIcon();
        Assertions.assertNotNull((Object)largeIcon);
        Assertions.assertEquals((int)this.largeIconFileItem.getAsByte().length, (int)largeIcon.getData().length);
    }

    @Test
    public void getLargeIconWithNoDimensions() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        ManifestIcon largeIcon = this.pwaManifestService.getLargeIcon(null);
        Assertions.assertNotNull((Object)largeIcon);
        Assertions.assertEquals((int)this.largeIconFileItem.getAsByte().length, (int)largeIcon.getData().length);
        largeIcon = this.pwaManifestService.getLargeIcon("test2");
        Assertions.assertNotNull((Object)largeIcon);
        Assertions.assertEquals((int)this.largeIconFileItem.getAsByte().length, (int)largeIcon.getData().length);
    }

    @Test
    public void getLargeIconWithDimensions() throws Exception {
        this.mockWithStoredValues();
        this.pwaManifestService.init();
        FileItem thumbnailFileItem = (FileItem)Mockito.mock(FileItem.class);
        FileInfo thumbnailFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)thumbnailFileItem.getFileInfo()).thenReturn((Object)thumbnailFileInfo);
        Mockito.when((Object)this.imageThumbnailService.getOrCreateThumbnail((ImageResizeService)ArgumentMatchers.any(), (FileItem)ArgumentMatchers.eq((Object)this.largeIconFileItem), ArgumentMatchers.eq((int)100), ArgumentMatchers.eq((int)100))).thenReturn((Object)thumbnailFileItem);
        Mockito.when((Object)thumbnailFileItem.getAsStream()).thenAnswer(invocation -> new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)thumbnailFileInfo.getId()).thenReturn((Object)5L);
        ManifestIcon largeIcon = this.pwaManifestService.getLargeIcon("100x100");
        Assertions.assertNotNull((Object)largeIcon);
        Assertions.assertEquals((int)3, (int)largeIcon.getData().length);
        Assertions.assertEquals((long)5L, (long)largeIcon.getFileId());
    }

    @Test
    public void updateManifest() throws Exception {
        this.mockSettingsService();
        this.mockFeatureService();
        this.mockManifestFileContent();
        this.mockBrandingAttributes();
        this.mockIconFiles();
        this.pwaManifestService.init();
        PwaManifestUpdate manifestUpdate = new PwaManifestUpdate();
        manifestUpdate.setEnabled(true);
        manifestUpdate.setName("Name2");
        manifestUpdate.setDescription("Description2");
        manifestUpdate.setLargeIconUploadId("largeIconUploadId");
        manifestUpdate.setSmallIconUploadId("smallIconUploadId");
        manifestUpdate.setThemeColor("themeColor2");
        manifestUpdate.setBackgroundColor("eval");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pwaManifestService.updateManifest(manifestUpdate, TEST_USER));
        manifestUpdate.setThemeColor("eval");
        manifestUpdate.setBackgroundColor("backgroundColor2");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pwaManifestService.updateManifest(manifestUpdate, TEST_USER));
        manifestUpdate.setThemeColor("themeColor2");
        manifestUpdate.setBackgroundColor("backgroundColor2");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pwaManifestService.updateManifest(manifestUpdate, TEST_USER));
        Mockito.when((Object)this.fileService.writeFile((FileItem)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FileItem fileItem = (FileItem)invocation.getArgument(0);
            FileInfo fileInfo = (FileInfo)Mockito.mock(FileInfo.class);
            fileItem.setFileInfo(fileInfo);
            Mockito.when((Object)fileInfo.getId()).thenReturn((Object)RANDOM.nextLong());
            return fileItem;
        });
        UploadResource largeIconUploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.uploadService.getUploadResource(manifestUpdate.getLargeIconUploadId())).thenReturn((Object)largeIconUploadResource);
        Mockito.when((Object)largeIconUploadResource.getStoreLocation()).thenReturn((Object)this.getClass().getClassLoader().getResource("test_icon.png").getPath());
        UploadResource smallIconUploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.uploadService.getUploadResource(manifestUpdate.getSmallIconUploadId())).thenReturn((Object)smallIconUploadResource);
        Mockito.when((Object)smallIconUploadResource.getStoreLocation()).thenReturn((Object)this.getClass().getClassLoader().getResource("test_icon.png").getPath());
        this.pwaManifestService.updateManifest(manifestUpdate, TEST_USER);
        Assertions.assertTrue((boolean)this.pwaManifestService.isPwaEnabled());
        PwaManifest pwaManifest = this.pwaManifestService.getPwaManifest();
        Assertions.assertNotNull((Object)pwaManifest);
        Assertions.assertEquals((Object)manifestUpdate.getName(), (Object)pwaManifest.getName());
        Assertions.assertEquals((Object)manifestUpdate.getDescription(), (Object)pwaManifest.getDescription());
        Assertions.assertEquals((Object)manifestUpdate.getThemeColor(), (Object)pwaManifest.getThemeColor());
        Assertions.assertEquals((Object)manifestUpdate.getBackgroundColor(), (Object)pwaManifest.getBackgroundColor());
        Assertions.assertNotEquals((long)Long.parseLong(LARGE_ICON_FILE_ID), (long)this.pwaManifestService.getLargeIcon().getFileId());
        Assertions.assertNotEquals((long)Long.parseLong(SMALL_ICON_FILE_ID), (long)this.pwaManifestService.getSmallIcon().getFileId());
    }

    private void mockWithStoredValues() throws Exception {
        Mockito.when((Object)this.channelManager.getChannel(ChannelKey.key((String)"PUSH_CHANNEL"))).thenReturn((Object)this.channel);
        Mockito.when((Object)this.featureService.isActiveFeature("pwa")).thenReturn((Object)true);
        this.mockManifestFileContent();
        this.mockSettingValue("pwa.name", MANIFEST_NAME);
        this.mockSettingValue("pwa.description", MANIFEST_DESCRIPTION);
        this.mockSettingValue("pwa.backgroundColor", BACKGROUND_COLOR);
        this.mockSettingValue("pwa.themeColor", THEME_COLOR);
        this.mockIconFiles();
    }

    private void mockWithBrandingValues() throws Exception {
        Mockito.when((Object)this.channelManager.getChannel(ChannelKey.key((String)"PUSH_CHANNEL"))).thenReturn((Object)this.channel);
        Mockito.when((Object)this.featureService.isActiveFeature("pwa")).thenReturn((Object)true);
        Mockito.when((Object)this.brandingService.getDefaultLanguage()).thenReturn((Object)Locale.ENGLISH.toLanguageTag());
        Mockito.when((Object)this.resourceBundleService.getSharedString(MANIFEST_DESCRIPTION_KEY, Locale.ENGLISH)).thenReturn((Object)MANIFEST_DESCRIPTION);
        Mockito.when((Object)this.brandingService.getThemeStyle()).thenReturn(Collections.singletonMap("primaryColor", PRIMARY_COLOR));
        this.mockManifestFileContent();
        this.mockSettingValue("pwa.name", MANIFEST_NAME);
        this.mockBrandingIconFiles();
    }

    private void mockManifestFileContent() throws Exception {
        Mockito.when((Object)this.configurationManager.getInputStream(PWA_MANIFEST_PATH)).thenAnswer(invocation -> this.getClass().getClassLoader().getResourceAsStream("pwa/manifest.json"));
    }

    private void mockBrandingAttributes() {
        Mockito.when((Object)this.brandingService.getBrandingInformation(false)).thenReturn((Object)this.branding);
        Mockito.when((Object)this.branding.getDefaultLanguage()).thenReturn((Object)Locale.ENGLISH.toLanguageTag());
        Mockito.when((Object)this.branding.getDirection()).thenReturn((Object)"ltr");
    }

    private void mockBrandingIconFiles() {
        this.mockBrandingLogoFile();
        this.mockBrandingFaviconFile();
    }

    /*
     * Exception decompiling
     */
    private void mockBrandingLogoFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void mockBrandingFaviconFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void mockIconFiles() throws FileStorageException {
        this.mockLargeIconFile();
        this.mockSmallIconFile();
        this.mockSettingValue("pwa.illustration71", SMALL_ICON_FILE_ID);
        this.mockSettingValue("pwa.illustration512", LARGE_ICON_FILE_ID);
    }

    /*
     * Exception decompiling
     */
    private void mockSmallIconFile() throws FileStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void mockLargeIconFile() throws FileStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void mockSettingValue(String key, String value) {
        Mockito.when((Object)this.settingService.get(Context.GLOBAL, Scope.GLOBAL, key)).thenReturn((Object)SettingValue.create((String)value));
    }

    private void mockSettingsService() {
        ((SettingService)Mockito.doAnswer(invocation -> {
            Context context = (Context)invocation.getArgument(0);
            Scope scope = (Scope)invocation.getArgument(1);
            String key = (String)invocation.getArgument(2);
            SettingValue value = (SettingValue)invocation.getArgument(3);
            Mockito.when((Object)this.settingService.get(context, scope, key)).thenReturn((Object)value);
            return null;
        }).when((Object)this.settingService)).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.any());
    }

    private void mockFeatureService() {
        ((ExoFeatureService)Mockito.doAnswer(invocation -> {
            String featureName = (String)invocation.getArgument(0);
            boolean enabled = (Boolean)invocation.getArgument(1);
            Mockito.when((Object)this.featureService.isActiveFeature(featureName)).thenReturn((Object)enabled);
            return null;
        }).when((Object)this.featureService)).saveActiveFeature((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }
}

