/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.cleanup;

import io.cucumber.java.AfterAll;
import io.meeds.qa.ui.hook.TestInitHook;
import io.meeds.qa.ui.utils.ExceptionLauncher;
import net.serenitybdd.core.Serenity;
import org.openqa.selenium.JavascriptExecutor;

public class TestCleanupHook {
    public static final boolean CLEAN_DATA = Boolean.parseBoolean(System.getProperty("io.meeds.cleanData", "false").toLowerCase());
    private static final String DELETE_SPACE_SCRIPT = " const callback = arguments && arguments.length && arguments[arguments.length - 1] || null;\n fetch(\"/portal/rest/v1/social/spaces/byPrettyName/%s\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"method\": \"GET\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (!resp || !resp.ok) {\n     throw new Error(\"Error getting space\");\n   } else {\n     return resp.json();\n   }\n })\n .then(space =>\n   space && space.id && fetch(\"/portal/rest/v1/social/spaces/\" + space.id, {\n     \"headers\": {\n       \"content-type\": \"application/json\",\n     },\n     \"method\": \"DELETE\",\n     \"credentials\": \"include\"\n   })\n   .then(resp => {\n     if (resp && !resp.ok) {\n       throw new Error(\"Error deleting space\");\n     }\n   })\n )\n .then(() => callback && callback(true))\n .catch(() => callback && callback(false));\n";
    private static final String DELETE_USER_SCRIPT = " const callback = arguments && arguments.length && arguments[arguments.length - 1] || null;\n fetch(\"/portal/rest/v1/social/users/%s\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"method\": \"DELETE\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (resp && !resp.ok) {\n     throw new Error(\"Error deleting user\");\n   }\n })\n .then(() => callback && callback(true))\n .catch(() => callback && callback(false));\n";

    @AfterAll
    public static void cleanDatas() {
        if (TestInitHook.instance == null || !CLEAN_DATA) {
            return;
        }
        ExceptionLauncher.LOGGER.info("---- Start cleanup phase");
        long start = System.currentTimeMillis();
        try {
            TestInitHook.instance.genericSteps.closeAllDrawers();
            TestInitHook.instance.genericSteps.closeAllDialogs();
            TestInitHook.instance.loginSteps.logout();
        }
        catch (Exception e) {
            ExceptionLauncher.LOGGER.warn("Can't logout admin user. Proceed to login phase", (Throwable)e);
        }
        if (!TestInitHook.instance.loginSteps.authenticate(TestInitHook.ADMIN_USERNAME, TestInitHook.ADMIN_PASSWORD, false)) {
            ExceptionLauncher.LOGGER.warn("Couldn't login with admin, cleanup phase aborted");
        }
        TestCleanupHook.deleteSpaces();
        TestCleanupHook.deleteUsers();
        ExceptionLauncher.LOGGER.info("---- End cleanup phase in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private static void deleteSpaces() {
        TestInitHook.SPACE_NAMES.forEach(TestCleanupHook::deleteSpace);
    }

    private static void deleteUsers() {
        TestInitHook.USER_NAMES.forEach(TestCleanupHook::deleteUser);
    }

    private static void deleteSpace(String spaceName) {
        Object result = ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(String.format(DELETE_SPACE_SCRIPT, spaceName), new Object[0]);
        ExceptionLauncher.LOGGER.info("Delete created space in Tests {}, result = {}", (Object)spaceName, result);
    }

    private static void deleteUser(String userName) {
        Object result = ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(String.format(DELETE_USER_SCRIPT, userName), new Object[0]);
        ExceptionLauncher.LOGGER.info("Delete created user in Tests {}, result = {}", (Object)userName, result);
    }
}

