/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.hook;

import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.meeds.qa.ui.steps.AddUserSteps;
import io.meeds.qa.ui.steps.AdminApplicationSteps;
import io.meeds.qa.ui.steps.GenericSteps;
import io.meeds.qa.ui.steps.HomeSteps;
import io.meeds.qa.ui.steps.LoginSteps;
import io.meeds.qa.ui.steps.ManageBadgesSteps;
import io.meeds.qa.ui.steps.ManageSpaceSteps;
import io.meeds.qa.ui.steps.SocialSteps;
import io.meeds.qa.ui.steps.definition.ManageSpaceStepDefinitions;
import io.meeds.qa.ui.utils.ExceptionLauncher;
import io.meeds.qa.ui.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeVisibleException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public class TestInitHook {
    public static final String ADMIN_PREFIX = "admin";
    public static final String URL = System.getProperty("webdriver.base.url", "http://localhost:8080/");
    public static final String ADMIN_USERNAME = System.getProperty("adminUser", "admin");
    public static final String ADMIN_PASSWORD = System.getProperty("adminPassword", "Test1234@");
    public static final String[] ADMIN_GROUPS = System.getProperty("io.meeds.admin.groups", "/platform/administrators,/platform/rewarding,/platform/analytics").split(",");
    public static final boolean INIT_DATA = Boolean.parseBoolean(System.getProperty("io.meeds.initData", "true").toLowerCase());
    public static final String WARMUP_FILE_PATH = System.getProperty("io.meeds.warmUp.file", "warmUpFile.tmp");
    public static final int WARM_UP_PAGE_LOADING_WAIT = 30;
    public static final int MAX_WARM_UP_STEP_WAIT = 5;
    public static final int MAX_WARM_UP_RETRIES = 30;
    public static final Set<String> SPACE_NAMES = new HashSet<String>();
    public static final Set<String> USER_NAMES = new HashSet<String>();
    public static final Map<String, String> SPACES = new HashMap<String, String>();
    public static final Map<String, String> SPACES_URLS = new HashMap<String, String>();
    public static final Map<String, String> USERS = new HashMap<String, String>();
    @Steps
    public AdminApplicationSteps adminApplicationSteps;
    @Steps
    public HomeSteps homeSteps;
    @Steps
    public LoginSteps loginSteps;
    @Steps
    public GenericSteps genericSteps;
    @Steps
    public ManageBadgesSteps manageBadgesSteps;
    @Steps
    public ManageSpaceStepDefinitions manageSpaceStepDefinitions;
    @Steps
    public ManageSpaceSteps manageSpaceSteps;
    @Steps
    public AddUserSteps addUserSteps;
    @Steps
    public SocialSteps socialSteps;
    public static TestInitHook instance;

    public static void spaceWithPrefixCreated(String spaceNamePrefix, String spaceName, String spaceUrl) {
        SPACES.put(spaceNamePrefix, spaceName);
        SPACES_URLS.put(spaceNamePrefix, spaceUrl);
        SPACE_NAMES.add(spaceName);
        Serenity.setSessionVariable((Object)spaceNamePrefix).to((Object)spaceName);
        Serenity.setSessionVariable((Object)(spaceNamePrefix + "-url")).to((Object)spaceUrl);
    }

    public static void spaceWithPrefixDeleted(String spaceNamePrefix) {
        SPACES.remove(spaceNamePrefix);
        SPACES_URLS.remove(spaceNamePrefix);
    }

    public static void userWithPrefixCreated(String userPrefix, String userName, String firstName, String lastName, String email, String password) {
        USERS.put(userPrefix + "UserName", userName);
        USERS.put(userPrefix + "UserFirstName", firstName);
        USERS.put(userPrefix + "UserLastName", lastName);
        USERS.put(userPrefix + "UserPassword", password);
        USERS.put(userPrefix + "UserEmail", email);
        USERS.put(userName + "-password", password);
        USER_NAMES.add(userName);
    }

    public TestInitHook() {
        instance = this;
    }

    @After
    public void deleteDatas() {
        this.genericSteps.closeAllDrawers();
        this.genericSteps.closeAllDialogs();
    }

    @Before
    public void initDatas() {
        WebDriver driver = Serenity.getDriver();
        driver.manage().timeouts().implicitlyWait(Duration.ofMillis(Utils.DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT));
        this.warmUp(driver);
        this.checkPageState(driver);
        SPACES.entrySet().forEach(entry -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                Serenity.setSessionVariable(entry.getKey()).to((Object)((String)entry.getValue()));
            }
        });
        SPACES_URLS.entrySet().forEach(entry -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                Serenity.setSessionVariable((Object)((String)entry.getKey() + "-url")).to((Object)((String)entry.getValue()));
            }
        });
        USERS.entrySet().forEach(entry -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                Serenity.setSessionVariable(entry.getKey()).to((Object)((String)entry.getValue()));
            }
        });
    }

    private void checkPageState(WebDriver driver) {
        try {
            driver.switchTo().alert().accept();
            driver.navigate().refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeCurrentWindow(WebDriver driver) {
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void loginAsAdmin() {
        try {
            this.loginSteps.logout();
        }
        catch (Exception e) {
            ExceptionLauncher.LOGGER.warn("Can't logout admin user. Proceed to login phase", (Throwable)e);
        }
        if (!this.loginSteps.authenticate(ADMIN_USERNAME, ADMIN_PASSWORD, false)) {
            throw new IllegalStateException("Couldn't login with admin");
        }
        this.genericSteps.disableTermsAndConditions();
        this.genericSteps.goToPage("/");
    }

    private void loginAsRandomAdmin() {
        try {
            this.loginSteps.logout();
        }
        catch (Exception e) {
            ExceptionLauncher.LOGGER.warn("Can't logout admin user. Proceed to login phase", (Throwable)e);
        }
        if (!this.loginSteps.authenticate(ADMIN_PREFIX, false)) {
            throw new IllegalStateException("Couldn't login with random admin");
        }
    }

    private void warmUp(WebDriver driver) {
        File warmUpFile = new File(WARMUP_FILE_PATH);
        if (warmUpFile.exists()) {
            ExceptionLauncher.LOGGER.debug("Warmup already proceeded. Execute test scenario.");
            return;
        }
        try {
            if (!warmUpFile.createNewFile()) {
                throw new IOException("Warmup File not created");
            }
        }
        catch (IOException e) {
            ExceptionLauncher.LOGGER.warn("Error creating warmup file {}. Proceed to execute Test scenario without warmup.", (Object)WARMUP_FILE_PATH, (Object)e);
            return;
        }
        ExceptionLauncher.LOGGER.info("---- Start warmup phase with {} retries and wait time of {} seconds", (Object)30, (Object)5);
        long start = System.currentTimeMillis();
        int retryCount = 1;
        boolean homePageDisplayed = false;
        do {
            ExceptionLauncher.LOGGER.info("---- {}/{} Warmup step", (Object)retryCount, (Object)30);
            try {
                driver.navigate().to(URL);
                Utils.waitForLoading((int)30, (boolean)true);
                driver.navigate().refresh();
                this.loginSteps.waitForUsernameInputDisplay(30);
                this.loginAsAdmin();
                Utils.waitForLoading((int)30, (boolean)true);
                this.homeSteps.waitPortalDisplayed(30);
                homePageDisplayed = this.homeSteps.isPortalDisplayed();
                if (!homePageDisplayed) {
                    throw new ElementShouldBeVisibleException("Home Page isn't displayed", null);
                }
                driver.navigate().to(driver.getCurrentUrl().replace("/portal", "/portal/en"));
                Utils.waitForLoading((int)30, (boolean)true);
            }
            catch (Throwable e) {
                ExceptionLauncher.LOGGER.warn("Error authenticating admin user", e);
                this.closeCurrentWindow(driver);
                Utils.waitRemainingTime((long)30000L, (long)start);
            }
        } while (!homePageDisplayed && retryCount++ < 30);
        if (!homePageDisplayed) {
            warmUpFile.deleteOnExit();
            this.closeCurrentWindow(driver);
            throw new ElementShouldBeVisibleException("Home Page isn't displayed", null);
        }
        this.addAdminRandomUser();
        this.manageSpaceSteps.setSideBarDefaultMode();
        this.manageSpaceSteps.injectSpaceTemplate();
        this.manageSpaceSteps.clearDefaultSpaces();
        this.genericSteps.disablePwa();
        this.loginAsRandomAdmin();
        if (INIT_DATA) {
            ExceptionLauncher.LOGGER.info("---- FOR LOCAL TESTS, disable WARMUP Phase (used to improve global test execution time only) by adding \n\n\t\t******* -Dio.meeds.initData=false ******* \n\n\n");
            this.injectSpaces();
            this.injectUsers();
        }
        ExceptionLauncher.LOGGER.info("---- End warmup phase in {} seconds", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    private void injectSpaces() {
        this.manageSpaceSteps.addOrGoToSpace("randomSpaceName");
    }

    private void injectUsers() {
        String[] randomUsers = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "firstgami", "secondgami", "firstkudos", "secondkudos", "thirdkudos", "fourthkudos", "fortyonekudos", "fortytwokudos", "fortythreekudos", "fiftyonekudos", "fiftytwokudos", "fiftythreekudos", "firstcommconn", "secondcommconn", "thirdcommconn", "fourthcommconn", "fifthcommconn", "firstprofile", "secondprofile", "fifthkudos", "sixthkudos", "seventhkudos", "thirdprofile", "firstlang", "seconddisabled", "eighteenth", "fisrtachievement", "secondachievement", "thirdachievement", "fourachievement", "fifthachievement", "sixthachievement", "seventhachievement", "eighthachievement", "firstrule", "secondrule", "homeicon"};
        if (!Arrays.stream(randomUsers).map(this::addRandomUser).allMatch(userCreated -> userCreated)) {
            throw new IllegalStateException("Some users wasn't created successfully in WarmUp phase");
        }
    }

    private void addAdminRandomUser() {
        this.addRandomUser(ADMIN_PREFIX);
        Arrays.stream(ADMIN_GROUPS).forEach(groupId -> this.addUserSteps.addUserRole(ADMIN_PREFIX, (String)groupId, "*"));
    }

    private boolean addRandomUser(String randomUser) {
        ExceptionLauncher.LOGGER.info("Injecting new random user {}", (Object)randomUser);
        try {
            this.addUserSteps.addRandomUser(randomUser, false, true);
            return true;
        }
        catch (Exception e) {
            ExceptionLauncher.LOGGER.warn("Error creating User {} in Warmup phase. Error: {}", (Object)randomUser, (Object)e.getMessage());
            return false;
        }
    }
}

