/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.hook.TestInitHook;
import io.meeds.qa.ui.pages.AddUserPage;
import io.meeds.qa.ui.pages.HomePage;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.support.ui.WebDriverWait;

public class AddUserSteps {
    private AddUserPage addUserPage;
    private HomePage homePage;

    public void addRandomUser(String userPrefix, boolean waitSearchable) {
        this.addRandomUser(userPrefix, waitSearchable, false);
    }

    public void addRandomUser(String userPrefix, boolean waitSearchable, boolean injectUsingRest) {
        if (StringUtils.isBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"))))) {
            String userName = "user" + userPrefix + Utils.getRandomString();
            String firstName = Utils.getRandomString((String)userPrefix);
            String lastName = Utils.getRandomString((String)userName);
            String email = userName + "@aa.bb";
            String password = "Test1234@" + Utils.getRandomString((String)userPrefix);
            if (injectUsingRest) {
                this.addRandomUser(userPrefix, userName, firstName, lastName, email, password);
            } else {
                this.homePage.goToAddUser();
                this.addRandomUser(userName, firstName, lastName, email, password);
                if (waitSearchable) {
                    this.addUserPage.waitFor(3).seconds();
                } else {
                    this.addUserPage.waitForDrawerToClose();
                }
            }
            Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to((Object)userName);
            Serenity.setSessionVariable((Object)(userPrefix + "UserFirstName")).to((Object)firstName);
            Serenity.setSessionVariable((Object)(userPrefix + "UserLastName")).to((Object)lastName);
            Serenity.setSessionVariable((Object)(userPrefix + "UserPassword")).to((Object)password);
            Serenity.setSessionVariable((Object)(userName + "-password")).to((Object)password);
            TestInitHook.userWithPrefixCreated(userPrefix, userName, firstName, lastName, email, password);
        }
    }

    public void addAdminUser(String userPrefix) {
        String adminUsername = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String firstName = "Admin";
        String lastName = "User";
        String email = adminUsername + "@localhost.com";
        String password = Utils.getRandomString((String)userPrefix);
        this.addRandomUser(userPrefix, adminUsername, firstName, lastName, email, password);
    }

    public void addRandomUser(String userName, String firstName, String lastName, String mail, String password) {
        this.addUserPage.clickAddUserButton();
        this.addUserPage.setRandomUserDetails(userName, firstName, lastName, mail, password);
        this.addUserPage.saveAddUserButton();
    }

    public void addUser(Map<String, String> userDetails) {
        this.addUserPage.clickAddUserButton();
        for (Map.Entry<String, String> field : userDetails.entrySet()) {
            this.addUserPage.setUserDetails(field.getKey(), field.getValue());
        }
        this.addUserPage.saveAddUserButton();
    }

    public void checkPopupCantDeleteLoggedUser() {
        this.addUserPage.checkPopupCantDeleteLoggedUser();
    }

    public void checkThatAddUserDrawerIsDisplayed() {
        this.addUserPage.clickAddUserButton();
        this.addUserPage.checkThatAddUserDrawerIsDisplayed();
    }

    public void checkUserIsDeleted(String fullName) {
        this.addUserPage.checkUserIsDeleted(fullName);
    }

    public void clickToDeleteUser() {
        this.addUserPage.clickToDeleteUser();
    }

    public void deleteUser() {
        this.addUserPage.deleteUser();
    }

    public void enableDisableUser(String user) {
        this.addUserPage.enableDisableUser(user);
    }

    public void enterUserInformations(Map<String, String> userDetails) {
        this.addUserPage.clickAddUserButton();
        for (Map.Entry<String, String> field : userDetails.entrySet()) {
            this.addUserPage.setUserDetails(field.getKey(), field.getValue());
        }
    }

    public void isUserNameDisplayed(String user) {
        this.addUserPage.isUserNameDisplayed(user);
    }

    public void saveAddingUser() {
        this.addUserPage.saveAddUserButton();
    }

    public void searchForUsersByName(String userName) {
        this.addUserPage.searchForUserByName(userName, 3);
    }

    public void searchForUsersByStatus(String status) {
        this.addUserPage.searchForUsersByStatus(status);
    }

    public void addUserRole(String userPrefix, String groupId, String membershipType) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String addUserScript = String.format(" const callback = arguments[arguments.length - 1];\n fetch(\"/portal/rest/v1/groups/memberships/bulk?membershipId=\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"body\": `[{\"userName\":\"%s\",\"groupId\":\"%s\",\"membershipType\":\"%s\"}]`,\n   \"method\": \"POST\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (!resp || !resp.ok) {\n     throw new Error(\"Error adding user role\");\n   }\n })\n .then(user => callback(true))\n .catch(() => callback(false));\n", userName, groupId, membershipType);
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(3L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeAsyncScript(addUserScript, new Object[0]).toString().equals("true"));
    }

    public void deleteUserRole(String userPrefix, String groupId, String membershipType) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String addUserScript = String.format(" const callback = arguments[arguments.length - 1];\n fetch(\"/portal/rest/v1/groups/memberships?membershipId=%s:%s:%s\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"method\": \"DELETE\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (!resp || !resp.ok) {\n     throw new Error(\"Error adding user role\");\n   }\n })\n .then(user => callback(true))\n .catch(() => callback(false));\n", membershipType, userName, groupId);
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(3L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeAsyncScript(addUserScript, new Object[0]).toString().equals("true"));
    }

    private void addRandomUser(String userPrefix, String userName, String firstName, String lastName, String email, String password) {
        String addUserScript = String.format(" const callback = arguments[arguments.length - 1];\n fetch(\"/portal/rest/v1/users\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"body\": `{\"enabled\":true,\"userName\":\"%s\",\"firstName\":\"%s\",\"lastName\":\"%s\",\"email\":\"%s\",\"password\":\"%s\",\"confirmNewPassword\":\"%s\"}`,\n   \"method\": \"POST\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (!resp || !resp.ok) {\n     throw new Error(\"Error creating user\");\n   }\n })\n .then(user => callback(true))\n .catch(() => callback(false));\n", userName, firstName, lastName, email, password, password);
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(10L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeAsyncScript(addUserScript, new Object[0]).toString().equals("true"));
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to((Object)userName);
        Serenity.setSessionVariable((Object)(userPrefix + "UserFirstName")).to((Object)firstName);
        Serenity.setSessionVariable((Object)(userPrefix + "UserLastName")).to((Object)lastName);
        Serenity.setSessionVariable((Object)(userPrefix + "UserPassword")).to((Object)password);
        Serenity.setSessionVariable((Object)(userName + "-password")).to((Object)password);
        TestInitHook.userWithPrefixCreated(userPrefix, userName, firstName, lastName, email, password);
    }

    public void injectRandomUserWithGroups(String userPrefix, List<String> memberships, boolean deleteInternalMembership) {
        this.addRandomUser(userPrefix, false, true);
        if (deleteInternalMembership) {
            this.deleteUserRole(userPrefix, "/platform/users", "member");
        }
        memberships.forEach(membership -> {
            String[] stringArray;
            if (membership.contains(":")) {
                stringArray = membership.split(":");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "member";
                stringArray = stringArray2;
                stringArray2[1] = membership;
            }
            String[] membershipParts = stringArray;
            this.addUserRole(userPrefix, membershipParts[1], membershipParts[0]);
        });
    }
}

