/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.support.ui.WebDriverWait;

public class GenericSteps {
    private static final String DISABLE_PWA_SCRIPT = " const callback = arguments[arguments.length - 1];\n fetch(\"/pwa/rest/manifest\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"body\": `{\"enabled\":false,\"name\":\"Web3 Hub\",\"description\":\"Your Application for Communication, Collaboration, Teamwork and Engagement\",\"themeColor\":\"#BC99E7\",\"backgroundColor\":\"#BC99E7\"}`,\n   \"method\": \"PUT\",\n   \"credentials\": \"include\"\n })\n.then(resp => {\n  if (!resp || !resp.ok) {\n    throw new Error(\"Error when switching Off PWA\");\n  }\n})\n.then(() => callback(true))\n.catch(() => callback(false));\n";
    private static final String DISABLE_TERMS_SCRIPT = " const callback = arguments[arguments.length - 1];\n fetch(\"/notes/rest/terms/settings?published=false&lang=en\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"method\": \"PUT\",\n   \"credentials\": \"include\"\n })\n.then(resp => {\n  if (!resp || !resp.ok) {\n    throw new Error(\"Error when switching Off Terms and Conditions\");\n  }\n})\n.then(() => callback(true))\n.catch(() => callback(false));\n";
    private GenericPage genericPage;

    public void checkConfirmMessageIsDisplayed(String message) {
        this.genericPage.checkConfirmMessageIsDisplayed(message);
    }

    public void checkMessageIsDisplayed(String message) {
        this.genericPage.checkMessageIsDisplayed(message);
    }

    public void checkMessageIsNotDisplayed(String message) {
        this.genericPage.checkMessageIsNotDisplayed(message);
    }

    public void checkMessageIsDisplayedInPage(String message) {
        this.genericPage.checkMessageIsDisplayedInPage(message);
    }

    public void checkMessageIsNotDisplayedInPage(String message) {
        this.genericPage.checkMessageIsNotDisplayedInPage(message);
    }

    public void checkDrawerDisplayed(String title) {
        this.genericPage.checkDrawerDisplayed(title);
    }

    public void checkSwitchButtonNotDisplayed(String buttonName) {
        this.genericPage.checkSwitchButtonNotDisplayed(buttonName);
    }

    public void checkSwitchButtonDisplayed(String buttonName) {
        this.genericPage.checkSwitchButtonDisplayed(buttonName);
    }

    public void enableSwitchButtonDisplayed(String buttonName) {
        this.genericPage.enableSwitchButtonDisplayed(buttonName);
    }

    public void clickConfirm() {
        this.genericPage.clickConfirm();
    }

    public void clickButton(String buttonText) {
        this.genericPage.clickButton(buttonText);
    }

    public void clickMenuItem(String buttonText) {
        this.genericPage.clickMenuItem(buttonText);
    }

    public void clickLink(String linkText) {
        this.genericPage.clickLink(linkText);
    }

    public void clickOnText(String text) {
        this.genericPage.clickOnText(text);
    }

    public void clickDrawerButton(String buttonText) {
        this.genericPage.clickDrawerButton(buttonText);
    }

    public void clickSelecdLevelDrawerButton(String buttonText) {
        this.genericPage.clickSelecdLevelDrawerButton(buttonText);
    }

    public void buttonIsDisabled(String buttonText) {
        this.genericPage.buttonIsDisabled(buttonText);
    }

    public void buttonIsEnabled(String buttonText) {
        this.genericPage.buttonIsEnabled(buttonText);
    }

    public void buttonInDrawerIsDisabled(String buttonText) {
        this.genericPage.buttonInDrawerIsDisabled(buttonText);
    }

    public void buttonInDrawerIsEnabled(String buttonText) {
        this.genericPage.buttonInDrawerIsEnabled(buttonText);
    }

    public void buttonInDrawerIsNotDisplayed(String buttonText) {
        this.genericPage.buttonInDrawerIsNotDisplayed(buttonText);
    }

    public void buttonInDrawerIsDisplayed(String buttonText) {
        this.genericPage.buttonInDrawerIsDisplayed(buttonText);
    }

    public void waitForDrawerToOpen() {
        this.genericPage.waitForDrawerToOpen();
    }

    public void waitForDrawerToClose() {
        this.genericPage.waitForDrawerToClose();
    }

    public void closeToastNotification() {
        this.genericPage.closeToastNotification(true);
    }

    public void closeAllDialogs() {
        this.genericPage.closeAllDialogs();
    }

    public void closeAllDrawers() {
        this.genericPage.closeAllDrawers();
    }

    public void closeBrowserTab(int tabIndex) {
        this.genericPage.closeBrowserTab(tabIndex);
    }

    public void closeDrawerIfDisplayed() {
        this.genericPage.closeDrawerIfDisplayed();
    }

    public void expandDrawer() {
        this.genericPage.expandDrawer();
    }

    public void clickOnGoBack() {
        this.genericPage.clickOnGoBack();
    }

    public void clickOnGoBackInDrawer() {
        this.genericPage.clickOnGoBackInDrawer();
    }

    public boolean containsContent(String content) {
        return this.genericPage.containsContent(content);
    }

    public String getCurrentUrl() {
        return this.genericPage.getCurrentUrl();
    }

    public boolean isButtonDisplayed(String button) {
        return this.genericPage.isButtonDisplayed(button);
    }

    public void isPageOpened(String uriPart) {
        this.genericPage.isPageOpened(uriPart);
    }

    public void checkSuccessMessageDisplayed() {
        this.genericPage.checkSuccessMessageDisplayed();
    }

    public void checkInformationMessageDisplayed() {
        this.genericPage.checkInformationMessageDisplayed();
    }

    public void waitInSeconds(int seconds) {
        this.genericPage.waitFor(seconds).seconds();
    }

    public void waitInMilliseconds(int milliseconds) {
        this.genericPage.waitFor(milliseconds).milliseconds();
    }

    public void checkTranslationButtonIsPrimary(int index) {
        this.genericPage.checkTranslationButtonIsPrimary(index);
    }

    public void checkTranslationButtonIsNotPrimary(int index) {
        this.genericPage.checkTranslationButtonIsNotPrimary(index);
    }

    public void openTranslationsDrawer(int index) {
        this.genericPage.openTranslationsDrawer(index);
    }

    public void addTranslationValues(String fieldType, Map<String, String> valuesByLanguage) {
        this.genericPage.addTranslationValues(fieldType, valuesByLanguage);
    }

    public void switchPageLanguage(String lang) {
        this.genericPage.switchPageLanguage(lang);
    }

    public void sortTableByField(String fieldText) {
        this.genericPage.sortTableByField(fieldText);
    }

    public void disablePwa() {
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(10L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeAsyncScript(DISABLE_PWA_SCRIPT, new Object[0]).toString().equals("true"));
    }

    public void disableTermsAndConditions() {
        ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(DISABLE_TERMS_SCRIPT, new Object[0]);
    }

    public void goToPage(String link) {
        this.genericPage.goToPage(link);
    }
}

