/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.pages.HomePage;
import java.util.List;
import net.serenitybdd.core.Serenity;

public class HomeSteps {
    private HomePage homePage;

    public void acceptConnectionInvitations(List<String> names, boolean isPrefix) {
        for (String name : names) {
            if (isPrefix) {
                name = (String)Serenity.sessionVariableCalled((Object)(name + "UserFirstName"));
            }
            this.homePage.acceptConnectionInvitation(name);
        }
    }

    public void rejectConnectionInvitations(List<String> names, boolean isPrefix) {
        for (String name : names) {
            if (isPrefix) {
                name = (String)Serenity.sessionVariableCalled((Object)(name + "UserFirstName"));
            }
            this.homePage.rejectConnexionInvitation(name);
        }
    }

    public void acceptRandomSpaceInvitation(String spaceName) {
        this.homePage.acceptSpaceInvitation(spaceName);
    }

    public void acceptSpaceInvitation(List<String> listOfSpaces) {
        for (String spaceName : listOfSpaces) {
            this.homePage.acceptSpaceInvitation(spaceName);
        }
    }

    public void accessToRecentSpaces() {
        this.homePage.accessToRecentSpaces();
    }

    public void bookmarkActivity(String activity) {
        this.homePage.bookmarkActivity(activity);
    }

    public void checkConnectionsBadge(String badgeNumber) {
        this.homePage.isConnectionsBadgeWithNumberVisible(badgeNumber);
    }

    public void checkDisplaySpaceInvitation(List<String> listOfSpaces) {
        for (String spaceName : listOfSpaces) {
            this.homePage.checkExistingSpaceInvitation(spaceName);
        }
    }

    public void checkFavIcon(String activity) {
        this.homePage.checkFavIcon(activity);
    }

    public void checkNoActivityDisplayed() {
        this.homePage.checkNoActivityDisplayed();
    }

    public void checkNotDisplaySpaceInvitation(List<String> listOfSpaces) {
        for (String spaceName : listOfSpaces) {
            this.homePage.checkNotExistingSpaceInvitation(spaceName);
        }
    }

    public void checkRandomDisplaySpaceInvitation(String space) {
        this.homePage.checkExistingSpaceInvitation(space);
    }

    public void checkRandomNotDisplaySpaceInvitation(String space) {
        this.homePage.checkNotExistingSpaceInvitation(space);
    }

    public void checkSpacesBadge(String badgeNumber) {
        this.homePage.isSpacesBadgeWithNumberVisible(badgeNumber);
    }

    public void checkPageIsDisplayed(String pageUri) {
        this.homePage.checkPageIsDisplayed(pageUri);
    }

    public void clickOnArrowIcon() {
        this.homePage.clickOnArrowIcon();
    }

    public void clickOnCommentActivityNotification(String message, String activity, String comment) {
        this.homePage.clickOnCommentActivityNotification(message, activity, comment);
    }

    public void clickOnConnectionsBagde() {
        this.homePage.clickOnConnectionsBagde();
    }

    public void clickOnHomeLink() {
        this.homePage.clickOnHomeLink();
    }

    public void clickOnHomeIcon(String pageName) {
        this.homePage.clickOnHomeIcon(pageName);
    }

    public void checkHomeButtonPosition(String pageName) {
        this.homePage.checkHomeButtonPosition(pageName);
    }

    public void clickOnSpaceInvitationWidget() {
        this.homePage.clickOnSpaceInvitationWidget();
    }

    public void clickOnSpacesBagde() {
        this.homePage.clickOnSpacesBagde();
    }

    public void clickSeeAll() {
        this.homePage.clickSeeAll();
    }

    public void commentActivityNotificationIsDisplayed(String message, String activity, String comment) {
        this.homePage.commentActivityNotificationIsDisplayed(message, activity, comment);
    }

    public void confirmationForChangeSiteHomeLink() {
        this.homePage.confirmationForChangeSiteHomeLink();
    }

    public void deactivateSwitcher() {
        this.homePage.deactivateSwitcher();
    }

    public void favoriteActivity(String activity) {
        this.homePage.favoriteActivity(activity);
    }

    public void goToAddGroups() {
        this.homePage.goToAddGroups();
    }

    public void goToAddUser() {
        this.homePage.goToAddUser();
    }

    public void goToMainSettings() {
        this.homePage.goToMainSettings();
    }

    public void goToAccessCustomization() {
        this.homePage.goToAccessCustomization();
    }

    public void goToAppCenterAdminSetupPage() {
        this.homePage.goToAppCenterAdminSetupPage();
    }

    public void goToNotificationAdminPage() {
        this.homePage.goToNotificationAdminPage();
    }

    public void goToHomePage() {
        this.homePage.goToHomePage();
    }

    public void goToManageSpacesPage() {
        this.homePage.goToSpacesPage(false);
    }

    public void goToMyProfile() {
        this.homePage.goToMyProfile();
    }

    public void goToPeoplePage() {
        this.homePage.goToPeoplePage();
    }

    public void goToSettingsPage() {
        this.homePage.goToSettingsPage();
    }

    public void goToStreamPage() {
        this.homePage.goToStreamPage();
    }

    public void goToContributePage() {
        this.homePage.goToContributePage();
    }

    public void goToPrograms() {
        this.homePage.goToPrograms();
    }

    public void goMyAchievements() {
        this.homePage.goMyAchievements();
    }

    public void goToSite(String siteName) {
        this.homePage.goToSite(siteName);
    }

    public void goToSiteNavigation(String siteName, String uriPart) {
        this.homePage.goToSiteNavigation(siteName, uriPart);
    }

    public void hoverOnPageHomeIcon(String pageName) {
        this.homePage.hoverOnPageHomeIcon(pageName);
    }

    public void hoverSearchedSpaceInSideBarFilter(String space) {
        this.homePage.hoverSearchedSpaceInSideBarFilter(space);
    }

    public void isArrowDisplayedAfterHoveringOnSpaceName() {
        this.homePage.isArrowDisplayedAfterHoveringOnSpaceName();
    }

    public boolean isConnectionsBadgeWithNumberVisible(String number) {
        return this.homePage.isConnectionsBadgeWithNumberVisible(number);
    }

    public void checkNoConnectionsBadge() {
        this.homePage.goToStreamPage();
        this.homePage.checkNoConnectionsBadge();
    }

    public void checkNoSpacesBadge() {
        this.homePage.goToStreamPage();
        this.homePage.checkNoSpacesBadge();
    }

    public void checkNumberOfConnectionsInDrawer(String number) {
        this.homePage.checkNumberOfConnectionsInDrawer(Integer.valueOf(number).intValue());
    }

    public boolean isNumberOfSpacesInDrawer(String number) {
        return this.homePage.isNumberOfSpacesInDrawer(Integer.valueOf(number).intValue());
    }

    public void isPageOpened(String uriPart) {
        this.homePage.isPageOpened(uriPart);
    }

    public boolean isSpacesBadgeWithNumberVisible(String number) {
        return this.homePage.isSpacesBadgeWithNumberVisible(number);
    }

    public void checkThirdLevelNavigationDisplayed() {
        this.homePage.checkThirdLevelNavigationDisplayed();
    }

    public boolean isWidgetWithNumberVisible(String widget, String number) {
        return this.homePage.isWidgetWithNumberVisible(widget, number);
    }

    public void openNotifications() {
        this.homePage.openNotifications();
    }

    public void rejectRandomSpaceInvitation(String spaceName) {
        this.homePage.rejectSpaceInvitation(spaceName);
    }

    public void rejectSingleConnectionInvitation(String userName) {
        this.homePage.rejectConnexionInvitation(userName);
    }

    public void rejectSpaceInvitation(List<String> listOfSpaces) {
        for (String spaceName : listOfSpaces) {
            this.homePage.rejectSpaceInvitation(spaceName);
        }
    }

    public void checkHamburgerMenuSpacePosition(String spaceName, int spaceMenuPosition) {
        this.homePage.checkHamburgerMenuSpacePosition(spaceName, spaceMenuPosition);
    }

    public void checkHamburgerMenuRecentSpaceMenuApplication(String spaceName, String appName, int appPosition) {
        this.homePage.checkHamburgerMenuRecentSpaceMenuApplication(spaceName, appName, appPosition);
    }

    public void openHamburgerMenuRecentSpaceDetails(String spaceName) {
        this.homePage.openHamburgerMenuRecentSpaceDetails(spaceName);
    }

    public void searchApplicationCenter(String app) {
        this.homePage.searchApplicationCenter(app);
    }

    public void searchedSpaceIsDisplayedInSideBarFilter(String space) {
        this.homePage.searchedSpaceIsDisplayedInSideBarFilter(space);
    }

    public void searchedSpaceIsNotDisplayedInSideBarFilter(String space) {
        this.homePage.searchedSpaceIsNotDisplayedInSideBarFilter(space);
    }

    public void searchSpaceInSideBarFilter(String space) {
        this.homePage.searchSpaceInSideBarFilter(space);
    }

    public void selectAllOrMySpaces(String filter) {
        this.homePage.selectAllOrMySpaces(filter);
    }

    public void unbookmarkActivity(String activity) {
        this.homePage.unbookmarkActivity(activity);
    }

    public void checkHamburgerMenuUnsticked() {
        this.homePage.checkHamburgerMenuUnsticked();
    }

    public void checkHamburgerMenuSticky() {
        this.homePage.checkHamburgerMenuSticked();
    }

    public void openHamburgerMenuDrawer() {
        this.homePage.openHamburgerMenuDrawer();
    }

    public void stickHamburgerMenu() {
        this.homePage.stickHamburgerMenu();
    }

    public void unstickHamburgerMenu() {
        this.homePage.unstickHamburgerMenu();
    }

    public boolean isPortalDisplayed() {
        return this.homePage.isPortalDisplayed();
    }

    public void checkHamburgerMenuSpaceDescriptionAndName(String randomSpaceName) {
        this.homePage.checkHamburgerMenuSpaceDescriptionAndName(randomSpaceName);
    }

    public void checkRedDotInHamburgerMenu() {
        this.homePage.checkRedDotInHamburgerMenu();
    }

    public void checkRedDotNotInHamburgerMenu() {
        this.homePage.checkRedDotNotInHamburgerMenu();
    }

    public void clickOnHamburgerMenu() {
        this.homePage.clickOnHamburgerMenu();
    }

    public void clickOutsideHamburgerMenu() {
        this.homePage.clickOutsideHamburgerMenu();
    }

    public void closeHamburgerMenu() {
        this.homePage.closeHamburgerMenu();
    }

    public void waitPortalDisplayed(int retries) {
        this.homePage.waitPortalDisplayed(retries);
    }
}

