/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.pages.KudosPage;
import io.meeds.qa.ui.pages.SpacePage;
import io.meeds.qa.ui.utils.Utils;

public class KudosSteps {
    private KudosPage kudosPage;
    private SpacePage spaceHomePage;

    public void addActivityCommentKudos(String kudos) {
        this.kudosPage.sendKudosMessageFromOpenedDrawer(kudos);
    }

    public void addActivityKudos(String activity, String comment) {
        this.kudosPage.addActivityKudos(activity, comment);
    }

    public void addActivityKudosToSomeoneDifferent(String activity, String message, String user) {
        this.kudosPage.addActivityKudosToSomeoneDifferent(activity, message, user);
    }

    public void attemptSendActivityKudosToSomeoneDifferent(String activity, String message, String user) {
        this.kudosPage.attemptSendActivityKudosToSomeoneDifferent(activity, message, user);
    }

    public void checkKudosIconDisabled(String activityId) {
        this.kudosPage.checkKudosIconDisabled(activityId);
    }

    public void checkKudosSettings(String val, String period) {
        this.kudosPage.checkKudosSettings(val, period);
    }

    public void clickEditKudos() {
        this.kudosPage.clickEditKudos();
    }

    public void clickEditKudosFromReply() {
        this.kudosPage.clickEditKudosFromReply();
    }

    public void editKudos() {
        this.kudosPage.editKudos();
    }

    public void enterKudosNumber(String val) {
        this.kudosPage.enterKudosNumber(val);
    }

    public void goToKudosMenu() {
        this.kudosPage.goToKudosMenu();
    }

    public void isKudosActivityVisible(String message) {
        this.kudosPage.checkKudosActivityVisible(message);
    }

    public void saveChanges() {
        this.kudosPage.saveChange();
    }

    public void selectType() {
        this.kudosPage.selectType();
    }

    public void userCardMenuSendKudos(String kudosMessage) {
        Utils.retryOnCondition(() -> {
            this.kudosPage.userCardSendKudos();
            this.kudosPage.sendKudosMessageFromOpenedDrawer(kudosMessage);
        }, () -> {
            this.kudosPage.closeAllDrawers();
            this.kudosPage.userCardSendKudos();
        });
    }

    public void updateKudosMessage(String kudos) {
        this.spaceHomePage.addActivityTextInOpenedEditor(kudos);
        this.spaceHomePage.clickOnUpdateActivity();
    }

    public void updateKudosCommentMessage(String kudos) {
        this.spaceHomePage.addActivityCommentEditorContent(kudos, true, true);
    }

    public void checkCancelKudosActivityIsNotVisible(String kudos) {
        this.spaceHomePage.openThreeDotsActivityMenu(kudos);
        this.kudosPage.checkCancelKudosActivityIsNotVisible(kudos);
    }

    public void checkCancelKudosCommentIsNotVisible(String activity, String kudos) {
        this.spaceHomePage.openCommentsDrawer(activity);
        this.spaceHomePage.clickOnCommentThreeDotsButtonFromCommentsDrawer(kudos, false);
        this.kudosPage.checkCancelKudosCommentIsNotVisible(kudos);
    }

    public void checkDeleteKudosCommentIsNotVisible(String activity, String kudos) {
        this.spaceHomePage.openCommentsDrawer(activity);
        this.spaceHomePage.clickOnCommentThreeDotsButtonFromCommentsDrawer(kudos, false);
        this.kudosPage.checkDeleteKudosCommentIsNotVisible(kudos);
    }

    public void checkDeleteKudosCommentIsVisible(String activity, String kudos) {
        this.spaceHomePage.openCommentsDrawer(activity);
        this.spaceHomePage.clickOnCommentThreeDotsButtonFromCommentsDrawer(kudos, false);
        this.kudosPage.checkDeleteKudosCommentIsVisible(kudos);
    }

    public void cancelCommentKudos(String activity, String comment) {
        this.spaceHomePage.openCommentsDrawer(activity);
        this.spaceHomePage.clickOnCommentThreeDotsButtonFromCommentsDrawer(comment, false);
        this.kudosPage.cancelKudosComment(activity, comment);
        this.spaceHomePage.clickYesbutton();
    }

    public void cancelActivityKudos(String activity) {
        this.kudosPage.cancelKudosActivity(activity);
        this.spaceHomePage.clickYesbutton();
    }

    public void sendKudosFromUserPopover(String user, String kudosMessage) {
        this.spaceHomePage.showUserPopover(user);
        this.kudosPage.clickOnKudosButtonFromOpenedUserPopover();
        this.kudosPage.sendKudosMessageFromOpenedDrawer(kudosMessage);
    }
}

