/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.pages.LoginPage;
import java.util.List;
import net.serenitybdd.core.Serenity;
import org.apache.commons.lang3.StringUtils;

public class LoginSteps {
    private LoginPage loginPage;

    public void authenticate(String userPrefix) {
        String username = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String password = (String)Serenity.sessionVariableCalled((Object)(username + "-password"));
        this.loginPage.login(username, password);
    }

    public boolean authenticate(String userPrefix, boolean throwException) {
        String username = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String password = (String)Serenity.sessionVariableCalled((Object)(username + "-password"));
        return this.loginPage.login(username, password, throwException);
    }

    public boolean authenticate(String username, String password, boolean throwException) {
        return this.loginPage.login(username, password, throwException);
    }

    public void authenticateIfRandomSpaceAndUsersNotExists(String userPrefix, String spacePrefix, List<String> userPrefixes) {
        boolean spaceDoesntExist = StringUtils.isBlank((CharSequence)spacePrefix) || StringUtils.isBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)spacePrefix)));
        boolean userDoesntExist = userPrefixes.stream().anyMatch(userToCreatePrefix -> StringUtils.isBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)(userToCreatePrefix + "UserName")))));
        if (userDoesntExist || spaceDoesntExist) {
            this.authenticate(userPrefix);
        }
    }

    public void authenticateIfUsersNotExists(String userPrefix, List<String> userPrefixes) {
        this.authenticateIfRandomSpaceAndUsersNotExists(userPrefix, null, userPrefixes);
    }

    public void deleteCookies() {
        this.loginPage.deleteCookies();
    }

    public boolean isLoggedIn() {
        String currentUrl = this.loginPage.getCurrentUrl();
        return StringUtils.contains((CharSequence)currentUrl, (CharSequence)"/portal") && !StringUtils.contains((CharSequence)currentUrl, (CharSequence)"/login");
    }

    public void logout() {
        this.loginPage.logout();
    }

    public void checkLoginPageDisplay() {
        this.loginPage.checkLoginPageDisplay();
    }

    public void waitForUsernameInputDisplay(int retries) {
        if (!this.loginPage.getCurrentUrl().contains("/portal/login")) {
            this.loginPage.openLoginPage();
            this.loginPage.verifyPageLoaded();
        }
        this.loginPage.waitForUsernameInputDisplay(retries);
    }

    public void checkRegisterLinkIsDisplayed() {
        this.loginPage.registerLinkIsDisplayed();
    }

    public void checkRegisterLinkIsNotDisplayed() {
        this.loginPage.registerLinkIsNotDisplayed();
    }
}

