/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.hook.TestInitHook;
import io.meeds.qa.ui.pages.HomePage;
import io.meeds.qa.ui.pages.ManageSpacesPage;
import io.meeds.qa.ui.utils.Utils;
import java.time.Duration;
import java.util.List;
import net.serenitybdd.core.Serenity;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ManageSpaceSteps {
    private static final String GET_CREATE_SPACE_TEMPLATE_SCRIPT = " const callback = arguments[arguments.length - 1];\n fetch(\"/social/rest/space/templates?includeDisabled=true\", {\n   \"method\": \"GET\",\n   \"credentials\": \"include\"\n })\n     .then(resp => resp.json())\n     .then(spaceTemplates => spaceTemplates.find(t => t.name === '000 Automatic Test Template'))\n     .then(template => {\n       return fetch(`/social/rest/space/templates${template?.id && ('/' + template?.id) || ''}`, {\n         \"headers\": {\n           \"content-type\": \"application/json\",\n         },\n         \"body\": `{\"id\": ${template?.id || 0},\"icon\":\"fab fa-adn\",\"enabled\":true,\"order\":0,\"permissions\":[\"*:/platform/users\"],\"spaceLayoutPermissions\":[\"spaceAdmin\"],\"spaceDeletePermissions\":[\"spaceAdmin\"],\"spaceFields\":[\"name\", \"properties\", \"invitation\", \"access\"],\"spaceDefaultVisibility\":\"PRIVATE\",\"spaceDefaultRegistration\":\"OPEN\",\"spaceAllowContentCreation\":false}`,\n         \"method\": template?.id && \"PUT\" || \"POST\",\n         \"credentials\": \"include\"\n       })\n         .then(r => r?.ok && !template && r.json())\n         .then(async temp => {\n             if (template && !temp) {\n               temp = template;\n             }\n             await fetch(`/portal/rest/social/translations/spaceTemplate/${temp.id}/name`, {\n               \"headers\": {\n                 \"content-type\": \"application/json\",\n               },\n               \"body\": `{\"en\":\"000 Automatic Test Template\"}`,\n               \"method\": \"POST\",\n               \"credentials\": \"include\"\n             });\n             await fetch(`/portal/rest/social/translations/spaceTemplate/${temp.id}/description`, {\n               \"headers\": {\n                 \"content-type\": \"application/json\",\n               },\n               \"body\": `{\"en\":\"Automatic Test Template\"}`,\n               \"method\": \"POST\",\n               \"credentials\": \"include\"\n             });\n             return temp;\n         });\n     })\n     .then(spaceTemplate => callback(spaceTemplate.id))\n     .catch(e => callback(String(e) + e?.stack));\n";
    private static final String CREATE_SPACE_SCRIPT = " const callback = arguments[arguments.length - 1];\n fetch(\"/portal/rest/v1/social/spaces/\", {\n   \"headers\": {\n     \"content-type\": \"application/json\",\n   },\n   \"body\": `{\"subscription\":\"%s\",\"visibility\":\"%s\",\"templateId\":%s,\"invitedMembers\":[],\"displayName\":\"%s\",\"description\":\"%s\"}`,\n   \"method\": \"POST\",\n   \"credentials\": \"include\"\n })\n .then(resp => {\n   if (!resp || !resp.ok) {\n     throw new Error(\"Error creating space\");\n   }\n })\n .then(() => callback(true))\n .catch(e => callback(String(e) + e?.stack));\n";
    private static final String SET_SIDEBAR_DEFAULT_MODE = " const callback = arguments[arguments.length - 1];\n fetch(\"/social/rest/navigation/settings\", {\n   \"method\": \"GET\",\n   \"credentials\": \"include\"\n })\n     .then(resp => resp.json())\n     .then(settings => {\n       settings.sidebar.defaultMode = 'STICKY';\n       return fetch(\"/social/rest/navigation/settings\", {\n         \"headers\": {\n           \"content-type\": \"application/json\",\n         },\n         \"body\": JSON.stringify(settings),\n         \"method\": \"PUT\",\n         \"credentials\": \"include\"\n       });\n     })\n     .then(() => callback(true))\n     .catch(e => callback(String(e) + e?.stack));\n";
    private static final String CLEAR_DEFAULT_SPACES = " const callback = arguments[arguments.length - 1];\n fetch(\"/portal/rest/registration/settings\", {\n   \"method\": \"GET\",\n   \"credentials\": \"include\"\n })\n     .then(resp => resp.json())\n     .then(settings => {\n       settings.extraGroupIds = [];\n       return fetch(\"/portal/rest/registration/settings\", {\n         \"headers\": {\n           \"content-type\": \"application/json\",\n         },\n         \"body\": JSON.stringify(settings),\n         \"method\": \"PUT\",\n         \"credentials\": \"include\"\n       });\n     })\n     .then(() => callback(true))\n     .catch(e => callback(String(e) + e?.stack));\n";
    private HomePage homePage;
    private ManageSpacesPage manageSpacesPage;

    public void joinOrGoToSpace(String spaceNamePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)spaceNamePrefix);
        this.homePage.goToSpacesPage(false);
        if (this.findSpaceCard(spaceName, spaceNamePrefix, true)) {
            this.goOrJoinToSpace(spaceName);
        }
    }

    public void addOrGoToSpace(String spaceNamePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)spaceNamePrefix);
        String spaceUrl = (String)Serenity.sessionVariableCalled((Object)(spaceNamePrefix + "-url"));
        if (StringUtils.isNotBlank((CharSequence)spaceUrl)) {
            boolean joined;
            this.homePage.openUrl(spaceUrl);
            Utils.waitForPageLoading();
            if (StringUtils.equals((CharSequence)this.homePage.getCurrentUrl(), (CharSequence)spaceUrl)) {
                return;
            }
            if (!this.manageSpacesPage.isSpaceMenuDisplayed() && (joined = this.manageSpacesPage.clickSpaceActionToJoin())) {
                Utils.waitForLoading();
                return;
            }
        }
        this.homePage.goToSpacesPage(false);
        if (StringUtils.isBlank((CharSequence)spaceName)) {
            spaceName = Utils.getRandomString((String)spaceNamePrefix);
            if (this.findSpaceCard(spaceName, spaceNamePrefix)) {
                this.goOrJoinToSpace(spaceName);
            } else {
                this.addSpaceWithRegistration(spaceName, "Open");
            }
            TestInitHook.spaceWithPrefixCreated(spaceNamePrefix, spaceName, this.homePage.getCurrentUrl());
        } else if (this.findSpaceCard(spaceName, spaceNamePrefix, true)) {
            this.goOrJoinToSpace(spaceName);
        }
    }

    public void addSpaceWithInviteUser(String spaceName, String user) {
        this.manageSpacesPage.openSpaceFormDrawer();
        this.manageSpacesPage.setSpaceName(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.setSpaceDescription(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.inviteUserToSpace(user);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.saveSpace();
    }

    private String getSpaceTemplateId() {
        return (String)Serenity.sessionVariableCalled((Object)"SpaceTemplateId");
    }

    public void addSpaceWithRegistrationAndInviteUser(String spaceName, String registration, String user) {
        this.manageSpacesPage.openSpaceFormDrawer();
        this.manageSpacesPage.setSpaceName(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.setSpaceDescription(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.inviteUserToSpace(user);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.checkSpaceRegistration(registration);
        this.manageSpacesPage.saveSpace();
    }

    public void addSpaceWithRegistration(String spaceName, String registration) {
        this.manageSpacesPage.openSpaceFormDrawer();
        this.manageSpacesPage.setSpaceName(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.setSpaceDescription(spaceName);
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.clickNextButton();
        this.manageSpacesPage.checkSpaceRegistration(registration);
        this.manageSpacesPage.saveSpace();
    }

    public void addUserToSpace(String user) {
        this.manageSpacesPage.addUserToSpace(user);
    }

    public void checkAvatarSection() {
        this.manageSpacesPage.checkAvatarSection();
    }

    public void checkCancelButton() {
        this.manageSpacesPage.checkCancelButton();
    }

    public void checkDescriptionSpaceSection() {
        this.manageSpacesPage.checkDescriptionSpaceSection();
    }

    public void checkFavIconInSpaceCard() {
        this.manageSpacesPage.checkFavIconInSpaceCard();
    }

    public void checkFavIconInSpacePopoverFromTopbar() {
        this.manageSpacesPage.checkFavIconInSpacePopoverFromTopbar();
    }

    public void checkFavIconInThirdNavigationLevel() {
        this.manageSpacesPage.checkFavIconInThirdNavigationLevel();
    }

    public void checkSpaceBookmarkedFromSpaceCard() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromSpaceCard(true);
    }

    public void checkSpaceBookmarkedFromTopbarSpacePopover() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromTopbarSpacePopover(true);
    }

    public void checkSpaceBookmarkThirdNavigationLevel() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromThirdNavigationLevel(true);
    }

    public void checkSpaceUnBookmarkFromSpaceCard() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromSpaceCard(false);
    }

    public void checkSpaceUnBookmarkFromThirdNavigationLevel() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromThirdNavigationLevel(false);
    }

    public void checkSpaceUnBookmarkFromTopbarSpacePopover() {
        this.manageSpacesPage.checkSpaceBookmarkStatusFromTopbarSpacePopover(false);
    }

    public void checkThatSpaceDetailsInSearchResultsAreDisplayed(String spaceName, String members) {
        this.manageSpacesPage.checkThatSpaceDetailsInSearchResultsAreDisplayed(spaceName, members);
    }

    public void checkThatSpaceDetailsInSearchResultsAreDisplayedByOtherUser(String spaceName, String members) {
        this.manageSpacesPage.checkThatSpaceDetailsInSearchResultsAreDisplayedByOtherUser(spaceName, members);
    }

    public void checkThatSpaceInSearchResultsIsNotDisplayed(String spaceName) {
        this.manageSpacesPage.checkThatSpaceInSearchResultsIsNotDisplayed(spaceName);
    }

    public void checkThirtyRandomSpacesArePresent() {
        this.homePage.goToSpacesPage(true);
        Utils.waitForLoading();
        if (!this.manageSpacesPage.isLoadMoreButtonPresent()) {
            for (int i = 0; i < 30; ++i) {
                this.injectRandomSpace("randomSpaceName");
            }
            this.homePage.goToSpacesPage(true);
            Utils.waitForLoading();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.manageSpacesPage.isLoadMoreButtonPresent()).as("Spaces Load More button isn't displayed after adding 30 spaces", new Object[0])).isTrue();
        }
    }

    public void clickOnGeneralSpaceSettings() {
        this.manageSpacesPage.clickOnGeneralSpaceSettings();
    }

    public void clickOnSpaceBookmarkIconFromSpaceCard() {
        this.manageSpacesPage.clickOnSpaceBookmarkIconFromSpaceCard();
    }

    public void clickOnSpaceBookmarkIconFromThirdNavigationLevel() {
        this.manageSpacesPage.clickOnSpaceBookmarkIconFromThirdNavigationLevel();
    }

    public void clickOnSpaceBookmarkIconFromTopbarSpacePopover() {
        this.manageSpacesPage.clickOnSpaceBookmarkIconFromTopbarSpacePopover();
    }

    public void clickSpaceAction(String action) {
        this.manageSpacesPage.clickSpaceAction(action);
    }

    public void deleteSpace(String spaceName) {
        this.manageSpacesPage.deleteSpace(spaceName);
    }

    public void deleteSpacesList(List<String> listOfSpaces) {
        for (String spaceName : listOfSpaces) {
            Utils.refreshPage();
            this.manageSpacesPage.deleteSpace(spaceName);
        }
    }

    public void goToMembersTab() {
        this.manageSpacesPage.goToMembersTab();
    }

    public void goToSettingsTab() {
        this.manageSpacesPage.goToSettingsTab();
    }

    public void goToSpaceHomeViaSpaceAvatar() {
        this.manageSpacesPage.goToSpaceHomeViaSpaceAvatar();
    }

    public void goToTasksTab() {
        this.manageSpacesPage.goToTasksTab();
    }

    public void hoverOnSpaceName() {
        this.manageSpacesPage.hoverOnSpaceName();
    }

    public void searchSpace(String spaceName) {
        this.manageSpacesPage.insertSpaceNameInSearchField(spaceName);
    }

    public void leaveSpace() {
        this.manageSpacesPage.leaveSpace();
    }

    public void selectFilter(String filter) {
        this.manageSpacesPage.selectFilter(filter);
    }

    public void showMoreSpaces() {
        this.manageSpacesPage.showMoreSpaces();
    }

    public void spaceAvatarIsDisplayed() {
        this.manageSpacesPage.spaceAvatarIsDisplayed();
    }

    public void spaceNameIsDisplayed(String space) {
        this.manageSpacesPage.spaceNameIsDisplayed(space);
    }

    public void uploadSpaceBanner(String fileName) {
        this.manageSpacesPage.uploadSpaceBanner(fileName);
    }

    public void openSpaceInvitationDrawer() {
        this.manageSpacesPage.openSpaceInvitationDrawer();
    }

    public void openSpaceExternalInvitationDrawer() {
        this.manageSpacesPage.openSpaceExternalInvitationDrawer();
    }

    public void inviteEmailAsSpaceMember(String email) {
        this.manageSpacesPage.inviteEmailAsSpaceMember(email);
    }

    public void emailIsListedInInvitationList(String email, String status) {
        this.manageSpacesPage.emailIsListedInInvitationList(email, status);
    }

    public void openSpacePendingInvitationsDrawer() {
        this.manageSpacesPage.openSpacePendingInvitationsDrawer();
    }

    public void openSpaceExternalInvitationsTab() {
        this.manageSpacesPage.openSpaceExternalInvitationsTab();
    }

    public void checkExternalInviteButtonNotDisplayed() {
        this.manageSpacesPage.checkExternalInviteButtonNotDisplayed();
    }

    public void emailIsNotListedInInvitationList(String email) {
        this.manageSpacesPage.emailIsNotListedInInvitationList(email);
    }

    public void injectRandomSpace(String spaceNamePrefix) {
        String spaceName = Utils.getRandomString((String)spaceNamePrefix);
        String addSpaceScript = String.format(CREATE_SPACE_SCRIPT, "open", "private", this.getSpaceTemplateId(), spaceName, spaceName);
        WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(10L), Duration.ofMillis(Utils.SHORT_WAIT_DURATION_MILLIS));
        wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeAsyncScript(addSpaceScript, new Object[0]).toString().equals("true"));
        String spaceUrl = this.homePage.getCurrentUrl().split("/portal")[0] + "/portal/g/:spaces:" + spaceName;
        TestInitHook.spaceWithPrefixCreated(spaceNamePrefix, spaceName, spaceUrl);
    }

    public void injectSpaceTemplate() {
        String spaceTemplateId = ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(GET_CREATE_SPACE_TEMPLATE_SCRIPT, new Object[0]).toString();
        Long.parseLong(spaceTemplateId);
        Serenity.setSessionVariable((Object)"SpaceTemplateId").to((Object)spaceTemplateId);
    }

    public void setSideBarDefaultMode() {
        String result = ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(SET_SIDEBAR_DEFAULT_MODE, new Object[0]).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)result);
    }

    public void clearDefaultSpaces() {
        String result = ((JavascriptExecutor)Serenity.getDriver()).executeAsyncScript(CLEAR_DEFAULT_SPACES, new Object[0]).toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)result);
    }

    private boolean findSpaceCard(String spaceName, String spaceNamePrefix) {
        return this.findSpaceCard(spaceName, spaceNamePrefix, false);
    }

    private boolean findSpaceCard(String spaceName, String spaceNamePrefix, boolean mandatory) {
        if (StringUtils.isNotBlank((CharSequence)spaceNamePrefix) && StringUtils.isNotBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)(spaceNamePrefix + "-url"))))) {
            try {
                Utils.retryOnCondition(() -> {
                    this.manageSpacesPage.insertSpaceNameInSearchField(spaceName);
                    if (!this.manageSpacesPage.isSpaceCardDisplayed(spaceName, mandatory)) {
                        throw new IllegalStateException(String.format("Space %s not found", spaceName));
                    }
                });
                return this.manageSpacesPage.isSpaceCardDisplayed(spaceName, mandatory);
            }
            catch (RuntimeException e) {
                if (mandatory) {
                    throw e;
                }
                return false;
            }
        }
        this.manageSpacesPage.insertSpaceNameInSearchField(spaceName);
        return this.manageSpacesPage.isSpaceCardDisplayed(spaceName, mandatory);
    }

    private void goOrJoinToSpace(String spaceName) {
        if (this.manageSpacesPage.isSpaceCardJoinButtonDisplayed(spaceName)) {
            this.manageSpacesPage.joinSpaceFromCard(spaceName);
        }
        this.manageSpacesPage.goToSpecificSpace(spaceName);
        if (!this.manageSpacesPage.isSpaceMenuDisplayed()) {
            this.manageSpacesPage.clickSpaceActionToJoin();
        }
    }
}

