/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps;

import io.meeds.qa.ui.pages.ProgramsPage;
import io.meeds.qa.ui.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import org.apache.commons.lang3.StringUtils;

public class ProgramsSteps {
    private ProgramsPage programsPage;
    private String currentProgramTitle;
    private Map<String, String> programUrls = new HashMap<String, String>();

    public void enableDisableProgram() {
        this.programsPage.enableDisableProgram();
    }

    public void checkProgramStatusSwitchNotDisplayed() {
        this.programsPage.checkProgramStatusSwitchNotDisplayed();
    }

    public void goBackUsingProgramTitle(String programName) {
        this.programsPage.goBackUsingProgramTitle(programName);
    }

    public void enterProgramDescription(String programDescription) {
        this.programsPage.enterProgramDescription(programDescription);
    }

    public void addSpaceAudience(String randomSpaceName) {
        this.programsPage.addSpaceAudience(randomSpaceName);
    }

    public void clickSaveProgramButton() {
        this.programsPage.clickSaveProgramButton();
        if (this.currentProgramTitle != null && this.programsPage.getCurrentUrl().contains("programs/")) {
            this.programUrls.put(this.currentProgramTitle, this.programsPage.getCurrentUrl());
        }
    }

    public void checkProgramCardDisplay(String programName) {
        this.programsPage.checkProgramCardDisplay(programName);
    }

    public void checkProgramCardTitle(String title) {
        this.programsPage.checkProgramCardTitle(title);
    }

    public void checkProgramDrawerDisplay() {
        this.programsPage.checkProgramDrawerDisplay();
    }

    public void clickAddProgramBtn() {
        this.programsPage.clickAddProgramBtn();
    }

    public void deleteCreatedProgram(String programName) {
        this.programsPage.deleteCreatedProgram(programName);
    }

    public void editProgram() {
        this.programsPage.editProgram();
    }

    public void editProgram(String programName) {
        this.programsPage.editProgram(programName);
    }

    public void editProgramWithDescription(String programName, String newProgramName, String newProgramDescription) {
        this.programsPage.editProgramWithDescription(programName, newProgramName, newProgramDescription);
        this.programUrls.remove(programName);
    }

    public void enterProgramTitle(String programTitle) {
        this.programsPage.enterProgramTitle(programTitle);
        this.currentProgramTitle = programTitle;
    }

    public void selectEngagementApplication(String tab) {
        this.programsPage.selectEngagementApplication(tab);
    }

    public void selectProgramsFilter(String value) {
        this.programsPage.selectProgramsFilter(value);
    }

    public void selectProgramActionsFilter(String value) {
        this.programsPage.selectProgramActionsFilter(value);
    }

    public void openProgramCard(String programTitle) {
        this.programUrls.compute(programTitle, (k, v) -> {
            if (StringUtils.isBlank((CharSequence)v)) {
                this.programsPage.openProgramCard(programTitle);
            } else {
                this.programsPage.getDriver().navigate().to(v);
            }
            return v;
        });
    }

    public void editProgramAction(String actionTitle) {
        this.programsPage.editProgramAction(actionTitle);
    }

    public void enableProgramAction(String actionTitle) {
        this.programsPage.enableProgramAction(actionTitle);
    }

    public void disableProgramAction(String actionTitle) {
        this.programsPage.disableProgramAction(actionTitle);
    }

    public void deleteProgramAction(String actionTitle) {
        this.programsPage.deleteProgramAction(actionTitle);
    }

    public void checkCannotAnnounceAction() {
        this.programsPage.checkCannotAnnounceAction();
    }

    public void checkProgramActionNotContainsDurationLimitation() {
        this.programsPage.checkProgramActionNotContainsDurationLimitation();
    }

    public void checkProgramActionContainsDurationLimitation() {
        this.programsPage.checkProgramActionContainsDurationLimitation();
    }

    public void closeProgramCard() {
        this.programsPage.closeProgramCard();
    }

    public void announceAction(String challengeTitle, String announcementMessage) {
        this.programsPage.announceAction(challengeTitle, announcementMessage);
    }

    public void announceActionFromActivity(String challengeTitle, String announcementMessage) {
        this.programsPage.announceActionFromActivity(challengeTitle, announcementMessage);
    }

    public void sendAnnouncementMessage(String announcementMessage) {
        this.programsPage.sendAnnouncementMessage(announcementMessage);
    }

    public void createRandomProgram(String programName, Map<String, String> details) {
        this.clickAddProgramBtn();
        Object programDescription = details.get("description");
        String programAudience = details.get("audience");
        if (StringUtils.isBlank((CharSequence)programDescription)) {
            programDescription = "programDescription" + Utils.getRandomNumber();
        }
        if (StringUtils.isNotBlank((CharSequence)programAudience)) {
            programAudience = (String)Serenity.sessionVariableCalled((Object)(programAudience + "RandomSpaceName"));
        }
        this.programsPage.saveProgram(programName, (String)programDescription, programAudience);
        this.programsPage.closeToastNotification(false);
        if (programName != null && this.programsPage.getCurrentUrl().contains("programs/")) {
            this.programUrls.put(programName, this.programsPage.getCurrentUrl());
        }
    }

    public void checkProgramPositionInTopPrograms(String programName, int listPosition) {
        this.programsPage.checkProgramPositionInTopPrograms(programName, listPosition);
    }

    public void checkProgramNotDisplayedInTopPrograms(String programName) {
        this.programsPage.checkProgramNotDisplayedInTopPrograms(programName);
    }

    public void addProgramOwner(String firstName) {
        this.programsPage.addProgramOwner(firstName);
    }

    public void checkActionsFilterIsDisplayed() {
        this.programsPage.checkActionsFilterIsDisplayed();
    }

    public void checkAdminActionsFilterIsNotDisplayed() {
        this.programsPage.checkAdminActionsFilterIsNotDisplayed();
    }

    public void checkAdminActionsFilterIsDisplayed() {
        this.programsPage.checkAdminActionsFilterIsDisplayed();
    }

    public void checkMessageIsDisplayedInProgramDetailDrawer(String message) {
        this.programsPage.checkMessageIsDisplayedInProgramDetailDrawer(message);
    }

    public void checkMessageIsNotDisplayedInProgramDetailDrawer(String message) {
        this.programsPage.checkMessageIsNotDisplayedInProgramDetailDrawer(message);
    }

    public void attachAvatarToProgram() {
        this.programsPage.attachAvatarToProgram();
    }

    public void attachCoverToProgram() {
        this.programsPage.attachCoverToProgram();
    }

    public void deleteAvatarFromProgram() {
        this.programsPage.deleteAvatarFromProgram();
    }

    public void deleteCoverFromProgram() {
        this.programsPage.deleteCoverFromProgram();
    }

    public void checkProgramAvatarIsSpecificInDetail() {
        this.programsPage.checkProgramAvatarIsSpecificInDetail();
    }

    public void checkProgramCoverIsSpecificInDetail() {
        this.programsPage.checkProgramCoverIsSpecificInDetail();
    }

    public void checkProgramAvatarIsDefaultInDetail() {
        this.programsPage.checkProgramAvatarIsDefaultInDetail();
    }

    public void checkProgramCoverIsDefaultInDetail() {
        this.programsPage.checkProgramCoverIsDefaultInDetail();
    }
}

