/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.AchievementsSteps;
import io.meeds.qa.ui.utils.Utils;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class AchievementsStepDefinition {
    private static final String PROGRAM_NAME_PREFIX = "programName";
    @Steps
    private AchievementsSteps achievementsSteps;

    @When(value="I open '{}' achivements drawer from program detail")
    public void openAchievementsDrawerFromProgramDetail(String ruleTitle) {
        this.achievementsSteps.openAchievementsDrawerFromProgramDetail(ruleTitle);
    }

    @Then(value="Achievement '{}' of user '{}' is displayed '{}'")
    public void checkThatAchievementIsDisplayedInPosition(String ruleTitle, String userPrefix, String indexName) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        int index = Utils.getIndexFomName((String)indexName);
        this.achievementsSteps.checkThatAchievementIsDisplayedInPosition(ruleTitle, userName, index);
    }

    @Then(value="Current user achievement '{}' is displayed '{}'")
    public void checkThatAchievementIsDisplayedInPosition(String ruleTitle, String indexName) {
        int index = Utils.getIndexFomName((String)indexName);
        this.achievementsSteps.checkThatAchievementIsDisplayedInPosition(ruleTitle, index);
    }

    @Then(value="In drawer, user '{}' achievement is display '{}'")
    public void checkThatAchievementInDrawerIsDisplayedInPosition(String userPrefix, String indexName) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        String fullName = firstName + " " + lastName;
        int index = Utils.getIndexFomName((String)indexName);
        this.achievementsSteps.checkThatAchievementInDrawerIsDisplayedInPosition(fullName, index);
    }

    @Then(value="^Achievement for '(.*)' is accepted$")
    public void checkThatAchievementIsAccepted(String appDescription) {
        this.achievementsSteps.checkThatAchievementIsAccepted(appDescription);
    }

    @Then(value="^Achievement for '(.*)' is pending")
    public void checkThatAchievementIsPending(String appDescription) {
        this.achievementsSteps.checkThatAchievementIsPending(appDescription);
    }

    @Then(value="^I accept the achievements '(.*)'")
    public void acceptAchievement(String appDescription) {
        this.achievementsSteps.acceptAchievement(appDescription);
    }

    @Then(value="^Achievement for '(.*)' is rejected$")
    public void checkThatAchievementIsRejected(String actionTitle) {
        this.achievementsSteps.checkThatAchievementIsRejected(actionTitle);
    }

    @Then(value="^Achievement for '(.*)' is canceled$")
    public void checkThatAchievementIsCanceled(String actionTitle) {
        this.achievementsSteps.checkThatAchievementIsCanceled(actionTitle);
    }

    @Then(value="^Achievement for '(.*)' is rejected due to activity deletion$")
    public void checkThatAchievementIsDeleted(String actionTitle) {
        this.achievementsSteps.checkThatAchievementIsDeleted(actionTitle);
    }

    @Then(value="^The achievement '(.*)' is displayed '(.*)' times$")
    public void checkThatAchievementIsDisplayed(String actionTitle, String times) {
        this.achievementsSteps.checkThatAchievementIsDisplayed(actionTitle, Long.parseLong(times));
    }

    @Then(value="^The achievement '(.*)' is displayed '(.*)' times when enabling program owner view for '(.*)' random program$")
    public void checkThatAchievementIsDisplayedWithProgramOwnerView(String actionTitle, String times, String randomProgramSuffix) {
        String programName = (String)Serenity.sessionVariableCalled((Object)(PROGRAM_NAME_PREFIX + randomProgramSuffix));
        this.achievementsSteps.checkThatAchievementIsDisplayedWithProgramOwnerView(actionTitle, Long.parseLong(times), programName);
    }

    @Then(value="^The achievement '(.*)' is displayed '(.*)' times for '(.*)' random program$")
    public void checkThatAchievementIsDisplayed(String actionTitle, String times, String randomProgramSuffix) {
        String programName = (String)Serenity.sessionVariableCalled((Object)(PROGRAM_NAME_PREFIX + randomProgramSuffix));
        this.achievementsSteps.checkThatAchievementIsDisplayed(actionTitle, Long.parseLong(times), programName);
    }

    @And(value="^I filter achievements using '(.*)' program$")
    public void filterAchievementByProgram(String programTitle) {
        this.achievementsSteps.filterAchievementByProgram(programTitle);
    }

    @And(value="^I filter achievements using '(.*)' random program$")
    public void filterAchievementByRandomProgram(String suffix) {
        String programName = (String)Serenity.sessionVariableCalled((Object)(PROGRAM_NAME_PREFIX + suffix));
        this.achievementsSteps.filterAchievementByProgram(programName);
    }

    @And(value="^I filter achievements using '(.*)' random user$")
    public void filterAchievementByRandomUser(String userPrefix) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.achievementsSteps.filterAchievementByUser(firstName + " " + lastName);
    }
}

