/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.meeds.qa.ui.steps.ActionsSteps;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class ActionsStepDefinition {
    @Steps
    private ActionsSteps actionsSteps;

    @And(value="^I update the '(.*)' random challenge with$")
    public void updateRandomChallenge(String suffix, Map<String, String> details) {
        String challengeName = (String)Serenity.sessionVariableCalled((Object)("actionName" + suffix));
        this.actionsSteps.updateAction(challengeName, details);
    }

    @And(value="^I search the '(.*)' random challenge$")
    public void searchChallenge(String suffix) {
        String challengeName = (String)Serenity.sessionVariableCalled((Object)("actionName" + suffix));
        this.actionsSteps.searchChallenge(challengeName);
    }

    @And(value="^The '(.*)' challenge is displayed with '(.*)' points$")
    public void checkChallengePoints(String suffix, String points) {
        String challengeName = (String)Serenity.sessionVariableCalled((Object)("actionName" + suffix));
        this.actionsSteps.checkChallengePoints(challengeName, points);
    }

    @And(value="I go to the activity of opened action")
    public void openActionActivity() {
        this.actionsSteps.openActionActivity();
    }

    @And(value="I go to the action from opened drawer")
    public void openActionFromActivity() {
        this.actionsSteps.openActionFromActivity();
    }

    @And(value="^'(.*)' participants is displayed in action drawer$")
    public void openActionFromActivity(String count) {
        this.actionsSteps.checkParticipantsCount(Integer.parseInt(count));
    }

    @And(value="^I set rule publication message '(.*)'$")
    public void setActionPublicationMessage(String message) {
        this.actionsSteps.setActionPublicationMessage(message);
    }

    @And(value="I enable rule publication")
    public void enableActionPublication() {
        this.actionsSteps.enableActionPublication();
    }

    @Then(value="^'(.*)' is displayed in challenge portlet with '(.*)' participants$")
    public void isOverviewChallengeDisplayed(String challengeTitle, String participantsCount) {
        this.actionsSteps.isOverviewChallengeDisplayed(challengeTitle, participantsCount);
    }

    @Then(value="^'(.*)' with '(.*)' participants is not displayed in challenge portlet$")
    public void isOverviewChallengeNotDisplayed(String challengeTitle, String participantsCount) {
        this.actionsSteps.isOverviewChallengeNotDisplayed(challengeTitle, participantsCount);
    }
}

