/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.meeds.qa.ui.steps.AddUserSteps;
import io.meeds.qa.ui.steps.HomeSteps;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class AddUserStepDefinition {
    @Steps
    private AddUserSteps addUserSteps;
    @Steps
    private HomeSteps homeSteps;

    @Given(value="^I create a dedicated user to be an administrator$")
    public void addRandomAdminUser() {
        this.addUserSteps.addRandomUser("firstAdmin", true, false);
    }

    @Given(value="^I create the ([^']*) random user if not existing$")
    @And(value="^I create the '(.*)' random user if not existing$")
    public void createRandomUserIfNotExisting(String userPrefix) {
        this.addUserSteps.addRandomUser(userPrefix, true, false);
    }

    @Given(value="^I inject the ([^']*) random user if not existing$")
    @And(value="^I inject the '(.*)' random user if not existing$")
    public void injectRandomUserIfNotExisting(String userPrefix) {
        this.addUserSteps.addRandomUser(userPrefix, true, true);
    }

    @Given(value="^I create the ([^']*) random user if not existing, no wait$")
    @And(value="^I create the '(.*)' random user if not existing, no wait$")
    public void createRandomUserIfNotExistingNoWait(String userPrefix) {
        this.addUserSteps.addRandomUser(userPrefix, false, false);
    }

    @Given(value="^I inject the ([^']*) random user if not existing, no wait$")
    @And(value="^I inject the '(.*)' random user if not existing, no wait$")
    public void injectRandomUserIfNotExistingNoWait(String userPrefix) {
        this.addUserSteps.addRandomUser(userPrefix, false, true);
    }

    @Given(value="^I create the ([^']*) random user$")
    @And(value="^I create the '(.*)' random user$")
    public void createRandomUser(String userPrefix) {
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to(null);
        this.addUserSteps.addRandomUser(userPrefix, true, false);
    }

    @Given(value="^I inject the ([^']*) random user$")
    @And(value="^I inject the '(.*)' random user$")
    public void injectRandomUser(String userPrefix) {
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to(null);
        this.addUserSteps.addRandomUser(userPrefix, true, true);
    }

    @Given(value="^I create the ([^']*) random user, no wait$")
    @And(value="^I create the '(.*)' random user, no wait$")
    public void createRandomUserNoWait(String userPrefix) {
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to(null);
        this.addUserSteps.addRandomUser(userPrefix, false, false);
    }

    @Given(value="^I inject the ([^']*) random user, no wait$")
    @And(value="^I inject the '(.*)' random user, no wait$")
    public void injectRandomUserNoWait(String userPrefix) {
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to(null);
        this.addUserSteps.addRandomUser(userPrefix, false, true);
    }

    @Given(value="^I inject the ([^']*) random user with the following memberships")
    @And(value="^I inject the '(.*)' random user with the following memberships$")
    public void injectRandomUserWithGroups(String userPrefix, List<String> groups) {
        Serenity.setSessionVariable((Object)(userPrefix + "UserName")).to(null);
        this.addUserSteps.injectRandomUserWithGroups(userPrefix, groups, true);
    }

    @Given(value="^The following user is created$")
    public void addUser(Map<String, String> userDetails) {
        this.homeSteps.goToAddUser();
        this.addUserSteps.addUser(userDetails);
    }

    @Given(value="^I check that the (.*) random user is deleted$")
    public void checkCreatedUserIsDeleted(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.addUserSteps.checkUserIsDeleted(userLastName);
    }

    @Given(value="^Popup is displayed to inform user that we can't delete your user account while being logged in with it$")
    public void checkPopupCantDeleteLoggedUser() {
        this.addUserSteps.checkPopupCantDeleteLoggedUser();
    }

    @Given(value="^Add Users drawer is opened$")
    public void checkThatAddUserDrawerIsDisplayed() {
        this.addUserSteps.checkThatAddUserDrawerIsDisplayed();
    }

    @Given(value="^I check that '(.*)' is deleted'$")
    public void checkUserIsDeleted(String fullName) {
        this.addUserSteps.checkUserIsDeleted(fullName);
    }

    @Given(value="^I click to delete user$")
    public void clickToDeleteUser() {
        this.addUserSteps.clickToDeleteUser();
    }

    @Given(value="^I delete user$")
    public void deleteUser() {
        this.addUserSteps.deleteUser();
    }

    @Given(value="^I enable User Status '(.*)'$")
    @And(value="^I disable User Status '(.*)'$")
    public void enableDisableUser(String userPrefix) {
        this.addUserSteps.enableDisableUser((String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName")));
    }

    @Given(value="^I enter the user's informations$")
    public void enterUserInformations(Map<String, String> userDetails) {
        this.homeSteps.goToAddUser();
        this.addUserSteps.enterUserInformations(userDetails);
    }

    @Given(value="^I go to Add Users page$")
    public void goToAddUser() {
        this.homeSteps.goToAddUser();
    }

    @Given(value="^The (.*) created user is displayed$")
    public void isFirstUserNameDisplayed(String userPrefix) {
        this.addUserSteps.isUserNameDisplayed((String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName")));
    }

    @Given(value="^The user '(.*)' is displayed$")
    public void isUserNameDisplayed(String user) {
        this.addUserSteps.isUserNameDisplayed(user);
    }

    @Given(value="^I add the user$")
    public void saveAddingUser() {
        this.addUserSteps.saveAddingUser();
    }

    @Given(value="^I search for the (.*) random user$")
    public void searchForCreatedUser(String userPrefix) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        this.addUserSteps.searchForUsersByName(userName);
    }

    @Given(value="^I search for user '(.*)'$")
    public void searchForUser(String user) {
        this.addUserSteps.searchForUsersByName(user);
    }

    @Given(value="^I search for '(.*)' Users$")
    public void searchForUsersByStatus(String status) {
        this.addUserSteps.searchForUsersByStatus(status);
    }
}

