/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.AdminApplicationSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class AdminApplicationStepDefinition {
    @Steps
    private AdminApplicationSteps adminApplicationSteps;

    @When(value="^I add a new application with the following data$")
    public void addNewApp(Map<String, String> appData) {
        this.adminApplicationSteps.enterApplicationValues(appData);
        this.setCurrentlyTestingApplicationTitle(appData);
    }

    @When(value="^I add a new application with the title, the url and the description$")
    public void addNewAppWithDescription(Map<String, String> appData) {
        this.adminApplicationSteps.enterApplicationTitleUrlDescription(appData);
        String applicationTitle = appData.get("Application title");
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)applicationTitle);
        this.setCurrentlyTestingApplicationTitle(applicationTitle);
    }

    @When(value="I add a new random application")
    public void addNewRandomApp() {
        String randomApplicationTitle = "title" + Utils.getRandomString();
        String randomApplicationUrl = "./" + Utils.getRandomString();
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)randomApplicationTitle);
        Serenity.setSessionVariable((Object)"randomApplicationUrl").to((Object)randomApplicationUrl);
        this.adminApplicationSteps.enterRandomApplicationTitleAndUrl(randomApplicationTitle, randomApplicationUrl);
        this.setCurrentlyTestingApplicationTitle(randomApplicationTitle);
    }

    @When(value="Edit application mandatory active and mobile are displayed in drawer")
    public void applicationDrawerEnabledButtonsAreIsDisplayed() {
        this.adminApplicationSteps.applicationDrawerEnabledButtonsAreIsDisplayed();
    }

    @When(value="Edit application image is displayed {string} in drawer")
    public void applicationDrawerImageIsDisplayed(String image) {
        this.adminApplicationSteps.applicationDrawerImageIsDisplayed(image);
    }

    @When(value="Edit application permissions {string} and {string} are displayed in drawer")
    public void applicationDrawerPermissionsIsDisplayed(String firstPermission, String secondPermission) {
        this.adminApplicationSteps.applicationDrawerPermissionsIsDisplayed(firstPermission, secondPermission);
    }

    @When(value="^Edit application title is displayed '(.*)' in drawer$")
    public void applicationDrawerTitleIsDisplayed(String title) {
        this.adminApplicationSteps.applicationDrawerTitleIsDisplayed(title);
    }

    @Then(value="^Application Title '(.*)' is displayed in Applications Table$")
    public void appTitleInApplicationsTableIsDisplayed(String appTitle) {
        this.adminApplicationSteps.appTitleInApplicationsTableIsDisplayed(appTitle);
    }

    @Then(value="Delete popup is not displayed")
    public void checkPopupDeleteNotVisible() {
        this.adminApplicationSteps.checkPopupDeleteNotVisible();
    }

    @Then(value="^Application image title '(.*)' is displayed in the drawer$")
    public void checkThatApplicationImageIsDisplayedInDrawer(String image) {
        this.adminApplicationSteps.checkThatApplicationImageIsDisplayedInDrawer();
    }

    @Then(value="The image of the application is not displayed in Applications Table")
    public void checkThatApplicationImageIsNotDisplayedInApplicationsTable() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.checkThatApplicationImageIsNotDisplayedInApplicationsTable(randomApplicationTitle);
    }

    @Then(value="^Application image title '(.*)' is not displayed in the drawer$")
    public void checkThatApplicationImageIsNotDisplayedInDrawer(String image) {
        this.adminApplicationSteps.checkThatApplicationImageIsNotDisplayedInDrawer();
    }

    @Then(value="The image of the second application is not displayed in Applications Table")
    public void checkThatSecondApplicationImageIsNotDisplayedInApplicationsTable() {
        String secondRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"secondRandomApplicationTitle");
        this.adminApplicationSteps.checkThatApplicationImageIsNotDisplayedInApplicationsTable(secondRandomApplicationTitle);
    }

    @When(value="^I click on '(.*)' active button$")
    public void clickActiveApp(String appName) {
        this.adminApplicationSteps.clickActiveApp(appName);
    }

    @When(value="^I click on cancel delete application$")
    public void clickCancelDelete() {
        this.adminApplicationSteps.clickCancelDelete();
    }

    @When(value="^I click on close popup delete application$")
    public void clickCloseDeletePopup() {
        this.adminApplicationSteps.clickCloseDeletePopup();
    }

    @When(value="^I click on delete icon of the created application$")
    public void clickDeleteRandomApplication() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.deleteApp(randomApplicationTitle, false);
    }

    @When(value="^I click on the added application active button$")
    public void clickRandomActiveApp() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.clickActiveApp(randomApplicationTitle);
    }

    @When(value="^I click on Save in application drawer$")
    public void clickSaveApplicationDrawer() {
        this.adminApplicationSteps.clickSaveApplicationDrawer();
    }

    @When(value="^I delete the created application$")
    public void deleteRandomApp() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.deleteApp(randomApplicationTitle, true);
    }

    @When(value="^I disable Mandatory '(.*)' for application$")
    public void disableMandatoryApplication(String appTitle) {
        this.adminApplicationSteps.disableMandatoryApplication(appTitle);
    }

    @When(value="^I disable Mandatory for the created application$")
    public void disableMandatoryRandomApplication() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.disableMandatoryApplication(randomApplicationTitle);
    }

    @When(value="^I edit the application '(.*)' data$")
    public void editApplicationTitleUrlDescription(String appName, Map<String, String> appData) {
        this.adminApplicationSteps.editApplicationTitleUrlDescription(appName, appData);
    }

    @When(value="^I edit the first added application data$")
    public void editRandomApplicationTitleUrlDescription() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        String editedRandomApplicationTitle = "title" + Utils.getRandomString();
        String editedRandomApplicationUrl = "./" + Utils.getRandomString();
        String editedRandomApplicationDescription = "desc" + Utils.getRandomString();
        Serenity.setSessionVariable((Object)"editedRandomApplicationTitle").to((Object)editedRandomApplicationTitle);
        Serenity.setSessionVariable((Object)"editedRandomApplicationUrl").to((Object)editedRandomApplicationUrl);
        Serenity.setSessionVariable((Object)"editedRandomApplicationDescription").to((Object)editedRandomApplicationDescription);
        this.adminApplicationSteps.editRandomApplicationTitleUrlDescription(randomApplicationTitle, editedRandomApplicationTitle, editedRandomApplicationUrl, editedRandomApplicationDescription);
    }

    @When(value="^I disable Active option for application '(.*)'$")
    @Then(value="$I enable Active option for application '(.*)'$")
    public void enableDisableActiveApplication(String appTitle) {
        this.adminApplicationSteps.enableDisableActiveApplication(appTitle);
    }

    @When(value="^I disable Active option for the created application$")
    @Then(value="I enable Active option for the created application")
    public void enableDisableActiveRandomApplication() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.enableDisableActiveApplication(randomApplicationTitle);
    }

    @When(value="^I enable Mandatory '(.*)' for application$")
    public void enableMandatoryApplication(String appTitle) {
        this.adminApplicationSteps.enableMandatoryApplication(appTitle);
    }

    @When(value="^I enable Mandatory for the created application$")
    public void enableMandatoryRandomApplication() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.enableMandatoryApplication(randomApplicationTitle);
    }

    @When(value="^I add a new application with the title, the url and the description with image '(.*)'$")
    public void enterApplicationTitleUrlDescriptionWithImage(String image, Map<String, String> appData) {
        this.adminApplicationSteps.enterApplicationTitleUrlDescriptionWithImage(image, appData);
        String applicationTitle = appData.get("Application title");
        this.setCurrentlyTestingApplicationTitle(applicationTitle);
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)applicationTitle);
    }

    @When(value="^I add a new random application with the title, the url and the description$")
    public void enterRandomApplicationTitleUrlDescription() {
        String randomApplicationTitle = "title" + Utils.getRandomString();
        String randomApplicationUrl = "./" + Utils.getRandomString();
        String randomApplicationDescription = "desc" + Utils.getRandomString();
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)randomApplicationTitle);
        Serenity.setSessionVariable((Object)"randomApplicationUrl").to((Object)randomApplicationUrl);
        Serenity.setSessionVariable((Object)"randomApplicationDescription").to((Object)randomApplicationDescription);
        this.setCurrentlyTestingApplicationTitle(randomApplicationTitle);
        this.adminApplicationSteps.enterRandomApplicationTitleUrlDescription(randomApplicationTitle, randomApplicationUrl, randomApplicationDescription);
    }

    @When(value="^I add a new random application with the title, the url and the description with image <(.*)>$")
    public void enterRandomApplicationTitleUrlDescriptionWithImage(String image) {
        String randomApplicationTitle = "title" + Utils.getRandomString();
        String randomApplicationUrl = "./" + Utils.getRandomString();
        String randomApplicationDescription = "desc" + Utils.getRandomString();
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)randomApplicationTitle);
        Serenity.setSessionVariable((Object)"randomApplicationUrl").to((Object)randomApplicationUrl);
        Serenity.setSessionVariable((Object)"randomApplicationDescription").to((Object)randomApplicationDescription);
        this.setCurrentlyTestingApplicationTitle(randomApplicationTitle);
        this.adminApplicationSteps.enterRandomApplicationTitleUrlDescriptionImage(randomApplicationTitle, randomApplicationUrl, randomApplicationDescription, image);
    }

    @When(value="^I add a second random application with the title, the url and the description with image <(.*)>$")
    public void enterSecondRandomApplicationTitleUrlDescriptionWithImage(String image) {
        String secondRandomApplicationTitle = "title" + Utils.getRandomString();
        String secondRandomApplicationUrl = "./" + Utils.getRandomString();
        String secondRandomApplicationDescription = "desc" + Utils.getRandomString();
        Serenity.setSessionVariable((Object)"secondRandomApplicationTitle").to((Object)secondRandomApplicationTitle);
        Serenity.setSessionVariable((Object)"secondRandomApplicationUrl").to((Object)secondRandomApplicationUrl);
        Serenity.setSessionVariable((Object)"secondRandomApplicationDescription").to((Object)secondRandomApplicationDescription);
        this.setCurrentlyTestingApplicationTitle(secondRandomApplicationTitle);
        this.adminApplicationSteps.enterRandomApplicationTitleUrlDescriptionImage(secondRandomApplicationTitle, secondRandomApplicationUrl, secondRandomApplicationDescription, image);
    }

    @Then(value="First application edited Title is displayed in Applications Table")
    public void firstAppEditedTitleInApplicationsTableIsDisplayed() {
        String editedRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"editedRandomApplicationTitle");
        this.adminApplicationSteps.appTitleInApplicationsTableIsDisplayed(editedRandomApplicationTitle);
    }

    @Then(value="First application Title is displayed in Applications Table")
    public void firstAppTitleInApplicationsTableIsDisplayed() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.appTitleInApplicationsTableIsDisplayed(randomApplicationTitle);
    }

    @When(value="^I open '(.*)' edit drawer$")
    public void openEditApplicationDrawer(String applicationName) {
        this.adminApplicationSteps.goToEditTheApplication(applicationName);
    }

    @When(value="^I open the added application edit drawer$")
    public void openEditRandomApplicationDrawer() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.adminApplicationSteps.goToEditTheApplication(randomApplicationTitle);
    }

    @When(value="^I open the second added application edit drawer$")
    public void openEditSecondRandomApplicationDrawer() {
        String secondRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"secondRandomApplicationTitle");
        this.adminApplicationSteps.goToEditTheApplication(secondRandomApplicationTitle);
    }

    @When(value="I choose icon {string} in application drawer")
    public void selectApplicationIconFromDrawer(String icon) {
        this.adminApplicationSteps.selectApplicationIconFromDrawer(icon);
    }

    @When(value="^I search for application '(.*)'$")
    public void searchApp(String appTitle) {
        this.adminApplicationSteps.searchApp(appTitle);
    }

    @Then(value="Second application Title is displayed in Applications Table")
    public void secondAppTitleInApplicationsTableIsDisplayed() {
        String secondRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"secondRandomApplicationTitle");
        this.adminApplicationSteps.appTitleInApplicationsTableIsDisplayed(secondRandomApplicationTitle);
    }

    private void setCurrentlyTestingApplicationTitle(Map<String, String> appData) {
        String applicationTitle = appData.get("Application title");
        Serenity.setSessionVariable((Object)"randomApplicationTitle").to((Object)applicationTitle);
        this.setCurrentlyTestingApplicationTitle(applicationTitle);
    }

    private void setCurrentlyTestingApplicationTitle(String applicationTitle) {
        if (Serenity.hasASessionVariableCalled((Object)"appCenterAppName")) {
            List appNames = (List)Serenity.sessionVariableCalled((Object)"appCenterAppName");
            appNames.add(applicationTitle);
        } else {
            ArrayList<String> appNames = new ArrayList<String>();
            appNames.add(applicationTitle);
            Serenity.setSessionVariable((Object)"appCenterAppName").to(appNames);
        }
    }
}

