/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.GenericSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import net.thucydides.core.annotations.Steps;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class GenericStepDefinitions {
    @Steps
    private GenericSteps genericSteps;

    @When(value="^I go to '([^']*)'$")
    public void gotToSite(String link) {
        this.genericSteps.goToPage(link);
    }

    @When(value="The button '{}' is displayed")
    public void checkButton(String button) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.genericSteps.isButtonDisplayed(button)).as(String.format("The button %s should be displayed but it is not", button), new Object[0])).isTrue();
    }

    @When(value="The button '{}' is not displayed")
    public void checkButtonNotdisplayed(String button) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.genericSteps.isButtonDisplayed(button)).as(String.format("The button %s should not be displayed but it was", button), new Object[0])).isFalse();
    }

    @When(value="Confirmation message is displayed '{}'")
    public void checkConfirmMessage(String message) {
        this.genericSteps.checkConfirmMessageIsDisplayed(message);
    }

    @When(value="I switch the page to '{}' language")
    public void switchPageLanguage(String lang) {
        this.genericSteps.switchPageLanguage(lang);
    }

    @When(value="The '{}' translations button is primary")
    public void checkTranslationButtonIsPrimary(String indexName) {
        int index = Utils.getIndexFomName((String)indexName);
        this.genericSteps.checkTranslationButtonIsPrimary(index);
    }

    @When(value="The '{}' translations button is not primary")
    public void checkTranslationButtonIsNotPrimary(String indexName) {
        int index = Utils.getIndexFomName((String)indexName);
        this.genericSteps.checkTranslationButtonIsNotPrimary(index);
    }

    @When(value="I open translations drawer for the '{}' input")
    public void openTranslationsDrawer(String indexName) {
        int index = Utils.getIndexFomName((String)indexName);
        this.genericSteps.openTranslationsDrawer(index);
    }

    @When(value="I add the following '{}' translations")
    public void addTranslationValues(String fieldType, Map<String, String> valuesByLanguage) {
        this.genericSteps.addTranslationValues(fieldType, valuesByLanguage);
    }

    @When(value="The message '{}' is displayed")
    public void checkMessageIsDisplayed(String message) {
        this.genericSteps.checkMessageIsDisplayed(message);
    }

    @When(value="The message '{}' is displayed in page")
    public void checkMessageIsDisplayedInPage(String message) {
        this.genericSteps.checkMessageIsDisplayedInPage(message);
    }

    @When(value="The message '{}' is not displayed")
    public void checkMessageIsNotDisplayed(String message) {
        this.genericSteps.checkMessageIsNotDisplayed(message);
    }

    @When(value="The message '{}' is not displayed in page")
    public void checkMessageIsNotDisplayedInPage(String message) {
        this.genericSteps.checkMessageIsNotDisplayedInPage(message);
    }

    @When(value="^The '(.*)' drawer is displayed$")
    public void checkDrawerDisplayed(String title) {
        this.genericSteps.checkDrawerDisplayed(title);
    }

    @Then(value="The page {string} is displayed")
    public void checkPage(String pageUri) {
        String currentUrl = this.genericSteps.getCurrentUrl();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)StringUtils.contains((CharSequence)currentUrl, (CharSequence)pageUri)).as(String.format("Current URL '%s' doesn't end with '%s'", currentUrl, pageUri), new Object[0])).isTrue();
    }

    @Then(value="The page {string} that contains {string} is displayed")
    public void checkPage(String pageUri, String content) {
        String currentUrl = this.genericSteps.getCurrentUrl();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)StringUtils.contains((CharSequence)currentUrl, (CharSequence)pageUri)).as(String.format("Current URL '%s' doesn't end with '%s'", currentUrl, pageUri), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.genericSteps.containsContent(content)).as(String.format("Current Page '%s' doesn't contain '%s'", currentUrl, content), new Object[0])).isTrue();
    }

    @When(value="Success message is displayed")
    public void checkSuccessMessage() {
        this.genericSteps.checkSuccessMessageDisplayed();
    }

    @When(value="Information message is displayed")
    public void checkInformationMessageDisplayed() {
        this.genericSteps.checkInformationMessageDisplayed();
    }

    @When(value="^I confirm$")
    public void clickConfirm() {
        this.genericSteps.clickConfirm();
    }

    @When(value="^I click on '(.*)' button$")
    public void clickButton(String buttonText) {
        this.genericSteps.clickButton(buttonText);
    }

    @When(value="^I click on '(.*)' menu item$")
    public void clickMenuItem(String menuText) {
        this.genericSteps.clickMenuItem(menuText);
    }

    @When(value="^I click on '(.*)' link$")
    public void clickOnLink(String linkText) {
        this.genericSteps.clickLink(linkText);
    }

    @When(value="^I click on '(.*)' text$")
    public void clickOnText(String text) {
        this.genericSteps.clickOnText(text);
    }

    @When(value="^I click on '(.*)' button in drawer$")
    public void clickDrawerButton(String buttonText) {
        this.genericSteps.clickDrawerButton(buttonText);
    }

    @When(value="^I click on '(.*)' button in second level drawer$")
    public void clickSelecdLevelDrawerButton(String buttonText) {
        this.genericSteps.clickSelecdLevelDrawerButton(buttonText);
    }

    @Then(value="^The button '(.*)' is disabled$")
    public void buttonIsDisabled(String buttonText) {
        this.genericSteps.buttonIsDisabled(buttonText);
    }

    @Then(value="^The button '(.*)' is enabled")
    public void buttonIsEnabled(String buttonText) {
        this.genericSteps.buttonIsEnabled(buttonText);
    }

    @Then(value="^The button '(.*)' is disabled in drawer$")
    public void buttonInDrawerIsDisabled(String buttonText) {
        this.genericSteps.buttonInDrawerIsDisabled(buttonText);
    }

    @Then(value="^The button '(.*)' is enabled in drawer$")
    public void buttonInDrawerIsEnabled(String buttonText) {
        this.genericSteps.buttonInDrawerIsEnabled(buttonText);
    }

    @Then(value="^The button '(.*)' is not displayed in drawer$")
    public void buttonInDrawerIsNotDisplayed(String buttonText) {
        this.genericSteps.buttonInDrawerIsNotDisplayed(buttonText);
    }

    @Then(value="^The button '(.*)' is displayed in drawer$")
    public void buttonInDrawerIsDisplayed(String buttonText) {
        this.genericSteps.buttonInDrawerIsDisplayed(buttonText);
    }

    @When(value="I wait for drawer to open")
    public void waitForDrawerToOpen() {
        this.genericSteps.waitForDrawerToOpen();
    }

    @When(value="I wait for application loading")
    public void waitApplicationLoading() {
        Utils.waitForLoading();
    }

    @When(value="I sort table by '{}'")
    public void sortTableByField(String fieldText) {
        this.genericSteps.sortTableByField(fieldText);
    }

    @When(value="I wait for drawer to close")
    public void waitForDrawerToClose() {
        this.genericSteps.waitForDrawerToClose();
    }

    @When(value="I close the notification")
    public void closeToastNotification() {
        this.genericSteps.closeToastNotification();
    }

    @When(value="I close browser tab {int}")
    public void closeBrowserTab(int tabIndex) {
        this.genericSteps.closeBrowserTab(tabIndex);
    }

    @Then(value="I close the opened drawer")
    public void closeDrawerIfDisplayed() {
        this.genericSteps.closeDrawerIfDisplayed();
    }

    @Then(value="I close all opened drawer")
    public void closeAllDrawerIfDisplayed() {
        this.genericSteps.closeAllDrawers();
    }

    @Then(value="I expand the drawer")
    public void expandDrawer() {
        this.genericSteps.expandDrawer();
    }

    @Then(value="I click on go back button")
    public void clickOnGoBack() {
        this.genericSteps.clickOnGoBack();
    }

    @Then(value="I click on go back button in drawer")
    public void clickOnGoBackInDrawer() {
        this.genericSteps.clickOnGoBackInDrawer();
    }

    @When(value="I wait '{int}' seconds")
    @And(value="I wait for '{int}' seconds")
    public void waitInSeconds(int seconds) {
        this.genericSteps.waitInSeconds(seconds);
    }

    @When(value="I wait '{int}' milliseconds")
    public void waitInMilliseconds(int milliseconds) {
        this.genericSteps.waitInMilliseconds(milliseconds);
    }

    @Then(value="^The switch button '(.*)' is not displayed$")
    public void checkSwitchButtonNotDisplayed(String buttonName) {
        this.genericSteps.checkSwitchButtonNotDisplayed(buttonName);
    }

    @Then(value="^The switch button '(.*)' is displayed$")
    public void checkSwitchButtonDisplayed(String buttonName) {
        this.genericSteps.checkSwitchButtonDisplayed(buttonName);
    }

    @Then(value="^I enable the switch button '(.*)'$")
    public void enableSwitchButtonDisplayed(String buttonName) {
        this.genericSteps.enableSwitchButtonDisplayed(buttonName);
    }
}

