/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.HomeSteps;
import io.meeds.qa.ui.steps.PeopleSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class HomeStepDefinition {
    private static final String SECOND_USER_LAST_NAME = "secondUserLastName";
    private static final String SECOND_USER_FIRST_NAME = "secondUserFirstName";
    private static final String RANDOM_SPACE_NAME = "RandomSpaceName";
    @Steps
    private HomeSteps homeSteps;
    @Steps
    private PeopleSteps peopleSteps;

    @When(value="^I accept the following connection invitation from random user$")
    public void acceptRandomUsersConnection(List<String> names) {
        this.homeSteps.acceptConnectionInvitations(names, true);
    }

    @When(value="^I reject the following connection invitation from random user$")
    public void rejectRandomUsersConnection(List<String> names) {
        this.homeSteps.rejectConnectionInvitations(names, true);
    }

    @When(value="^I accept the invitation of the following four random spaces$")
    public void acceptFourRandomSpaces() {
        ArrayList<String> spaces = new ArrayList<String>();
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        String secondRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)"secondRandomSpaceName");
        String thirdRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)"thirdRandomSpaceName");
        String fourthRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)"fourthRandomSpaceName");
        spaces.add(randomSpaceName);
        spaces.add(secondRandomSpaceName);
        spaces.add(thirdRandomSpaceName);
        spaces.add(fourthRandomSpaceName);
        this.homeSteps.acceptSpaceInvitation(spaces);
    }

    @When(value="^I go to '(.*)' site$")
    public void gotToSite(String siteName) {
        this.homeSteps.goToSite(siteName);
    }

    @When(value="^I go to '(.*)' in site '(.*)'")
    public void gotToSiteNavigation(String uriPart, String siteName) {
        this.homeSteps.goToSiteNavigation(siteName, uriPart);
    }

    @When(value="^I accept the following connection invitation sent by first user and second user$")
    public void acceptRandomConnections() {
        this.homeSteps.acceptConnectionInvitations(Stream.of("first", "second").toList(), false);
    }

    @When(value="^I accept the invitation of the following spaces$")
    public void acceptSpaces(List<String> listOfSpace) {
        this.homeSteps.acceptSpaceInvitation(listOfSpace);
    }

    @When(value="^I accept the invitation of the following three random spaces$")
    public void acceptThreeRandomSpaces() {
        ArrayList<String> spaces = new ArrayList<String>();
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        String secondRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)"secondRandomSpaceName");
        String thirdRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)"thirdRandomSpaceName");
        spaces.add(randomSpaceName);
        spaces.add(secondRandomSpaceName);
        spaces.add(thirdRandomSpaceName);
        this.homeSteps.acceptSpaceInvitation(spaces);
    }

    @When(value="^I access to Recent spaces$")
    public void accessToRecentSpaces() {
        this.homeSteps.accessToRecentSpaces();
    }

    @And(value="I unbookmark the activity '{}'")
    @When(value="I bookmark the activity '{}'")
    public void bookmarkActivity(String activity) {
        this.homeSteps.bookmarkActivity(activity);
    }

    @Then(value="^the invitation number for spaces is '(.*)'$")
    public void checkBagde(String number) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.homeSteps.isSpacesBadgeWithNumberVisible(number)).as(String.format("The spaces invitation badge must be %s", number), new Object[0])).isTrue();
    }

    @When(value="The 'Connections' badge is '{}'")
    public void checkConnectionsBadge(String badgeNumber) {
        this.homeSteps.checkConnectionsBadge(badgeNumber);
    }

    @Then(value="^the number of connection requests is '(.*)'$")
    public void checkConnectionBadge(String number) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.homeSteps.isConnectionsBadgeWithNumberVisible(number)).as(String.format("The badge must contains %s connections", number), new Object[0])).isTrue();
    }

    @Then(value="^the drawer with '(.*)' connections is opened$")
    public void checkNumberOfConnectionsInDrawer(String number) {
        this.homeSteps.checkNumberOfConnectionsInDrawer(number);
    }

    @When(value="the following Space is displayed in Spaces Requests section")
    public void checkDisplaySpaceInvitation(List<String> listOfSpace) {
        this.homeSteps.checkDisplaySpaceInvitation(listOfSpace);
    }

    @Then(value="^The favorite star should be displayed in the published activity '(.*)'$")
    public void checkFavIcon(String activity) {
        this.homeSteps.checkFavIcon(activity);
    }

    @Given(value="No activity is displayed in stream$")
    public void checkNoActivityDisplayed() {
        this.homeSteps.checkNoActivityDisplayed();
    }

    @When(value="the following Space is not displayed in Spaces Requests section")
    public void checkNotDisplaySpaceInvitation(List<String> listOfSpace) {
        this.homeSteps.checkNotDisplaySpaceInvitation(listOfSpace);
    }

    @When(value="The page '(.*)' is opened$")
    public void checkPageTitle(String uriPart) {
        this.homeSteps.isPageOpened(uriPart);
    }

    @When(value="^The Spaces badge is '(.*)'$")
    public void checkSpaceBadge(String badgeNumber) {
        this.homeSteps.checkSpacesBadge(badgeNumber);
    }

    @Then(value="^the drawer with '(.*)' spaces is opened$")
    public void checkSpaceDrawer(String number) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.homeSteps.isNumberOfSpacesInDrawer(number)).as(String.format("Le nombre d'espace dans le drawer n'est pas \u00e9gale \u00e0 %s", number), new Object[0])).isTrue();
    }

    @Then(value="^'(.*)' page is displayed$")
    public void checkPageIsDisplayed(String pageUri) {
        this.homeSteps.checkPageIsDisplayed(pageUri);
    }

    @Then(value="^The '(.*)' number is '(.*)'$")
    public void checkWidgetContent(String widget, String number) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.homeSteps.isWidgetWithNumberVisible(widget, number)).as(String.format("La widget %s doit avoir le nombre %s", widget, number), new Object[0])).isTrue();
    }

    @And(value="^I click on the arrow displayed when hovering the searched space in Side Bar Filter$")
    public void clickOnArrowIcon() {
        this.homeSteps.clickOnArrowIcon();
    }

    @When(value="^I click on connections badge$")
    public void clickOnConnectionsBadge() {
        this.homeSteps.clickOnConnectionsBagde();
    }

    @Given(value="I close current browser tab")
    public void closeCurrentBrowserTab() {
        Serenity.getDriver().close();
        Serenity.getDriver().switchTo().window((String)Serenity.sessionVariableCalled((Object)"windowHandle"));
    }

    @When(value="^I click on the notification that shows that activity '(.*)' posted by first user is commented by second user with comment '(.*)'$")
    public void clickOnFirstUserActivityCommentedBySecondUserNotification(String activity, String comment) {
        String secondUserFirstName = (String)Serenity.sessionVariableCalled((Object)SECOND_USER_FIRST_NAME);
        String secondUserLastName = (String)Serenity.sessionVariableCalled((Object)SECOND_USER_LAST_NAME);
        String secondUserFullName = secondUserFirstName + " " + secondUserLastName;
        this.homeSteps.commentActivityNotificationIsDisplayed("has commented on a post", activity, comment);
        this.homeSteps.clickOnCommentActivityNotification(secondUserFullName, activity, comment);
    }

    @Given(value="^My home icon is on '(.*)'")
    public void checkHomeButtonPosition(String pageName) {
        this.homeSteps.checkHomeButtonPosition(pageName);
    }

    @And(value="^I click on home page link$")
    public void clickOnHomeLink() {
        this.homeSteps.clickOnHomeLink();
    }

    @And(value="^I click on home icon$")
    public void clickOnHomeIcon() {
        this.homeSteps.clickOnHomeIcon(Serenity.sessionVariableCalled((Object)"hoverHomeLink").toString());
    }

    @When(value="^I click on the notification that shows that comment '(.*)' posted by second user is replied by first user with '(.*)'$")
    public void clickOnSecondUserCommentRepliedByFirstUserNotification(String comment, String reply) {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String firstUserFullName = firstUserFirstName + " " + firstUserLastName;
        this.homeSteps.commentActivityNotificationIsDisplayed("replied to your comment", comment, reply);
        this.homeSteps.clickOnCommentActivityNotification(firstUserFullName, comment, reply);
    }

    @When(value="^I click on space invitation widget$")
    public void clickOnSpaceInvitationWidget() {
        this.homeSteps.clickOnSpaceInvitationWidget();
    }

    @When(value="^I click on spaces badge$")
    public void clickOnSpacesBadge() {
        this.homeSteps.clickOnSpacesBagde();
    }

    @Given(value="^I click on see all$")
    public void clickSeeAll() {
        this.homeSteps.clickSeeAll();
    }

    @Then(value="^I click to confirm the new home page$")
    public void confirmationForChangeSiteHomeLink() {
        this.homeSteps.confirmationForChangeSiteHomeLink();
    }

    @When(value="^I favorite the activity posted in the space$")
    public void favoriteActivity() {
        String oldActiviyy = (String)Serenity.sessionVariableCalled((Object)"activity");
        this.homeSteps.favoriteActivity(oldActiviyy);
    }

    @Then(value="^The notification that shows that activity '(.*)' posted by first user is commented by second user with comment '(.*)', is displayed$")
    public void firstUserActivityCommentedBySecondUserNotificationIsDisplayed(String activity, String comment) {
        String secondUserFirstName = (String)Serenity.sessionVariableCalled((Object)SECOND_USER_FIRST_NAME);
        String secondUserLastName = (String)Serenity.sessionVariableCalled((Object)SECOND_USER_LAST_NAME);
        String secondUserFullName = secondUserFirstName + " " + secondUserLastName;
        this.homeSteps.commentActivityNotificationIsDisplayed("has commented on a post", activity, comment);
        this.homeSteps.commentActivityNotificationIsDisplayed(secondUserFullName, activity, comment);
    }

    @When(value="^I go to groups Management page$")
    public void goToAddGroups() {
        this.homeSteps.goToAddGroups();
    }

    @Given(value="^I go to Administer application center Page$")
    public void goToAppCenterAdminSetupPage() {
        this.homeSteps.goToAppCenterAdminSetupPage();
    }

    @Given(value="I go to notification administration Page")
    public void goToNotificationAdminPage() {
        this.homeSteps.goToNotificationAdminPage();
    }

    @When(value="^I go to the home page$")
    public void goToHomePage() {
        this.homeSteps.goToHomePage();
    }

    @When(value="^I go to People Page$")
    public void goToPeoplePage() {
        this.homeSteps.goToPeoplePage();
    }

    @When(value="^I go to My Profile page$")
    public void goToProfilePage() {
        this.homeSteps.goToMyProfile();
    }

    @Given(value="I go to Settings page")
    public void goToSettingsPage() {
        this.homeSteps.goToSettingsPage();
    }

    @Given(value="^I go to spaces page$")
    public void goToSpacesPage() {
        this.homeSteps.goToManageSpacesPage();
    }

    @Given(value="I go to Stream page")
    public void goToStreamPage() {
        this.homeSteps.goToStreamPage();
    }

    @Given(value="^I go to Contribute page$")
    public void goToContributePage() {
        this.homeSteps.goToContributePage();
    }

    @Given(value="^I go to Programs page$")
    public void goToProgramsPage() {
        this.homeSteps.goToPrograms();
    }

    @Given(value="^I go to My Achievements$")
    public void goMyAchievementsPage() {
        this.homeSteps.goMyAchievements();
    }

    @And(value="^I mouse over the '(.*)' icon in sidebar menu$")
    public void hoverOnPageHomeIcon(String pageName) {
        Serenity.setSessionVariable((Object)"hoverHomeLink").to((Object)pageName);
        this.homeSteps.hoverOnPageHomeIcon(pageName);
    }

    @And(value="^I hover on the (.*) searched Space In side bar filter$")
    public void hoverSearchedSpaceInSideBarFilter(String spacePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        this.homeSteps.hoverSearchedSpaceInSideBarFilter(spaceName);
    }

    @And(value="^The arrow is displayed when hovering on searched space in Side Bar Filter$")
    public void isArrowDisplayedAfterHoveringOnSpaceName() {
        this.homeSteps.isArrowDisplayedAfterHoveringOnSpaceName();
    }

    @Then(value="The badge isn't displayed")
    public void checkNoConnectionsBadge() {
        this.homeSteps.checkNoConnectionsBadge();
    }

    @Then(value="^The spaces badge isn't displayed$")
    public void checkNoSpacesBadge() {
        this.homeSteps.checkNoSpacesBadge();
    }

    @And(value="^The third level Navigation should display the space details panel$")
    public void checkThirdLevelNavigationDisplayed() {
        this.homeSteps.checkThirdLevelNavigationDisplayed();
    }

    @When(value="^I open Notifications$")
    public void openNotifications() {
        this.homeSteps.openNotifications();
    }

    @When(value="^(.*) searched space is displayed in Side Bar Filter$")
    public void randomSearchedSpaceIsDisplayedInSideBarFilter(String spacePrefix) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix.toLowerCase() + RANDOM_SPACE_NAME));
        this.homeSteps.searchedSpaceIsDisplayedInSideBarFilter(randomSpaceName);
    }

    @When(value="^(.*) searched space is not displayed in Side Bar Filter$")
    public void randomSearchedSpaceIsNotDisplayedInSideBarFilter(String spacePrefix) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix.toLowerCase() + RANDOM_SPACE_NAME));
        this.homeSteps.searchedSpaceIsNotDisplayedInSideBarFilter(randomSpaceName);
    }

    @When(value="I refresh the page")
    public void refreshPage() {
        Utils.refreshPage();
    }

    @When(value="^I reject the following connection invitation sent by second user$")
    public void rejectConnectionInvitationSentBySecondUser() {
        String secondUserFirstName = (String)Serenity.sessionVariableCalled((Object)SECOND_USER_FIRST_NAME);
        this.homeSteps.rejectSingleConnectionInvitation(secondUserFirstName);
    }

    @When(value="^I reject the invitation of the following spaces$")
    public void rejectSpaces(List<String> listOfSpace) {
        this.homeSteps.rejectSpaceInvitation(listOfSpace);
    }

    @Then(value="I search for the random created application")
    public void searchApplicationCenter() {
        String randomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"randomApplicationTitle");
        this.homeSteps.searchApplicationCenter(randomApplicationTitle);
    }

    @Then(value="I search for the edited random application")
    public void searchEditedApplicationCenter() {
        String editedRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"editedRandomApplicationTitle");
        this.homeSteps.searchApplicationCenter(editedRandomApplicationTitle);
    }

    @When(value="^Searched space '(.*)' is displayed in Side Bar Filter$")
    public void searchedSpaceIsDisplayedInSideBarFilter(String space) {
        this.homeSteps.searchedSpaceIsDisplayedInSideBarFilter(space);
    }

    @When(value="^Searched space '(.*)' is not displayed in Side Bar Filter$")
    public void searchedSpaceIsNotDisplayedInSideBarFilter(String space) {
        this.homeSteps.searchedSpaceIsNotDisplayedInSideBarFilter(space);
    }

    @When(value="^I search for the (.*) created space in Side Bar Filter$")
    public void searchRandomSpaceInSideBarFilter(String spacePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        this.homeSteps.searchSpaceInSideBarFilter(spaceName);
    }

    @Then(value="I search for the second random created application")
    public void searchSecondApplicationCenter() {
        this.goToAppCenterAdminSetupPage();
        String secondRandomApplicationTitle = (String)Serenity.sessionVariableCalled((Object)"secondRandomApplicationTitle");
        this.homeSteps.searchApplicationCenter(secondRandomApplicationTitle);
    }

    @When(value="^I search space '(.*)' in Side Bar Filter$")
    public void searchSpaceInSideBarFilter(String space) {
        this.homeSteps.searchSpaceInSideBarFilter(space);
    }

    @Then(value="^The notification that shows that comment '(.*)' posted by second user is replied by first user with '(.*)', is displayed$")
    public void secondUserCommentRepliedByFirstUserNotificationIsDisplayed(String comment, String reply) {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String firstUserFullName = firstUserFirstName + " " + firstUserLastName;
        this.homeSteps.commentActivityNotificationIsDisplayed("replied to your comment", comment, reply);
        this.homeSteps.commentActivityNotificationIsDisplayed(firstUserFullName, comment, reply);
    }

    @Given(value="^I select '(.*)'$")
    public void selectAllOrMySpaces(String filter) {
        this.homeSteps.selectAllOrMySpaces(filter);
    }

    @And(value="I unbookmark the favorite activity posted in the space")
    public void unbookmarkActivity() {
        String oldActiviyy = (String)Serenity.sessionVariableCalled((Object)"activity");
        this.homeSteps.unbookmarkActivity(oldActiviyy);
    }

    @When(value="I open hamburger menu drawer")
    public void openHamburgerMenuDrawer() {
        this.homeSteps.openHamburgerMenuDrawer();
    }

    @When(value="I stick the hamburger menu")
    public void stickHamburgerMenu() {
        this.homeSteps.stickHamburgerMenu();
    }

    @When(value="I unstick the hamburger menu")
    public void unstickHamburgerMenu() {
        this.homeSteps.unstickHamburgerMenu();
    }

    @Then(value="The hamburger menu is displayed as stickied")
    public void checkHamburgerMenuSticky() {
        this.homeSteps.checkHamburgerMenuSticky();
    }

    @Then(value="The hamburger menu is displayed as unstickied")
    public void checkHamburgerMenuUnsticked() {
        this.homeSteps.checkHamburgerMenuUnsticked();
    }

    @Then(value="^The (.*) random space is displayed as (.*) item in recent spaces menu$")
    public void checkHamburgerMenuSpacePosition(String spacePrefix, String spacePosition) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        int spaceMenuPosition = Utils.getIndexFomName((String)spacePosition);
        this.homeSteps.checkHamburgerMenuSpacePosition(spaceName, spaceMenuPosition);
    }

    @Given(value="^The (.*) random space name and description are displayed in second menu level$")
    public void checkHamburgerMenuSpaceDescriptionAndName(String spacePrefix) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        this.homeSteps.checkHamburgerMenuSpaceDescriptionAndName(randomSpaceName);
    }

    @Then(value="^Previously (.*) application in settings is displayed as (.*) menu item in (.*) random space left menu$")
    @And(value="^The (.*) application in settings is displayed as (.*) menu item in (.*) random space left menu$")
    public void checkHamburgerMenuRecentSpaceMenuApplication(String appSettingPosition, String appMenuPosition, String spacePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        String appName = (String)Serenity.sessionVariableCalled((Object)(appSettingPosition + "SettingApplication"));
        int appPosition = Utils.getIndexFomName((String)appMenuPosition);
        this.homeSteps.checkHamburgerMenuRecentSpaceMenuApplication(spaceName, appName, appPosition);
    }

    @Then(value="^I open the (.*) random space menu details$")
    public void openHamburgerMenuRecentSpaceDetails(String spacePrefix) {
        String spaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME));
        this.homeSteps.openHamburgerMenuRecentSpaceDetails(spaceName);
    }

    @Then(value="The red dot is displayed in the hamburger menu")
    public void checkRedDotInHamburgerMenu() {
        this.homeSteps.checkRedDotInHamburgerMenu();
    }

    @Then(value="The red dot is not displayed in the hamburger menu")
    public void checkRedDotNotInHamburgerMenu() {
        this.homeSteps.checkRedDotNotInHamburgerMenu();
    }

    @When(value="I click on the hambuger menu")
    public void clickOnHamburgerMenu() {
        this.homeSteps.clickOnHamburgerMenu();
    }

    @When(value="I click on the drawer overlay")
    public void clickOutsideHamburgerMenu() {
        this.homeSteps.clickOutsideHamburgerMenu();
    }

    @Then(value="The hamburger menu is closed")
    public void closeHamburgerMenu() {
        this.homeSteps.closeHamburgerMenu();
    }
}

