/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.ManageBadgesSteps;
import io.meeds.qa.ui.utils.Utils;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class ManageBadgesStepDefinitions {
    @Steps
    private ManageBadgesSteps manageBadgesSteps;

    @And(value="I add new Badge with random name, description '{}', score '{}', icon '{}', and domain '{}'")
    public void addRandomBadge(String description, String score, String icon, String domain) {
        String badgeName = "badge1" + Utils.getRandomString();
        this.manageBadgesSteps.addBadge(badgeName, description, score, icon, domain);
        Serenity.setSessionVariable((Object)"badgeName").to((Object)badgeName);
    }

    @And(value="^I add new Badge to be deleted with random name, description '(.*)', score '(.*)', icon '(.*)', and domain '(.*)'$")
    public void addRandomBadgeToBeDeleted(String description, String score, String icon, String domain) {
        String badgeName = "badge1" + Utils.getRandomString();
        this.manageBadgesSteps.addBadge(badgeName, description, score, icon, domain);
        Serenity.setSessionVariable((Object)"badgeNameToBeDeleted").to((Object)badgeName);
    }

    @And(value="^I add new Badge to be updated with random name, description '(.*)', score '(.*)', icon '(.*)', and domain '(.*)'$")
    public void addRandomBadgeToBeUpdated(String description, String score, String icon, String domain) {
        String badgeNameToBeUpdated = "badge1" + Utils.getRandomString();
        this.manageBadgesSteps.addBadge(badgeNameToBeUpdated, description, score, icon, domain);
        Serenity.setSessionVariable((Object)"badgeNameToBeUpdated").to((Object)badgeNameToBeUpdated);
    }

    @And(value="I click on badge name Delete button")
    public void clickOnDeleteBadge() {
        String badgeName = (String)Serenity.sessionVariableCalled((Object)"badgeNameToBeDeleted");
        this.manageBadgesSteps.clickOnDeleteBadge(badgeName);
    }

    @And(value="^I click on badge '(.*)' Delete button$")
    public void clickOnDeleteBadge(String badgeName) {
        this.manageBadgesSteps.clickOnDeleteBadge(badgeName);
    }

    @And(value="^I click on badge '(.*)' Edit button$")
    public void clickOnEditBadge(String badgeName) {
        this.manageBadgesSteps.clickOnEditBadge(badgeName);
    }

    @And(value="I click on the Edit button of the added badge")
    public void clickOnEditRandomBadge() {
        String badgeNameToBeUpdated = (String)Serenity.sessionVariableCalled((Object)"badgeNameToBeUpdated");
        this.manageBadgesSteps.clickOnEditBadge(badgeNameToBeUpdated);
    }

    @Then(value="I confirm the addition of the new badge")
    public void confirmBadgeDomain() {
        this.manageBadgesSteps.confirmAdditionNewBadge();
    }

    @And(value="I confirm the deletion of the badge")
    public void confirmDeletionBadge() {
        this.manageBadgesSteps.confirmDeletionBadge();
    }

    @And(value="I confirm the edit of the badge")
    public void confirmEditBadge() {
        this.manageBadgesSteps.confirmEditBadge();
    }

    @And(value="^I enter the new badge description '(.*)'$")
    public void editBadgeDescription(String description) {
        this.manageBadgesSteps.editBadgeDescription(description);
    }

    @And(value="^I select the new badge domain '(.*)'$")
    public void editBadgeDomain(String domain) {
        this.manageBadgesSteps.editBadgeDomain(domain);
    }

    @And(value="^I enter the new badge name '(.*)'$")
    public void editBadgeName(String name) {
        this.manageBadgesSteps.editBadgeName(name);
    }

    @And(value="^I enter the new badge score '(.*)'$")
    public void editBadgeScore(String score) {
        this.manageBadgesSteps.editBadgeScore(score);
    }

    @And(value="I enter the new badge name")
    public void editRandomBadgeName() {
        String updatedBadgeName = "badge2" + Utils.getRandomString();
        this.manageBadgesSteps.editBadgeName(updatedBadgeName);
        Serenity.setSessionVariable((Object)"updatedBadgeName").to((Object)updatedBadgeName);
    }

    @When(value="^I go to administration then I select manage badges$")
    public void goToManageBadgesMenu() {
        this.manageBadgesSteps.goToManageBadgesMenu();
    }

    @And(value="^I search for the badge '(.*)'$")
    public void insertBadgeNameInSearchField(String badgeName) {
        this.manageBadgesSteps.insertBadgeNameInSearchField(badgeName);
    }

    @And(value="I search for the random badge name")
    public void insertRandomBadgeNameInSearchField() {
        String badgeName = (String)Serenity.sessionVariableCalled((Object)"badgeName");
        this.manageBadgesSteps.insertBadgeNameInSearchField(badgeName);
    }

    @Then(value="^The new badge is added successfully and is displayed with name '(.*)', description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    @And(value="^The badge has been updated successfully and is displayed with name '(.*)', description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    public void isBadgeDisplayedWithEnabledStatus(String badgeName, String badgeDescription, String badgeScore, String badgeDomain) {
        this.manageBadgesSteps.isBadgeDisplayedWithEnabledStatus(badgeName, badgeDescription, badgeScore, badgeDomain);
    }

    @And(value="^The badge with name '(.*)', description '(.*)', score '(.*)', domain '(.*)' is no longer displayed in badges list$")
    public void isBadgeNotDisplayedWithEnabledStatus(String badgeName, String badgeDescription, String badgeScore, String badgeDomain) {
        this.manageBadgesSteps.isBadgeNotDisplayedWithEnabledStatus(badgeName, badgeDescription, badgeScore, badgeDomain);
    }

    @And(value="^The deleted badge with random name, description '(.*)', score '(.*)', domain '(.*)' is no longer displayed in badges list")
    public void isDeletedRandomBadgeNotDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String badgeName = (String)Serenity.sessionVariableCalled((Object)"badgeNameToBeDeleted");
        this.manageBadgesSteps.isBadgeNotDisplayedWithEnabledStatus(badgeName, badgeDescription, badgeScore, badgeDomain);
    }

    @Then(value="^The new badge is added successfully and is displayed with random name, description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    public void isRandomBadgeDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String badgeName = (String)Serenity.sessionVariableCalled((Object)"badgeName");
        this.manageBadgesSteps.isBadgeDisplayedWithEnabledStatus(badgeName, badgeDescription, badgeScore, badgeDomain);
    }

    @And(value="^The badge with random name, description '(.*)', score '(.*)', domain '(.*)' is no longer displayed in badges list$")
    public void isRandomBadgeNotDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String badgeName = (String)Serenity.sessionVariableCalled((Object)"badgeName");
        this.manageBadgesSteps.isBadgeNotDisplayedWithEnabledStatus(badgeName, badgeDescription, badgeScore, badgeDomain);
    }

    @Then(value="^The new badge to be deleted is added successfully and is displayed with random name, description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    public void isRandomBadgeToBeDeletedDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String badgeNameToBeUpdated = (String)Serenity.sessionVariableCalled((Object)"badgeNameToBeDeleted");
        this.manageBadgesSteps.isBadgeDisplayedWithEnabledStatus(badgeNameToBeUpdated, badgeDescription, badgeScore, badgeDomain);
    }

    @Then(value="^The new badge to be updated is added successfully and is displayed with random name, description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    public void isRandomBadgeToBeUpdatedDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String badgeNameToBeUpdated = (String)Serenity.sessionVariableCalled((Object)"badgeNameToBeUpdated");
        this.manageBadgesSteps.isBadgeDisplayedWithEnabledStatus(badgeNameToBeUpdated, badgeDescription, badgeScore, badgeDomain);
    }

    @Then(value="Success alert '{}' is displayed")
    public void isSuccessAlertDisplayed(String message) {
        this.manageBadgesSteps.isSuccessAlertDisplayed(message);
    }

    @Then(value="^The badge has been updated successfully and is displayed with random name, description '(.*)', score '(.*)', domain '(.*)', and enabled status in badges list")
    public void isUpdatedRandomBadgeDisplayedWithEnabledStatus(String badgeDescription, String badgeScore, String badgeDomain) {
        String updatedBadgeName = (String)Serenity.sessionVariableCalled((Object)"updatedBadgeName");
        this.manageBadgesSteps.isBadgeDisplayedWithEnabledStatus(updatedBadgeName, badgeDescription, badgeScore, badgeDomain);
    }
}

