/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.hook.TestInitHook;
import io.meeds.qa.ui.pages.ManageSpacesPage;
import io.meeds.qa.ui.steps.HomeSteps;
import io.meeds.qa.ui.steps.ManageSpaceSteps;
import io.meeds.qa.ui.utils.Utils;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import org.apache.commons.lang3.StringUtils;

public class ManageSpaceStepDefinitions {
    private static final String RANDOM_SPACE_NAME2 = "RandomSpaceName";
    private static final String THIRD_RANDOM_SPACE_NAME = "thirdRandomSpaceName";
    private static final String USER_FIRST_NAME = "UserFirstName";
    private static final String SECOND_RANDOM_SPACE_NAME = "secondRandomSpaceName";
    private static final String SPACE_NAME = "spaceName";
    public static final String RANDOM_SPACE_NAME = "randomSpaceName";
    @Steps
    private HomeSteps homeSteps;
    private ManageSpacesPage manageSpacesPage;
    @Steps
    private ManageSpaceSteps manageSpaceSteps;

    @When(value="I accept the invitation of the random space")
    public void acceptInvitationRandomSpace() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME);
        this.homeSteps.acceptRandomSpaceInvitation(randomSpaceName);
    }

    @When(value="^I accept the invitation of the (.*) created space$")
    public void acceptRandomSpace(String spacePrefix) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME2));
        this.homeSteps.acceptRandomSpaceInvitation(randomSpaceName);
    }

    @When(value="^I accept the invitation of the third created space$")
    public void acceptThirdRandomSpace() {
        String thirdRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)THIRD_RANDOM_SPACE_NAME);
        this.homeSteps.acceptRandomSpaceInvitation(thirdRandomSpaceName);
    }

    @Given(value="I create a random space")
    public void addARandomSpace() {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithRegistration(randomSpaceName, "Open");
        TestInitHook.spaceWithPrefixCreated(RANDOM_SPACE_NAME, randomSpaceName, Serenity.getDriver().getCurrentUrl());
    }

    @Given(value="^I create a random space with the (.*) random user$")
    public void addARandomSpaceWithRandomUserInvited(String userPrefix) {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithInviteUser(randomSpaceName, userFirstName);
        Serenity.setSessionVariable((Object)RANDOM_SPACE_NAME).to((Object)randomSpaceName);
    }

    @Given(value="^I create the '(.*)' random space with the '(.*)' random user as member and registration '(.*)'$")
    public void addARandomSpaceWithRegistrationAndRandomUserInvited(String spacePrefix, String userPrefix, String registration) {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithRegistrationAndInviteUser(randomSpaceName, registration, userFirstName);
        Serenity.setSessionVariable((Object)(spacePrefix + RANDOM_SPACE_NAME2)).to((Object)randomSpaceName);
    }

    @Given(value="^I create the '(.*)' random space with registration '(.*)'$")
    public void addARandomSpaceWithRegistration(String spacePrefix, String registration) {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithRegistration(randomSpaceName, registration);
        TestInitHook.spaceWithPrefixCreated(spacePrefix + RANDOM_SPACE_NAME2, randomSpaceName, Serenity.getDriver().getCurrentUrl());
    }

    @Given(value="I open space invitation drawer")
    public void openSpaceInvitationDrawer() {
        this.manageSpaceSteps.openSpaceInvitationDrawer();
    }

    @Given(value="I open space external invitation drawer")
    public void openSpaceExternalInvitationDrawer() {
        this.manageSpaceSteps.openSpaceExternalInvitationDrawer();
    }

    @Given(value="^I enter email '(.*)' to invite in random space$")
    public void inviteEmailAsSpaceMember(String email) {
        this.manageSpaceSteps.inviteEmailAsSpaceMember(email);
    }

    @Then(value="^The email '(.*)' is set to '(.*)' in invitations list$")
    public void emailIsListedInInvitationList(String email, String status) {
        this.manageSpaceSteps.emailIsListedInInvitationList(email, status);
    }

    @Then(value="I open the space pending invitations drawer")
    public void openSpacePendingInvitationsDrawer() {
        this.manageSpaceSteps.openSpacePendingInvitationsDrawer();
    }

    @Then(value="I open the space extenal invitations tab")
    public void openSpaceExternalInvitationsTab() {
        this.manageSpaceSteps.openSpaceExternalInvitationsTab();
    }

    @Then(value="I cannot access space external invitation drawer")
    public void checkExternalInviteButtonNotDisplayed() {
        this.manageSpaceSteps.checkExternalInviteButtonNotDisplayed();
    }

    @Then(value="^The email '(.*)' is not displayed in invitations list$")
    public void emailIsNotListedInInvitationList(String email) {
        this.manageSpaceSteps.emailIsNotListedInInvitationList(email);
    }

    @Given(value="^I create a (.*) random space$")
    @And(value="^I create the (.*) random space$")
    public void addARandomSpace(String spacePrefix) {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithRegistration(randomSpaceName, "Open");
        TestInitHook.spaceWithPrefixCreated(spacePrefix + RANDOM_SPACE_NAME2, randomSpaceName, Serenity.getDriver().getCurrentUrl());
    }

    @Given(value="^I create a (.*) random space with the (.*) created user as member$")
    @And(value="^I create the (.*) random space with the (.*) random user as member$")
    public void addARandomSpaceWithRandomUserInvited(String spacePrefix, String userPrefix) {
        String randomSpaceName = RANDOM_SPACE_NAME + Utils.getRandomNumber();
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.addSpaceWithInviteUser(randomSpaceName, userFirstName);
        Serenity.setSessionVariable((Object)(spacePrefix + RANDOM_SPACE_NAME2)).to((Object)randomSpaceName);
    }

    @Given(value="^I check that avatar section is displayed$")
    public void checkAvatarSection() {
        this.manageSpaceSteps.checkAvatarSection();
    }

    @Given(value="^I check that cancel button is displayed$")
    public void checkCancelButton() {
        this.manageSpaceSteps.checkCancelButton();
    }

    @Given(value="^I check that space description section is displayed$")
    public void checkDescriptionSpaceSection() {
        this.manageSpaceSteps.checkDescriptionSpaceSection();
    }

    @Then(value="The favorite icon should be displayed in space card")
    public void checkFavIconInSpaceCard() {
        this.manageSpaceSteps.checkFavIconInSpaceCard();
    }

    @Then(value="The favorite icon should be displayed in space popover from topbar")
    public void checkFavIconInSpacePopoverFromTopbar() {
        this.manageSpaceSteps.checkFavIconInSpacePopoverFromTopbar();
    }

    @Then(value="The favorite icon should be displayed on space details panel")
    public void checkFavIconInThirdNavigationLevel() {
        this.manageSpaceSteps.checkFavIconInThirdNavigationLevel();
    }

    @When(value="The first created space is not displayed in Spaces Requests section")
    public void checkFirstRandomDisplaySpaceInvitation() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME);
        this.homeSteps.checkRandomNotDisplaySpaceInvitation(randomSpaceName);
    }

    @When(value="The second created space is not displayed in Spaces Requests section")
    public void checkSecondRandomNotDisplaySpaceInvitation() {
        String secondRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)SECOND_RANDOM_SPACE_NAME);
        this.homeSteps.checkRandomNotDisplaySpaceInvitation(secondRandomSpaceName);
    }

    @When(value="I check that the random space is bookmarked as favorite from space card")
    public void checkSpaceBookmarkedFromSpaceCard() {
        this.manageSpaceSteps.checkSpaceBookmarkedFromSpaceCard();
    }

    @When(value="I check that the random space is bookmarked as favorite from topbar space popover")
    public void checkSpaceBookmarkedFromTopbarSpacePopover() {
        this.manageSpaceSteps.checkSpaceBookmarkedFromTopbarSpacePopover();
    }

    @When(value="I check that the random space is bookmarked as favorite from Third Navigation Level")
    public void checkSpaceBookmarkThirdNavigationLevel() {
        this.manageSpaceSteps.checkSpaceBookmarkThirdNavigationLevel();
    }

    @When(value="I check that the random space is unbookmarked from space card")
    public void checkSpaceUnBookmarkFromSpaceCard() {
        this.manageSpaceSteps.checkSpaceUnBookmarkFromSpaceCard();
    }

    @When(value="I check that the random space is unbookmarked from Third Navigation Level")
    public void checkSpaceUnBookmarkFromThirdNavigationLevel() {
        this.manageSpaceSteps.checkSpaceUnBookmarkFromThirdNavigationLevel();
    }

    @When(value="I check that the random space is unbookmarked from topbar space popover")
    public void checkSpaceUnBookmarkFromTopbarSpacePopover() {
        this.manageSpaceSteps.checkSpaceUnBookmarkFromTopbarSpacePopover();
    }

    @Given(value="^First space details are displayed in spaces page search results with '(.*)'$")
    public void checkThatFirstSpaceDetailsInSearchResultsAreDisplayed(String members) {
        this.manageSpaceSteps.checkThatSpaceDetailsInSearchResultsAreDisplayed((String)Serenity.sessionVariableCalled((Object)SPACE_NAME), members);
    }

    @Given(value="First space name is not displayed in spaces page search results$")
    public void checkThatFirstSpaceInSearchResultsIsNotDisplayed() {
        this.manageSpaceSteps.checkThatSpaceInSearchResultsIsNotDisplayed((String)Serenity.sessionVariableCalled((Object)SPACE_NAME));
    }

    @Given(value="^Second space details are displayed in spaces page search results with '(.*)'$")
    public void checkThatSecondSpaceDetailsInSearchResultsAreDisplayed(String members) {
        this.manageSpaceSteps.checkThatSpaceDetailsInSearchResultsAreDisplayed((String)Serenity.sessionVariableCalled((Object)SECOND_RANDOM_SPACE_NAME), members);
    }

    @Given(value="Second space name is not displayed in spaces page search results$")
    public void checkThatSecondSpaceInSearchResultsIsNotDisplayed() {
        this.manageSpaceSteps.checkThatSpaceInSearchResultsIsNotDisplayed((String)Serenity.sessionVariableCalled((Object)SECOND_RANDOM_SPACE_NAME));
    }

    @Given(value="^The created space details are displayed in spaces page search results with '(.*)'$")
    public void checkThatSpaceDetailsInSearchResultsAreDisplayedByOtherUser(String members) {
        this.manageSpaceSteps.checkThatSpaceDetailsInSearchResultsAreDisplayedByOtherUser((String)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME), members);
    }

    @Given(value="Space Top Bar Elements are displayed")
    public void checkThatSpaceTopBarElementsAreDisplayed() {
        this.manageSpacesPage.checkThatSpaceTopBarElementsAreDisplayed();
    }

    @Given(value="^Third space details are displayed in spaces page search results with '(.*)'$")
    public void checkThatThirdSpaceDetailsInSearchResultsAreDisplayed(String members) {
        this.manageSpaceSteps.checkThatSpaceDetailsInSearchResultsAreDisplayed((String)Serenity.sessionVariableCalled((Object)THIRD_RANDOM_SPACE_NAME), members);
    }

    @When(value="The third created space is displayed in Spaces Requests section")
    public void checkThirdRandomDisplaySpaceInvitation() {
        String thirdRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)THIRD_RANDOM_SPACE_NAME);
        this.homeSteps.checkRandomDisplaySpaceInvitation(thirdRandomSpaceName);
    }

    @Given(value="I create or check that thirty spaces are created")
    public void checkThirtyRandomSpacesArePresent() {
        this.manageSpaceSteps.checkThirtyRandomSpacesArePresent();
    }

    @Given(value="^I click on edit general space settings$")
    public void clickOnGeneralSpaceSettings() {
        this.manageSpaceSteps.clickOnGeneralSpaceSettings();
    }

    @Then(value="I bookmark the random space as favorite from space card")
    @When(value="I unfavorite the random space from space card")
    public void clickOnSpaceBookmarkIconFromSpaceCard() {
        this.manageSpaceSteps.clickOnSpaceBookmarkIconFromSpaceCard();
    }

    @Then(value="I bookmark the random space as favorite from Third Navigation Level")
    @When(value="I unfavorite the random space from Third Navigation Level")
    public void clickOnSpaceBookmarkIconFromThirdNavigationLevel() {
        this.manageSpaceSteps.clickOnSpaceBookmarkIconFromThirdNavigationLevel();
    }

    @Then(value="I bookmark the random space as favorite from topbar space popover")
    @When(value="I unfavorite the random space from topbar space popover")
    public void clickOnSpaceBookmarkIconFromTopbarSpacePopover() {
        this.manageSpaceSteps.clickOnSpaceBookmarkIconFromTopbarSpacePopover();
    }

    @Given(value="^The First space was deleted successfully$")
    public void deleteFirstSpace() {
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.deleteSpace((String)Serenity.sessionVariableCalled((Object)SPACE_NAME));
        TestInitHook.spaceWithPrefixDeleted(SPACE_NAME);
    }

    @Given(value="^The Second space was deleted successfully$")
    public void deleteSecondSpace() {
        this.homeSteps.goToManageSpacesPage();
        this.manageSpaceSteps.deleteSpace(SECOND_RANDOM_SPACE_NAME);
        TestInitHook.spaceWithPrefixDeleted(SECOND_RANDOM_SPACE_NAME);
    }

    @Given(value="I go to members tab")
    public void goToMembersTab() {
        this.manageSpaceSteps.goToMembersTab();
    }

    @Given(value="I go to the random space")
    public void goToRandomSpace() {
        this.manageSpaceSteps.addOrGoToSpace(RANDOM_SPACE_NAME);
    }

    @Given(value="I join the random space")
    public void joinRandomSpace() {
        this.manageSpaceSteps.joinOrGoToSpace(RANDOM_SPACE_NAME);
    }

    @Given(value="I create the random space if not existing")
    public void goToRandomSpaceIfNotExisting() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME)))) {
            this.manageSpaceSteps.addOrGoToSpace(RANDOM_SPACE_NAME);
        }
    }

    @Given(value="^I go to the (.*) random space$")
    @And.Ands(value={@And(value="^I create the (.*) random space if not existing$"), @And(value="^I create or go to the (.*) random space$")})
    public void goToRandomSpaceWithPrefix(String spacePrefix) {
        this.manageSpaceSteps.addOrGoToSpace(spacePrefix + RANDOM_SPACE_NAME2);
    }

    @Given(value="I inject the random space")
    @And(value="I inject a random space")
    public void injectRandomSpace() {
        this.manageSpaceSteps.injectRandomSpace(RANDOM_SPACE_NAME);
    }

    @Given(value="I inject the random space if not existing")
    public void injectRandomSpaceIfNotExisting() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME)))) {
            this.manageSpaceSteps.injectRandomSpace(RANDOM_SPACE_NAME);
        }
    }

    @Given(value="^I inject the (.*) random space$")
    public void injectRandomSpace(String spacePrefix) {
        this.manageSpaceSteps.injectRandomSpace(spacePrefix);
    }

    @Given(value="^I go to Settings in space tab$")
    public void goToSettingsTab() {
        this.manageSpaceSteps.goToSettingsTab();
    }

    @Given(value="^I go to space Home$")
    public void goToSpaceHomeViaSpaceAvatar() {
        this.manageSpaceSteps.goToSpaceHomeViaSpaceAvatar();
    }

    @Given(value="^I go to Tasks in space tab$")
    public void goToTasksTab() {
        this.manageSpaceSteps.goToTasksTab();
    }

    @When(value="^I hover on space name from top bar$")
    public void hoverOnSpaceName() {
        this.manageSpaceSteps.hoverOnSpaceName();
    }

    @Then(value="^The space page is displayed '(.*)'$")
    public void isSpacePageOpened(String space) {
        this.manageSpacesPage.isSpacePageOpened(space);
    }

    @Given(value="^The created space name is displayed$")
    public void randomSpaceNameIsDisplayed() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME);
        this.manageSpaceSteps.spaceNameIsDisplayed(randomSpaceName);
    }

    @When(value="^I reject the invitation of the (.*) created space$")
    public void rejectRandomSpace(String spacePrefix) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)(spacePrefix + RANDOM_SPACE_NAME2));
        this.homeSteps.rejectRandomSpaceInvitation(randomSpaceName);
    }

    @Given(value="^I search the space '(.*)'$")
    public void searchSpace(String spaceName) {
        this.manageSpaceSteps.searchSpace(spaceName);
    }

    @Given(value="^The second created space name is displayed$")
    public void secondRandomSpaceNameIsDisplayed() {
        String secondRandomSpaceName = (String)Serenity.sessionVariableCalled((Object)SECOND_RANDOM_SPACE_NAME);
        this.manageSpaceSteps.spaceNameIsDisplayed(secondRandomSpaceName);
    }

    @Given(value="^I select the filter '(.*)'$")
    public void selectFilter(String filter) {
        this.manageSpaceSteps.selectFilter(filter);
    }

    @Given(value="^I '(.*)'$")
    public void sendRequestToJoin(String action) {
        this.manageSpaceSteps.clickSpaceAction(action);
    }

    @When(value="I search for the random space")
    public void setInSearchRandomSpaceField() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)RANDOM_SPACE_NAME);
        this.manageSpaceSteps.searchSpace(randomSpaceName);
    }

    @When(value="I leave found space")
    public void leaveSpace() {
        this.manageSpaceSteps.leaveSpace();
    }

    @Given(value="^I click on Show more button$")
    public void showMoreSpaces() {
        this.manageSpaceSteps.showMoreSpaces();
    }

    @Given(value="^Space Avatar is displayed$")
    public void spaceAvatarIsDisplayed() {
        this.manageSpaceSteps.spaceAvatarIsDisplayed();
    }

    @Given(value="^Space Name is displayed '(.*)'$")
    public void spaceNameIsDisplayed(String space) {
        this.manageSpaceSteps.spaceNameIsDisplayed(space);
    }

    @Given(value="^I upload the Space banner '(.*)'$")
    public void uploadSpaceBanner(String fileName) {
        this.manageSpaceSteps.uploadSpaceBanner(fileName);
    }
}

