/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.cucumber.java.fr.Et;
import io.meeds.qa.ui.steps.HomeSteps;
import io.meeds.qa.ui.steps.ManageUnifiedSearchSteps;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class ManageUnifiedSearchStepDefinitions {
    @Steps
    private HomeSteps homeSteps;
    @Steps
    private ManageUnifiedSearchSteps manageUnifiedSearchSteps;

    @And(value="I access to the unified search page")
    public void accessUnifiedSearchPage() {
        this.manageUnifiedSearchSteps.accessUnifiedSearchPage();
    }

    @When(value="^I click on the favorite button$")
    public void clickFavoriteBtn() {
        this.manageUnifiedSearchSteps.clickFavoriteBtn();
    }

    @When(value="^I favorite the activity '(.*)' from the search page$")
    public void favoriteSearchedActivity(String activity) {
        this.manageUnifiedSearchSteps.favoriteSearchedActivity(activity);
    }

    @When(value="^I click on the first created space$")
    public void goToTheFirsRandomSearchedSpace() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.manageUnifiedSearchSteps.goToTheSearchedSpace(randomSpaceName);
    }

    @When(value="^I click on the activity '(.*)'$")
    public void goToTheSearchedActivity(String activity) {
        this.manageUnifiedSearchSteps.goToTheSearchedActivity();
    }

    @When(value="^I click on the application '(.*)'$")
    public void goToTheSearchedApplication(String appName) {
        this.manageUnifiedSearchSteps.goToTheSearchedApplication(appName);
    }

    @When(value="^I click on the space '(.*)'$")
    public void goToTheSearchedSpace(String space) {
        this.manageUnifiedSearchSteps.goToTheSearchedSpace(space);
    }

    @When(value="^The activity is not displayed in the search '(.*)'$")
    public void isSearchedActivityTitleNotVisible(String activity) {
        this.manageUnifiedSearchSteps.isSearchedActivityTitleNotVisible(activity);
    }

    @Then(value="^The task is displayed in the search '(.*)'$")
    @When(value="^The activity is displayed in the search '(.*)'$")
    public void isSearchedActivityTitleVisible(String activity) {
        this.manageUnifiedSearchSteps.isSearchedActivityTitleVisible(activity);
    }

    @Then(value="^The description of the application is displayed in the search '(.*)'$")
    public void isSearchedApplicationDescriptionVisible(String appDesc) {
        this.manageUnifiedSearchSteps.isSearchedApplicationDescriptionVisible(appDesc);
    }

    @Then(value="^The full name of the application is displayed in the search '(.*)'$")
    public void isSearchedApplicationNameVisible(String appName) {
        this.manageUnifiedSearchSteps.isSearchedApplicationNameVisible(appName);
    }

    @Then(value="^The app logo is displayed in the search$")
    public void isSearchedApplicationPictureVisible() {
        this.manageUnifiedSearchSteps.isSearchedApplicationPictureVisible();
    }

    @Then(value="^The full name of the first created space is displayed in the search$")
    public void isSearchedFirsRandomSpaceNameVisible() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.manageUnifiedSearchSteps.isSearchedSpaceNameVisible(randomSpaceName);
    }

    @Then(value="^The user's full name is displayed in the search with last name Smith$")
    public void isSearchedRandomUserNameVisibleWithSameLastName() {
        String randomUserFirstName = (String)Serenity.sessionVariableCalled((Object)"randomUserFirstName");
        String randomUserLastName = (String)Serenity.sessionVariableCalled((Object)"randomUserLastName");
        String fullName = randomUserFirstName + " " + randomUserLastName;
        this.manageUnifiedSearchSteps.isSearchedUserNameVisible(fullName);
    }

    @Then(value="^The full name of the space is displayed in the search '(.*)'$")
    public void isSearchedSpaceNameVisible(String space) {
        this.manageUnifiedSearchSteps.isSearchedSpaceNameVisible(space);
    }

    @Then(value="^The user's full name is displayed in the search '(.*)'$")
    public void isSearchedUserNameVisible(String fullname) {
        this.manageUnifiedSearchSteps.isSearchedUserNameVisible(fullname);
    }

    @When(value="^I start the search for the user created by the name '(.*)'$")
    @Et(value="^I launch the search for the space created '(.*)'$")
    @Then(value="^I start the search for '(.*)'$")
    public void search(String element) {
        this.manageUnifiedSearchSteps.search(element);
    }

    @And(value="^I launch the search for the first random created space$")
    @Then(value="^I start the search for the first random created space$")
    public void searchForFirstRandomCreatedSpace() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.manageUnifiedSearchSteps.search(randomSpaceName);
    }

    @And(value="^I select an object from the drop-down menu '(.*)'$")
    public void selectDropDown(String object) {
        this.manageUnifiedSearchSteps.selectDropDown(object);
    }

    @When(value="^I start the search for the application created by the name '(.*)'$")
    public void searchForApplication(String element) {
        this.manageUnifiedSearchSteps.search(element, true);
    }
}

