/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.ProgramsSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import org.apache.commons.lang3.StringUtils;

public class ProgramsStepDefinition {
    @Steps
    private ProgramsSteps programsSteps;

    @And(value="I add an audience space")
    public void addAudienceSpace() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.programsSteps.addSpaceAudience(randomSpaceName);
    }

    @And(value="I save the program details")
    public void saveProgram() {
        this.programsSteps.clickSaveProgramButton();
    }

    @When(value="I switch program as disabled")
    @And(value="I switch program as enabled")
    public void enableDisableProgram() {
        this.programsSteps.enableDisableProgram();
    }

    @Then(value="The program status switch is not displayed")
    public void programStatusSwitchNotDisplayed() {
        this.programsSteps.checkProgramStatusSwitchNotDisplayed();
    }

    @Then(value="I attach an avatar to the program")
    public void attachAvatarToProgram() {
        this.programsSteps.attachAvatarToProgram();
    }

    @Then(value="I attach a cover to the program")
    public void attachCoverToProgram() {
        this.programsSteps.attachCoverToProgram();
    }

    @Then(value="The program is displayed with specific avatar")
    public void checkProgramAvatarIsSpecificInDetail() {
        this.programsSteps.checkProgramAvatarIsSpecificInDetail();
    }

    @Then(value="The program is displayed with specific cover")
    public void checkProgramCoverIsSpecificInDetail() {
        this.programsSteps.checkProgramCoverIsSpecificInDetail();
    }

    @Then(value="I delete the specific avatar of the program")
    public void deleteAvatarFromProgram() {
        this.programsSteps.deleteAvatarFromProgram();
    }

    @Then(value="I delete the specific cover of the program")
    public void deleteCoverFromProgram() {
        this.programsSteps.deleteCoverFromProgram();
    }

    @Then(value="The program is displayed with default avatar")
    public void checkProgramAvatarIsDefaultInDetail() {
        this.programsSteps.checkProgramAvatarIsDefaultInDetail();
    }

    @Then(value="The program is displayed with default cover")
    public void checkProgramCoverIsDefaultInDetail() {
        this.programsSteps.checkProgramCoverIsDefaultInDetail();
    }

    @Then(value="I click on program title to go back")
    public void goBackUsingProgramTitle() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.goBackUsingProgramTitle(programName);
    }

    @And.Ands(value={@And(value="^I add program with random description$"), @And(value="I enter a random description for program")})
    public void enterProgramRandomDescription() {
        String programDescription = "programDescription" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"programDescription").to((Object)programDescription);
        this.programsSteps.enterProgramDescription(programDescription);
    }

    @And(value="^I enter the program description '(.*)' '(.*)' times$")
    public void enterProgramDescription(String programDescription, String times) {
        StringBuilder programLongDescription = new StringBuilder();
        for (int i = 0; i < Integer.parseInt(times); ++i) {
            programLongDescription.append(programDescription);
        }
        this.programsSteps.enterProgramDescription(programLongDescription.toString());
    }

    @Then(value="^The drawer add program should be displayed$")
    public void checkAddProgramDrawerDisplay() {
        this.programsSteps.checkProgramDrawerDisplay();
    }

    @And(value="^The program card should not be displayed$")
    public void checkProgramCardDisplay() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.checkProgramCardDisplay(programName);
    }

    @Then(value="^The program card title '(.*)' should be displayed$")
    public void checkProgramCardTitle(String title) {
        this.programsSteps.checkProgramCardTitle(title);
    }

    @And(value="^The program title should be displayed on the card$")
    public void checkProgramTitleDisplayOnCard() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.checkProgramCardTitle(programName);
    }

    @And(value="^The program title should be updated on the card$")
    public void checkProgramTitleUpdateOnCard() {
        String newProgramName = (String)Serenity.sessionVariableCalled((Object)"newProgramName");
        this.programsSteps.checkProgramCardTitle(newProgramName);
    }

    @And(value="^I create the '(.*)' random program with$")
    public void createRandomProgram(String suffix, Map<String, String> details) {
        String programName = "programName" + Utils.getRandomNumber();
        this.programsSteps.createRandomProgram(programName, details);
        Serenity.setSessionVariable((Object)("programName" + suffix)).to((Object)programName);
    }

    @Then(value="^The '(.*)' random program is not displayed in Top Programs widget$")
    public void checkProgramNotInTopPrograms(String suffix) {
        String programName = (String)Serenity.sessionVariableCalled((Object)("programName" + suffix));
        this.programsSteps.checkProgramNotDisplayedInTopPrograms(programName);
    }

    @Then(value="^The '(.*)' random program is displayed in '(.*)' position in Top Programs widget$")
    public void checkProgramPositionInTopPrograms(String suffix, String position) {
        String programName = (String)Serenity.sessionVariableCalled((Object)("programName" + suffix));
        int listPosition = Utils.getIndexFomName((String)position);
        this.programsSteps.checkProgramPositionInTopPrograms(programName, listPosition);
    }

    @And(value="^I click on the button add program(.*)$")
    public void clickAddProgramBtn(String message) {
        this.programsSteps.clickAddProgramBtn();
    }

    @And(value="^I delete the created program$")
    public void deleteCreatedProgram() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.deleteCreatedProgram(programName);
    }

    @And(value="I edit the program from detail")
    public void editProgram() {
        this.programsSteps.editProgram();
    }

    @And(value="I edit the program from list")
    public void editProgramFromList() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.editProgram(programName);
    }

    @And(value="I change the created program with a random description")
    public void editProgramWithDescription() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        String newProgramName = "newProgramName" + Utils.getRandomNumber();
        String newProgramDescription = "newProgramDescription" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"newProgramName").to((Object)newProgramName);
        Serenity.setSessionVariable((Object)"newProgramDescription").to((Object)newProgramDescription);
        this.programsSteps.editProgramWithDescription(programName, newProgramName, newProgramDescription);
    }

    @And(value="^I enter a random program title$")
    public void enterProgramTitle() {
        String programName = "programName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"programName").to((Object)programName);
        this.programsSteps.enterProgramTitle(programName);
    }

    @And(value="^I enter the program title '(.*)'$")
    public void enterProgramTitle(String programTitle) {
        this.programsSteps.enterProgramTitle(programTitle);
    }

    @And(value="^I enter the random program title '(.*)'$")
    public void enterRandomProgramTitle(String suffix) {
        String programTitle = StringUtils.truncate((String)Utils.getRandomString((String)suffix, (int)20), (int)49);
        Serenity.setSessionVariable((Object)("programName" + suffix)).to((Object)programTitle);
        this.programsSteps.enterProgramTitle(programTitle);
    }

    @When(value="^I go to engagement application '(.*)'$")
    public void selectEngagementApplication(String tab) {
        this.programsSteps.selectEngagementApplication(tab);
    }

    @When(value="^I set user '(.*)' as program owner$")
    public void addProgramOwner(String suffix) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(suffix + "UserFirstName"));
        this.programsSteps.addProgramOwner(firstName);
    }

    @And(value="^I filter programs by value '(.*)'$")
    public void selectProgramsFilter(String value) {
        this.programsSteps.selectProgramsFilter(value);
    }

    @And(value="^I filter program actions by value '(.*)'$")
    public void selectProgramActionsFilter(String value) {
        this.programsSteps.selectProgramActionsFilter(value);
    }

    @And(value="^I open '(.*)' program card$")
    public void openProgramCard(String value) {
        this.programsSteps.openProgramCard(value);
    }

    @And(value="^I open '(.*)' random program card$")
    public void openRandomProgramCard(String suffix) {
        String programName = (String)Serenity.sessionVariableCalled((Object)("programName" + suffix));
        this.programsSteps.openProgramCard(programName);
    }

    @And(value="I close program card")
    public void closeProgramCard() {
        this.programsSteps.closeProgramCard();
    }

    @And(value="^I open random program card$")
    public void openRandomProgramCard() {
        String programName = (String)Serenity.sessionVariableCalled((Object)"programName");
        this.programsSteps.openProgramCard(programName);
    }

    @And(value="^I edit program action '(.*)'$")
    public void editProgramAction(String actionTitle) {
        this.programsSteps.editProgramAction(actionTitle);
    }

    @And(value="^I enable program action '(.*)'$")
    public void enableProgramAction(String actionTitle) {
        this.programsSteps.enableProgramAction(actionTitle);
    }

    @And(value="^I disable program action '(.*)'$")
    public void disableProgramAction(String actionTitle) {
        this.programsSteps.disableProgramAction(actionTitle);
    }

    @And(value="^I delete program action '(.*)'$")
    public void deleteProgramAction(String actionTitle) {
        this.programsSteps.deleteProgramAction(actionTitle);
    }

    @And(value="I cannot announce program action")
    public void checkCannotAnnounceAction() {
        this.programsSteps.checkCannotAnnounceAction();
    }

    @And(value="The program action does not contain duration limitation")
    public void checkProgramActionNotContainsDurationLimitation() {
        this.programsSteps.checkProgramActionNotContainsDurationLimitation();
    }

    @And(value="The program action contains duration limitation")
    public void checkProgramActionContainsDurationLimitation() {
        this.programsSteps.checkProgramActionContainsDurationLimitation();
    }

    @And(value="^I announce challenge '(.*)' with message '(.*)'$")
    public void announceAction(String challengeTitle, String announcementMessage) {
        this.programsSteps.announceAction(challengeTitle, announcementMessage);
    }

    @And(value="^I announce challenge '(.*)' with message '(.*)' from activity$")
    public void announceActionFromActivity(String challengeTitle, String announcementMessage) {
        this.programsSteps.announceActionFromActivity(challengeTitle, announcementMessage);
    }

    @And(value="^I announce action with message '(.*)'$")
    public void sendAnnouncementMessage(String announcementMessage) {
        this.programsSteps.sendAnnouncementMessage(announcementMessage);
    }

    @Then(value="Actions Filter dropdown is displayed")
    public void checkActionsFilterIsDisplayed() {
        this.programsSteps.checkActionsFilterIsDisplayed();
    }

    @Then(value="Admin Actions Filter dropdown is not displayed")
    public void checkAdminActionsFilterIsNotDisplayed() {
        this.programsSteps.checkAdminActionsFilterIsNotDisplayed();
    }

    @Then(value="Admin Actions Filter dropdown is displayed")
    public void checkAdminActionsFilterIsDisplayed() {
        this.programsSteps.checkAdminActionsFilterIsDisplayed();
    }

    @Then(value="The message '{}' is displayed in program detail drawer")
    public void checkMessageIsDisplayedInProgramDetailDrawer(String message) {
        this.programsSteps.checkMessageIsDisplayedInProgramDetailDrawer(message);
    }

    @When(value="The message '{}' is not displayed in program detail drawer")
    public void checkMessageIsNotDisplayedInProgramDetailDrawer(String message) {
        this.programsSteps.checkMessageIsNotDisplayedInProgramDetailDrawer(message);
    }
}

