/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.RulesSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class RulesStepDefinition {
    @Steps
    private RulesSteps rulesSteps;

    @And(value="^I enter the rule title '(.*)'$")
    public void enterProgramTitle(String ruleTitle) {
        this.rulesSteps.enterRuleTitle(ruleTitle);
    }

    @And(value="I add rule random title")
    public void enterProgramTitle() {
        String ruleTitle = "ruleTitle" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"ruleTitle").to((Object)ruleTitle);
        this.rulesSteps.enterRuleTitle(ruleTitle);
    }

    @And(value="^I select a '(.*)' application")
    public void selectActionApplication(String applicationLabel) {
        this.rulesSteps.selectActionApplication(applicationLabel);
    }

    @And(value="^I select a '(.*)' event")
    public void addRuleEvent(String triggerName) {
        this.rulesSteps.addRuleEvent(triggerName);
    }

    @And(value="^I select '(.*)' as default contribution status")
    public void selectDefaultContributionStatus(String status) {
        this.rulesSteps.selectDefaultContributionStatus(status);
    }

    @And(value="I set rule end date")
    public void setActionEndDate() {
        this.rulesSteps.setActionEndDate();
    }

    @And(value="I delete rule duration")
    public void deleteActionDuration() {
        this.rulesSteps.deleteActionDuration();
    }

    @And(value="I click on the button to add a rule")
    public void clickAddActionButton() {
        this.rulesSteps.clickAddActionButton();
    }

    @And(value="I add rule random description")
    public void addRuleRandomDescription() {
        String ruleDescription = "ruleDescription" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"ruleDescription").to((Object)ruleDescription);
        this.rulesSteps.addRuleRandomDescription(ruleDescription);
    }

    @And(value="^I create the '(.*)' random manual action with$")
    public void createRandomManualRule(String suffix, Map<String, String> details) {
        String title = "actionName" + Utils.getRandomNumber();
        this.rulesSteps.createAction(title, true, details);
        Serenity.setSessionVariable((Object)("actionName" + suffix)).to((Object)title);
    }

    @When(value="^I search for the (.*) rule in program detail rule filter$")
    public void searchRuleInProgramRuleFilter(String ruleTitle) {
        this.rulesSteps.searchRuleInProgramRuleFilter(ruleTitle);
    }

    @Then(value="^Rule not found. Please try again is displayed$")
    public void ruleNotfoundTryAgain() {
        this.rulesSteps.ruleNotfoundTryAgain();
    }

    @When(value="^I clear rules search filter$")
    public void clearRulesSearchFilter() {
        this.rulesSteps.clearRulesSearchFilter();
    }

    @Then(value="^The action '(.*)' is displayed in program detail$")
    public void isRuleDisplayedInProgramDetail(String actionTitle) {
        this.rulesSteps.isActionDisplayedInProgramDetail(actionTitle);
    }

    @Then(value="^The action '(.*)' is not displayed in program detail$")
    public void isRuleNotDisplayedInProgramDetail(String actionTitle) {
        this.rulesSteps.isActionNotDisplayedInProgramDetail(actionTitle);
    }

    @Then(value="^I open program action '(.*)'$")
    public void openActionDrawer(String actionTitle) {
        this.rulesSteps.openActionDrawer(actionTitle);
    }

    @And(value="I attach an image to the program action")
    public void attachImageToProgramAction() {
        this.rulesSteps.attachImageToProgramAction();
    }

    @And(value="I attach an image to the announcement")
    public void attachImageToAnnouncement() {
        this.rulesSteps.attachImageToAnnouncement();
    }
}

