/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.SocialSteps;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class SocialStepDefinitions {
    @Steps
    private SocialSteps socialSteps;

    @When(value="^I set the new comment '(.*)' and I click on cancel button$")
    public void cancelUpdateActivityComment(String comment) {
        this.socialSteps.cancelUpdateActivityComment(comment);
    }

    @Given(value="^The search result is well matched with the username entered '(.*)'$")
    @And(value="^The search result is well matched with the username entered of the (.*) user$")
    public void checkSearchedUserWellMatched(String suffix) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(suffix + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(suffix + "UserLastName"));
        String fullName = firstName + " " + lastName;
        this.socialSteps.checkSearchedUserWellMatched(fullName);
    }

    @And(value="I Select the comment added and I click on edit button")
    public void editComment() {
        this.socialSteps.editComment();
    }

    @And(value="I click on People filter and I select My connections")
    public void filterByMyConnections() {
        this.socialSteps.filterByMyConnections();
    }

    @When(value="^I go to people page$")
    public void goToPeoplePage() {
        this.socialSteps.goToPeopleMenu();
    }

    @And(value="^I search for '(.*)' random user$")
    public void searchRandomUser(String suffix) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(suffix + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(suffix + "UserLastName"));
        String fullName = firstName + " " + lastName;
        this.socialSteps.insertNameContact(fullName);
    }

    @When(value="^I set the new comment '(.*)' and I click on update button$")
    public void updateActivityComment(String comment) {
        this.socialSteps.updateActivityComment(comment);
    }
}

