/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.pages.SpacePage;
import io.meeds.qa.ui.steps.SpaceSteps;
import java.util.List;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import org.apache.commons.lang3.StringUtils;

public class SpaceStepDefinition {
    private static final String USER_LAST_NAME = "UserLastName";
    private static final String ACTIVITY = "activity";
    private static final String USER_FIRST_NAME = "UserFirstName";
    private SpacePage spacePage;
    @Steps
    private SpaceSteps spaceSteps;

    @When(value="^I enter an activity '(.*)'$")
    @And(value="^I add a short message '(.*)' for the Poll$")
    public void addActivity(String activity) {
        this.spaceSteps.addActivity(activity);
    }

    @When(value="^I add in activity '(.*)' a comment '(.*)'$")
    public void addActivityComment(String activity, String comment) {
        this.spacePage.addActivityComment(activity, comment);
    }

    @When(value="^I add in activity '(.*)' the following comments$")
    public void addActivityComments(String activity, List<String> comments) {
        this.spacePage.addActivityComments(activity, comments);
    }

    @When(value="^I add in comment '(.*)' of activity '(.*)' the following replies$")
    public void addActivityComments(String comment, String activity, List<String> replies) {
        this.spacePage.addCommentReplies(replies, comment, activity);
    }

    @When(value="^I enter an activity more than 1300 characters$")
    public void addActivityExceed() {
        String activity = StringUtils.repeat((String)"activity to add", (int)90);
        this.spaceSteps.addActivity(activity);
        Serenity.setSessionVariable((Object)ACTIVITY).to((Object)activity);
    }

    @When(value="^I enter an activity '(.*)' mentioning the (.*) user$")
    public void addActivityMentioningRandomUser(String activity, String userPrefix) {
        String userName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String newActivity = activity + " @" + userName;
        this.spaceSteps.addActivity(newActivity);
    }

    @When(value="^I add a reply '(.*)' to comment '(.*)' in activity '(.*)'$")
    public void addCommentReply(String reply, String comment, String activity) {
        this.spacePage.addCommentReply(reply, comment, activity);
    }

    @When(value="^I add description with less than 1000 characters In the poll$")
    public void addDescriptionLess1000CharsInThePoll() {
        String description = StringUtils.repeat((String)"Description ", (int)80);
        this.spaceSteps.addDescriptionLess1000CharsInThePoll(description);
    }

    @When(value="^I add description with more than 1000 characters In the poll$")
    public void addDescriptionMore1000CharsInThePoll() {
        String description = StringUtils.repeat((String)"Description ", (int)100);
        this.spaceSteps.addOptionThreeInThePoll(description);
    }

    @When(value="^I add in activity '(.*)' an internal link '(.*)' as a comment$")
    public void addInternalLinkComment(String activity, String comment) {
        this.spacePage.addActivityComment(activity, this.spacePage.getCurrentUrl() + comment);
    }

    @When(value="^I added the second choice '(.*)' in the poll$")
    public void addOptionTwoInThePoll(String choiceTow) {
        this.spaceSteps.addOptionTwoInThePoll(choiceTow);
    }

    @Then(value="^I click on Cancel button$")
    public void cancelDeleteComment() {
        this.spaceSteps.cancelDeleteComment();
    }

    @Then(value="^The comment '(.*)' is displayed in Comments drawer$")
    public void checkActivityCommentInDrawer(String comment) {
        this.spaceSteps.checkActivityCommentInDrawer(comment);
    }

    @Then(value="^The comment '(.*)' is displayed in Comments drawer of activity '(.*)'$")
    public void checkActivityCommentInDrawer(String comment, String activity) {
        this.spaceSteps.checkActivityCommentDisplayed(activity, comment);
    }

    @Then(value="^The comment '(.*)' is not displayed in Comments drawer of activity '(.*)'$")
    public void checkActivityCommentNotDisplayed(String comment, String activity) {
        this.spaceSteps.checkActivityCommentNotDisplayed(activity, comment);
    }

    @And.Ands(value={@And(value="^the activity '(.*)' is no more displayed in the activity stream$"), @And(value="^The activity '(.*)' is not displayed$")})
    @Then(value="^the activity '(.*)' is not displayed in activity stream$")
    @When(value="^the activity '(.*)' is not displayed in stream page$")
    public void checkActivityNotVisible(String activity) {
        this.spaceSteps.checkActivityNotVisible(activity);
    }

    @Then(value="^The activity '(.*)' is pinned in space stream$")
    public void checkActivityPinned(String activity) {
        this.spaceSteps.checkActivityPinned(activity);
    }

    @Then(value="^The activity page is opened '(.*)'$")
    public void checkActivityTitle(String activity) {
        this.spaceSteps.checkActivityTitle(activity);
    }

    @When(value="^the activity '(.*)' is displayed in activity stream$")
    @Then(value="^the activity '(.*)' is displayed in stream page$")
    @And.Ands(value={@And(value="^The Poll '(.*)' is displayed in stream page$"), @And(value="^The activity '(.*)' is displayed$")})
    public void checkActivityVisible(String activity) {
        this.spaceSteps.checkActivityVisible(activity);
    }

    @When(value="^The comment '(.*)' is displayed$")
    public void checkCommentVisible(String comment) {
        this.spaceSteps.checkCommentVisible(comment);
    }

    @Then(value="^Comment is displayed in comments drawer at the sixth position$")
    public void checkCommentInDrawerSixthPosition() {
        this.spaceSteps.checkSixthPositionInDrawer();
    }

    @When(value="^In activity '(.*)' with comment '(.*)', the reply '(.*)' is displayed$")
    public void checkCommentReplyDisplayed(String activity, String comment, String reply) {
        this.spaceSteps.checkCommentReplyDisplayed(activity, comment, reply);
    }

    @And(value="^In activity '(.*)' with comment '(.*)', the reply '(.*)' is displayed in Comment Drawer$")
    public void checkCommentReplyDisplayedInDrawer(String activity, String comment, String reply) {
        this.spaceSteps.checkCommentReplyDisplayedInDrawer(activity, comment, reply);
    }

    @When(value="^In activity '(.*)' with comment '(.*)', the reply '(.*)' is not displayed$")
    public void checkCommentReplyNotDisplayed(String activity, String comment, String reply) {
        this.spaceSteps.checkCommentReplyNotDisplayed(activity, comment, reply);
    }

    @Then(value="The confirmation popup is displayed")
    public void checkConfirmationPopupIsVisible() {
        this.spaceSteps.checkConfirmationPopupVisible();
    }

    @Then(value="the confirmation popup is not displayed")
    public void checkConfirmationPopupNotVisible() {
        this.spaceSteps.checkConfirmationPopupNotVisible();
    }

    @When(value="^Create Poll Button is Disabled$")
    public void checkCreatePollButtonIsDisabled() {
        this.spaceSteps.checkCreatePollButtonIsDisabled();
    }

    @When(value="^Create Poll Button is Enabled$")
    public void checkCreatePollButtonIsEnabled() {
        this.spaceSteps.checkCreatePollButtonIsEnabled();
    }

    @Then(value="^the video '(.*)' is displayed in the activity stream$")
    public void checkDisplayVideo(String videoLink) {
        this.spaceSteps.checkVideoActivityVisible(videoLink);
    }

    @Then(value="^First comment '(.*)' is displayed in activity stream$")
    public void checkFirstActivityComment(String comment) {
        this.spaceSteps.checkFirstActivityComment(comment);
    }

    @Then(value="^First comment '(.*)' is displayed in comments drawer$")
    public void checkFirstCommentInDrawer(String comment) {
        this.spaceSteps.checkFirstCommentInDrawer(comment);
    }

    @Then(value="Check Four comment is displayed in comments drawer")
    public void checkFourCommentIsDisplayedInDrawer() {
        this.spaceSteps.checkFourCommentIsDisplayedInDrawer();
    }

    @Then(value="^Fourth comment is displayed in comments drawer$")
    public void checkFourthCommentInDrawer() {
        this.spaceSteps.checkFourthCommentInDrawer();
    }

    @Then(value="^Internal link '(.*)' is displayed in Comments drawer of activity '(.*)'$")
    public void checkInternalLinkCommentInDrawer(String comment, String activity) {
        this.spaceSteps.checkActivityCommentDisplayed(activity, this.currentUrlNoProtocol() + comment);
    }

    @Then(value="The link is displayed with the preview")
    public void checkPreviewLink() {
        this.spaceSteps.checkLinkPreviewVisible();
    }

    @Then(value="^The (.*) user is displayed in activity likers drawer$")
    public void checkReactionsDrawerDisplay(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        this.spaceSteps.checkUserDisplayedInReactionsDrawer(userLastName);
    }

    @Then(value="^Second comment is displayed in activity stream$")
    public void checkSecondActivityComment() {
        this.spaceSteps.checkSecondActivityComment();
    }

    @Then(value="^Second comment is displayed in comments drawer$")
    public void checkSecondCommentInDrawer() {
        this.spaceSteps.checkSecondCommentInDrawer();
    }

    @Then(value="Check Ten comment is displayed in comments drawer")
    public void checkTenCommentIsDisplayedInDrawer() {
        this.spaceSteps.checkTenCommentIsDisplayedInDrawer();
    }

    @Then(value="^Third comment is displayed in comments drawer$")
    public void checkThirdCommentInDrawer() {
        this.spaceSteps.checkThirdCommentInDrawer();
    }

    @When(value="^I click on Create Poll$")
    public void clickCreatePoll() {
        this.spaceSteps.clickCreatePoll();
    }

    @When(value="^I click on send kudos$")
    public void clickSendKudos() {
        this.spaceSteps.clickSendKudos();
    }

    @When(value="^I send kudos to '(.*)' with message '(.*)'$")
    public void sendKudosWithReceiver(String receiver, String message) {
        this.spaceSteps.sendKudosWithReceiver(message, receiver);
    }

    @When(value="^I click Create Poll$")
    public void clickCreatePollButton() {
        this.spaceSteps.clickCreatePollButton();
    }

    @When(value="^I click on Delete button related to activity '(.*)'$")
    public void clickDeleteActivityButton(String activity) {
        this.spaceSteps.clickDeleteActivityButton(activity);
    }

    @When(value="^I click on '(.*)' button related to comment '(.*)'$")
    public void clickCommentButton(String buttonName, String comment) {
        this.spaceSteps.clickCommentButton(buttonName, comment);
    }

    @When(value="^I click on comment '(.*)'$")
    public void clickOnActivityComment(String comment) {
        this.spaceSteps.clickOnActivityComment(comment);
    }

    @When(value="^I click on comment button related to activity '(.*)'$")
    public void clickOnCommentActivity(String activity) {
        this.spacePage.clickOnCommentActivityButton(activity);
    }

    @When(value="^I go to the comments drawer first page$")
    public void clickOnCommentsDrawerFirstPage() {
        this.spaceSteps.clickOnCommentsDrawerFirstPage();
    }

    @When(value="^I go to the comments drawer second page$")
    public void clickOnCommentsDrawerSecondPage() {
        this.spaceSteps.clickOnCommentsDrawerSecondPage();
    }

    @Then(value="^I click on the comment '(.*)' three dots icon from comments drawer$")
    @And(value="^I click on the first comment '(.*)' three dots icon from comments drawer$")
    public void clickOnCommentThreeDotsButtonFromCommentsDrawer(String comment) {
        this.spaceSteps.clickOnCommentThreeDotsButtonFromCommentsDrawer(comment, false);
    }

    @When(value="^I click on the reply '(.*)' three dots icon from comments drawer$")
    public void clickOnReplyThreeDotsButtonFromCommentsDrawer(String comment) {
        this.spaceSteps.clickOnCommentThreeDotsButtonFromCommentsDrawer(comment, true);
    }

    @When(value="^I click on the internal link '(.*)'$")
    public void clickOnInternalLinkComment(String comment) {
        this.spaceSteps.clickOnActivityComment(this.currentUrlNoProtocol() + comment);
    }

    @When(value="^I click on Load more button$")
    public void clickOnLoadMoreActivities() {
        this.spaceSteps.clickOnLoadMoreActivities();
    }

    @Then(value="^In reply '(.*)', I click on kudos button$")
    public void clickOnReplyKudos(String reply) {
        this.spaceSteps.clickOnReplyKudos(reply);
    }

    @Then(value="I click on the kudos button on first displayed Activity")
    public void clickOnTheKudosButtonFromTheActivityStream() {
        this.spaceSteps.clickKudosFromActivityStream();
    }

    @Then(value="I click on the kudos button from the comment '(.*)'$")
    public void clickOnCommentKudosButton(String comment) {
        this.spaceSteps.clickOnCommentKudosButton(comment);
    }

    @Then(value="I click on the kudos button from the comments drawer")
    public void clickOnTheKudosButtonFromTheCommentsDrawer() {
        this.spaceSteps.clickKudosFromCommentsDrawer();
    }

    @And(value="I click on the kudos button number")
    public void clickOnTheKudosButtonNumber() {
        this.spaceSteps.clickOnKudosNumberButton();
    }

    @And(value="I click on the kudos button number from the comments drawer")
    public void clickOnTheKudosButtonNumberFromTheCommentsDrawer() {
        this.spaceSteps.clickOnKudosNumberButtonFromTheCommentsDrawer();
    }

    @Then(value="^I click on the (.*) user Popover$")
    public void clickOnTheRandomUserPopover(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.clickOnTheUserPopover(fullName);
    }

    @Then(value="^I click on the user Popover '(.*)'$")
    public void clickOnTheUserPopover(String user) {
        this.spaceSteps.clickOnTheUserPopover(user);
    }

    @When(value="^I click on View all X comments$")
    public void clickOnViewallXcomments() {
        this.spaceSteps.clickOnViewallXcomments();
    }

    @When(value="^I click on Pin button related to activity '(.*)'$")
    public void clickPinActivityButton(String activity) {
        this.spaceSteps.clickPinActivityButton(activity);
    }

    @When(value="I click on post in space")
    public void clickPostIcon() {
        this.spaceSteps.clickPostIcon();
    }

    @When(value="I click on user avatar in space stream")
    public void clickUserAvatar() {
        this.spaceSteps.clickUserAvatar();
    }

    @When(value="^I click on kudos button below the post field$")
    public void clickKudosBtnBelowPostField() {
        this.spaceSteps.clickKudosBtnBelowPostField();
    }

    @When(value="^I click on poll button below the post field$")
    public void clickPollBtnBelowPostField() {
        this.spaceSteps.clickPollBtnBelowPostField();
    }

    @Then(value="the composer is opened")
    public void composerDrawerIsDisplayed() {
        this.spaceSteps.composerDrawerIsDisplayed();
    }

    @Then(value="the kudos drawer is opened")
    public void kudosDrawerIsDisplayed() {
        this.spaceSteps.kudosDrawerIsDisplayed();
    }

    @When(value="^I close kudos drawer$")
    public void clickCloseKudosDrawer() {
        this.spaceSteps.clickCloseKudosDrawer();
    }

    @Then(value="The Poll drawer is opened")
    public void pollDrawerIsDisplayed() {
        this.spaceSteps.pollDrawerIsDisplayed();
    }

    @When(value="^I click to the Unpin button related to activity '(.*)'$")
    public void clickUnpinActivityButton(String activity) {
        this.spaceSteps.clickUnpinActivityButton(activity);
    }

    @Then(value="^'(.*)' among them '(.*)' are displayed in Comments drawer$")
    @And(value="^'(.*)', only '(.*)' is displayed in Comments drawer$")
    public void commentIsDisplayedInDrawer(String commentsNumber, String comment) {
        this.spaceSteps.commentIsDisplayedInDrawer(commentsNumber, comment);
    }

    @Then(value="^'(.*)' among them '(.*)' are not displayed in Comments drawer$")
    @And(value="^'(.*)', only '(.*)' is not displayed in Comments drawer$")
    public void commentIsNotDisplayedInDrawer(String commentsNumber, String comment) {
        this.spaceSteps.commentIsNotDisplayedInDrawer(commentsNumber, comment);
    }

    @When(value="^Comment '(.*)' is not displayed in the drawer$")
    public void commentNameIsNotDisplayedInDrawer(String comment) {
        this.spaceSteps.commentNameIsNotDisplayedInDrawer(comment);
    }

    @Then(value="^In comments drawer, on comment '(.*)', '(.*)' like is displayed$")
    public void commentsDrawerDisplayedLikesOnComment(String comment, String number) {
        this.spaceSteps.commentsDrawerDisplayedLikesOnComment(comment, number);
    }

    @When(value="^In comments drawer, I like the activity comment '(.*)'$")
    @And(value="^In comments drawer, I unlike the activity comment '(.*)'$")
    public void commentsDrawerlikeActivityComment(String activityComment) {
        this.spaceSteps.commentsDrawerlikeActivityComment(activityComment);
    }

    @When(value="^Copy link button related to activity '(.*)' is displayed$")
    public void copyLinkActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.copyLinkActivityButtonIsDisplayed(activity);
    }

    @When(value="^I create a simple poll with title '(.*)' and Choice One '(.*)' and Choice Two '(.*)'$")
    public void createPoll(String pollTitle, String choiceOne, String choiceTow) {
        this.spaceSteps.createPoll(pollTitle, choiceOne, choiceTow);
    }

    @When(value="^create poll drawer is closed$")
    public void createPollDrawerClosed() {
        this.spaceSteps.createPollDrawerClosed();
    }

    @When(value="^I try to create a poll with title '(.*)' and with a single choice '(.*)'$")
    public void createPollWithOneChoice(String pollTitle, String choiceOne) {
        this.spaceSteps.createPollWithOneChoice(pollTitle, choiceOne);
    }

    @When(value="^Delete button related to activity '(.*)' is displayed$")
    public void deleteActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.deleteActivityButtonIsDisplayed(activity);
    }

    @When(value="^In comment '(.*)', I click on delete button$")
    public void deleteComment(String comment) {
        this.spaceSteps.deleteComment(comment);
    }

    @When(value="^In reply '(.*)', I click on delete button$")
    public void deleteReply(String reply) {
        this.spaceSteps.deleteReply(reply);
    }

    @Then(value="^On comment '(.*)', '(.*)' like is displayed$")
    public void displayedLikesOnComment(String comment, String number) {
        this.spaceSteps.displayedLikesOnComment(comment, number);
    }

    @When(value="^Download button related to activity '(.*)' is displayed$")
    public void downloadActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.downloadActivityButtonIsDisplayed(activity);
    }

    @When(value="I click on Update")
    public void editActivity() {
        this.spaceSteps.editActivity();
    }

    @When(value="^Edit button related to activity '(.*)' is displayed$")
    public void editActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.editActivityButtonIsDisplayed(activity);
    }

    @When(value="^In comment '(.*)', I click on edit button$")
    public void editComment(String comment) {
        this.spaceSteps.editComment(comment);
    }

    @When(value="^In comment '(.*)', I click on edit button from comments drawer$")
    public void editCommentFromCommentsDrawer(String comment) {
        this.spaceSteps.editCommentFromCommentsDrawer(comment);
    }

    @When(value="^I edited created poll with title '(.*)' and Choice One '(.*)' and Choice Two '(.*)'$")
    public void editPoll(String pollTitle, String choiceOne, String choiceTow) {
        this.spaceSteps.editPoll(pollTitle, choiceOne, choiceTow);
    }

    @When(value="^I enter a comment '(.*)' with mentioning the (.*) user$")
    public void enterActivityCommentWithRandomUser(String comment, String userPrefix) {
        String lastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        this.spaceSteps.enterActivityCommentWithUser(comment, lastName);
    }

    @When(value="^I enter a comment '(.*)' with attempting to mention the (.*) user$")
    public void enterActivityCommentWithRandomUserNoMention(String comment, String userPrefix) {
        String lastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        this.spaceSteps.enterActivityCommentWithUserNoMention(comment, lastName);
    }

    @When(value="^I insert text '(.*)'$")
    public void enterActivityText(String activity) {
        this.spaceSteps.enterActivityText(activity);
    }

    @When(value="^In activity '(.*)' I enter the link '(.*)' as comment$")
    public void enterCommentLink(String activity, String link) {
        this.spacePage.enterCommentLink(activity, link);
    }

    @When(value="^I insert text '(.*)' as comment$")
    public void enterCommentText(String comment) {
        this.spaceSteps.enterCommentText(comment);
    }

    @Then(value="^I click on '(.*)' space menu tab$")
    public void goToTab(String tabName) {
        this.spaceSteps.goToSpecificTab(tabName);
    }

    @When(value="^I open user profile of (.*) user from activity likers drawer$")
    public void goToUserProfileFromLikersDrawer(String prefix) {
        this.spaceSteps.goToUserProfileFromLikersDrawer(prefix);
    }

    @When(value="^In comment '(.*)', I hover on Like icon$")
    public void hoverOnLikeIcon(String comment) {
        this.spaceSteps.hoverOnLikeIcon(comment);
    }

    @When(value="^In comments drawer, in comment '(.*)', I hover on Like icon$")
    public void hoverOnLikeIconCommentsDrawer(String comment) {
        this.spaceSteps.hoverOnLikeIconCommentsDrawer(comment);
    }

    @When(value="^In post '(.*)', I mouse over the mentioned (.*) user$")
    public void hoverOnMentionedRandomUserInPost(String activity, String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.hoverOnMentionedUserInPost(activity, fullName);
    }

    @When(value="^In post '(.*)', I mouse over the mentioned user '(.*)'$")
    public void hoverOnMentionedUserInPost(String activity, String user) {
        this.spaceSteps.hoverOnMentionedUserInPost(activity, user);
    }

    @Then(value="^The internal link '(.*)' is opened in new tab$")
    public void internalLinkIsOpenedNewTab(String link) {
        this.spaceSteps.linkIsOpenedNewTab(link);
    }

    @Then(value="^The activity '(.*)' posted by the (.*) user in the created space is displayed with its timestamp in space stream page$")
    @And(value="^The activity '(.*)' posted by the (.*) user in the created space is displayed with its timestamp in streams page$")
    public void isActivityNamePostedByRandomUserSpaceDisplayed(String activity, String userPrefix) {
        String user = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserName"));
        String space = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.spaceSteps.isActivityNameUserSpaceDisplayed(activity, user, space);
    }

    @Then(value="^The activity '(.*)' posted by the user '(.*)' in space '(.*)' is displayed with its timestamp in activity stream$")
    @And(value="^The activity '(.*)' posted by the user '(.*)' in space '(.*)' is displayed with its timestamp in streams page$")
    public void isActivityNameUserSpaceDisplayed(String activity, String user, String space) {
        this.spaceSteps.isActivityNameUserSpaceDisplayed(activity, user, space);
    }

    @When(value="^In post '(.*)', the mentioned (.*) user is displayed$")
    public void isMentionedRandomUserDisplayedInPost(String activity, String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.isMentionedUserDisplayedInPost(activity, fullName);
    }

    @When(value="^In post '(.*)', the mentioned user '(.*)' is displayed$")
    public void isMentionedUserDisplayedInPost(String activity, String user) {
        this.spaceSteps.isMentionedUserDisplayedInPost(activity, user);
    }

    @Then(value="User Popover of the (.*) user is displayed")
    public void isRandomUserPopoverDisplayed(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.isUserPopoverDisplayed(fullName);
    }

    @Then(value="^User Popover '(.*)' is displayed$")
    public void isUserPopoverDisplayed(String user) {
        this.spaceSteps.isUserPopoverDisplayed(user);
    }

    @Then(value="^In comment '(.*)', Kudos label should be black$")
    public void kudosLabelIsBlack(String comment) {
        this.spaceSteps.kudosLabelIsBlack(comment);
    }

    @Then(value="^In comment '(.*)', Kudos label should be blue$")
    public void kudosLabelIsBlue(String comment) {
        this.spaceSteps.kudosLabelIsBlue(comment);
    }

    @When(value="^I like the activity '(.*)'$")
    @And(value="^I unlike the activity '(.*)'$")
    public void likeActivity(String activity) {
        this.spaceSteps.likeActivity(activity);
    }

    @When(value="^I like the activity comment '(.*)'$")
    @And(value="^I unlike the activity comment '(.*)'$")
    public void likeActivityComment(String activityComment) {
        this.spaceSteps.likeActivityComment(activityComment);
    }

    @When(value="^In comments drawer, Like label in comment '(.*)' should be black$")
    @And(value="^In comments drawer, in comment '(.*)', Like label should be black$")
    public void likeLabelInCommentsDrawerIsBlack(String comment) {
        this.spaceSteps.likeLabelInCommentsDrawerIsBlack(comment);
    }

    @When(value="^In comments drawer, Like label in comment '(.*)' should be blue$")
    @And(value="^In comments drawer, in comment '(.*)', Like label should be blue$")
    public void likeLabelInCommentsDrawerIsBlue(String comment) {
        this.spaceSteps.likeLabelInCommentsDrawerIsBlue(comment);
    }

    @When(value="^In comment '(.*)', Like label should be black$")
    public void likeLabelIsBlack(String comment) {
        this.spaceSteps.likeLabelIsBlack(comment);
    }

    @When(value="^In comment '(.*)', Like label should be blue$")
    public void likeLabelIsBlue(String comment) {
        this.spaceSteps.likeLabelIsBlue(comment);
    }

    @Then(value="^Link '(.*)' is opened in new tab$")
    public void linkIsOpenedNewTab(String link) {
        this.spaceSteps.linkIsOpenedNewTab(link);
    }

    @When(value="^No comments displayed in the drawer$")
    public void noCommentDisplayedInDrawer() {
        this.spaceSteps.noCommentDisplayedInDrawer();
    }

    @When(value="^I click on likers number of the activity '(.*)'$")
    public void openActivityReactionsDrawer(String activity) {
        this.spaceSteps.openActivityReactionsDrawer(activity);
    }

    @Then(value="^The activity likers number is diplayed in '(.*)'$")
    public void checkActivityReactionsNumberDisplayed(String activity) {
        this.spaceSteps.checkActivityReactionsNumberDisplayed(activity);
    }

    @And(value="^The activity likers number is not diplayed in '(.*)'$")
    public void checkActivityReactionsNumberNotDisplayed(String activity) {
        this.spaceSteps.checkActivityReactionsNumberNotDisplayed(activity);
    }

    @When(value="^I open in activity '(.*)' the Comments drawer$")
    public void openCommentsDrawer(String activity) {
        this.spacePage.openCommentsDrawer(activity);
    }

    @When(value="^I click to delete from the dropdownActivitymenu$")
    public void openDeleteActivityMenu() {
        String oldActiviyy = (String)Serenity.sessionVariableCalled((Object)ACTIVITY);
        this.spaceSteps.openDeleteActivityMenu(oldActiviyy);
    }

    @When(value="^I click on modify the activity$")
    public void openEditActivityMenu() {
        String oldActiviyy = (String)Serenity.sessionVariableCalled((Object)ACTIVITY);
        this.spaceSteps.openEditActivityMenu(oldActiviyy);
    }

    @When(value="^I click on modify the activity '(.*)'$")
    public void openEditSpecificActivityMenu(String activiyy) {
        this.spaceSteps.openEditActivityMenu(activiyy);
    }

    @Then(value="^I open the internal link '(.*)' in new tab$")
    public void openInternalLinkInNewTab(String link) {
        this.spaceSteps.openLinkInNewTab(this.currentUrlNoProtocol() + link);
    }

    @Then(value="^I open link '(.*)' in new tab$")
    public void openLinkInNewTab(String link) {
        this.spaceSteps.openLinkInNewTab(link);
    }

    @When(value="^I click on three dots button related to activity '(.*)'$")
    public void openThreeDotsActivityMenu(String activity) {
        this.spaceSteps.openThreeDotsActivityMenu(activity);
    }

    @When(value="^Pin button related to activity '(.*)' is displayed$")
    public void pinActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.pinActivityButtonIsDisplayed(activity);
    }

    @When(value="^Pin button related to activity '(.*)' is not displayed$")
    public void pinActivityButtonIsNotDisplayed(String activity) {
        this.spaceSteps.pinActivityButtonIsNotDisplayed(activity);
    }

    @Then(value="^The activity '(.*)' should be not pinned in space stream$")
    public void pinnedActivityDisappears(String activity) {
        this.spaceSteps.pinnedActivityDisappears(activity);
    }

    @When(value="^I post '(.*)' activities with prefix '(.*)'$")
    public void postManyActivities(String activityNumber, String activityPrefix) {
        this.spaceSteps.postManyActivities(activityNumber, activityPrefix);
    }

    @When(value="^I promote '(.*)' random user as a space manager$")
    public void promoteRandomUserAsSpaceManager(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_LAST_NAME));
        this.spaceSteps.promoteSpaceMemberAsManager(userLastName);
    }

    @When(value="^I promote '(.*)' as a space manager$")
    public void promoteSpaceMemberAsManager(String name) {
        this.spaceSteps.promoteSpaceMemberAsManager(name);
    }

    @When(value="^I publish the activity$")
    @And(value="^I publish the Poll$")
    public void publishActivity() {
        this.spaceSteps.publishActicity();
    }

    @And(value="I attach an image to the activity")
    public void attachImageToActivity() {
        this.spaceSteps.attachImageToActivity();
    }

    @And(value="I attach a gif image to the activity")
    public void attachGifImageToActivity() {
        this.spaceSteps.attachGifImageToActivity();
    }

    @And(value="the crop zone should be blurred")
    public void checkCropDrawerBlurredZone() {
        this.spaceSteps.checkCropDrawerBlurredZone();
    }

    @And(value="I attach an image to the kudos")
    public void attachImageToKudos() {
        this.spaceSteps.attachImageToKudos();
    }

    @And(value="I attach an image to the activity comment")
    public void attachImageToActivityComment() {
        this.spaceSteps.attachImageToActivityComment();
    }

    @When(value="^I publish the activity stream in arabic language$")
    public void publishActivityInArabicLanguage() {
        this.spaceSteps.publishActivityInArabicLanguage();
    }

    @When(value="^I publish the comment$")
    public void publishComment() {
        this.spaceSteps.publishComment();
    }

    @When(value="^(.*) User is mentioned in the comment$")
    public void randomUserIsMentionedInCommentEntered(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix.toLowerCase() + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix.toLowerCase() + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.userIsMentionedInCommentEntered(fullName);
    }

    @When(value="^(.*) User is not mentioned in the comment$")
    public void randomUserIsNotMentionedInCommentEntered(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix.toLowerCase() + USER_FIRST_NAME));
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix.toLowerCase() + USER_LAST_NAME));
        String fullName = userFirstName + " " + userLastName;
        this.spaceSteps.userIsNotMentionedInCommentEntered(fullName);
    }

    @Then(value="^'(.*)' kudos are displayed on the reaction drawer$")
    public void receivedKudosOnDrawerIsDisplayed(String kudosNumber) {
        this.spaceSteps.receivedKudosDrawerIsDisplayed(kudosNumber);
    }

    @And(value="^I click on Yes button$")
    public void removeactivity() {
        this.spaceSteps.deleteactivity();
    }

    @When(value="^The reply '(.*)' is not displayed in the drawer$")
    public void replyInDrawerIsNotDisplayed(String reply) {
        this.spaceSteps.replyInDrawerIsNotDisplayed(reply);
    }

    @When(value="^In comment '(.*)', the reply '(.*)' is displayed in the drawer$")
    public void replyIsDisplayedInCommentsDrawer(String comment, String reply) {
        this.spaceSteps.replyIsDisplayedInCommentsDrawer(comment, reply);
    }

    @When(value="^In comment '(.*)', the reply '(.*)' is not displayed in the drawer$")
    public void replyIsNotDisplayedInCommentsDrawer(String comment, String reply) {
        this.spaceSteps.replyIsNotDisplayedInCommentsDrawer(comment, reply);
    }

    @Then(value="^In reply '(.*)', Kudos label should be black$")
    public void replyKudosLabelIsBlack(String comment) {
        this.spaceSteps.replyKudosLabelIsBlack(comment);
    }

    @Then(value="^In reply '(.*)', Kudos label should be blue$")
    public void replyKudosLabelIsBlue(String comment) {
        this.spaceSteps.replykudosLabelIsBlue(comment);
    }

    @When(value="^I click on filter icon from composer$")
    public void clickFilterIconFromComposer() {
        this.spaceSteps.clickFilterIconFromComposer();
    }

    @Then(value="^I click on '(.*)' activity filter radio button$")
    public void selectActivityFilter(String filter) {
        this.spaceSteps.selectActivityFilter(filter);
    }

    @Then(value="^the stream filter is selected$")
    public void filterIsSelected() {
        this.spaceSteps.filterIsSelected();
    }

    @Then(value="^the stream filter isn't selected$")
    public void filterIsntSelected() {
        this.spaceSteps.filterIsntSelected();
    }

    @When(value="^Tooltip Like on '(.*)' is displayed in comments drawer$")
    @And(value="^Tooltip Remove Like on '(.*)' is displayed in comments drawer$")
    public void tooltipCommentsDrawerIsDisplayed(String comment) {
        this.spaceSteps.tooltipCommentsDrawerIsDisplayed(comment);
    }

    @When(value="^Unpin button related to activity '(.*)' is displayed$")
    public void unPinActivityButtonIsDisplayed(String activity) {
        this.spaceSteps.unPinActivityButtonIsDisplayed(activity);
    }

    @When(value="^I click on update comment$")
    public void updateComment() {
        this.spaceSteps.updateComment();
    }

    @When(value="^I update comment with a new one '(.*)'$")
    public void updateCommentText(String comment) {
        this.spaceSteps.updateCommentText(comment);
    }

    @Then(value="^I click on View All replies related to the comment '(.*)' in activity stream$")
    public void viewAllRepliesInActivityStream(String comment) {
        this.spaceSteps.viewAllRepliesInActivityStream(comment);
    }

    @Then(value="^I click on View All replies related to the comment '(.*)'$")
    public void viewAllRepliesInCommentsDrawer(String comment) {
        this.spaceSteps.viewAllRepliesInCommentsDrawer(comment);
    }

    private String currentUrlNoProtocol() {
        return this.spacePage.getCurrentUrl().replace("https://", "").replace("http://", "").replace("www.", "");
    }

    @Then(value="^The attached images should be displayed in the published activity '(.*)'$")
    public void checkActivityAttachedImages(String activity) {
        this.spaceSteps.checkActivityAttachedImages(activity);
    }

    @And(value="^The second attached image should be displayed in the published activity '(.*)'$")
    public void checkActivitySecondAttachedImage(String activity) {
        this.spaceSteps.checkActivitySecondAttachedImage(activity);
    }

    @Then(value="^The attached images should be displayed in the activity comment '(.*)'$")
    public void checkKudosCommentAttachedImages(String comment) {
        this.spaceSteps.checkKudosCommentAttachedImages(comment);
    }

    @When(value="^I click on attached image related to activity '(.*)'$")
    public void clickPreviewAttachedImage(String activity) {
        this.spaceSteps.clickPreviewAttachedImage(activity);
    }

    @Then(value="^the preview of the attached image is displayed")
    public void previewAttachedImage() {
        this.spaceSteps.previewAttachedImage();
    }

    @And(value="^The preview arrows are not displayed")
    public void checkPreviewAttachedImageArrows() {
        this.spaceSteps.checkPreviewAttachedImageArrows();
    }

    @When(value="^I click on close icon in preview attached image")
    public void clickClosePreviewAttachedImage() {
        this.spaceSteps.clickClosePreviewAttachedImage();
    }

    @Then(value="^the preview of the attached image is not displayed")
    public void checkPreviewAttachedImageIsClosed() {
        this.spaceSteps.checkPreviewAttachedImageIsClosed();
    }

    @Then(value="^The attached images should be displayed in the activity '(.*)' drawer with the delete icon")
    public void checkActivityDrawerAttachedImagesDeleteIcon(String activity) {
        this.spaceSteps.checkActivityDrawerAttachedImagesDeleteIcon(activity);
    }

    @Then(value="^The attached images should be displayed in the activity '(.*)' drawer with the edit icon")
    public void checkActivityDrawerAttachedImagesEditIcon(String activity) {
        this.spaceSteps.checkActivityDrawerAttachedImagesEditIcon(activity);
    }

    @Then(value="^I click on delete an attached image")
    public void clickDeleteAttachment() {
        this.spaceSteps.clickDeleteAttachment();
    }

    @Then(value="^I update the attached image")
    public void clickUpdateAttachment() {
        this.spaceSteps.clickEditAttachment();
    }

    @Then(value="^I click on edit an attached image")
    public void clickEditAttachment() {
        this.spaceSteps.clickEditAttachment();
    }

    @When(value="^I click to zoom attached image")
    public void zoomAttachedImage() {
        this.spaceSteps.zoomAttachedImage();
    }

    @When(value="^The cancel option is displayed")
    public void checkAttachedImageCropDrawerCancelOption() {
        this.spaceSteps.checkAttachedImageCropDrawerCancelOption();
    }

    @Then(value="^The attached image crop drawer displayed")
    public void checkAttachedImageCropDrawer() {
        this.spaceSteps.checkAttachedImageCropDrawer();
    }

    @Then(value="^The attached image is not displayed")
    public void checkActivityAttachImageDeleted() {
        this.spaceSteps.checkActivityAttachImageDeleted();
    }

    @Then(value="^The attached images should not be displayed in the published activity '(.*)'$")
    public void checkActivityAttachedImagesIsNotDisplayed(String activity) {
        this.spaceSteps.checkActivityAttachedImagesIsNotDisplayed(activity);
    }

    @When(value="^I open '(.*)' Section from Space Settings$")
    public void openSpaceSettingsSection(String sectionId) {
        this.spaceSteps.openSpaceSettingsSection(sectionId);
    }

    @When(value="I enable redactional settings for the space")
    public void enableRedactionalSpaceSettings() {
        this.spaceSteps.enableRedactionalSpaceSettings();
    }

    @When(value="^I add the '(.*)' user as redactor$")
    public void promoteUserAsSpaceRedactor(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        this.spaceSteps.promoteUserAsSpaceRedactor(userFirstName);
    }

    @When(value="^I open the drawer to add a '(.*)'$")
    public void openSpaceSettingsRoleDrawer(String role) {
        this.spaceSteps.openSpaceSettingsRoleDrawer(role);
    }

    @When.Whens(value={@When(value="^I promote the '(.*)' user as manager$"), @When(value="^I promote the '(.*)' user as publisher$"), @When(value="^I promote the '(.*)' user as redactor$")})
    public void addUserWithRoleInSpace(String userPrefix) {
        String userFirstName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + USER_FIRST_NAME));
        this.spaceSteps.addUserWithRoleInSpace(userFirstName);
    }
}

