/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.HomeSteps;
import io.meeds.qa.ui.steps.LoginSteps;
import io.meeds.qa.ui.steps.ManageSpaceSteps;
import io.meeds.qa.ui.steps.TasksSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class TasksStepDefinition {
    @Steps
    private HomeSteps homeSteps;
    @Steps
    private LoginSteps loginSteps;
    @Steps
    private ManageSpaceSteps manageSpaceSteps;
    @Steps
    private TasksSteps tasksSteps;

    @When(value="^I accept the invitation of the created space project$")
    public void acceptRandomSpaceProject() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.homeSteps.acceptRandomSpaceInvitation(randomSpaceName);
    }

    @When(value="^I enter four label '(.*)' '(.*)' '(.*)' '(.*)' in the project$")
    public void addFourLabelToProject(String label1, String label2, String label3, String label4) {
        this.tasksSteps.addFourLabelToProject(label1, label2, label3, label4);
    }

    @When(value="^I enter label '(.*)' in the project$")
    public void addLabelToProject(String label) {
        this.tasksSteps.addLabelToProject(label);
    }

    @When(value="^I add Label '(.*)' to task$")
    public void addLabelToTask(String label) {
        this.tasksSteps.addLabelToTask(label);
    }

    @When(value="^I add a comment '(.*)' in task$")
    public void addNewCommentInTask(String comment) {
        this.tasksSteps.addNewCommentInTask(comment);
    }

    @And(value="^I click to add a new comment$")
    public void clickToAddNewComment() {
        this.tasksSteps.clickToAddNewComment();
    }

    @And(value="^I add a Task comment '(.*)' with attached images$")
    public void addNewCommentWIthAttachedImages(String comment) {
        this.tasksSteps.addNewCommentWithAttachedImages(comment);
    }

    @When(value="^I enter a comment '(.*)' with mentioning the '(.*)' user in task$")
    public void addNewCommentInTaskWithMentioningTheFirstUserInTask(String comment, String userSuffix) {
        String user = (String)Serenity.sessionVariableCalled((Object)(userSuffix + "UserName"));
        this.tasksSteps.addNewCommentInTaskWithMentioningTheFirstUserInTask(comment, user);
    }

    @Given(value="^I create space project with the first user$")
    public void addNewRandomProjectWithFirstUser() {
        this.homeSteps.goToManageSpacesPage();
        String randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"randomSpaceName").to((Object)randomSpaceName);
        String firstUserName = (String)Serenity.sessionVariableCalled((Object)"firstUserName");
        this.manageSpaceSteps.addSpaceWithInviteUser(randomSpaceName, firstUserName);
    }

    @Given(value="^I create space project with user '(.*)'$")
    public void addNewRandomProjectWithUser(String user) {
        this.homeSteps.goToManageSpacesPage();
        String randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"randomSpaceName").to((Object)randomSpaceName);
        this.manageSpaceSteps.addSpaceWithInviteUser(randomSpaceName, user);
    }

    @When(value="^I add other comment '(.*)' in task$")
    public void addOtherCommentInTask(String comment) {
        this.tasksSteps.addOtherCommentInTask(comment);
    }

    @And(value="^I add a new project$")
    public void addProject() {
        String projectName = "projectName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"projectName").to((Object)projectName);
        this.tasksSteps.addProject(projectName);
    }

    @When(value="^I create the project '(.*)'$")
    public void addProject(String projectName) {
        this.tasksSteps.addProject(projectName);
    }

    @Then(value="^I add the project '(.*)' with the manager '(.*)' and the participant '(.*)'$")
    public void addProjectWithAManagerAndParticipant(String projectName, String manager, String participant) {
        this.tasksSteps.addProjectWithManagerAndParticipant(projectName, manager, participant);
    }

    @And(value="^I add a new project with a description$")
    public void addProjectWithDescription() {
        String projectName = "projectName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"projectName").to((Object)projectName);
        String description = "description" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"description").to((Object)description);
        this.tasksSteps.addProjectWithDescription(projectName, description);
    }

    @Then(value="^I create the project '(.*)' with the '(.*)' created user as manager$")
    public void addProjectWithFirstCreatedUserAsMangerAndParticipant(String projectName, String userSuffix) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(userSuffix + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(userSuffix + "UserLastName"));
        String fullName = firstName + " " + lastName;
        this.tasksSteps.addProjectWithFirstCreatedUserAsManger(projectName, fullName);
    }

    @Then(value="^I add the random project with first user as the manager and second user as the participant$")
    public void addProjectWithFirstUserAsManagerAndSecondUserAsParticipant() {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String firstUserFullName = firstUserFirstName + " " + firstUserLastName;
        String secondUserFirstName = (String)Serenity.sessionVariableCalled((Object)"secondUserFirstName");
        String secondUserLastName = (String)Serenity.sessionVariableCalled((Object)"secondUserLastName");
        String secondUserFullName = secondUserFirstName + " " + secondUserLastName;
        String randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"randomSpaceName").to((Object)randomSpaceName);
        this.tasksSteps.addProjectWithManagerAndParticipant(randomSpaceName, firstUserFullName, secondUserFullName);
    }

    @Then(value="^I add the random project with first user as the participant$")
    public void addProjectWithFirstUserAsParticipant() {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String firstUserFullName = firstUserFirstName + " " + firstUserLastName;
        String randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"randomSpaceName").to((Object)randomSpaceName);
        this.tasksSteps.addProjectWithFirstUserAsParticipant(randomSpaceName, firstUserFullName);
    }

    @Then(value="^I create the project '(.*)' with the manager '(.*)'$")
    public void addProjectWithManager(String projectName, String fullName) {
        this.tasksSteps.addProjectWithManager(projectName, fullName);
    }

    @Then(value="^I create the random project with the (.*) created user as participant$")
    public void addRandomProjectWithRandomParticipant(String userPrefix) {
        Object randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        if (StringUtils.isBlank((CharSequence)randomSpaceName)) {
            randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
            Serenity.setSessionVariable((Object)"randomSpaceName").to(randomSpaceName);
        }
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.tasksSteps.addProjectWithParticipant((String)randomSpaceName, userLastName);
    }

    @Then(value="^I add (.*) user as the participant in the project$")
    public void addSecondUserToProject(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.tasksSteps.addSecondUserToProject(userLastName);
    }

    @When(value="^I enter six label '(.*)' '(.*)' '(.*)' '(.*)' '(.*)' '(.*)' in the project$")
    public void addSixLabelToProject(String label1, String label2, String label3, String label4, String label5, String label6) {
        this.tasksSteps.addSixLabelToProject(label1, label2, label3, label4, label5, label6);
    }

    @Given(value="I create the following task in selected project")
    @And(value="I create the following task")
    public void addTaskInProject(Map<String, String> taskDetails) {
        this.tasksSteps.addTaskInProject(taskDetails);
    }

    @And(value="I create a random quick task in the random project")
    public void addTaskInSimpleProject(Map<String, String> userDetails) {
        this.tasksSteps.addSimpleTaskProject(userDetails);
    }

    @Given(value="^The following task with label '(.*)' is created in the specific project$")
    public void addTaskWithLabelInProject(String label, Map<String, String> userDetails) {
        this.tasksSteps.addTaskWithLabelInProject(label, userDetails);
    }

    @And(value="^I assign task to me$")
    public void assignTaskToMe() {
        this.tasksSteps.assignTaskToMe();
    }

    @And(value="^I assign task to the first user$")
    public void assignTaskToTheFirstUser() {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        this.tasksSteps.assignTaskToUser(firstUserFirstName);
    }

    @When(value="^Board view is displayed by default$")
    public void boardViewIsDisplayedByDefault() {
        this.tasksSteps.boardViewIsDisplayedByDefault();
    }

    @When(value="^Cancel button is displayed in the Filter drawer$")
    public void cancelFilterButtonIsDisplayed() {
        this.tasksSteps.cancelFilterButtonIsDisplayed();
    }

    @Then(value="^The random created project with description '(.*)' is displayed in Project Card$")
    public void checkCreatedTasksProjectNameIsDisplayedInProjectCard(String projectDescription) {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.checkProjectNameIsDisplayedInProjectCard(randomSpaceName, projectDescription);
    }

    @Then(value="^The random created project is Not displayed in Project Card$")
    public void checkCreatedTasksProjectNameIsNotDisplayedInProjectCard() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.checkProjectNotDisplayed(randomSpaceName);
    }

    @Then(value="^the project is deleted successfully from Projects tab$")
    public void checkDeletedProject() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"projectName");
        this.tasksSteps.checkDeletedProject(projectName);
    }

    @Then(value="^Status '(.*)' is deleted successfully$")
    public void checkDeletedStatus(String statusColumn) {
        this.tasksSteps.checkDeletedStatus(statusColumn);
    }

    @Then(value="^Task '(.*)' is deleted successfully$")
    public void checkDeletedTask(String taskName) {
        this.tasksSteps.checkDeletedTask(taskName);
    }

    @When(value="^The description in the task '(.*)' is displayed$")
    @And(value="^The edit description in the task '(.*)' is displayed$")
    public void checkDescriptionDisplay(String description) {
        this.tasksSteps.checkDescriptionDisplay(description);
    }

    @Then(value="^The placeholder Filter by project should be displayed$")
    public void checkDisplayOfFilterByProject() {
        this.tasksSteps.checkDisplayOfFilterByProject();
    }

    @Then(value="^The placeholder Filter by task should be displayed$")
    public void checkDisplayOfFilterByTask() {
        this.tasksSteps.checkDisplayOfFilterByTask();
    }

    @And(value="^Status column '(.*)' is moved to the first position$")
    @Then(value="^Status column '(.*)' is displayed in the first position$")
    public void checkFirstStatusColumn(String columnStatus) {
        this.tasksSteps.checkFirstStatusColumn(columnStatus);
    }

    @Then(value="^I check that grouping '(.*)' is selected$")
    public void checkGroupingSelected(String groupingValue) {
        this.tasksSteps.checkGroupingSelected(groupingValue);
    }

    @And(value="^Status column '(.*)' is moved to the last position$")
    @Then(value="^Status column '(.*)' is displayed in the last position$")
    public void checkLastStatusColumn(String columnStatus) {
        this.tasksSteps.checkLastStatusColumn(columnStatus);
    }

    @Then(value="^Message Project Title is mandatory is displayed$")
    public void checkMessageSaveEmptyProject() {
        this.tasksSteps.checkMessageSaveEmptyProject();
    }

    @Then(value="^project is cloned successfully$")
    public void checkProjectIsCloned() {
        String randomSpaceName = "Copy of " + String.valueOf(Serenity.sessionVariableCalled((Object)"randomSpaceName"));
        this.tasksSteps.checkClonedProject(randomSpaceName);
    }

    @Then(value="the project is created successfully and displayed on Projects tab")
    public void checkProjectIsDisplayed() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.checkProjectIsDisplayed(projectName);
    }

    @Then(value="^project is edited successfully$")
    public void checkProjectIsEdited() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"newProjectName");
        String description = (String)Serenity.sessionVariableCalled((Object)"newDescription");
        this.tasksSteps.checkEditedProject(projectName, description);
    }

    @Then(value="^The project '(.*)' is not displayed in Projects tab$")
    public void checkProjectIsNotDisplayed(String projectName) {
        this.tasksSteps.checkProjectNotDisplayed(projectName);
    }

    @Then(value="^The random project is not displayed in Projects tab$")
    public void checkRandomProjectIsNotDisplayed() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.checkProjectNotDisplayed(projectName);
    }

    @Then(value="^Project name '(.*)' with description '(.*)' is displayed in Project Card$")
    public void checkProjectNameIsDisplayedInProjectCard(String projectName, String projectDescription) {
        this.tasksSteps.checkProjectNameIsDisplayedInProjectCard(projectName, projectDescription);
    }

    @And(value="^Status column '(.*)' is moved to the second position$")
    @Then(value="^Status column '(.*)' is displayed in the second position$")
    public void checkSecondStatusColumn(String columnStatus) {
        this.tasksSteps.checkSecondStatusColumn(columnStatus);
    }

    @Then(value="^Task status '(.*)' is modified successfully$")
    public void checkTaskCardStatus(String taskStatus) {
        this.tasksSteps.checkTaskStatus(taskStatus);
    }

    @Then(value="^task '(.*)' is cloned successfully$")
    public void checkTaskIsCloned(String taskName) {
        this.tasksSteps.checkClonedTask(taskName);
    }

    @And(value="^Task priority '(.*)' is modified successfully$")
    public void checkTaskPriority(String taskPriority) {
        this.tasksSteps.checkTaskPriority(taskPriority);
    }

    @Then(value="^I check that a new second level drawer Changes is opened$")
    public void checkThatSecondLevelDrawerChangesIsOpened() {
        this.tasksSteps.checkThatSecondLevelDrawerChangesIsOpened();
    }

    @Then(value="^I check that tasks are grouped by Assignee$")
    public void checkThatTasksAreGroupedByAssignee() {
        this.tasksSteps.checkThatTasksAreGroupedByAssignee();
    }

    @And(value="^I check the timestamp update just below Task title Last Update$")
    public void checkTheTimestampUpdate() {
        this.tasksSteps.checkTheTimestampUpdate();
    }

    @And(value="^Status column '(.*)' is moved to the third position$")
    @Then(value="^Status column '(.*)' is displayed in the third position$")
    public void checkThirdStatusColumn(String columnStatus) {
        this.tasksSteps.checkThirdStatusColumn(columnStatus);
    }

    @Then(value="^I check a tooltip is displayed Click to view all changes$")
    public void checkTooltipIsDisplayed() {
        this.tasksSteps.checkTooltipIsDisplayed();
    }

    @Then(value="^The typed project '(.*)' is removed from the Filter by project field$")
    public void checkTypedProjectIsRemoved(String typedProject) {
        this.tasksSteps.checkTypedProjectIsRemoved(typedProject);
    }

    @Then(value="^The typed task '(.*)' is removed from Filter by task field$")
    public void checkTypedTaskIsRemoved(String typedTask) {
        this.tasksSteps.checkTypedTaskIsRemoved(typedTask);
    }

    @When(value="^The update description '(.*)' is displayed in origin task$")
    @Then(value="^The update description '(.*)' is displayed in cloned task$")
    public void checkUpdatedDescription(String description) {
        this.tasksSteps.checkUpdatedDescription(description);
    }

    @Then(value="^The label View all attachments is displayed$")
    public void checkViewLinkAttachments() {
        this.tasksSteps.checkViewLinkAttachments();
    }

    @And(value="^The clear button is disappeared from Filter by task field$")
    public void clearButtonInFilterByTaskIsNotVisible() {
        this.tasksSteps.clearButtonInFilterByTaskIsNotVisible();
    }

    @And(value="^A clear button is displayed in the Filter by task field$")
    public void clearButtonInFilterByTaskIsVisible() {
        this.tasksSteps.clearButtonInFilterByTaskIsVisible();
    }

    @And(value="^The clear button is disappeared from the Filter by project field$")
    public void clearButtonIsNotVisible() {
        this.tasksSteps.clearButtonIsNotVisible();
    }

    @And(value="^A clear button is displayed in the search field$")
    public void clearButtonIsVisible() {
        this.tasksSteps.clearButtonIsVisible();
    }

    @When(value="^I click on Add new comment button$")
    public void clickAddNewComment() {
        this.tasksSteps.clickAddNewComment();
    }

    @When(value="^I click to add new project$")
    public void clickAddProjectButton() {
        this.tasksSteps.clickAddProjectButton();
    }

    @When(value="^I click on save new task button$")
    public void clickSaveTaskButton() {
        this.tasksSteps.clickSaveTaskButton();
    }

    @When(value="^I set task name '(.*)'$")
    public void clickAddTaskButton(String taskName) {
        this.tasksSteps.setTaskName(taskName);
    }

    @When(value="^I click on add new task button$")
    public void clickAddTaskButton() {
        this.tasksSteps.clickAddTaskButton();
    }

    @When(value="^I click on (add project|add tasks) button$")
    public void clickAddProjectButton(String buttonName) {
        this.tasksSteps.clickAddProjectButton();
    }

    @When(value="^I click on cancel to not confirm project deletion$")
    public void clickCancel() {
        this.tasksSteps.clickCancel();
    }

    @When(value="^I click on delete to confirm project deletion$")
    public void clickDelete() {
        this.tasksSteps.clickDelete();
    }

    @When(value="^I click on delete project button$")
    public void clickDeleteProjectButton() {
        this.tasksSteps.clickDeleteProjectButton();
    }

    @When(value="^I click on document button$")
    public void clickDocButton() {
        this.tasksSteps.clickDocButton();
    }

    @And(value="^I click on Add Status After option of the fifth status column$")
    public void clickOnAddStatusAfterOptionOfTheFifthStatusColumn() {
        this.tasksSteps.clickOnAddStatusAfterOptionOfTheFifthStatusColumn();
    }

    @And(value="^I click on Add Status Before option$")
    public void clickOnAddStatusBeforeOption() {
        this.tasksSteps.clickOnAddStatusBeforeOption();
    }

    @And(value="^I click on Assignee radio button$")
    public void clickOnAssigneeRadioButton() {
        this.tasksSteps.clickOnAssigneeRadioButton();
    }

    @When(value="^I click on clear button$")
    public void clickOnClearButton() {
        this.tasksSteps.clickOnClearButton();
    }

    @When(value="^I click on clear button in the Filter by task field$")
    public void clickOnClearButtonInFilterByTask() {
        this.tasksSteps.clickOnClearButtonInFilterByTask();
    }

    @When(value="^I click on reply button related to comment '(.*)'$")
    public void clickOnCommentReply(String comment) {
        this.tasksSteps.clickOnCommentReply(comment);
    }

    @And(value="^I click on Confirm filter button$")
    public void clickOnConfirmButton() {
        this.tasksSteps.clickOnConfirmButton();
    }

    @And(value="^I click on Delete option$")
    public void clickOnDeleteStatusIcon() {
        this.tasksSteps.clickOnDeleteStatusIcon();
    }

    @When(value="^I click on task delete option$")
    public void clickOnDeleteTaskoption() {
        this.tasksSteps.clickOnDeleteTaskOption();
    }

    @When(value="^I click on Edit project button$")
    public void clickOnEditProjectButton() {
        this.tasksSteps.clickOnEditProjectButton();
    }

    @And(value="^I click on Filter button$")
    public void clickOnFilterButton() {
        this.tasksSteps.clickFilterButton();
    }

    @And(value="^I click on Move Status column after option$")
    public void clickOnMoveStatusAfterIcon() {
        this.tasksSteps.clickOnMoveStatusAfterIcon();
    }

    @And(value="^I click on Move Status column before option$")
    public void clickOnMoveStatusBeforeIcon() {
        this.tasksSteps.clickOnMoveStatusBeforeIcon();
    }

    @And(value="^I click on plus Button To Add Task$")
    public void clickOnPlusButtonToAddTask() {
        this.tasksSteps.clickOnPlusButtonToAddTask();
    }

    @And(value="^I click on plus Button To Add Task of the sixth status column$")
    public void clickOnPlusButtonToAddTaskOfTheSixthStatusColumn() {
        this.tasksSteps.clickOnPlusButtonToAddTaskOfTheSixthStatusColumn();
    }

    @When(value="^I click on three dots project button$")
    public void clickOnProjectThreeDotsButton() {
        this.tasksSteps.clickOnProjectThreeDotsButton();
    }

    @And(value="^I click on save Button To Add Task$")
    public void clickOnSaveButtonToAddTask() {
        this.tasksSteps.clickOnSaveButtonToAddTask();
    }

    @And(value="^I click on apply Button To Add description$")
    public void clickOnApplyButtonToSaveDescription() {
        this.tasksSteps.clickOnApplyButtonToSaveDescription();
    }

    @And(value="^The attached image is displayed in the task description$")
    public void checkAttachedImagesToTaskDescription() {
        this.tasksSteps.checkAttachedImagesToTaskDescription();
    }

    @Then(value="^The attached images are displayed in the task comment$")
    public void checkAttachedImagesToTaskComment() {
        this.tasksSteps.checkAttachedImagesToTaskComment();
    }

    @And(value="^I click to edit task description$")
    public void openTaskDescriptionEditor() {
        this.tasksSteps.openTaskDescriptionEditor();
    }

    @And(value="^I attach image to the task description$")
    public void attachImageToTaskDescription() {
        this.tasksSteps.attachImageToTaskDescription();
    }

    @And(value="^I attach a second image to the task description$")
    public void attachSecondImageToTaskDescription() {
        this.tasksSteps.attachSecondImageToTaskDescription();
    }

    @And(value="^I click outside the task description$")
    public void clickOutsideTaskDescription() {
        this.tasksSteps.clickOutsideTaskDescription();
    }

    @And(value="^The new attached image is not displayed$")
    public void checkTaskDescriptionNewAttachImage() {
        this.tasksSteps.checkTaskDescriptionNewAttachImage();
    }

    @And(value="^I click on save Button To Add Task in space project$")
    public void clickOnSaveButtonToAddTaskSpaceProject() {
        this.tasksSteps.clickOnSaveButtonToAddTaskSpaceProject();
    }

    @When(value="^I click on three dots task option$")
    public void clickOnTaskThreeDotsOption() {
        this.tasksSteps.clickOnTaskThreeDotsOption();
    }

    @When(value="^I click on the notification that mention third user in a task in Project '(.*)' project$")
    public void clickOnTheNotificationThatMentioneFirstUserInATaskInProject(String projectName) {
        this.tasksSteps.clickOnTheNotificationThatMentionThirdUserInATaskInProject("mentioned", projectName);
    }

    @When(value="^I click on the timestamp$")
    public void clickOnTheTimestamp() {
        this.tasksSteps.clickOnTheTimestamp();
    }

    @And(value="^I click on three dots icon of the first status column$")
    public void clickOnThreeDotsIcon() {
        this.tasksSteps.clickOnThreeDotsIcon();
    }

    @And(value="^I click on three dots icon of the fifth status column$")
    public void clickOnThreeDotsIconOfFifthColumn() {
        this.tasksSteps.clickOnFifthColumnThreeDotsIcon();
    }

    @And(value="^I click on three dots icon of the last status column$")
    public void clickOnThreeDotsIconOfLastColumn() {
        this.tasksSteps.clickOnLastColumnThreeDotsIcon();
    }

    @When(value="^I click on update button$")
    public void clickOnUpDateButton() {
        this.tasksSteps.clickOnUpDateButton();
    }

    @And(value="^I click on Validate Name$")
    public void clickOnValidateStatusName() {
        this.tasksSteps.clickOnValidateStatusName();
    }

    @And(value="^I click on plus icon from attachments list drawer$")
    public void clickPlusIcon() {
        this.tasksSteps.clickPlusIcon();
    }

    @And(value="^I click on plus icon from attachments list drawer in simple project$")
    public void clickPlusIconProject() {
        this.tasksSteps.clickPlusIconProject();
    }

    @And(value="I click on save project button")
    public void clickSaveProjectButton() {
        this.tasksSteps.clickSaveProjectButton();
    }

    @When(value="^I click on Status name '(.*)'$")
    public void clickStatusName(String statusColumn) {
        this.tasksSteps.clickStatusName(statusColumn);
    }

    @And(value="^I click on View all attachments link$")
    public void clickViewAttachmentLink() {
        this.tasksSteps.clickViewAttachmentLink();
    }

    @And(value="^I clone the project$")
    public void cloneProject() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.cloneProject(randomSpaceName);
    }

    @And(value="^Clone project button is displayed$")
    public void cloneProjectButtonIsDisplayed() {
        this.tasksSteps.cloneProjectButtonIsDisplayed();
    }

    @When(value="^I clone Task in space project$")
    public void clonetaskinspaceproject() {
        this.tasksSteps.clonetaskinspaceproject();
    }

    @And(value="^Color Palette is displayed$")
    public void colorPaletteIsDisplayed() {
        this.tasksSteps.colorPaletteIsDisplayed();
    }

    @When(value="^Comment button is disabled$")
    public void commentButtonIsDisabled() {
        this.tasksSteps.commentButtonIsDisabled();
    }

    @When(value="^Comments drawer is displayed$")
    public void commentsDrawerIsDisplayed() {
        this.tasksSteps.commentsDrawerIsDisplayed();
    }

    @When(value="^(.*) user with the task comment '(.*)' is displayed in task comments drawer$")
    public void commentTaskWithRandomUser(String suffix, String comment) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)(suffix.toLowerCase() + "UserFirstName"));
        String lastName = (String)Serenity.sessionVariableCalled((Object)(suffix.toLowerCase() + "UserLastName"));
        String fullName = firstName + " " + lastName;
        this.tasksSteps.commentTaskWithUser(fullName, comment);
    }

    @Then(value="^I mark the task as completed$")
    public void completeTask() {
        this.tasksSteps.completeTask();
    }

    @And(value="^I confirm the deletion message$")
    public void confirmDeleteStatusColumn() {
        this.tasksSteps.confirmDeleteStatusColumn();
    }

    @And(value="^I confirm deletion Task message$")
    public void confirmDeleteTask() {
        this.tasksSteps.confirmDeleteTask();
    }

    @When(value="^I click on Confirm button$")
    public void confirmFilter() {
        this.tasksSteps.confirmFilter();
    }

    @When(value="^Confirm button is displayed in the Filter drawer$")
    public void confirmFilterButtonIsDisplayed() {
        this.tasksSteps.confirmFilterButtonIsDisplayed();
    }

    @And(value="^I clear browsing data cache and cookies$")
    public void deleteCookies() {
        this.loginSteps.deleteCookies();
    }

    @And(value="^I delete the added project$")
    public void deleteProject() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"projectName");
        this.tasksSteps.deleteProject(projectName);
    }

    @And(value="^Delete project button is displayed$")
    public void deleteProjectButtonIsDisplayed() {
        this.tasksSteps.deleteProjectButtonIsDisplayed();
    }

    @Then(value="^Delete task option is displayed$")
    public void deleteTaskOptionIsDisplayed() {
        this.tasksSteps.deleteTaskOptionIsDisplayed();
    }

    @And(value="^I edit description of the task '(.*)'$")
    public void editDescriptionForTask(String newDescription) {
        this.tasksSteps.editDescriptionForTask(newDescription);
    }

    @And(value="^Edit project button is displayed$")
    public void editProjectButtonIsDisplayed() {
        this.tasksSteps.editProjectButtonIsDisplayed();
    }

    @When(value="^I edit this project title '(.*)'$")
    public void editProjectName(String projectName) {
        this.tasksSteps.editProjectName(projectName);
    }

    @And(value="^I edit project name and description of added project$")
    public void editProjectNameWithDescription() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"projectName");
        String newProjectName = "projectName" + Utils.getRandomNumber();
        String newDescription = "projectDescription" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"newProjectName").to((Object)newProjectName);
        Serenity.setSessionVariable((Object)"newDescription").to((Object)newDescription);
        this.tasksSteps.editProjectNameWithDescription(projectName, newProjectName, newDescription);
    }

    @When(value="^I edit the created project title$")
    public void editRandomProjectName() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.editProjectName(randomSpaceName);
    }

    @When(value="^I edit the old Space Name with a new random Space Name$")
    public void editSpaceName() {
        String randomSpaceName = "randomSpaceName" + Utils.getRandomNumber();
        Serenity.setSessionVariable((Object)"randomSpaceName").to((Object)randomSpaceName);
        this.tasksSteps.editSpaceName(randomSpaceName);
    }

    @When(value="^Edit task drawer is displayed$")
    public void editTaskDrawerIsDisplayed() {
        this.tasksSteps.editTaskDrawerIsDisplayed();
    }

    @When(value="^I enter a comment with more than 1250 characters$")
    @And(value="^I enter a reply with more than 1250 characters$")
    public void enterCommentMore1250Chars() {
        String comment = StringUtils.repeat((String)"tasks", (int)251);
        this.tasksSteps.enterTaskComment(comment);
    }

    @And(value="^I enter a comment '(.*)'$")
    public void enterComment(String comment) {
        this.tasksSteps.enterTaskComment(comment);
    }

    @When(value="^I enter description for task '(.*)'$")
    public void enterDescriptionForTask(String description) {
        this.tasksSteps.enterDescriptionForTask(description);
    }

    @And(value="^I enter the project description '(.*)' without a project title$")
    public void enterProjectDescriptionWithoutTheTitle(String description) {
        this.tasksSteps.enterProjectDescriptionWithoutTheTitle(description);
    }

    @And(value="^I enter the project title '(.*)' with a description '(.*)'$")
    public void enterProjectTitleAndDescription(String projectName, String description) {
        this.tasksSteps.enterProjectTitleAndDescription(projectName, description);
    }

    @When(value="^I Type a Status name '(.*)'$")
    public void enterStatusText(String status) {
        this.tasksSteps.enterStatusText(status);
    }

    @When(value="^I enter title for task '(.*)'$")
    public void enterTitleForTask(String title) {
        this.tasksSteps.enterTitleForTask(title);
    }

    @Then(value="^I exit from project$")
    public void exitFromTheFirstProject() {
        this.tasksSteps.exitFromTheFirstProject();
    }

    @Then(value="^Avatar of the first created user is not displayed in Project Card$")
    public void firstRandomUserAvatarIsDisplayedInProjectCard() {
        String firstUserName = (String)Serenity.sessionVariableCalled((Object)"firstUserName");
        this.tasksSteps.userAvatarIsNotDisplayedInProjectCard(firstUserName);
    }

    @When(value="^I go back to edit task drawer$")
    public void goBack() {
        this.tasksSteps.goBack();
    }

    @When(value="^I go to Filter Tab$")
    public void goToFilterTab() {
        this.tasksSteps.goToFilterTab();
    }

    @When(value="^I go to Group And Sort Tab$")
    public void goToGroupAndSortTab() {
        this.tasksSteps.goToGroupAndSortTab();
    }

    @When(value="^I go to Labels Tab$")
    public void goToLabelsTab() {
        this.tasksSteps.goToLabelsTab();
    }

    @And(value="^I go to the PLAN view$")
    public void goToPLanView() {
        this.tasksSteps.goToPLanView();
    }

    @When(value="^I go to project details list$")
    public void goToProjectDetailsList() {
        this.tasksSteps.goToProjectDetailsList();
    }

    @When(value="I select projects tab")
    public void goToProjectsTab() {
        this.tasksSteps.goToProjectsTab();
    }

    @When(value="I select tasks tab")
    public void goToTasksTab() {
        this.tasksSteps.goToTasksTab();
    }

    @When(value="^Next to max chars number a green information icon is displayed$")
    public void greenInformationIconIsDisplayed() {
        this.tasksSteps.greenInformationIconIsDisplayed();
    }

    @When(value="^I hover on project manager icon$")
    public void hoverOnProjectManagerIcon() {
        this.tasksSteps.hoverOnProjectManagerIcon();
    }

    @When(value="^I hover on task's title '(.*)'$")
    public void hoverOnTaskName(String task) {
        this.tasksSteps.hoverOnTaskName(task);
    }

    @When(value="^I hover on the Changes timestamp$")
    public void hoverOnTheChangesTimestamp() {
        this.tasksSteps.hoverOnTheChangesTimestamp();
    }

    @When(value="^'(.*)' Tab is displayed$")
    public void isFilterDrawerTabDisplayed(String tab) {
        this.tasksSteps.isFilterDrawerTabDisplayed(tab);
    }

    @When(value="^The label '(.*)' is displayed '(.*)' times in project details$")
    @And(value="^In Section '(.*)', '(.*)' tasks are displayed$")
    @Then(value="^In Section '(.*)', '(.*)' task is displayed$")
    public void isLabelDisplayedInProjectDetails(String label, String times) {
        this.tasksSteps.isLabelDisplayedInProjectDetails(label, times);
    }

    @Then(value="^The searched task '(.*)' is displayed$")
    public void isSearchedTaskDisplayed(String taskName) {
        this.tasksSteps.isSearchedTaskDisplayed(taskName);
    }

    @When(value="^Status name '(.*)' Edit mode is opened successfully$")
    public void isStatusEditModeDisplayed(String statusColumn) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tasksSteps.isStatusEditModeDisplayed(statusColumn)).as("Status edit mode is opened successfully", new Object[0])).isTrue();
    }

    @When(value="^Status name '(.*)' Edit mode is not opened successfully$")
    public void isStatusEditModeNotDisplayed(String statusColumn) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tasksSteps.isStatusEditModeDisplayed(statusColumn)).as("Status edit mode is opened successfully", new Object[0])).isFalse();
    }

    @When(value="^Label '(.*)' is displayed in edit project drawer$")
    public void labelIsDisplayedInProjectDrawer(String label) {
        this.tasksSteps.labelIsDisplayedInProjectDrawer(label);
    }

    @When(value="^Label '(.*)' is displayed in edit task drawer and x icon is not displayed$")
    public void labelIsDisplayedInTaskDrawer(String label) {
        this.tasksSteps.labelIsDisplayedInTaskDrawer(label);
    }

    @When(value="^Label '(.*)' is Not displayed in edit project drawer$")
    public void labelIsNotDisplayedInProjectDrawer(String label) {
        this.tasksSteps.labelIsNotDisplayedInProjectDrawer(label);
    }

    @And(value="^I mark the task as completed from the task card$")
    public void markTaskAsCompletedFromTaskCard() {
        this.tasksSteps.markTaskAsCompletedFromTaskCard();
    }

    @When(value="^I mark the task '(.*)' as completed in project details$")
    public void markTaskAsCompletedInProjectDetails(String taskName) {
        this.tasksSteps.markTaskAsCompletedInProjectDetails(taskName);
    }

    @When(value="^The max chars number is 1250$")
    public void maxCharsCount1250InformationIsDisplayed() {
        this.tasksSteps.maxCharsCount1250InformationIsDisplayed();
    }

    @When(value="^Message : Please don't exceed 1250 characters, is displayed$")
    public void maxCharsNumberMessageIsDisplayed() {
        this.tasksSteps.maxCharsNumberMessageIsDisplayed();
    }

    @When(value="^The max chars number has been exceeded and it is displayed in red$")
    public void more1250CharsInformationIsDisplayed() {
        this.tasksSteps.more1250CharsInformationIsDisplayed();
    }

    @And(value="^I check that Move Status column after option is not displayed$")
    public void moveStatusAfterIconIsNotDisplayed() {
        this.tasksSteps.checkMoveStatusAfterIconIsNotDisplayed();
    }

    @And(value="^I check that Move Status column before option is not displayed$")
    public void moveStatusBeforeIconIsNotDisplayed() {
        this.tasksSteps.checkMoveStatusBeforeIconIsNotDisplayed();
    }

    @And(value="^I open the cloned project$")
    public void openClonedProject() {
        String randomSpaceName = "Copy of " + String.valueOf(Serenity.sessionVariableCalled((Object)"randomSpaceName"));
        this.tasksSteps.openProject(randomSpaceName);
    }

    @When(value="^I open the Filter drawer$")
    public void openFilterDrawer() {
        this.tasksSteps.openFilterDrawer();
    }

    @And(value="^I open the added project$")
    public void openProject() {
        String projectName = (String)Serenity.sessionVariableCalled((Object)"projectName");
        this.tasksSteps.openProject(projectName);
    }

    @When(value="^I open the project '(.*)'$")
    public void openProject(String project) {
        this.tasksSteps.openProject(project);
    }

    @And(value="^I open the created project$")
    public void openRandomProject() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.openProject(randomSpaceName);
    }

    @And(value="^I open the task '(.*)'$")
    public void openTaskCard(String task) {
        this.tasksSteps.openTaskCard(task);
    }

    @When(value="^I open the created task '(.*)'$")
    public void openTaskCreated(String taskName) {
        this.tasksSteps.openTaskCreated(taskName);
    }

    @When(value="^In Tasks tab, I open the task '(.*)'$")
    public void openTaskInTasksTab(String taskName) {
        this.tasksSteps.openTaskInTasksTab(taskName);
    }

    @Given(value="^The project drawer is not closing$")
    public void projectDrawerNotClosing() {
        this.tasksSteps.projectDrawerNotClosing();
    }

    @Then(value="^Project '(.*)' is displayed in Tasks App Center$")
    @And(value="^Project '(.*)' is displayed in Tasks space$")
    public void projectIsDisplayedInTasksAppCenter(String projectName) {
        this.tasksSteps.projectIsDisplayedInTasksAppCenter(projectName);
    }

    @When(value="The project name is displayed in project details")
    public void projectNameIsDisplayedInProjectDetails() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.projectNameIsDisplayedInProjectDetails(randomSpaceName);
    }

    @When(value="^The project '(.*)' is displayed in project details$")
    public void projectNameIsDisplayedInProjectDetails(String projectName) {
        this.tasksSteps.projectNameIsDisplayedInProjectDetails(projectName);
    }

    @When(value="The created project name is displayed in project details")
    public void randomProjectNameIsDisplayedInProjectDetails() {
        String randomProjectName = (String)Serenity.sessionVariableCalled((Object)"projectName");
        this.tasksSteps.projectNameIsDisplayedInProjectDetails(randomProjectName);
    }

    @Then(value="^Avatar of the first created user is displayed in Project Card$")
    public void randomUserAvatarIsDisplayedInProjectCard() {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String fullName = firstUserFirstName + " " + firstUserLastName;
        this.tasksSteps.userAvatarIsDisplayedInProjectCard(fullName);
    }

    @When(value="^Next to max chars number a red information icon is displayed$")
    public void redInformationIconIsDisplayed() {
        this.tasksSteps.redInformationIconIsDisplayed();
    }

    @When(value="^I Remove Label '(.*)' in edit project drawer$")
    public void removeLabelToProject(String label) {
        this.tasksSteps.removeLabelToProject(label);
    }

    @When(value="^Reply button is disabled$")
    public void replyTaskCommentButtonIsDisabled() {
        this.tasksSteps.replyTaskCommentButtonIsDisabled();
    }

    @When(value="^Reset button is displayed in the Filter drawer$")
    public void resetFilterButtonIsDisplayed() {
        this.tasksSteps.resetFilterButtonIsDisplayed();
    }

    @And(value="^I return to Projects tab$")
    public void returnToProjectsTab() {
        this.tasksSteps.returnToProjectsTab();
    }

    @And(value="I save the addition of the new project")
    public void saveAddingProject() {
        this.tasksSteps.saveAddingProject();
    }

    @Then(value="^I start the search for Task '(.*)'$")
    public void searchTask(String taskName) {
        this.tasksSteps.searchTask(taskName);
    }

    @Then(value="^Avatar of the second created user is not displayed in Project Card$")
    public void secondRandomUserAvatarIsDisplayedInProjectCard() {
        String secondUserName = (String)Serenity.sessionVariableCalled((Object)"secondUserName");
        this.tasksSteps.userAvatarIsNotDisplayedInProjectCard(secondUserName);
    }

    @When(value="^I select '(.*)' from Sort By Filter section$")
    @And(value="^I select '(.*)' from Group By Filter section$")
    public void selectFilterOption(String label) {
        this.tasksSteps.selectFilterOption(label);
    }

    @And(value="^I set task priority to '(.*)'$")
    public void selectTaskPriority(String taskPriority) {
        this.tasksSteps.setTaskPriority(taskPriority);
    }

    @When(value="^I search for the project '(.*)'$")
    public void setInSearchProjectField(String project) {
        this.tasksSteps.setInSearchProjectField(project);
    }

    @When(value="^I search for the created project '(.*)'$")
    public void setInSearchProjectNameField(String project) {
        this.tasksSteps.setInSearchProjectField(project);
    }

    @When(value="^I search for the created project$")
    public void setInSearchRandomProjectField() {
        String randomSpaceName = (String)Serenity.sessionVariableCalled((Object)"randomSpaceName");
        this.tasksSteps.setInSearchProjectField(randomSpaceName);
    }

    @When(value="^I enter the project name '(.*)'$")
    public void setProjectTitle(String projectTitle) {
        this.tasksSteps.setProjectTitle(projectTitle);
    }

    @When(value="^I mark the task as completed in task drawer$")
    public void setTaskCompletedInDrawer() {
        this.tasksSteps.setTaskCompletedInDrawer();
    }

    @When(value="^I mark the task as completed in task drawer without closing the drawer$")
    public void setTaskCompletedInDrawerWithoutClosingIt() {
        this.tasksSteps.setTaskCompletedInDrawerWithoutClosingIt();
    }

    @When(value="^I enter Description for this task '(.*)'$")
    public void setTaskDescription(String description) {
        this.tasksSteps.setTaskDescription(description);
    }

    @And(value="^I set task due date Next week$")
    public void setTaskDueDateNextWeek() {
        this.tasksSteps.setTaskDueDateNextWeek();
    }

    @And(value="^I set task due date TODAY$")
    public void setTaskDueDateToday() {
        this.tasksSteps.setTaskDueDateToday();
    }

    @And(value="^I set task due date TOMORROW$")
    public void setTaskDueDateTomorrow() {
        this.tasksSteps.setTaskDueDateTomorrow();
    }

    @And(value="^I set task start date TODAY$")
    public void setTaskStartDateToday() {
        this.tasksSteps.setTaskStartDateToday();
    }

    @And(value="^I set task start date TOMORROW$")
    public void setTaskStartDateTomorrow() {
        this.tasksSteps.setTaskStartDateTomorrow();
    }

    @And(value="^I set task status to '(.*)'$")
    public void setTaskStatus(String taskStatus) {
        this.tasksSteps.setTasksStatus(taskStatus);
    }

    @And(value="^I switch to TASKS tab$")
    public void switchToTASKSTab() {
        this.tasksSteps.switchToTASKSTab();
    }

    @When(value="^Task name '(.*)' is displayed in project details$")
    public void taskIsDisplayedInProjectDetails(String taskName) {
        this.tasksSteps.taskIsDisplayedInProjectDetails(taskName);
    }

    @When(value="^Task '(.*)' is marked as completed and displayed in Completed section$")
    public void taskIsMarkedAndDisplayedInCompletedSection(String taskName) {
        this.tasksSteps.taskIsMarkedAndDisplayedInCompletedSection(taskName);
    }

    @When(value="^Task name '(.*)' is not displayed in project details$")
    public void taskIsNotDisplayedInProjectDetails(String taskName) {
        this.tasksSteps.taskIsNotDisplayedInProjectDetails(taskName);
    }

    @When(value="^Task '(.*)' is not marked as completed and displayed in Uncompleted section$")
    public void taskIsNotMarkedAndDisplayedInUncompletedSection(String taskName) {
        this.tasksSteps.taskIsNotMarkedAndDisplayedInUncompletedSection(taskName);
    }

    @When(value="^The task is marked as completed in task drawer$")
    public void taskMarkedAsCompletedIsDisplayedInDrawer() {
        this.tasksSteps.taskMarkedAsCompletedIsDisplayedInDrawer();
    }

    @When(value="^Task label '(.*)' related to task name '(.*)' is displayed in project details$")
    public void taskNameAndLabelIsDisplayedInProjectDetails(String label, String taskName) {
        this.tasksSteps.taskNameAndLabelIsDisplayedInProjectDetails(label, taskName);
    }

    @When(value="^In column status '(.*)' , Task name '(.*)' is displayed$")
    public void taskNameIsDisplayedInDesiredColumn(String status, String taskName) {
        this.tasksSteps.taskNameIsDisplayedInDesiredColumn(status, taskName);
    }

    @Then(value="^The task name '(.*)' should be displayed in PLAN view$")
    public void taskNamePLanView(String taskName) {
        this.tasksSteps.taskNamePLanView(taskName);
    }

    @When(value="^In project details the task '(.*)' is displayed in '(.*)' place$")
    public void taskOrderInProjectDetails(String task, String number) {
        this.tasksSteps.taskOrderInProjectDetails(task, number);
    }

    @When(value="^Tasks number '(.*)' is displayed in the column To Do$")
    public void tasksNumberToDo(String tasksNumber) {
        this.tasksSteps.tasksNumberToDo(tasksNumber);
    }

    @When(value="^Task tooltip is displayed '(.*)'$")
    public void taskTooltipIsDisplayed(String task) {
        this.tasksSteps.taskTooltipIsDisplayed(task);
    }

    @When(value="^I update task Description '(.*)'$")
    public void updateTaskDescription(String description) {
        this.tasksSteps.updateTaskDescription(description);
    }

    @Then(value="^User avatar '(.*)' is displayed in Project Card$")
    public void userAvatarIsDisplayedInProjectCard(String userName) {
        String firstName = (String)Serenity.sessionVariableCalled((Object)"adminUserFirstName");
        String lastName = (String)Serenity.sessionVariableCalled((Object)"adminUserLastName");
        String fullName = firstName + " " + lastName;
        this.tasksSteps.userAvatarIsDisplayedInProjectCard(fullName);
    }

    @Then(value="^'(.*)' User avatars are displayed in Project Card$")
    public void userAvatarIsDisplayedInProjectCard(int count) {
        this.tasksSteps.countUserAvatarsInProjectCard(count);
    }

    @Then(value="^User avatar '(.*)' is not displayed in Project Card$")
    public void userAvatarIsNotDisplayedInProjectCard(String userName) {
        this.tasksSteps.userAvatarIsNotDisplayedInProjectCard(userName);
    }

    @Then(value="^Space manager '(.*)' is displayed in Project Card$")
    @And(value="^Project manager '(.*)' is displayed in Project Card$")
    public void userFullNameIsDisplayedInProjectCard(String name) {
        this.tasksSteps.userFullNameIsDisplayedInProjectCard(name);
    }

    @Then(value="^Space member '(.*)' is not displayed in Project Card$")
    @And(value="^Project participant '(.*)' is not displayed in Project Card$")
    public void userFullNameIsNotDisplayedInProjectCard(String name) {
        this.tasksSteps.userFullNameIsNotDisplayedInProjectCard(name);
    }

    @Then(value="^First Space member is not displayed in Project Card$")
    @And(value="^First Project participant is not displayed in Project Card$")
    public void userFullRandomNameIsNotDisplayedInProjectCard() {
        String firstUserFirstName = (String)Serenity.sessionVariableCalled((Object)"firstUserFirstName");
        String firstUserLastName = (String)Serenity.sessionVariableCalled((Object)"firstUserLastName");
        String fullName = firstUserFirstName + " " + firstUserLastName;
        this.tasksSteps.userFullNameIsNotDisplayedInProjectCard(fullName);
    }

    @Then(value="^The label View all attachments is not displayed$")
    public void verifyViewLinkAttachments() {
        this.tasksSteps.verifyViewLinkAttachments();
    }

    @When(value="^I view all task comments$")
    public void viewAllCommentsTaskButton() {
        this.tasksSteps.viewAllCommentsTaskButton();
    }

    @When(value="^I click on filter tasks button$")
    public void clickFilterTasksButton() {
        this.tasksSteps.clickFilterTasksButton();
    }

    @When(value="^I select the '(.*)' filter type$")
    public void goToFilterType(String filterType) {
        this.tasksSteps.goToFilterType(filterType);
    }

    @When(value="^I select the filter project option '(.*)'$")
    public void selectOption(String option) {
        this.tasksSteps.selectProjectFilterOption(option);
    }
}

