/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.steps.definition;

import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.meeds.qa.ui.steps.UserProfileSteps;
import io.meeds.qa.ui.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.annotations.Steps;

public class UserProfileStepDefinition {
    private static final String IM_PARAM = "instantMessaging";
    private static final String COMPANY_PARAM = "company";
    private static final String PHONE_PARAM = "phone";
    @Steps
    private UserProfileSteps userProfileSteps;

    @And(value="^I add my profile work experiences$")
    public void addWorkExperiences(Map<String, String> workExperiences) {
        this.userProfileSteps.addWorkExperiences(workExperiences);
    }

    @Then(value="My points augmented")
    public void checkMyPointIncrease() {
        int originalWeeklyPoint = (Integer)Serenity.sessionVariableCalled((Object)"originalWeeklyPoint");
        this.userProfileSteps.checkMyPointIncrease(originalWeeklyPoint);
    }

    @Then(value="^Updated Profile Contact instantMessaging is displayed$")
    public void checkProfileContactInstantMessagingVisible() {
        String instantMessagingType = "Skype";
        String instantMessaging = (String)Serenity.sessionVariableCalled((Object)IM_PARAM);
        this.userProfileSteps.checkProfileContactInstantMessagingVisible(instantMessagingType, instantMessaging);
    }

    @Given(value="^Job title '(.*)' and Organization '(.*)' and Job details '(.*)' and Used skills '(.*)' are displayed in Work experiences section$")
    public void checkWorkExperiencesSection(String jobTitle, String organization, String jobDetails, String usedSkills) {
        this.userProfileSteps.checkWorkExperiencesSection(jobTitle, organization, jobDetails, usedSkills);
    }

    @When(value="^I check my points$")
    public void getMyWeeklyPoint() {
        int originalWeeklyPoint = this.userProfileSteps.getMyWeeklyPoint();
        Serenity.setSessionVariable((Object)"originalWeeklyPoint").to((Object)originalWeeklyPoint);
    }

    @Then(value="I go to Received Kudos")
    public void goToReceivedKudos() {
        this.userProfileSteps.goToReceivedKudos();
    }

    @Then(value="I go to Sent Kudos")
    public void goToSentKudos() {
        this.userProfileSteps.goToSentKudos();
    }

    @When(value="^How to earn points page is displayed$")
    public void howToEarnPointsPageIsDisplayed() {
        this.userProfileSteps.howToEarnPointsPageIsDisplayed();
    }

    @Then(value="^User Avatar is displayed in Profile Page$")
    public void isAvatarVisible() {
        this.userProfileSteps.isAvatarVisible();
    }

    @Then(value="^User Cover is displayed in Profile Page$")
    public void isCoverVisible() {
        this.userProfileSteps.isCoverVisible();
    }

    @Then(value="Gained Cauris Section is displayed")
    public void isGainedCaurisVisible() {
        this.userProfileSteps.isGainedCaurisVisible();
    }

    @Then(value="Profile avatar is uploaded")
    public void isProfileAvatarUploaded() {
        this.userProfileSteps.isProfileAvatarUploaded();
    }

    @Then(value="^Profile Contact Company '(.*)' is displayed$")
    public void isProfileContactCompanyVisible(String company) {
        this.userProfileSteps.isProfileContactCompanyVisible(company);
    }

    @Then(value="^Profile Contact Email '(.*)' is displayed$")
    public void isProfileContactEmailVisible(String mail) {
        this.userProfileSteps.isProfileContactEmailVisible(mail);
    }

    @Then(value="^Profile Contact Fullname '(.*)' is displayed in '(.*)'$")
    public void isProfileContactFullNameVisible(String title, String fullName) {
        this.userProfileSteps.isProfileContactFullNameVisible(title, fullName);
    }

    @Then(value="^Profile Contact instantMessaging '(.*)' is displayed$")
    public void isProfileContactInstantMessagingVisible(String instantMessaging) {
        this.userProfileSteps.checkProfileContactInstantMessagingVisible("", instantMessaging);
    }

    @Then(value="^Profile Contact Phone '(.*)' is displayed$")
    public void isProfileContactPhoneVisible(String phone) {
        this.userProfileSteps.checkProfileContactPhoneVisible("", phone);
    }

    @Then(value="^Updated Profile Contact Company is displayed$")
    public void isProfileContactRandomCompanyVisible() {
        String company = (String)Serenity.sessionVariableCalled((Object)COMPANY_PARAM);
        this.userProfileSteps.isProfileContactCompanyVisible(company);
    }

    @Then(value="^Updated Profile Contact Email is displayed$")
    public void isProfileContactRandomEmailVisible() {
        String profileMail = (String)Serenity.sessionVariableCalled((Object)"profileMail");
        this.userProfileSteps.isProfileContactEmailVisible(profileMail);
    }

    @Then(value="^In '(.*)', Updated profile Contact Fullname is displayed$")
    public void isProfileContactRandomFullNameVisible(String title) {
        String profileFirstName = (String)Serenity.sessionVariableCalled((Object)"profileFirstName");
        String profileLastName = (String)Serenity.sessionVariableCalled((Object)"profileLastName");
        String fullName = profileFirstName + " " + profileLastName;
        this.userProfileSteps.isProfileContactFullNameVisible(title, fullName);
    }

    @Then(value="^Updated Profile Contact Job is displayed$")
    public void isProfileContactRandomJobVisible() {
        String profileJob = (String)Serenity.sessionVariableCalled((Object)"profileJob");
        this.userProfileSteps.isUserJobVisible(profileJob);
    }

    @Then(value="^Updated Profile Contact Phone is displayed$")
    public void isProfileContactRandomPhoneVisible() {
        String phoneType = "Work";
        String phone = (String)Serenity.sessionVariableCalled((Object)PHONE_PARAM);
        Utils.refreshPage();
        this.userProfileSteps.checkProfileContactPhoneVisible(phoneType, phone);
    }

    @Then(value="^Updated Profile Contact Url is displayed$")
    public void isProfileContactRandomUrlVisible() {
        this.userProfileSteps.isProfileContactUrlVisible("meeds.io");
    }

    @Then(value="^Received kudos by (.*) user is displayed$")
    public void receivedKudosByRandomUserSectionIsDisplayed(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.userProfileSteps.receivedKudosUsersSectionIsDisplayed(userLastName);
    }

    @Then(value="No kudos are received")
    public void checkNoReceivedKudos() {
        this.userProfileSteps.checkNoReceivedKudos();
    }

    @Then(value="No kudos are sent")
    public void checkNoSentKudos() {
        this.userProfileSteps.checkNoSentKudos();
    }

    @Then(value="^'(.*)' kudos are received$")
    public void receivedKudosSectionIsDisplayed(String kudosNumber) {
        this.userProfileSteps.receivedKudosSectionIsDisplayed(kudosNumber);
    }

    @Given(value="^I remove my profile work experiences '(.*)'$")
    public void removeWorkExperience(String jobTitle) {
        this.userProfileSteps.removeWorkExperience(jobTitle);
    }

    @When(value="^I send kudos with message '(.*)'$")
    public void sendKudos(String kudosMessage) {
        this.userProfileSteps.sendKudos(kudosMessage);
    }

    @Then(value="^'(.*)' kudos are sent$")
    public void sentKudosSectionIsDisplayed(String kudosNumber) {
        this.userProfileSteps.sentKudosSectionIsDisplayed(kudosNumber);
    }

    @Then(value="^Sent kudos by user '(.*)' is displayed$")
    public void sentKudosUsersSectionIsDisplayed(String userPrefix) {
        String userLastName = (String)Serenity.sessionVariableCalled((Object)(userPrefix + "UserLastName"));
        this.userProfileSteps.sentKudosUsersSectionIsDisplayed(userLastName);
    }

    @Given(value="^I update my profile other random informations$")
    public void updateContactOtherRandomInformations() {
        HashMap<String, String> basicInformations = new HashMap<String, String>();
        String company = Utils.getRandomString();
        String phoneType = "WORK";
        String phone = Utils.getRandomNumber();
        String instantMessagingType = "SKYPE";
        String instantMessaging = Utils.getRandomString() + "." + Utils.getRandomString();
        basicInformations.put(COMPANY_PARAM, company);
        basicInformations.put("phoneType", phoneType);
        basicInformations.put(PHONE_PARAM, phone);
        basicInformations.put("instantMessagingType", instantMessagingType);
        basicInformations.put(IM_PARAM, instantMessaging);
        basicInformations.put("url", "https://meeds.io/");
        Serenity.setSessionVariable((Object)COMPANY_PARAM).to((Object)company);
        Serenity.setSessionVariable((Object)"phoneType").to((Object)phoneType);
        Serenity.setSessionVariable((Object)PHONE_PARAM).to((Object)phone);
        Serenity.setSessionVariable((Object)"instantMessagingType").to((Object)instantMessagingType);
        Serenity.setSessionVariable((Object)IM_PARAM).to((Object)instantMessaging);
        Serenity.setSessionVariable((Object)"url").to((Object)"https://meeds.io/");
        this.userProfileSteps.updateContactOtherInformations(basicInformations);
    }

    @Given(value="^I update my profile random basic informations$")
    public void updateRandomBasicInformation() {
        HashMap<String, String> basicInformations = new HashMap<String, String>();
        String profileFirstName = Utils.getRandomString();
        String profileLastName = Utils.getRandomString();
        String profileMail = profileFirstName + "." + profileLastName + "@aa.bb";
        String profileJob = Utils.getRandomString() + " " + Utils.getRandomString();
        basicInformations.put("firstName", profileFirstName);
        basicInformations.put("lastName", profileLastName);
        basicInformations.put("email", profileMail);
        basicInformations.put("job", profileJob);
        Serenity.setSessionVariable((Object)"profileFirstName").to((Object)profileFirstName);
        Serenity.setSessionVariable((Object)"profileLastName").to((Object)profileLastName);
        Serenity.setSessionVariable((Object)"profileMail").to((Object)profileMail);
        Serenity.setSessionVariable((Object)"profileJob").to((Object)profileJob);
        this.userProfileSteps.updateBasicInformation(basicInformations);
    }

    @Then(value="^I upload the Profile avatar '(.*)'$")
    public void uploadProfileAvatar(String fileName) {
        this.userProfileSteps.uploadProfileAvatar(fileName);
    }
}

