@gamification
@rules
Feature: Rules

  Scenario: Quick filter rules
    Given I am authenticated as 'admin' random user
    And I create the random space if not existing
    And I go to Programs page
    And I click on the button add program
    And I enter a random program title
    And I add program with random description
    And I click on 'Next' button in drawer
    And I add an audience space
    And I save the program details

    And I click on 'Add quest' button
    And I wait for drawer to open
    And I enter the rule title 'Receive kudos'
    And I select a 'meeds' application
    And I click on 'Start' button in drawer
    And I add rule random description
    And I select a 'Receive kudos' event
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Add' button in drawer

    Then Confirmation message is displayed 'Quest has been successfully created'

    When I close the notification
    And The action 'Receive kudos' is displayed in program detail

    When I search for the 'Not found' rule in program detail rule filter
    Then Rule not found. Please try again is displayed

    When I clear rules search filter
    Then The action 'Receive kudos' is displayed in program detail

  Scenario: Space host can Add Quest in program
    Given I am authenticated as 'admin' random user
    And I inject the random space
    And I inject the firstrule random user if not existing, no wait

    When I login as 'firstrule' random user
    And I go to the random space

    When I login as 'admin' random user
    And I go to the random space
    And I click on 'More/Members' space menu tab
    And I promote 'firstrule' random user as a space manager

    When I go to Programs page
    And I click on the button add program
    And I enter the program title 'Test Rule Space Host'
    And I add program with random description
    And I click on 'Next' button in drawer
    And I add an audience space
    And I save the program details

    When I login as 'firstrule' random user
    And I go to Programs page
    And I filter programs by value 'ALL'
    And I open 'Test Rule Space Host' program card

    And I click on 'Add Quest' button
    And I wait for drawer to open
    And I enter the rule title 'Join space'
    And I select a 'meeds' application
    And I click on 'Start' button in drawer
    And I add rule random description
    And I select a 'Join space' event
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Add' button in drawer

    Then Confirmation message is displayed 'Quest has been successfully created'

    When I close the notification
    Then The action 'Join space' is displayed in program detail
    And The button 'Activate the campaign' is displayed

  Scenario: Space member as program owner can Add Quest
    Given I am authenticated as 'admin' random user
    And I inject the random space
    And I inject the secondrule random user if not existing, no wait

    When I login as 'secondrule' random user
    And I go to the random space

    When I login as 'admin' random user
    And I go to Programs page
    And I click on the button add program
    And I enter the program title 'Test Rule Program Owner'
    And I add program with random description
    And I click on 'Next' button in drawer
    And I add an audience space
    And I set user 'secondrule' as program owner
    And I save the program details

    When I login as 'secondrule' random user
    And I go to Programs page
    And I filter programs by value 'ALL'
    Then I open 'Test Rule Program Owner' program card

    When I click on 'Add Quest' button
    And I wait for drawer to open
    And I enter the rule title 'Join space'
    And I select a 'meeds' application
    And I click on 'Start' button in drawer
    And I add rule random description
    And I select a 'Join space' event
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Next' button in drawer
    And I click on 'Add' button in drawer

    Then Confirmation message is displayed 'Quest has been successfully created'

    When I close the notification
    Then The action 'Join space' is displayed in program detail
