/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.elements;

import io.meeds.qa.ui.elements.ElementFacadeImpl;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.utils.ExceptionLauncher;
import io.meeds.qa.ui.utils.Utils;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.core.pages.WebElementFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextBoxElementFacadeImpl
extends ElementFacadeImpl
implements TextBoxElementFacade {
    static final Logger LOGGER = LoggerFactory.getLogger(TextBoxElementFacadeImpl.class);

    public static TextBoxElementFacadeImpl wrapWebElementFacadeInTextBoxElement(WebDriver driver, WebElementFacade element, ElementLocator locator, String xPathOrCSSSelector, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        return new TextBoxElementFacadeImpl(driver, locator, xPathOrCSSSelector, (WebElement)element, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public TextBoxElementFacadeImpl(WebDriver driver, ElementLocator locator, String xPathOrCSSSelector, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(driver, locator, xPathOrCSSSelector, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public TextBoxElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(driver, locator, null, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    @Override
    public String getTextBoxValue() {
        try {
            if (!this.isVisible()) {
                Utils.waitForLoading();
                if (!this.isVisible()) {
                    this.waitUntilVisible();
                }
            }
            return this.getValue();
        }
        catch (Exception e) {
            ExceptionLauncher.throwSerenityExeption(e, String.format("Text can't be extracted from The element [%s]", this));
            return null;
        }
    }

    public void sendKeys(CharSequence ... value) {
        this.sendValueWithKeys(false, null, value);
    }

    public void sendValueWithKeys(boolean clear, Keys keys, CharSequence ... value) {
        Utils.retryOnCondition(() -> this.sendValueWithKeysOnElement(clear, keys, value));
    }

    public void sendValueWithKeysOnElement(boolean clear, Keys keys, CharSequence ... value) {
        this.waitUntilVisible();
        if (clear) {
            this.clear();
            String currentValue = this.getValue();
            if (StringUtils.isNotBlank((CharSequence)currentValue)) {
                List<Keys> backSpace = Collections.nCopies(currentValue.length(), Keys.BACK_SPACE);
                super.sendKeys((CharSequence[])backSpace.toArray(new Keys[0]));
            }
        }
        super.sendKeys(value);
        if (keys != null) {
            super.sendKeys(new CharSequence[]{keys});
        }
    }

    @Override
    public void setTextValue(String value) {
        this.setTextValue(value, null);
    }

    @Override
    public void setTextValue(String value, Keys keys) {
        try {
            this.sendValueWithKeys(true, keys, value);
        }
        catch (IllegalArgumentException | WebDriverException e) {
            ExceptionLauncher.throwSerenityExeption((Exception)e, String.format("The element [%s] is not visible. The new value [%s] cannot be entered.", this, value));
        }
    }
}

