/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.elements;

import io.meeds.qa.ui.elements.ElementFacadeImpl;
import io.meeds.qa.ui.elements.TextElementFacade;
import io.meeds.qa.ui.utils.ExceptionLauncher;
import io.meeds.qa.ui.utils.Utils;
import net.serenitybdd.core.pages.WebElementFacade;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextElementFacadeImpl
extends ElementFacadeImpl
implements TextElementFacade {
    static final Logger LOGGER = LoggerFactory.getLogger(TextElementFacadeImpl.class);

    public static TextElementFacadeImpl wrapWebElementFacadeInTextElement(WebDriver driver, WebElementFacade element, ElementLocator locator, String xPathOrCSSSelector, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        return new TextElementFacadeImpl(driver, locator, xPathOrCSSSelector, (WebElement)element, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public TextElementFacadeImpl(WebDriver driver, ElementLocator locator, String xPathOrCSSSelector, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(driver, locator, xPathOrCSSSelector, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public TextElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        super(driver, locator, null, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    @Override
    public String getContent() {
        String textValue = null;
        try {
            this.waitUntilVisible();
            textValue = this.getText();
        }
        catch (Exception e) {
            ExceptionLauncher.throwSerenityExeption(e, String.format("Text can't be extracted from The element [%s]", this));
        }
        return textValue;
    }

    public void sendKeys(CharSequence ... value) {
        this.sendValueWithKeys(false, null, value);
    }

    public void sendValueWithKeys(boolean clear, Keys keys, CharSequence ... value) {
        Utils.retryOnCondition(() -> {
            WebElement element = this.getElement();
            this.sendValueWithKeysOnElement(element, clear, keys, value);
        });
    }

    public void sendValueWithKeysOnElement(WebElement element, boolean clear, Keys keys, CharSequence ... value) {
        if (clear) {
            element.clear();
        }
        element.sendKeys(value);
        if (keys != null) {
            element.sendKeys(new CharSequence[]{keys});
        }
    }

    public void setTextValue(String value) {
        this.setTextValue(value, null);
    }

    public void setTextValue(String value, Keys keys) {
        try {
            this.sendValueWithKeys(true, keys, value);
        }
        catch (IllegalArgumentException | WebDriverException e) {
            ExceptionLauncher.throwSerenityExeption((Exception)e, String.format("The element [%s] is not visible. The new value [%s] cannot be entered.", this, value));
        }
    }
}

