/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.openqa.selenium.WebDriver;

public class AddGroupsPage
extends GenericPage {
    public AddGroupsPage(WebDriver driver) {
        super(driver);
    }

    public void addMemberInGroup(String role, String member) {
        Utils.retryOnCondition(() -> this.addMember(role, member));
    }

    public void addMember(String role, String member) {
        ElementFacade addMemberInGroupBtnElement = this.addMemberInGroupBtnElement();
        if (!addMemberInGroupBtnElement.isClickable() || !addMemberInGroupBtnElement.isVisible()) {
            Utils.refreshPage();
        }
        this.closeAllDrawers();
        addMemberInGroupBtnElement.click();
        ElementFacade selectedRoleFieldElement = this.selectedRoleFieldElement();
        selectedRoleFieldElement.checkVisible();
        selectedRoleFieldElement.selectByValue(role);
        selectedRoleFieldElement.click();
        TextBoxElementFacade inviteMemberInputElement = this.inviteMemberInputElement();
        inviteMemberInputElement.setTextValue(member);
        boolean found = this.mentionInField(inviteMemberInputElement, member, 3);
        if (found) {
            ElementFacade saveMemberAddedInGroupElement = this.saveMemberAddedInGroupElement();
            try {
                saveMemberAddedInGroupElement.click();
            }
            catch (Exception e) {
                this.findByXPathOrCSS("//*[contains(@class,'drawerTitle')]").click();
                saveMemberAddedInGroupElement.click();
            }
        }
        this.closeAllDrawers();
        this.waitForDrawerToClose();
    }

    public ElementFacade groupOpenBtn(String group) {
        return this.findByXPathOrCSS(String.format("//*[@class='flex sm12 md4 flat']//*[@class='v-list-item__content']//*[contains(text(),'%s')]/preceding::i[@class='v-icon notranslate mdi mdi-menu-right theme--light'][1]", group));
    }

    public ElementFacade groupToSelect(String group) {
        return this.findByXPathOrCSS(String.format("//*[@class='flex sm12 md4 flat']//*[@class='v-list-item__content']//*[contains(text(),'%s')]", group));
    }

    public void openGroup(String group) {
        this.groupOpenBtn(group).click();
    }

    public void selectGroup(String group) {
        this.groupToSelect(group).click();
    }

    private ElementFacade addMemberInGroupBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'addNewMembershipButton')]");
    }

    private TextBoxElementFacade inviteMemberInputElement() {
        return this.findTextBoxByXPathOrCSS("//input[@id='userNameInput']");
    }

    private ElementFacade saveMemberAddedInGroupElement() {
        return this.findByXPathOrCSS("//*[@id='membershipFormDrawer' and contains(@class, 'v-navigation-drawer--open')]//button[contains(@class,'btn-primary')]");
    }

    private ElementFacade selectedRoleFieldElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'membershipNameField')]//select");
    }
}

