/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import org.openqa.selenium.WebDriver;

public class AddUserPage
extends GenericPage {
    public AddUserPage(WebDriver driver) {
        super(driver);
    }

    public void checkPopupCantDeleteLoggedUser() {
        this.popupCantDeleteLoggedUserElement().assertVisible();
    }

    public void checkThatAddUserDrawerIsDisplayed() {
        this.addUserDrawerElement().assertVisible();
    }

    public void checkUserIsDeleted(String fullName) {
        this.searchForUserByName(fullName);
        this.clickToConfirmDialog();
    }

    public void clickAddUserButton() {
        this.clickOnElement(this.findByXPathOrCSS(".addNewUserButton"));
    }

    public void clickToDeleteUser() {
        this.deleteUserIconElement().click();
    }

    public void deleteUser() {
        this.deleteUserIconElement().click();
        this.clickToConfirmDialog();
    }

    public ElementFacade disableEnableStatusButton(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='text-center' and contains(text(),'%s')]/following::*[@class='switch']", user));
    }

    public void enableDisableUser(String user) {
        this.disableEnableStatusButton(user).click();
        this.waitForProgressBar();
    }

    public ElementFacade getUserElement(String user) {
        return this.findByXPathOrCSS(String.format("//*[@class='v-data-table__wrapper']//*[@class='text-center' and contains(text(),'%s')][1]", user));
    }

    public void isUserNameDisplayed(String user) {
        this.getUserElement(user).assertVisible();
    }

    public void saveAddUserButton() {
        this.saveAddUserButtonElement().click();
    }

    public void searchForUserByName(String userName) {
        this.searchForUserByName(userName, 1);
    }

    public void searchForUserByName(String userName, int tentatives) {
        int retry = 0;
        do {
            TextBoxElementFacade searchUsersFieldElement = this.searchUsersFieldElement();
            searchUsersFieldElement.setTextValue(userName);
            this.waitForProgressBar();
        } while (++retry < tentatives && !this.getUserElement(userName).isCurrentlyVisible());
    }

    public void searchForUsersByStatus(String status) {
        ElementFacade pullDownFilterUserStatusElement = this.pullDownFilterUserStatusElement();
        pullDownFilterUserStatusElement.selectByValue(status);
        this.waitForProgressBar();
    }

    public void setRandomUserDetails(String userName, String firstName, String lastName, String mail, String password) {
        this.userNameFieldElement().setTextValue(userName);
        this.firstNameFieldElement().setTextValue(firstName);
        this.lastNameFieldElement().setTextValue(lastName);
        this.emailFieldElement().setTextValue(mail);
        this.newPasswordFieldElement().setTextValue(password);
        this.confirmPasswordFieldElement().setTextValue(password);
    }

    public void setUserDetails(String fieldName, String fieldValue) {
        switch (fieldName) {
            case "UserName": {
                this.userNameFieldElement().setTextValue(fieldValue);
                break;
            }
            case "FirstName": {
                this.firstNameFieldElement().setTextValue(fieldValue);
                break;
            }
            case "LastName": {
                this.lastNameFieldElement().setTextValue(fieldValue);
                break;
            }
            case "Mail": {
                this.emailFieldElement().setTextValue(fieldValue);
                break;
            }
            case "Password": {
                this.newPasswordFieldElement().setTextValue(fieldValue);
                break;
            }
            case "Password Confirmation": {
                this.confirmPasswordFieldElement().setTextValue(fieldValue);
                break;
            }
        }
    }

    private ElementFacade addUserDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='userFormDrawer']//*[contains(@class,'drawerTitle ')]");
    }

    private TextBoxElementFacade confirmPasswordFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'confirmPasswordField')]//input");
    }

    private TextBoxElementFacade deleteUserIconElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='uiIconTrash trashIconColor']");
    }

    private TextBoxElementFacade emailFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'emailField')]//input");
    }

    private TextBoxElementFacade firstNameFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'firstNameField')]//input");
    }

    private TextBoxElementFacade lastNameFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'lastNameField')]//input");
    }

    private TextBoxElementFacade newPasswordFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'newPasswordField')]//input");
    }

    private TextBoxElementFacade popupCantDeleteLoggedUserElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(text(), 'You can\u2019t delete your user account while being logged in with it.')]");
    }

    private ElementFacade pullDownFilterUserStatusElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'selectUsersFilter')]");
    }

    private ElementFacade saveAddUserButtonElement() {
        return this.findByXPathOrCSS("//aside[@id='userFormDrawer']//button[contains(@class,'btn-primary')]");
    }

    private TextBoxElementFacade searchUsersFieldElement() {
        return this.findTextBoxByXPathOrCSS("//input[@placeholder='Filter by name or email']");
    }

    private TextBoxElementFacade userNameFieldElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'userNameField')]//input");
    }
}

