/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ApplicationPage
extends GenericPage {
    public ApplicationPage(WebDriver driver) {
        super(driver);
    }

    public void addRemoveApplicationToFavorites(String app) {
        this.searchAppInputElement().setTextValue(app);
        this.waitFor(50).milliseconds();
        this.getFavoriteButton(app).click();
    }

    public void bookmarkApplication(String appTitle) {
        this.getNonFavoriteApplicationElement(appTitle).click();
    }

    public void checkApplicationIsNotVisible(String application) {
        this.getApplicationInsideAppPage(application).assertNotVisible();
    }

    public void checkApplicationIsVisible(String application) {
        this.getApplicationInsideAppPage(application).assertVisible();
    }

    public void checkThatAddApplicationBtnToFavoritesIsDisplayed(String app) {
        this.getFavoriteButton(app).assertVisible();
    }

    public void checkThatAppcenterApplicationIsDisplayed(String app) {
        this.elementApplicationsTopbarElement().click();
        this.getFavoriteApplicationElement(app).assertVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkThatAppcenterApplicationIsNotDisplayed(String app) {
        this.elementApplicationsTopbarElement().click();
        this.getFavoriteApplicationElement(app).assertNotVisible();
        this.closeDrawerIfDisplayed();
    }

    public void checkThatApplicationIsDisplayedInFavoriteApps(String app) {
        this.getFavoriteApplicationElement(app).assertVisible();
    }

    public void checkThatApplicationIsNotDisplayedInFavoriteApps(String app) {
        this.getFavoriteApplicationElement(app).assertNotVisible();
    }

    public void checkThatOpenApplicationButtonIsDisplayed(String app) {
        this.getApplicationsCard(app).assertVisible();
    }

    public void clickOnOpenApplicationButton(String app) {
        this.getApplicationsCard(app).click();
    }

    public void clickOnTheAppLauncherIcon() {
        if (this.getCurrentUrl().contains("/portal/administration")) {
            this.getDriver().navigate().to(this.getCurrentUrl().split("/portal")[0]);
            this.verifyPageLoaded();
        }
        Utils.waitForLoading();
        this.closeAllDrawers();
        Utils.retryOnCondition(() -> {
            this.elementApplicationsTopbarElement().checkVisible();
            this.elementApplicationsTopbarElement().click();
            this.waitForDrawerToOpen();
            this.waitForDrawerToLoad();
        }, Utils::refreshPage);
    }

    public void goToApplication(String application) {
        this.clickOnTheAppLauncherIcon();
        this.getApplication(application).click();
        Utils.waitForLoading();
    }

    public void seeAllApplications() {
        this.elementApplicationsTopbarElement().click();
        this.waitForDrawerToOpen();
        this.waitForDrawerToLoad();
        this.expandDrawer();
    }

    public void settingsPageIsOpened() {
        this.settingsPageElement().assertVisible();
    }

    public void starButtonIsDisabled(String appTitle) {
        this.disabledFavoriteIsDisplayed(appTitle).assertVisible();
    }

    public void starButtonIsNotSelected(String appTitle) {
        this.getNonFavoriteApplicationElement(appTitle).assertVisible();
    }

    public void starButtonIsSelected(String appTitle) {
        this.getFavoriteApplicationElement(appTitle).assertVisible();
    }

    public void unbookmarkApplication(String appTitle) {
        this.getFavoriteApplicationElement(appTitle).click();
    }

    public void addImageToApplication(String image) {
        ElementFacade hiddenInput = this.findByXPathOrCSS("//input[@id='iconFileInput']//ancestor::*[contains(@class, 'v-input__control')]");
        String js = "arguments[0].style.display='block';";
        ((JavascriptExecutor)this.getDriver()).executeScript(js, new Object[]{hiddenInput.getWrappedElement()});
        WebElement elem = this.getDriver().findElement(By.xpath((String)"//input[@id='iconFileInput']"));
        this.upload(UPLOAD_DIRECTORY_PATH + image).fromLocalMachine().to(elem);
        js = "arguments[0].style.display='none';";
        ((JavascriptExecutor)this.getDriver()).executeScript(js, new Object[]{hiddenInput.getWrappedElement()});
    }

    public void applicationDrawerEnabledButtonsAreIsDisplayed() {
        this.findByXPathOrCSS("(//*[contains(@class, 'appCenterDrawer')]//*[contains(@class, 'applicationProperties')]//input[@aria-checked='true'])[1]//ancestor::*[contains(@class, 'v-input')]").assertVisible();
        this.findByXPathOrCSS("(//*[contains(@class, 'appCenterDrawer')]//*[contains(@class, 'applicationProperties')]//input[@aria-checked='true'])[2]//ancestor::*[contains(@class, 'v-input')]").assertVisible();
        this.findByXPathOrCSS("(//*[contains(@class, 'appCenterDrawer')]//*[contains(@class, 'applicationProperties')]//input[@aria-checked='true'])[3]//ancestor::*[contains(@class, 'v-input')]").assertVisible();
    }

    public void applicationDrawerImageIsDisplayed(String image) {
        Assert.assertEquals((Object)this.editApplicationDrawerImageElement().getText(), (Object)image);
    }

    public void applicationDrawerPermissionsIsDisplayed(String firstPermission, String secondPermission) {
        TextBoxElementFacade editApplicationDrawerPermissionsFirstElement = this.editApplicationDrawerPermissionsFirstElement();
        String firstValue = editApplicationDrawerPermissionsFirstElement.getAttribute("data-value");
        Assert.assertEquals((Object)firstPermission, (Object)firstValue);
        Assert.assertTrue((boolean)editApplicationDrawerPermissionsFirstElement.getTextValue().contains(firstPermission));
        ElementFacade editApplicationDrawerPermissionsSecondElement = this.editApplicationDrawerPermissionsSecondElement();
        String secondValue = editApplicationDrawerPermissionsSecondElement.getAttribute("data-value");
        Assert.assertEquals((Object)secondPermission, (Object)secondValue);
        Assert.assertTrue((boolean)editApplicationDrawerPermissionsSecondElement.getTextValue().contains(secondPermission));
    }

    public void applicationDrawerTitleIsDisplayed(String title) {
        Assert.assertEquals((Object)this.editApplicationDrawerTitleElement().getTextValue(), (Object)title);
    }

    public void appTitleInApplicationsTableIsDisplayed(String appTitle) {
        this.appTitleInApplicationsTable(appTitle).assertVisible();
    }

    public void checkPopupDeleteNotVisible() {
        this.confirmDeleteElement().assertNotVisible();
    }

    public void checkThatApplicationImageIsDisplayedInDrawer() {
        this.getApplicationImageInDrawer().assertVisible();
    }

    public void checkThatApplicationImageIsNotDisplayedInApplicationsTable(String appTitle) {
        this.appTitleNoImageElement(appTitle).assertVisible();
    }

    public void checkThatApplicationImageIsNotDisplayedInDrawer() {
        this.getApplicationImageInDrawer().assertNotVisible();
    }

    public void clickActiveApp(String appTitle) {
        this.searchAppByTitle(appTitle);
        this.enableDisableActiveApplication(appTitle);
    }

    public void clickAddApplicationButton() {
        this.addApplicationButtonElement().click();
    }

    public void clickCancelDelete() {
        this.cancelDeleteButtonElement().click();
    }

    public void clickCloseDeletePopup() {
        this.closeDeletePopupButtonElement().click();
    }

    public void clickSaveAddApplication() {
        this.clickDrawerButton("Save");
        this.waitForDrawerToClose();
    }

    public void deleteApp(String appTitle, boolean confirm) {
        this.openMenu(appTitle);
        this.getDeleteButton().click();
        if (confirm) {
            this.waitFor(200).milliseconds();
            this.clickConfirm();
        }
        Utils.waitForLoading();
    }

    public void enableDisableActiveApplication(String appTitle) {
        this.getActiveApplication(appTitle).click();
    }

    public void enableMandatoryApplication(String appTitle) {
        this.searchAppByTitle(appTitle);
        this.waitFor(50).milliseconds();
        this.openMenu(appTitle);
        this.getEditButton().click();
        ElementFacade mandatoryApplication = this.getMandatorySwitch();
        mandatoryApplication.checkVisible();
        String enabled = this.getMandatorySwitchInput().getAttribute("aria-checked");
        if (StringUtils.equals((CharSequence)enabled, (CharSequence)"false")) {
            this.clickOnElement(mandatoryApplication);
            this.waitFor(200).milliseconds();
            enabled = this.getMandatorySwitchInput().getAttribute("aria-checked");
            Assert.assertEquals((Object)"true", (Object)enabled);
            this.clickDrawerButton("Save");
        } else {
            Assert.assertEquals((Object)"true", (Object)enabled);
            this.closeDrawerIfDisplayed();
        }
    }

    public void disableMandatoryApplication(String appTitle) {
        this.goToEditTheApplication(appTitle);
        ElementFacade mandatoryApplication = this.getMandatorySwitch();
        mandatoryApplication.checkVisible();
        String enabled = this.getMandatorySwitchInput().getAttribute("aria-checked");
        if (StringUtils.equals((CharSequence)enabled, (CharSequence)"true")) {
            this.clickOnElement(mandatoryApplication);
            this.waitFor(200).milliseconds();
            enabled = this.getMandatorySwitchInput().getAttribute("aria-checked");
            Assert.assertEquals((Object)"false", (Object)enabled);
            this.clickDrawerButton("Save");
        } else {
            Assert.assertEquals((Object)"false", (Object)enabled);
            this.closeDrawerIfDisplayed();
        }
    }

    public void enterDataValueToField(String fieldName, String value) {
        switch (fieldName) {
            case "Application title": {
                this.titleAppInputElement().setTextValue(value);
                break;
            }
            case "Application url": {
                this.urlAppInputElement().setTextValue(value);
                break;
            }
            case "Application description": {
                this.applicationDescriptionElement().setTextValue(value);
                break;
            }
        }
    }

    public void enterRandomAppDataTitleUrl(String title, String url) {
        this.titleAppInputElement().setTextValue(title);
        this.urlAppInputElement().setTextValue(url);
    }

    public void enterRandomAppDataTitleUrlDescription(String title, String url, String desc) {
        this.titleAppInputElement().setTextValue(title);
        this.urlAppInputElement().setTextValue(url);
        this.applicationDescriptionElement().setTextValue(desc);
    }

    public void goToEditTheApplication(String appTitle) {
        this.searchAppByTitle(appTitle);
        this.waitFor(50).milliseconds();
        this.openMenu(appTitle);
        this.getEditButton().click();
        this.waitForDrawerToOpen();
    }

    public void selectApplicationIconFromDrawer(String icon) {
        this.clickDrawerButton("Choose");
        this.waitForDrawerToOpen("#nodeIconPickerDrawer", false);
        this.searchIconInput().setTextValue(icon);
        this.waitFor(50).milliseconds();
        this.iconCard().click();
        this.waitFor(50).milliseconds();
        this.iconSaveButton().click();
    }

    public void searchApp(String appTitle) {
        this.searchAppByTitle(appTitle);
    }

    private void openMenu(String appTitle) {
        ElementFacade menuThreeDots = this.editApplication(appTitle);
        menuThreeDots.waitUntilVisible();
        menuThreeDots.click();
    }

    private ElementFacade addApplicationButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'btn-primary')]//*[contains(text(), 'Add')]//ancestor::button");
    }

    private ElementFacade appTitleInApplicationsTable(String appTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::tr", appTitle));
    }

    private ElementFacade appTitleNoImageElement(String appTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::tr/td[1]//*[contains(@class, 'v-icon')]", appTitle));
    }

    private ElementFacade myApplicationDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='appLauncher']");
    }

    private ElementFacade closeDeletePopupButtonElement() {
        return this.findByXPathOrCSS(".v-dialog--active .uiIconClose");
    }

    private ElementFacade confirmDeleteElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[contains(text(), 'Delete')]");
    }

    private ElementFacade cancelDeleteButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-dialog--active')]//button[contains(text(), 'Cancel')]");
    }

    private ElementFacade editApplicationDrawerImageElement() {
        return this.findByXPathOrCSS("//*[@class='appLauncherDrawerTitle']/following::*[@class='imageTitle']");
    }

    private TextBoxElementFacade editApplicationDrawerPermissionsFirstElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class, 'appCenterDrawer')]//*[@for='permissions']/following::*[@class='item'])[1]");
    }

    private ElementFacade editApplicationDrawerPermissionsSecondElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'appCenterDrawer')]//*[@for='permissions']/following::*[@class='item'])[2]");
    }

    private TextBoxElementFacade editApplicationDrawerTitleElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='appLauncherDrawerTitle']/following::*[@name='title']");
    }

    private ElementFacade getActiveApplication(String appTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::tr//*[@class='v-input--selection-controls__input']", appTitle));
    }

    private ElementFacade getApplicationImageInDrawer() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class, 'v-image')]");
    }

    private ElementFacade getDeleteButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'fa-trash')]");
    }

    private ElementFacade getEditButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade getMandatorySwitch() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), 'Mandatory')]/parent::*//*[@class='v-input--selection-controls__input']");
    }

    private ElementFacade getMandatorySwitchInput() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), 'Mandatory')]/parent::*//*[@class='v-input--selection-controls__input']//input");
    }

    private ElementFacade getFavoriteButton(String app) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]//*[contains(@class, 'fa-star')]", app));
    }

    private ElementFacade disabledFavoriteIsDisplayed(String app) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]//*[contains(@class, 'fa-star')]//ancestor::button[@disabled]", app));
    }

    private ElementFacade elementApplicationsTopbarElement() {
        return this.findByXPathOrCSS("//*[@id='appcenterLauncherButton']");
    }

    private ElementFacade getApplicationsCard(String app) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]", app));
    }

    private ElementFacade getApplication(String appName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class,'appLauncherTitle') and contains(text(),'%s')]", appName));
    }

    private ElementFacade getApplicationInsideAppPage(String appName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]", appName));
    }

    private ElementFacade getFavoriteApplicationElement(String appName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]//*[contains(@class, 'fa-star') and contains(@class, 'yellow--text')]", appName));
    }

    private ElementFacade getNonFavoriteApplicationElement(String appName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'appLauncherItemContainer')]//*[contains(@class, 'fa-star') and not(contains(@class, 'yellow--text'))]", appName));
    }

    private ElementFacade settingsPageElement() {
        return this.findByXPathOrCSS("//*[@class='drawer filterSpacesDrawer open']//*[@class='btn reset']");
    }

    private ElementFacade editApplication(String appName) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::tr//*[contains(@class, 'fa-ellipsis-v')]", appName));
    }

    private void searchAppByTitle(String appTitle) {
        Utils.refreshPage();
        this.searchAppInputElementInAdmin().setTextValue(appTitle);
        this.waitForSearchToComplete();
    }

    private TextBoxElementFacade searchAppInputElement() {
        return this.findTextBoxByXPathOrCSS("//div[contains(@class,'appSearch')]//input");
    }

    private TextBoxElementFacade searchAppInputElementInAdmin() {
        return this.findTextBoxByXPathOrCSS("#applicationToolbarFilterInput");
    }

    private TextBoxElementFacade searchIconInput() {
        return this.findTextBoxByXPathOrCSS("#nodeIconPickerDrawer input");
    }

    private ElementFacade iconCard() {
        return this.findTextBoxByXPathOrCSS("#nodeIconPickerDrawer .v-card--link");
    }

    private ElementFacade iconSaveButton() {
        return this.findTextBoxByXPathOrCSS("#nodeIconPickerDrawer .btn-primary");
    }

    private TextBoxElementFacade titleAppInputElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='applicationName']");
    }

    private TextBoxElementFacade applicationDescriptionElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='applicationDescription']");
    }

    private TextBoxElementFacade urlAppInputElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='applicationUrl']");
    }

    private void waitForSearchToComplete() {
        try {
            this.findByXPathOrCSS("(//*[contains(@class, 'tableAppTitle')])[2]").checkNotVisible();
        }
        catch (Exception e) {
            LOGGER.debug("Search on AppCenter hasn't finished loading at time", (Throwable)e);
        }
        this.waitFor(500).milliseconds();
    }

    public void isMyApplicationButtonDisplayed() {
        this.elementApplicationsTopbarElement().assertVisible();
    }

    public void isMyApplicationDrawerDisplayed() {
        this.myApplicationDrawerElement().assertVisible();
    }
}

