/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.pages.SpacePage;
import io.meeds.qa.ui.utils.Utils;
import org.junit.Assert;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class KudosPage
extends GenericPage {
    private static final String ACTIVITY_KUDOS_DRAWER_SELECTOR = "//*[@id='activityKudosDrawer' and contains(@class, 'v-navigation-drawer--open')]";
    private SpacePage spaceHomePage;

    public KudosPage(WebDriver driver) {
        super(driver);
    }

    public void addActivityKudosToSomeoneDifferent(String activity, String message, String user) {
        this.getKudosLink(activity).click();
        this.waitCKEditorLoading("//*[@id='activityKudosDrawer']");
        this.deleteUserFromKudosButtonElement().click();
        this.mentionInField(this.userKudosInputElement(), user, 5);
        this.sendKudosMessageFromOpenedDrawer(message);
    }

    public void attemptSendActivityKudosToSomeoneDifferent(String activity, String message, String user) {
        this.getKudosLink(activity).click();
        this.waitCKEditorLoading("//*[@id='activityKudosDrawer']");
        this.deleteUserFromKudosButtonElement().click();
        this.mentionInField(this.userKudosInputElement(), user, 5);
        this.enterKudosMessageFromOpenedDrawer(message);
    }

    public void addActivityKudos(String activity, String comment) {
        this.getKudosLink(activity).click();
        this.sendKudosMessageFromOpenedDrawer(comment);
    }

    public void checkKudosActivityVisible(String message) {
        this.getKudosActivityText(message).assertVisible();
    }

    public void checkKudosIconDisabled(String activityId) {
        this.getKudosLink(activityId).assertDisabled();
    }

    public void checkKudosSettings(String kudosNbr, String period) {
        Assert.assertTrue((boolean)this.kudosNumberElement().getTextValue().contains(kudosNbr));
        Assert.assertTrue((boolean)this.displayedPeriodTypeElement().getTextValue().contains(period));
    }

    public void clickEditKudos() {
        this.threedotsKudosCommentElement().click();
        this.editKudosCommentElement().click();
    }

    public void clickEditKudosFromReply() {
        this.threedotsKudosReplyCommentElement().click();
        this.editKudosCommentElement().click();
    }

    public void editKudos() {
        this.dotsMenuElement().click();
        this.editButtonElement().click();
    }

    public void cancelKudosActivity(String activity) {
        if (!this.getCancelKudosActivityIcon(activity).isVisible()) {
            this.spaceHomePage.openThreeDotsActivityMenu(activity);
        }
        this.getCancelKudosActivityIcon(activity).click();
    }

    public void cancelKudosComment(String activity, String kudos) {
        if (!this.getCancelKudosCommentIcon(kudos).isVisible()) {
            this.spaceHomePage.openThreeDotsCommentMenu(activity, kudos);
        }
        ElementFacade cancelKudosCommentIcon = this.getCancelKudosCommentIcon(kudos);
        cancelKudosCommentIcon.assertVisible();
        cancelKudosCommentIcon.click();
        cancelKudosCommentIcon.assertNotVisible();
    }

    public void enterKudosNumber(String val) {
        TextBoxElementFacade kudosNumberElement = this.kudosNumberElement();
        kudosNumberElement.click();
        kudosNumberElement.clear();
        kudosNumberElement.setTextValue(val);
    }

    public void goToKudosMenu() {
        this.menuBtnElement().click();
        this.administrationIconElement().hover();
        this.addministrationMenuElement().click();
        this.kudosLinkElement().click();
    }

    public void saveChange() {
        this.saveBtnElement().click();
    }

    public void selectType() {
        this.periodTypeElement().click();
        this.semesterPeriodElement().click();
    }

    public void sendKudosMessageFromOpenedDrawer(String kudosMessage) {
        this.waitForDrawerToOpen(ACTIVITY_KUDOS_DRAWER_SELECTOR, false);
        this.waitCKEditorLoading(ACTIVITY_KUDOS_DRAWER_SELECTOR);
        Utils.retryOnCondition(() -> {
            ElementFacade ckEditorFrameKudos = this.getCkEditorFrameKudos();
            ckEditorFrameKudos.waitUntilVisible();
            this.getDriver().switchTo().frame((WebElement)ckEditorFrameKudos);
        }, () -> {
            this.getDriver().switchTo().defaultContent();
            this.waitFor(500).milliseconds();
        });
        try {
            TextBoxElementFacade kudosFieldElement = this.kudosFieldElement();
            kudosFieldElement.waitUntilVisible();
            kudosFieldElement.setTextValue(kudosMessage);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.getDriver().switchTo().defaultContent();
        ElementFacade kudosButtonInDrawerElement = this.kudosButtonInDrawerElement();
        kudosButtonInDrawerElement.assertVisible();
        kudosButtonInDrawerElement.click();
        kudosButtonInDrawerElement.waitUntilNotVisible();
        Utils.refreshPage();
    }

    public void enterKudosMessageFromOpenedDrawer(String kudosMessage) {
        this.waitForDrawerToOpen(ACTIVITY_KUDOS_DRAWER_SELECTOR, false);
        this.waitCKEditorLoading(ACTIVITY_KUDOS_DRAWER_SELECTOR);
        Utils.retryOnCondition(() -> {
            ElementFacade ckEditorFrameKudos = this.getCkEditorFrameKudos();
            ckEditorFrameKudos.waitUntilVisible();
            this.getDriver().switchTo().frame((WebElement)ckEditorFrameKudos);
        }, () -> {
            this.getDriver().switchTo().defaultContent();
            this.waitFor(500).milliseconds();
        });
        try {
            TextBoxElementFacade kudosFieldElement = this.kudosFieldElement();
            kudosFieldElement.waitUntilVisible();
            kudosFieldElement.setTextValue(kudosMessage);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.getDriver().switchTo().defaultContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKudosMessageWithReceiverFromOpenedDrawer(String kudosMessage, String kudosReceiver) {
        this.waitForDrawerToOpen(ACTIVITY_KUDOS_DRAWER_SELECTOR, false);
        this.waitCKEditorLoading(ACTIVITY_KUDOS_DRAWER_SELECTOR);
        this.mentionInField(this.kudosReceiverField(), kudosReceiver, 5);
        Utils.retryOnCondition(() -> {
            ElementFacade ckEditorFrameKudos = this.getCkEditorFrameKudos();
            ckEditorFrameKudos.waitUntilVisible();
            this.getDriver().switchTo().frame((WebElement)ckEditorFrameKudos);
        }, () -> {
            this.getDriver().switchTo().defaultContent();
            this.waitFor(500).milliseconds();
        });
        try {
            TextBoxElementFacade kudosFieldElement = this.kudosFieldElement();
            kudosFieldElement.waitUntilVisible();
            kudosFieldElement.setTextValue(kudosMessage);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.getDriver().switchTo().defaultContent();
        ElementFacade kudosButtonInDrawerElement = this.kudosButtonInDrawerElement();
        kudosButtonInDrawerElement.assertVisible();
        kudosButtonInDrawerElement.click();
        kudosButtonInDrawerElement.waitUntilNotVisible();
        Utils.refreshPage();
    }

    public void userCardSendKudos() {
        ElementFacade sendKudosMenuElement = this.sendKudosMenuElement();
        sendKudosMenuElement.assertVisible();
        sendKudosMenuElement.click();
    }

    public void checkCancelKudosActivityIsNotVisible(String kudos) {
        this.getCancelKudosActivityIcon(kudos).assertNotVisible();
        this.closeMenu();
    }

    public void checkCancelKudosCommentIsNotVisible(String kudos) {
        this.getCancelKudosCommentIcon(kudos).assertNotVisible();
        this.closeMenu();
    }

    public void checkDeleteKudosCommentIsNotVisible(String kudos) {
        this.getDeleteCommentIcon(kudos).assertNotVisible();
        this.closeMenu();
    }

    public void checkDeleteKudosCommentIsVisible(String kudos) {
        this.getDeleteCommentIcon(kudos).assertVisible();
        this.closeMenu();
    }

    private ElementFacade addministrationMenuElement() {
        return this.findByXPathOrCSS("//*[@id='AdministrationHamburgerNavigation']//*[contains(@class,'fa fa-arrow')]");
    }

    private ElementFacade administrationIconElement() {
        return this.findByXPathOrCSS("//*[@id='AdministrationHamburgerNavigation']//*[contains(@class,'titleIcon')]");
    }

    private TextBoxElementFacade userKudosInputElement() {
        return this.findTextBoxByXPathOrCSS(".v-navigation-drawer--open .user-suggester input");
    }

    private ButtonElementFacade deleteUserFromKudosButtonElement() {
        return this.findButtonByXPathOrCSS(".v-navigation-drawer--open .user-suggester button");
    }

    private ElementFacade displayedPeriodTypeElement() {
        return this.findByXPathOrCSS("(//*[@class='v-select__selections'])[1]");
    }

    private TextBoxElementFacade dotsMenuElement() {
        return this.findTextBoxByXPathOrCSS("(//i[@class='v-icon notranslate icon-default-color fas fa-ellipsis-v theme--light'])[1]");
    }

    private ElementFacade editButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'contentBox')]//*[contains(@class, 'v-menu')]//*[contains(@class,'fa-edit')]");
    }

    private ElementFacade editKudosCommentElement() {
        return this.findByXPathOrCSS("//*[@class='v-list-item__title pl-3' and contains(text(),'Edit')]");
    }

    private ElementFacade getCkEditorFrameKudos() {
        return this.findByXPathOrCSS("//*[@id='activityKudosDrawer' and contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private ElementFacade getKudosActivityText(String message) {
        return this.findByXPathOrCSS(String.format("//div[contains(@class,'activity-detail')]//descendant::*[contains(text(),'%s')]", message));
    }

    private ElementFacade getKudosLink(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'activity-detail')]//child::button[contains(@id, 'KudosActivity')]", activity));
    }

    private ElementFacade kudosButtonInDrawerElement() {
        return this.findByXPathOrCSS("//*[@id = 'activityKudosDrawer']//*[contains(@class, 'drawerFooter')]//button[contains(@class, 'btn-primary')]");
    }

    private TextBoxElementFacade kudosFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable')]");
    }

    private ElementFacade kudosLinkElement() {
        return this.findByXPathOrCSS("//a[@href='/portal/g/:platform:rewarding/rewardAdministration/kudosAdministration']");
    }

    private TextBoxElementFacade kudosNumberElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='kudosPerPeriod']");
    }

    private ElementFacade menuBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerNavigationMenuLink')]");
    }

    private ElementFacade periodTypeElement() {
        return this.findByXPathOrCSS("//i[@class='v-icon notranslate mdi mdi-menu-down theme--light']");
    }

    private ElementFacade saveBtnElement() {
        return this.findByXPathOrCSS("//button[@class='btn btn-primary ignore-vuetify-classes mb-3']");
    }

    private TextBoxElementFacade kudosReceiverField() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class,'user-suggester')]//input[@type = 'text']");
    }

    private ElementFacade semesterPeriodElement() {
        return this.findByXPathOrCSS("//*[contains(text(),'Semester')]");
    }

    private ElementFacade sendKudosMenuElement() {
        return this.findByXPathOrCSS("//div[contains(@id, 'peopleCard')]//*[contains(@class, 'fa-award')]//ancestor::button");
    }

    private ElementFacade threedotsKudosCommentElement() {
        return this.findByXPathOrCSS("(//*[@class='flex-grow-1 flex-shrink-1 overflow-hidden']//*[@class='v-icon notranslate primary--text mdi mdi-dots-vertical theme--light'])[2]");
    }

    private ElementFacade threedotsKudosReplyCommentElement() {
        return this.findByXPathOrCSS("(//*[@class='flex-grow-1 flex-shrink-1 overflow-hidden']//*[@class='v-icon notranslate primary--text mdi mdi-dots-vertical theme--light'])[3]");
    }

    private ElementFacade getCancelKudosActivityIcon(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'activity-detail')]//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'undo')]", activity));
    }

    private ElementFacade getCancelKudosCommentIcon(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'ActivityComm')]//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'undo')]", comment));
    }

    private ElementFacade getDeleteCommentIcon(String comment) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]//ancestor::*[contains(@id, 'ActivityComm')]//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'fa-trash')]", comment));
    }

    public void clickOnKudosButtonFromOpenedUserPopover() {
        ButtonElementFacade kudosButton = this.findButtonByXPathOrCSS("div[id*='popover-action']:first-child button");
        kudosButton.click();
    }
}

