/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class ManageBadgesPage
extends GenericPage {
    public void addBadgeDescription(String description) {
        this.badgeDescriptionElement().setTextValue(description);
    }

    public void addBadgeDomain(String domain) {
        this.selectBadgeDomainElement().selectByVisibleText(domain);
    }

    public void addBadgeIcon(String icon) {
        WebElement elem = this.getDriver().findElement(By.xpath((String)"//input[@id='iconInput']"));
        String js = "arguments[0].style.height='auto'; arguments[0].style.visibility='visible';";
        ((JavascriptExecutor)this.getDriver()).executeScript(js, new Object[]{elem});
        this.upload(UPLOAD_DIRECTORY_PATH + icon).fromLocalMachine().to(elem);
    }

    public void addBadgeName(String name) {
        this.badgeNameElement().setTextValue(name);
    }

    public void addBadgeScore(String score) {
        this.badgeScoreElement().setTextValue(score);
    }

    public void clickOnAddBadge() {
        this.addBadgeBtnElement().click();
    }

    public void clickOnDeleteBadge(String badgeName) {
        this.getBadgeDeleteButton(badgeName).click();
    }

    public void clickOnEditBadge(String badgeName) {
        this.getBadgeEditButton(badgeName).click();
    }

    public void confirmAdditionNewBadge() {
        this.confirmAddBadgeBtnElement().click();
    }

    public void confirmDeletionBadge() {
        ElementFacade confirmDeleteBadgeBtnElement = this.confirmDeleteBadgeBtnElement();
        confirmDeleteBadgeBtnElement.waitUntilClickable();
        confirmDeleteBadgeBtnElement.click();
    }

    public void confirmEditBadge() {
        this.confirmEditBadgeBtnElement().click();
    }

    public void editBadgeDescription(String description) {
        TextBoxElementFacade editBadgeDescriptionElement = this.editBadgeDescriptionElement();
        editBadgeDescriptionElement.clear();
        editBadgeDescriptionElement.setTextValue(description);
    }

    public void editBadgeDomain(String domain) {
        TextBoxElementFacade editSelectBadgeDomainElement = this.editSelectBadgeDomainElement();
        editSelectBadgeDomainElement.selectByVisibleText(domain);
    }

    public void editBadgeName(String name) {
        TextBoxElementFacade editBadgeNameElement = this.editBadgeNameElement();
        editBadgeNameElement.clear();
        editBadgeNameElement.setTextValue(name);
    }

    public void editBadgeScore(String score) {
        TextBoxElementFacade editBadgeScoreElement = this.editBadgeScoreElement();
        editBadgeScoreElement.clear();
        editBadgeScoreElement.setTextValue(score);
    }

    public void fillForm(String name, String description, String score, String icon, String domain) {
        this.closeFormBtnElement().waitUntilVisible();
        this.addBadgeName(name);
        this.addBadgeDescription(description);
        this.addBadgeScore(score);
        this.addBadgeIcon(icon);
        this.addBadgeDomain(domain);
    }

    public void goToManageBadgesMenu() {
        this.menuBtnElement().click();
        this.adminIconElement().hover();
        ElementFacade adminBtnElement = this.adminBtnElement();
        adminBtnElement.waitUntilVisible();
        adminBtnElement.click();
        this.badgeLinkElement().click();
    }

    public void insertBadgeNameInSearchField(String badgeName) {
        TextBoxElementFacade searchBadgeInputElement = this.searchBadgeInputElement();
        searchBadgeInputElement.waitUntilVisible();
        if (searchBadgeInputElement.isNotVisible()) {
            Utils.refreshPage();
        }
        searchBadgeInputElement = this.searchBadgeInputElement();
        searchBadgeInputElement.waitUntilVisible();
        searchBadgeInputElement.setTextValue(badgeName);
        this.waitForSearchToLoad();
    }

    public void isBadgeDisplayedWithEnabledStatus(String badgeName, String badgeDescription, String badgeScore, String badgeDomain) {
        ElementFacade badgeElement = this.getBadgeNameInListOfBadges(badgeName, badgeDescription, badgeScore, badgeDomain);
        badgeElement.assertVisible();
        Assert.assertTrue((boolean)badgeElement.getText().contains("Yes"));
    }

    public void isBadgeNotDisplayedWithEnabledStatus(String badgeName, String badgeDescription, String badgeScore, String badgeDomain) {
        ElementFacade badgeElement = this.getBadgeNameInListOfBadges(badgeName, badgeDescription, badgeScore, badgeDomain);
        badgeElement.assertNotVisible();
    }

    public void isSuccessAlertDisplayed(String message) {
        this.successAlertElement().assertVisible();
        Assert.assertTrue((boolean)this.successAlertElement().getText().contains(message));
    }

    private ElementFacade addBadgeBtnElement() {
        return this.findByXPathOrCSS("//button[@class='btn btn-primary']");
    }

    private ElementFacade adminBtnElement() {
        return this.findByXPathOrCSS("//*[@id='AdministrationHamburgerNavigation']//*[contains(@class,'fa fa-arrow')]");
    }

    private ElementFacade adminIconElement() {
        return this.findByXPathOrCSS("//*[@id='AdministrationHamburgerNavigation']//*[contains(@class,'titleIcon')]");
    }

    private TextBoxElementFacade badgeDescriptionElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='badgeDescription'])[1]");
    }

    private ElementFacade badgeLinkElement() {
        return this.findByXPathOrCSS("//a[@href='/portal/g/:platform:administrators/gamification/badges']");
    }

    private TextBoxElementFacade badgeNameElement() {
        return this.findTextBoxByXPathOrCSS("(//input[@id='titleInput'])[1]");
    }

    private TextBoxElementFacade badgeScoreElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='neededScoreInput'])[1]");
    }

    private ElementFacade closeFormBtnElement() {
        return this.findByXPathOrCSS("//a[@class='uiIconClose pull-right']");
    }

    private ElementFacade confirmAddBadgeBtnElement() {
        return this.findByXPathOrCSS("(//button[@class='btn-primary pull-right'])[1]");
    }

    private ElementFacade confirmDeleteBadgeBtnElement() {
        return this.findByXPathOrCSS("(//button[@class='btn-primary pull-right'])[3]");
    }

    private ElementFacade confirmEditBadgeBtnElement() {
        return this.findByXPathOrCSS("(//button[@class='btn-primary pull-right'])[2]");
    }

    private TextBoxElementFacade editBadgeDescriptionElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='badgeDescription'])[2]");
    }

    private TextBoxElementFacade editBadgeNameElement() {
        return this.findTextBoxByXPathOrCSS("(//input[@id='titleInput'])[2]");
    }

    private TextBoxElementFacade editBadgeScoreElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='neededScoreInput'])[2]");
    }

    private TextBoxElementFacade editSelectBadgeDomainElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='domainSelectboxGroup']//select)[2]");
    }

    private ElementFacade getBadgeDeleteButton(String badgeName) {
        return this.findByXPathOrCSS(String.format("//*[@id='iconInputGroup']//img/following::*[@class='badge-title-col']/div[contains(text(),'%s')]/following::*[@class='uiIconDelete uiIconLightGray'][1]", badgeName));
    }

    private ElementFacade getBadgeEditButton(String badgeName) {
        return this.findByXPathOrCSS(String.format("//*[@id='iconInputGroup']//img/following::*[@class='badge-title-col']/div[contains(text(),'%s')]/following::*[@class='uiIconEdit uiIconLightGray'][1]", badgeName));
    }

    private ElementFacade getBadgeNameInListOfBadges(String badgeName, String badgeDescription, String badgeScore, String badgeDomain) {
        return this.findByXPathOrCSS(String.format("//*[@id='iconInputGroup']//img/following::*[@class='badge-title-col']/div[contains(text(),'%s')]/following::*[@class='badge-desc-col']/div[contains(text(),'%s')]/following::*[@class='badge-needed-score-col']/div/div[contains(text(),'%s')]/following::*[contains(text(),'%s')]/following::*[@class='badge-status-col']//*[@class='slider round']", badgeName, badgeDescription, badgeScore, badgeDomain));
    }

    private ElementFacade menuBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'HamburgerNavigationMenuLink')]");
    }

    private TextBoxElementFacade searchBadgeInputElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='keyword']");
    }

    private TextBoxElementFacade selectBadgeDomainElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@id='domainSelectboxGroup']//select)[1]");
    }

    private ElementFacade successAlertElement() {
        return this.findByXPathOrCSS("//*[@class='alert alert-success']");
    }

    private void waitForSearchToLoad() {
        this.findByXPathOrCSS("(//*[contains(@class, 'badge-table')]//tr)[3]").waitUntilNotVisible();
    }
}

