/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ButtonElementFacade;
import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.pages.SpacePage;
import io.meeds.qa.ui.utils.Utils;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ManageSpacesPage
extends GenericPage {
    private SpacePage spaceHomePage;

    public ManageSpacesPage(WebDriver driver) {
        super(driver);
    }

    public void addUserToSpace(String user) {
        this.spaceMembersTabElement().click();
        ElementFacade inviteUserButtonElement = this.inviteUserButton();
        inviteUserButtonElement.waitUntilVisible();
        ElementFacade memberCard = this.findByXPathOrCSS(String.format("//*[contains(@class, 'userFullname') and contains(text(), '%s')]", user));
        if (memberCard.isPresent()) {
            this.spaceHomePage.removeMember(user);
        }
        inviteUserButtonElement.click();
        this.inviteUserToSpace(user);
        this.inviteUserButtonDrawerElement().click();
    }

    public void checkAvatarSection() {
        this.avatarSectionElement().assertVisible();
    }

    public void checkCancelButton() {
        this.cancelButtonElement().assertVisible();
    }

    public void checkDescriptionSpaceSection() {
        this.ckEditorDescription().assertVisible();
    }

    public void checkFavIconInSpaceCard() {
        this.findByXPathOrCSS("//*[@id = 'spacesListBody']//*[contains(@class,'fa-star')]").assertVisible();
    }

    public void checkFavIconInSpacePopoverFromTopbar() {
        this.findByXPathOrCSS("//*[contains(@class,'v-card')]//*[contains(@class,'fa-star')]").assertVisible();
    }

    public void checkFavIconInThirdNavigationLevel() {
        this.findByXPathOrCSS("//*[contains(@class,'HamburgerMenuThirdLevelParent')]//*[contains(@class,'fa-star')]").assertVisible();
    }

    public void checkSpaceBookmarkStatusFromSpaceCard(boolean shouldBeBookmarked) {
        if (shouldBeBookmarked) {
            this.findByXPathOrCSS("//*[@id = 'spacesListBody']//*[contains(@class,'fas fa-star')]").assertVisible();
        } else {
            this.findByXPathOrCSS("//*[@id = 'spacesListBody']//*[contains(@class,'far fa-star')]").assertVisible();
        }
    }

    public void checkSpaceBookmarkStatusFromThirdNavigationLevel(boolean shouldBeBookmarked) {
        if (shouldBeBookmarked) {
            this.findByXPathOrCSS("//*[contains(@class,'HamburgerMenuThirdLevelParent')]//*[contains(@class,'fas fa-star')]").assertVisible();
        } else {
            this.findByXPathOrCSS("//*[contains(@class,'HamburgerMenuThirdLevelParent')]//*[contains(@class,'far fa-star')]").assertVisible();
        }
    }

    public void checkSpaceBookmarkStatusFromTopbarSpacePopover(boolean shouldBeBookmarked) {
        if (shouldBeBookmarked) {
            this.findByXPathOrCSS("//*[contains(@class,'v-card')]//*[contains(@class,'fas fa-star')]").assertVisible();
        } else {
            this.findByXPathOrCSS("//*[contains(@class,'v-card')]//*[contains(@class,'far fa-star')]").assertVisible();
        }
    }

    public void checkSpaceRegistration(String registration) {
        switch (registration) {
            case "Open": {
                this.openRadioBtnElement().click();
                break;
            }
            case "Validation": {
                this.validationRadioBtnElement().click();
                break;
            }
            case "Closed": {
                this.closedRadioBtnElement().click();
                break;
            }
        }
    }

    public void checkThatSpaceDetailsInSearchResultsAreDisplayed(String spaceName, String members) {
        this.spaceSearchDetailsAvatarElement(spaceName).assertVisible();
        this.spaceSearchDetailsInfoElement(spaceName).assertVisible();
        this.spaceThreeDotsButtonElement(spaceName).assertVisible();
        this.spaceSearchDetailsSpaceName(spaceName).assertVisible();
        this.spaceSearchDetailsSpaceMembers(members).assertVisible();
    }

    public void checkThatSpaceDetailsInSearchResultsAreDisplayedByOtherUser(String spaceName, String members) {
        this.spaceSearchDetailsAvatarElement(spaceName).assertVisible();
        this.spaceSearchDetailsInfoElement(spaceName).assertVisible();
        this.spaceSearchDetailsSpaceName(spaceName).assertVisible();
        this.spaceSearchDetailsSpaceMembers(members).assertVisible();
    }

    public void checkThatSpaceInSearchResultsIsNotDisplayed(String spaceName) {
        this.spaceSearchDetailsSpaceName(spaceName).assertNotVisible();
    }

    public void checkThatSpaceTopBarElementsAreDisplayed() {
        this.spaceMenuItemElement().assertVisible();
    }

    public void saveSpace() {
        this.clickDrawerButton("Create");
        this.waitForDrawerToClose();
        Utils.waitForLoading();
        Assertions.assertThat((String)this.getCurrentUrl()).contains(new CharSequence[]{"/g/"});
    }

    public void clickNextButton() {
        this.clickDrawerButton("Next");
    }

    public void clickOnGeneralSpaceSettings() {
        this.editIconOfGeneralSpaceSettingsElement().click();
    }

    public void clickOnSpaceBookmarkIconFromSpaceCard() {
        this.findByXPathOrCSS("//*[@id = 'spacesListBody']//*[contains(@class,'fa-star')]").click();
    }

    public void clickOnSpaceBookmarkIconFromThirdNavigationLevel() {
        this.findByXPathOrCSS("//*[contains(@class,'HamburgerMenuThirdLevelParent')]//*[contains(@class,'fa-star')]").click();
    }

    public void clickOnSpaceBookmarkIconFromTopbarSpacePopover() {
        this.findByXPathOrCSS("//*[contains(@class,'v-card')]//*[contains(@class,'fa-star')]").click();
    }

    public void clickSpaceAction(String action) {
        ElementFacade spaceFirstNavigationTab = this.getSpaceFirstNavigationTab();
        if (spaceFirstNavigationTab.isPresent()) {
            this.clickOnElement(spaceFirstNavigationTab);
        } else {
            ElementFacade spaceAction = this.getSpaceAction(action);
            if (spaceAction != null) {
                this.clickOnElement(spaceAction);
            }
        }
    }

    public boolean clickSpaceActionToJoin() {
        ElementFacade spaceAction = this.getSpaceAction("Join");
        if (spaceAction != null) {
            spaceAction.click();
            this.waitFor(50).milliseconds();
            this.verifyPageLoaded();
            return true;
        }
        spaceAction = this.getSpaceAction("Accept");
        if (spaceAction != null) {
            spaceAction.click();
            this.waitFor(50).milliseconds();
            this.verifyPageLoaded();
            return true;
        }
        return false;
    }

    public void deleteSpace(String spaceName) {
        this.insertSpaceNameInSearchField(spaceName);
        this.getSpaceMenu(spaceName).click();
        this.getDeleteSpaceButton(spaceName).click();
        TextBoxElementFacade okButtonElement = this.okButtonElement();
        okButtonElement.click();
        okButtonElement.waitUntilNotVisible();
    }

    public void goToMembersTab() {
        this.spaceHomePage.goToSpecificTab("More/Members");
    }

    public void goToSettingsTab() {
        this.spaceHomePage.goToSpecificTab("More/Settings");
    }

    public void goToTasksTab() {
        this.spaceHomePage.goToSpecificTab("Tasks");
    }

    public void goToSpaceHomeViaSpaceAvatar() {
        this.spaceAvatarElement().click();
    }

    public void goToSpecificSpace(String spaceName) {
        this.getSpaceNameInListOfSpace(spaceName).click();
        Utils.waitForPageLoading();
    }

    public void hoverOnSpaceName() {
        this.spaceName().hover();
    }

    public void insertSpaceNameInSearchField(String spaceName) {
        this.openAdvancedSpacesFilterToolbar();
        TextBoxElementFacade searchSpaceInputElement = this.searchSpaceInputElement();
        searchSpaceInputElement.waitUntilVisible();
        searchSpaceInputElement.setTextValue(spaceName);
        this.waitFor(200).milliseconds();
        this.waitForProgressBar();
    }

    public void leaveSpace() {
        if (this.spaceLeaveButtonElement().isVisible()) {
            this.spaceLeaveButtonElement().click();
        } else {
            this.spaceThreeDotsButtonElement().click();
            this.spaceLeaveMenuItem().click();
        }
        this.waitFor(200).milliseconds();
        this.clickToConfirmDialog();
        this.waitFor(200).milliseconds();
    }

    public void inviteUserToSpace(String user) {
        if (this.inviteUserInputElement().isCurrentlyVisible()) {
            this.mentionInField(this.inviteUserInputElement(), user, 5);
        } else if (this.inviteMembersButton().isVisible()) {
            this.inviteMembersButton().click();
            this.waitForDrawerToOpen();
            this.mentionInField(this.memberIdentitySuggesterInput(), user, 5);
            this.clickDrawerButton("Add");
            this.waitForDrawerToClose();
        } else if (this.memberIdentitySuggesterInput().isCurrentlyVisible()) {
            this.mentionInField(this.memberIdentitySuggesterInput(), user, 5);
        } else {
            throw new IllegalStateException("No invitation input was found");
        }
    }

    public boolean isLoadMoreButtonPresent() {
        return this.findByXPathOrCSS("#spacesListFooter .loadMoreButton").isPresent();
    }

    public boolean isSpaceCardDisplayed(String space, boolean mandatory) {
        try {
            ElementFacade webElementFacade = this.findByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]", space));
            if (mandatory) {
                webElementFacade.checkVisible();
                return true;
            }
            return webElementFacade.isCurrentlyVisible();
        }
        catch (RuntimeException e) {
            if (mandatory) {
                throw e;
            }
            return false;
        }
    }

    public boolean isSpaceCardJoinButtonDisplayed(String space) {
        try {
            ElementFacade webElementFacade = this.findByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//*[contains(text(), 'Join')]//ancestor::button", space));
            return webElementFacade.isCurrentlyVisible();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isSpaceMenuDisplayed() {
        try {
            ElementFacade webElementFacade = this.findByXPathOrCSS("#topBarMenu .v-tab--active");
            return webElementFacade.isCurrentlyVisible();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isSpacePageOpened(String space) {
        return this.getSpaceElement(space).isVisible();
    }

    public void joinSpaceFromCard(String space) {
        ElementFacade webElementFacade = this.findByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//*[contains(text(), 'Join')]//ancestor::button", space));
        webElementFacade.click();
    }

    public void openSpaceFormDrawer() {
        if (this.applicationToolbarCollpseButton().isCurrentlyEnabled()) {
            this.applicationToolbarCollpseButton().click();
            this.waitFor(200).milliseconds();
        }
        this.addNewSpaceButtonElement().click();
        this.waitForDrawerToOpen();
        this.waitFor(200).milliseconds();
        this.defaultSpaceTemplateInSpaceFormElement().click();
        this.waitFor(200).milliseconds();
    }

    private ButtonElementFacade defaultSpaceTemplateInSpaceFormElement() {
        return this.findButtonByXPathOrCSS(String.format("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), '%s')]", "000 Automatic Test Template"));
    }

    private ElementFacade inviteMembersButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Invite Members')]");
    }

    public void selectFilter(String filter) {
        ElementFacade selectSpaceFilterElement = this.selectSpaceFilterElement();
        if (filter.equals("My spaces")) {
            selectSpaceFilterElement.select().byValue("member");
        } else {
            selectSpaceFilterElement.select().byValue("all");
        }
    }

    public void setSpaceName(String spaceName) {
        this.spaceNameInputElement().setTextValue(spaceName);
    }

    public void setSpaceDescription(String spaceDescription) {
        this.waitForDrawerToOpen("//*[contains(@class, 'v-navigation-drawer--open')]", false);
        this.waitCKEditorLoading("//*[contains(@class, 'v-navigation-drawer--open')]");
        Utils.retryOnCondition(() -> {
            ElementFacade ckEditorFrameKudos = this.ckEditorDescription();
            ckEditorFrameKudos.waitUntilVisible();
            this.getDriver().switchTo().frame((WebElement)ckEditorFrameKudos);
        }, () -> {
            this.getDriver().switchTo().defaultContent();
            this.waitFor(500).milliseconds();
        });
        try {
            TextBoxElementFacade kudosFieldElement = this.ckEditorDescriptionElement();
            kudosFieldElement.waitUntilVisible();
            kudosFieldElement.setTextValue(spaceDescription);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.getDriver().switchTo().defaultContent();
    }

    public void showMoreSpaces() {
        this.spacesPageElement().scrollDown();
        this.showMoreButtonElement().click();
    }

    public void spaceAvatarIsDisplayed() {
        this.spaceAvatarElement().assertVisible();
    }

    public void spaceNameIsDisplayed(String space) {
        this.spaceName(space).assertVisible();
    }

    public void uploadSpaceBanner(String fileName) {
        this.spaceBannerButton().click();
        this.uploadSpaceBannerButtonElement().click();
        ElementFacade fileInput = this.findByXPathOrCSS(".v-navigation-drawer--open input[type=file]");
        this.upload(UPLOAD_DIRECTORY_PATH + fileName).fromLocalMachine().to((WebElement)fileInput);
        this.waitForProgressBar();
        ElementFacade imageApplyButton = this.findByXPathOrCSS("#imageCropDrawerApply");
        imageApplyButton.click();
        this.spaceBannerResetButton().assertVisible();
    }

    public void openSpaceInvitationDrawer() {
        this.inviteUserButton().click();
        this.findByXPathOrCSS("#InvitePlatformUserToSpaceButton").click();
        this.waitForDrawerToOpen();
    }

    public void openSpaceExternalInvitationDrawer() {
        this.inviteUserButton().click();
        this.findByXPathOrCSS("#InviteUserByEmailToSpaceButton").click();
        this.waitForDrawerToOpen();
    }

    public void inviteEmailAsSpaceMember(String email) {
        this.inviteEmailAsSpaceMemberInput().setTextValue(email);
        this.inviteEmailAsSpaceMemberInput().sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public void emailIsListedInInvitationList(String email, String status) {
        this.inviteEmailStatusElement(email, status).assertVisible();
    }

    public void emailIsNotListedInInvitationList(String email) {
        this.inviteEmailStatusElement(email).assertNotVisible();
    }

    public void openSpacePendingInvitationsDrawer() {
        this.findByXPathOrCSS("#SpacePendingUsersButton").click();
    }

    public void openSpaceExternalInvitationsTab() {
        this.findByXPathOrCSS("[tab-value='external']").click();
    }

    public void checkExternalInviteButtonNotDisplayed() {
        this.inviteUserButton().assertNotVisible();
        this.invitePlatformUserButton().assertVisible();
    }

    private ElementFacade applicationToolbarCollpseButton() {
        return this.findByXPathOrCSS("#applicationToolbarRight .fa-arrow-left");
    }

    private ElementFacade invitePlatformUserButton() {
        return this.findByXPathOrCSS("#spaceSettingUsersListToolbar");
    }

    private ElementFacade addNewSpaceButtonElement() {
        return this.findByXPathOrCSS("#addNewSpaceButton");
    }

    private ElementFacade avatarSectionElement() {
        return this.findByXPathOrCSS("//*[@class='v-avatar spaceAvatar mx-auto mb-6 mt-2 rounded-0 spaceAvatarHoverEdit']");
    }

    private ElementFacade cancelButtonElement() {
        return this.findByXPathOrCSS("//button[@class='btn me-2 v-btn v-btn--contained theme--light v-size--default']");
    }

    private ElementFacade closedRadioBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-radio')])[3]");
    }

    private ElementFacade editIconOfGeneralSpaceSettingsElement() {
        return this.findByXPathOrCSS("//*[contains(text(), 'General')]//ancestor::*[contains(@class, 'v-application')]//*[contains(@class, 'fa-edit')]");
    }

    private ElementFacade getDeleteSpaceButton(String spaceName) {
        return this.findByXPathOrCSS(String.format("//a[contains(@title,'%s')]//following::i[contains(@class,'uiIconTrash')]", spaceName));
    }

    private ElementFacade getSpaceAction(String action) {
        try {
            ElementFacade webElementFacade = this.findByXPathOrCSS(String.format("//*[@id = 'SpaceAccess']//button//*[contains(text(), '%s')]", action));
            return webElementFacade.isVisible() ? webElementFacade : null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public void openAdvancedSpacesFilterToolbar() {
        ButtonElementFacade spacesListFilterButton = this.spacesListFilterButton();
        if (spacesListFilterButton.isVisible()) {
            spacesListFilterButton.click();
            this.waitFor(200).milliseconds();
        }
    }

    public ButtonElementFacade spacesListFilterButton() {
        return this.findButtonByXPathOrCSS("#spacesListToolbar #applicationToolbarConeButton");
    }

    private ElementFacade getSpaceElement(String space) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'brandingContainer space')]//*[contains(text(),'%s')]", space));
    }

    private ElementFacade getSpaceFirstNavigationTab() {
        return this.findByXPathOrCSS("//*[contains(@class, 'spaceNavigationTab')]");
    }

    private ElementFacade getSpaceMenu(String spaceName) {
        return this.findByXPathOrCSS(String.format("//a[contains(@title,'%s')]/../..//button[contains(@class,'spaceMenuIcon')]", spaceName));
    }

    private ElementFacade getSpaceNameInListOfSpace(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]", spaceName));
    }

    private ElementFacade inviteUserButtonDrawerElement() {
        return this.findByXPathOrCSS("//*[@class='btn btn-primary v-btn v-btn--contained theme--light v-size--default']");
    }

    private ElementFacade inviteUserButton() {
        return this.findByXPathOrCSS("#InviteUserToSpaceButton");
    }

    private TextBoxElementFacade memberIdentitySuggesterInput() {
        return this.findTextBoxByXPathOrCSS(".v-navigation-drawer--open .identitySuggester input");
    }

    private TextBoxElementFacade inviteUserInputElement() {
        return this.findTextBoxByXPathOrCSS("(//div[@name='inviteMembers']//input)[1]");
    }

    private TextBoxElementFacade inviteEmailAsSpaceMemberInput() {
        return this.findTextBoxByXPathOrCSS("#spaceEmailInvitationDrawer [contenteditable=true]");
    }

    private ElementFacade inviteEmailStatusElement(String email, String status) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]/ancestor::*[contains(@class, 'v-list-item')]//*[contains(text(), '%s')]", email, status));
    }

    private ElementFacade inviteEmailStatusElement(String email) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s')]/ancestor::*[contains(@class, 'v-list-item')]", email));
    }

    private TextBoxElementFacade okButtonElement() {
        return this.findTextBoxByXPathOrCSS("//button[contains(text(),'OK')]");
    }

    private ElementFacade openRadioBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-radio')])[1]");
    }

    private TextBoxElementFacade searchSpaceInputElement() {
        return this.findTextBoxByXPathOrCSS("#spacesListToolbar #applicationToolbarFilterInput");
    }

    private ElementFacade selectSpaceFilterElement() {
        return this.findByXPathOrCSS("//select");
    }

    private ElementFacade showMoreButtonElement() {
        return this.findByXPathOrCSS("//*[@id='spacesListFooter']//button");
    }

    private ElementFacade spaceAvatarElement() {
        return this.findByXPathOrCSS("//*[@id='UserHomePortalLink']");
    }

    private TextBoxElementFacade spaceBannerButton() {
        return this.findTextBoxByXPathOrCSS("//*[@id='spaceBannerEditButton']");
    }

    private TextBoxElementFacade spaceBannerResetButton() {
        return this.findTextBoxByXPathOrCSS("//*[@id='spaceBannerDeleteButton']");
    }

    private ElementFacade spaceMembersTabElement() {
        return this.findByXPathOrCSS("(//a[contains(@href,'/members') and @tabindex='0'])");
    }

    private ElementFacade spaceMenuItemElement() {
        return this.findByXPathOrCSS("#topBarMenu .v-tabs-bar .v-tab");
    }

    private ElementFacade spaceName() {
        return this.findByXPathOrCSS("//*[contains(@class,'UITopBarContainerItem')]//*[contains(@class,'logoTitle')]");
    }

    private ElementFacade spaceName(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'brandingContainer')]//div[contains(text(),'%s')]", spaceName));
    }

    private TextBoxElementFacade spaceNameInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@name='name']");
    }

    private TextBoxElementFacade spaceSearchDetailsAvatarElement(String spaceName) {
        return this.findTextBoxByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//img[contains(@src,'/avatar')]", spaceName));
    }

    private TextBoxElementFacade spaceSearchDetailsInfoElement(String spaceName) {
        return this.findTextBoxByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//*[contains(text(),'Members')]", spaceName));
    }

    private TextBoxElementFacade spaceLeaveButtonElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//*[contains(text(),'Leave')]");
    }

    private TextBoxElementFacade spaceLeaveMenuItem() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'menuable__content__active')]//*[contains(@class, 'sign-out')]");
    }

    private TextBoxElementFacade spaceThreeDotsButtonElement(String spaceName) {
        return this.findTextBoxByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(), '%s')]//ancestor::a[@href]//*[contains(@class,'fa-ellipsis-v')]", spaceName));
    }

    private TextBoxElementFacade spaceThreeDotsButtonElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id = 'spacesListBody']//a[@href]//*[contains(@class,'fa-ellipsis-v')]");
    }

    private ElementFacade spaceSearchDetailsSpaceMembers(String members) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'spaceMembersLabel') and contains(text(),'%s')]", members));
    }

    private ElementFacade spaceSearchDetailsSpaceName(String spaceName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'spaceCardBody')]//a[contains(text(),'%s')]", spaceName));
    }

    private ElementFacade spacesPageElement() {
        return this.findByXPathOrCSS("//*[@id='UISiteBody']");
    }

    private TextBoxElementFacade uploadSpaceBannerButtonElement() {
        return this.findTextBoxByXPathOrCSS("#spaceBannerEditButton");
    }

    private ElementFacade validationRadioBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-radio')])[2]");
    }

    private ElementFacade ckEditorDescription() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//iframe[contains(@class,'cke_wysiwyg_frame')]");
    }

    private TextBoxElementFacade ckEditorDescriptionElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable')]");
    }
}

