/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public class NotificationSettingsPage
extends GenericPage {
    public NotificationSettingsPage(WebDriver driver) {
        super(driver);
    }

    public void disableEmailNotificationForAll() {
        this.emailNotifSwitchInput().assertEnabled();
        if (this.emailNotifSwitchInput().isSelected()) {
            this.emailNotifSwitch().click();
            this.waitFor(500).milliseconds();
            Utils.waitForLoading();
        }
    }

    public void enableEmailNotificationForAll() {
        this.emailNotifSwitchInput().assertEnabled();
        if (!this.emailNotifSwitchInput().isSelected()) {
            this.emailNotifSwitch().click();
            this.waitFor(500).milliseconds();
            Utils.waitForLoading();
        }
    }

    public void checkEmailNotificationIsHidden() {
        this.personalEmailSettingNotifSwitch().assertNotVisible();
    }

    public void checkEmailNotificationIsDisplayed() {
        this.personalEmailSettingNotifSwitch().assertVisible();
    }

    public void goToNotificationSettingDetails() {
        this.personalSettingNotificationDetailButton().click();
    }

    public void checkEmailNotificationIsHiddenForAllTypes() {
        this.personalSettingEmailNotificationElement().assertNotVisible();
    }

    public void disableEmailNotification(String notificationType) {
        this.personalSettingNotificationTypeButton(notificationType).click();
        this.waitForDrawerToOpen();
        if (this.emailNotifDrawerInput().isSelected()) {
            this.emailNotifDrawerSwitch().click();
            this.waitFor(500).milliseconds();
            this.clickDrawerButton("Apply");
            this.waitForDrawerToClose();
        }
    }

    public void enableEmailNotification(String notificationType) {
        this.personalSettingNotificationTypeButton(notificationType).click();
        this.waitForDrawerToOpen();
        if (!this.emailNotifDrawerInput().isSelected()) {
            this.emailNotifDrawerSwitch().click();
            this.waitFor(500).milliseconds();
            this.clickDrawerButton("Apply");
        }
    }

    public void checkEmailNotificationIsHiddenFor(String notificationType) {
        this.personalSettingEmailNotificationElement(notificationType).assertNotVisible();
    }

    public void checkEmailNotificationIsDisplayedFor(String notificationType) {
        this.personalSettingEmailNotificationElement(notificationType).assertVisible();
    }

    public void editNotificationSender() {
        this.editNotificationSenderButton().click();
    }

    public void setNotificationSenderInput(Map<String, String> values) {
        this.notificationSenderNameInput().setTextValue(values.get("name"));
        this.notificationSenderEmailInput().setTextValue(values.get("email"));
    }

    public void enablePersonalEmailNotification() {
        if (!this.personalEmailSettingNotifInput().isSelected()) {
            this.personalEmailSettingNotifSwitch().click();
            this.waitFor(500).milliseconds();
        }
    }

    private ElementFacade emailNotifDrawerSwitch() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'email') or contains(text(), 'Email')]/parent::*/parent::*//*[contains(@class, 'v-input--switch') and contains(@class, 'v-input--selection-controls')]");
    }

    private ElementFacade emailNotifDrawerInput() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'email') or contains(text(), 'Email')]/parent::*/parent::*//*[contains(@class, 'v-input--switch') and contains(@class, 'v-input--selection-controls')]//input");
    }

    private ElementFacade personalSettingNotificationDetailButton() {
        return this.findByXPathOrCSS("(//*[contains(text(), 'Manage notifications')]//ancestor::*[@role=\"listitem\"])[1]//button");
    }

    private ElementFacade personalSettingEmailNotificationElement() {
        return this.findByXPathOrCSS("//*[contains(text(), 'by email')]");
    }

    private ElementFacade personalEmailSettingNotifSwitch() {
        return this.findByXPathOrCSS("(//*[contains(text(), 'by email')]//ancestor::*[@role='listitem'])[1]//*[contains(@class, 'v-input--switch') and contains(@class, 'v-input--selection-controls')]");
    }

    private ElementFacade personalEmailSettingNotifInput() {
        return this.findByXPathOrCSS("(//*[contains(text(), 'by email')]//ancestor::*[@role='listitem'])[1]//*[contains(@class, 'v-input--switch') and contains(@class, 'v-input--selection-controls')]//input");
    }

    private ElementFacade personalSettingEmailNotificationElement(String notificationType) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'v-list-item')])[1]/parent::*//*[contains(text(), 'by email')]", notificationType));
    }

    private ElementFacade personalSettingNotificationTypeButton(String notificationType) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'v-list-item')])[1]//button", notificationType));
    }

    private ElementFacade editNotificationSenderButton() {
        return this.findByXPathOrCSS("(//*[contains(text(), 'Notification Sender')]/following::button)[1]");
    }

    private TextBoxElementFacade notificationSenderNameInput() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//input[@name='companyName']");
    }

    private TextBoxElementFacade notificationSenderEmailInput() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//input[@name='companyEmail']");
    }

    private ElementFacade emailNotifSwitch() {
        return this.findByXPathOrCSS("//*[contains(text(), 'mail')]//ancestor::*[contains(@class, 'v-input--switch')]");
    }

    private ElementFacade emailNotifSwitchInput() {
        return this.findByXPathOrCSS("//*[contains(text(), 'mail')]//ancestor::*[contains(@class, 'v-input--switch')]//input");
    }
}

