/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.ApplicationPage;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ProgramsPage
extends GenericPage {
    private static final boolean APPS_ACCESS_VIA_MENU = Boolean.parseBoolean(System.getProperty("io.meeds.engagementApps.useMenu", "true"));
    private static final String PROGRAM_OVERVIEW_PARENT_ITEM_PATH = "//*[@id='programsOverview']//*[contains(@class, 'v-avatar')]/parent::*/parent::*";
    private ApplicationPage applicationPage;

    public ProgramsPage(WebDriver driver) {
        super(driver);
    }

    public void saveProgram(String programName, String programDescription, String programAudience) {
        if (StringUtils.isNotBlank((CharSequence)programName)) {
            this.enterProgramTitle(programName);
        }
        if (StringUtils.isNotBlank((CharSequence)programAudience)) {
            this.enterProgramDescription(programDescription);
        }
        this.clickDrawerButton("Next");
        if (StringUtils.isNotBlank((CharSequence)programAudience)) {
            this.addSpaceAudience(programAudience);
        }
        this.saveButtonElement().click();
        this.waitForDrawerToClose();
        Utils.waitForLoading();
        this.waitFor(200).milliseconds();
    }

    public void enableDisableProgram() {
        this.programStatusSwitcher().click();
        Utils.waitForLoading();
        this.waitFor(200).milliseconds();
    }

    public void checkProgramStatusSwitchNotDisplayed() {
        this.programStatusSwitcher().assertNotVisible();
    }

    public void goBackUsingProgramTitle(String programName) {
        this.getProgramDetailTitle(programName).click();
    }

    public void addSpaceAudience(String randomSpaceName) {
        this.mentionInField(this.audienceSpaceFieldElement(), randomSpaceName, 5);
    }

    public void checkProgramCardDisplay(String title) {
        this.getProgramCardTitle(title).assertNotVisible();
    }

    public void checkProgramCardTitle(String title) {
        this.searchProgram(title);
        this.getProgramCardTitle(title).assertVisible();
    }

    public void checkProgramDrawerDisplay() {
        this.headerProgramDrawerElement().assertVisible();
    }

    public void clickAddProgramBtn() {
        this.clickOnElement(this.addProgramBtnElement());
    }

    public void clickSaveProgramButton() {
        this.createButtonElement().click();
        this.waitForDrawerToClose();
        Utils.waitForLoading();
        this.waitFor(200).milliseconds();
    }

    public void deleteCreatedProgram(String programName) {
        this.searchProgram(programName);
        this.getProgramCard(programName).assertVisible();
        this.programThreeDotsButtonElement(programName).click();
        this.deleteProgramButtonElement().click();
        this.yesConfirmButtonElement().click();
        Utils.waitForLoading();
    }

    public void editProgram() {
        this.programThreeDotsButtonElement().click();
        this.editProgramButtonElement().click();
    }

    public void editProgram(String programName) {
        this.searchProgram(programName);
        this.getProgramCard(programName).assertVisible();
        this.programThreeDotsButtonElement(programName).click();
        this.editActionMenuItem().click();
    }

    public void editProgramWithDescription(String programName, String newProgramName, String newProgramDescription) {
        this.searchProgram(programName);
        this.getProgramCard(programName).assertVisible();
        this.programThreeDotsButtonElement(programName).click();
        this.editProgramButtonElement().click();
        this.saveProgram(newProgramName, newProgramDescription, null);
    }

    public void enterProgramTitle(String programTitle) {
        this.programTitleFieldElement().setTextValue(programTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterProgramDescription(String programDescription) {
        this.waitDrawerCKEditorLoading();
        ElementFacade ckEditorFrameProgramElement = this.ckEditorFrameElement();
        ckEditorFrameProgramElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameProgramElement);
        try {
            TextBoxElementFacade programDescriptionFieldElement = this.programDescriptionFieldElement();
            programDescriptionFieldElement.waitUntilVisible();
            programDescriptionFieldElement.setTextValue(programDescription);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
    }

    public void selectEngagementApplication(String link) {
        if (APPS_ACCESS_VIA_MENU) {
            ElementFacade engagementApplicationLink = this.engagementApplicationLink(link);
            engagementApplicationLink.waitUntilVisible();
            engagementApplicationLink.click();
            Utils.waitForLoading();
            this.waitFor(300).milliseconds();
        } else {
            this.applicationPage.goToApplication("Contributions");
            if (!StringUtils.equals((CharSequence)link, (CharSequence)"programs")) {
                String currentUrl = this.getDriver().getCurrentUrl();
                this.getDriver().navigate().to(currentUrl + "/" + link);
            }
        }
    }

    public void selectProgramsFilter(String value) {
        this.programFilterDropdown().selectByValue(value);
        Utils.waitForLoading();
    }

    public void selectProgramActionsFilter(String value) {
        this.rulesStatusDropdown().selectByValue(value);
        Utils.waitForLoading();
    }

    public void openProgramCard(String title) {
        this.searchProgram(title);
        this.getProgramCard(title).click();
    }

    public void checkCannotAnnounceAction() {
        this.announceChallengeActionFromDrawer().assertNotVisible();
    }

    public void checkProgramActionNotContainsDurationLimitation() {
        this.daysLeftInfoFromDrawer().assertNotVisible();
    }

    public void checkProgramActionContainsDurationLimitation() {
        this.daysLeftInfoFromDrawer().assertVisible();
    }

    public void closeProgramCard() {
        this.closeProgramCardIcon().click();
    }

    public void editProgramAction(String actionTitle) {
        this.getActionItemElement(actionTitle).hover();
        this.actionMenuButton().click();
        this.editActionMenuItem().click();
    }

    public void enableProgramAction(String actionTitle) {
        this.getActionItemElement(actionTitle).hover();
        this.actionMenuButton().click();
        this.enableActionMenuItem().click();
    }

    public void disableProgramAction(String actionTitle) {
        this.getActionItemElement(actionTitle).hover();
        this.actionMenuButton().click();
        this.disableActionMenuItem().click();
    }

    public void deleteProgramAction(String actionTitle) {
        Utils.retryOnCondition(() -> {
            this.getActionItemElement(actionTitle).assertVisible();
            this.getActionItemElement(actionTitle).hover();
        });
        this.actionMenuButton().click();
        this.deleteActionMenuItem().click();
        this.clickToConfirmDialog();
    }

    public void announceAction(String actionTitle, String announcementMessage) {
        Utils.retryOnCondition(() -> {
            this.getActionItemElement(actionTitle).checkPresent();
            this.getActionItemElement(actionTitle).scrollToWebElement();
            this.getActionItemElement(actionTitle).checkVisible();
            this.getActionItemElement(actionTitle).hover();
            this.announceButton().checkVisible();
        });
        this.announceButton().click();
        this.sendAnnouncementMessage(announcementMessage);
    }

    public void announceActionFromActivity(String actionTitle, String announcementMessage) {
        this.activityAnnounceButton(actionTitle).click();
        this.sendAnnouncementMessage(announcementMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAnnouncementMessage(String announcementMessage) {
        ElementFacade ckEditorFrameAnnouncementElement = this.ckEditorFrameElement();
        ckEditorFrameAnnouncementElement.waitUntilVisible();
        this.getDriver().switchTo().frame((WebElement)ckEditorFrameAnnouncementElement);
        try {
            TextBoxElementFacade challengeAnnouncementFieldElement = this.challengeAnnouncementFieldElement();
            challengeAnnouncementFieldElement.waitUntilVisible();
            challengeAnnouncementFieldElement.setTextValue(announcementMessage);
        }
        finally {
            this.getDriver().switchTo().defaultContent();
        }
        this.saveButtonElement().click();
        this.waitForDrawerToClose();
    }

    public void checkProgramPositionInTopPrograms(String programName, int listPosition) {
        this.topProgramsElement(programName, listPosition).assertVisible();
    }

    public void checkProgramNotDisplayedInTopPrograms(String programName) {
        this.topProgramsElement(programName).assertNotVisible();
    }

    public void addProgramOwner(String firstName) {
        this.addProgramOwnerButton().click();
        this.mentionInField(this.programOwnerSuggester(), firstName, 5);
    }

    public void checkAdminActionsFilterIsDisplayed() {
        this.rulesAdminStatusDropdown().assertVisible();
    }

    public void checkMessageIsDisplayedInProgramDetailDrawer(String message) {
        this.messageElementInProgramDetailDrawer(message).assertVisible();
    }

    public void checkMessageIsNotDisplayedInProgramDetailDrawer(String message) {
        this.messageElementInProgramDetailDrawer(message).assertNotVisible();
    }

    public void checkAdminActionsFilterIsNotDisplayed() {
        this.rulesAdminStatusDropdown().assertNotVisible();
    }

    public void checkActionsFilterIsDisplayed() {
        this.rulesStatusDropdown().assertVisible();
    }

    public void attachAvatarToProgram() {
        this.attachAvatarButton().click();
        this.waitForDrawerToOpen();
        this.attachImageToOpenedDrawer();
    }

    public void attachCoverToProgram() {
        this.attachCoverButton().click();
        this.waitForDrawerToOpen();
        this.attachImageToOpenedDrawer();
    }

    public void deleteAvatarFromProgram() {
        this.deleteAvatarButton().click();
    }

    public void deleteCoverFromProgram() {
        this.deleteCoverButton().click();
    }

    public void checkProgramAvatarIsSpecificInDetail() {
        this.waitForAvatarBackgroundToLoad();
        ((AbstractStringAssert)Assertions.assertThat((String)this.avatarImageElement().getAttribute("style")).doesNotContain(new CharSequence[]{"default"})).as("Program Avatar should be specific", new Object[0]);
    }

    public void checkProgramAvatarIsDefaultInDetail() {
        this.waitForAvatarBackgroundToLoad();
        ((AbstractStringAssert)Assertions.assertThat((String)this.avatarImageElement().getAttribute("style")).contains(new CharSequence[]{"default"})).as("Program Avatar should be default", new Object[0]);
    }

    public void checkProgramCoverIsSpecificInDetail() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.coverImageElement().getAttribute("src")).doesNotContain(new CharSequence[]{"default"})).as("Program Cover should be specific", new Object[0]);
    }

    public void checkProgramCoverIsDefaultInDetail() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.coverImageElement().getAttribute("src")).contains(new CharSequence[]{"default"})).as("Program Cover should be default", new Object[0]);
    }

    public String getProgramTitleFromDrawer() {
        TextBoxElementFacade programTitleElement = this.programTitleFieldElement();
        return programTitleElement.isCurrentlyVisible() ? programTitleElement.getTextValue() : null;
    }

    private void searchProgram(String title) {
        String showMoreLabel;
        Utils.waitForLoading();
        String string = showMoreLabel = this.getLanguage().equals("fr") ? "Voir plus" : "Show More";
        while (this.getProgramCardTitle(title).isNotVisible() && this.getButton(showMoreLabel).isVisible()) {
            this.getButton(showMoreLabel).scrollToWebElement();
            this.getButton(showMoreLabel).click();
            this.waitFor(200).milliseconds();
            Utils.waitForLoading();
        }
    }

    private TextBoxElementFacade programOwnerSuggester() {
        return this.findTextBoxByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'assignChallengeMenu')]//*[contains(@class, 'identitySuggesterInputStyle')]//input[@type = 'text']");
    }

    private ElementFacade addProgramOwnerButton() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Add Owners')]");
    }

    private ElementFacade topProgramsElement(String programName, int listPosition) {
        return this.findByXPathOrCSS(String.format("(%s)[%s]//*[contains(text(), '%s')]", PROGRAM_OVERVIEW_PARENT_ITEM_PATH, listPosition, programName));
    }

    private ElementFacade topProgramsElement(String programName) {
        return this.findByXPathOrCSS(String.format("%s//*[contains(text(), '%s')]", PROGRAM_OVERVIEW_PARENT_ITEM_PATH, programName));
    }

    private ElementFacade addProgramBtnElement() {
        return this.findByXPathOrCSS("//*[contains(text(), 'Add campaign')]//ancestor::*[contains(@class, 'btn-primary')]");
    }

    private TextBoxElementFacade audienceSpaceFieldElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[@name='programSpaceAutocomplete']//input)[01]");
    }

    private ElementFacade ckEditorFrameElement() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open iframe.cke_wysiwyg_frame");
    }

    private ElementFacade createButtonElement() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open .drawerFooter button.btn-primary");
    }

    private ElementFacade programStatusSwitcher() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//input[@id='engagementCenterProgramDrawerSwitch']/parent::*[contains(@class, 'v-input--selection-controls__input')]");
    }

    private ElementFacade deleteProgramButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'fas fa-trash-alt')]");
    }

    private ElementFacade editProgramButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'fas fa-edit')]");
    }

    private ElementFacade engagementApplicationLink(String link) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class, 'topBarMenu')]//a[contains(@href, '%s')]", link));
    }

    private ElementFacade getProgramCard(String programName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'engagement-center-card')]//*[contains(text(),'%s')]", programName));
    }

    private ElementFacade getProgramCardTitle(String title) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class,'engagement-center-card')]", title));
    }

    private ElementFacade getProgramDetailTitle(String title) {
        return this.findByXPathOrCSS(String.format("//*[@id='engagementCenterProgramDetail']//*[contains(@class,'v-card')]//*[contains(text(),'%s')]", title));
    }

    private ElementFacade headerProgramDrawerElement() {
        return this.findByXPathOrCSS("//*[@id='EngagementCenterProgramDrawerForm']");
    }

    private TextBoxElementFacade programDescriptionFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private ElementFacade programThreeDotsButtonElement(String programName) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'engagement-center-card')]//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'engagement-center-card')]//*[contains(@class,'fa-ellipsis-v')]", programName));
    }

    private ElementFacade programThreeDotsButtonElement() {
        return this.findByXPathOrCSS("#engagementCenterProgramDetail .fa-ellipsis-v");
    }

    private TextBoxElementFacade programTitleFieldElement() {
        return this.findTextBoxByXPathOrCSS("//input[@name='programTitle']");
    }

    private ElementFacade saveButtonElement() {
        return this.findByXPathOrCSS(".v-navigation-drawer--open .drawerFooter button.btn-primary");
    }

    private ElementFacade yesConfirmButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__actions']//button[contains(@class,'btn btn-primary')]");
    }

    private ElementFacade getActionItemElement(String challengeTitle) {
        return this.findByXPathOrCSS(String.format("//ancestor::tbody//ancestor::*[contains(@title,'%s')]", challengeTitle));
    }

    private ElementFacade activityAnnounceButton(String ruleTitle) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class, 'activity-detail')]//*[contains(@class, 'activity-footer')]//*[contains(@class, 'bullhorn')]", ruleTitle));
    }

    private ElementFacade announceButton() {
        return this.findByXPathOrCSS("//*[@id = 'engagementCenterProgramDetail']//button//*[contains(@class, 'fa-bullhorn')]");
    }

    private ElementFacade actionMenuButton() {
        return this.findByXPathOrCSS("//*[@id = 'engagementCenterProgramDetail']//*[contains(@class, 'v-data-table')]//*[contains(@class, 'fa-ellipsis-v')]");
    }

    private ElementFacade editActionMenuItem() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-menu')]//*[contains(text(), 'Edit')]");
    }

    private ElementFacade enableActionMenuItem() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-menu')]//*[contains(text(), 'Enable')]");
    }

    private ElementFacade disableActionMenuItem() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-menu')]//*[contains(text(), 'Disable')]");
    }

    private ElementFacade deleteActionMenuItem() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-menu')]//*[contains(text(), 'Delete')]");
    }

    private ElementFacade closeProgramCardIcon() {
        return this.findByXPathOrCSS("//*[@id = 'engagementCenterProgramDetail']//*[contains(@class, 'fa-arrow-left')]");
    }

    private TextBoxElementFacade challengeAnnouncementFieldElement() {
        return this.findTextBoxByXPathOrCSS("//body[contains(@class,'cke_editable_themed')]");
    }

    private ElementFacade programFilterDropdown() {
        return this.findByXPathOrCSS("//*[@id='applicationToolbarFilterSelect']//option[@value='ALL']/parent::select");
    }

    private ElementFacade rulesStatusDropdown() {
        return this.findByXPathOrCSS("//*[@id='rulesStatusFilter']//option[@value='ALL']/parent::select");
    }

    private ElementFacade rulesAdminStatusDropdown() {
        return this.findByXPathOrCSS("//*[@id='rulesStatusFilter']//option[@value='DISABLED']/parent::select");
    }

    private ElementFacade announceChallengeActionFromDrawer() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Announce your achievement']");
    }

    private ElementFacade daysLeftInfoFromDrawer() {
        return this.findByXPathOrCSS("//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(text(), 'Ends in') or contains(text(), 'Available in')]");
    }

    private ElementFacade attachCoverButton() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'fa-file-image')])[1]");
    }

    private ElementFacade deleteCoverButton() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'fa-file-image')])[1]//ancestor::*[contains(@class, 'EngagementCenterImageSelector')]//i[contains(@class, 'delete')]");
    }

    private ElementFacade attachAvatarButton() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'fa-file-image')])[2]");
    }

    private ElementFacade deleteAvatarButton() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'fa-file-image')])[2]//ancestor::*[contains(@class, 'EngagementCenterImageSelector')]//i[contains(@class, 'delete')]");
    }

    private ElementFacade coverImageElement() {
        return this.findByXPathOrCSS("//*[@id='engagementCenterCoverImage']");
    }

    private ElementFacade avatarImageElement() {
        return this.findByXPathOrCSS(".rule-program-cover .v-image__image--cover");
    }

    private ElementFacade messageElementInProgramDetailDrawer(String message) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'engagementCenterProgramDetail' or contains(@class, 'layout-page-parent')]//*[contains(text(), '%s') and not (@role)]", message));
    }

    private void waitForAvatarBackgroundToLoad() {
        Utils.retryOnCondition(() -> {
            if (!this.avatarImageElement().getAttribute("style").contains("background-image")) {
                throw new IllegalStateException(String.format("Element doesn't have adequate style for background image: %s", this.avatarImageElement()));
            }
        }, () -> this.waitFor(500).milliseconds());
    }

    private String getLanguage() {
        String script = "return eXo.env.portal.language;";
        return ((JavascriptExecutor)this.getDriver()).executeScript(script, new Object[0]).toString();
    }
}

