/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.openqa.selenium.WebDriver;

public class UnifiedSearchPage
extends GenericPage {
    public UnifiedSearchPage(WebDriver driver) {
        super(driver);
    }

    public void clickFavoriteBtn() {
        ElementFacade favoritesBtnElement = this.favoritesBtnElement();
        favoritesBtnElement.waitUntilVisible();
        favoritesBtnElement.waitUntilClickable();
        favoritesBtnElement.click();
    }

    public void favoriteSearchedActivity(String activity) {
        this.getFavoriteIconSearchedActivity(activity).click();
        this.toolbarSearchButtonElement().hover();
    }

    public void goToTheSearchedActivity() {
        this.elementAccessToSearchedActivityElement().click();
    }

    public void goToTheSearchedApplication(String appName) {
        this.getApplicationSearchTitle(appName).click();
    }

    public void goToTheSearchedSpace(String space) {
        this.getSpaceSearchTitle(space).click();
    }

    public void isSearchedActivityTitleNotVisible(String activity) {
        Utils.retryOnCondition(() -> this.getActivitySearchTitle(activity).checkNotVisible(), () -> {
            this.waitFor(1).seconds();
            Utils.refreshPage();
        });
    }

    public void isSearchedActivityTitleVisible(String activity) {
        Utils.retryOnCondition(() -> this.getActivitySearchTitle(activity).checkVisible(), () -> {
            this.waitFor(1).seconds();
            Utils.refreshPage();
        });
    }

    public void isSearchedApplicationDescriptionVisible(String appDesc) {
        this.getApplicationSearchDescription(appDesc).assertVisible();
    }

    public void isSearchedApplicationNameVisible(String appName) {
        this.getApplicationSearchTitle(appName).assertVisible();
    }

    public void isSearchedApplicationPictureVisible() {
        this.elementApplicationSearchPictureElement().assertVisible();
    }

    public void isSearchedSpaceNameVisible(String space) {
        this.getSpaceSearchTitle(space).assertVisible();
    }

    public void isSearchedUserNameVisible(String user) {
        this.getUserSearchTitle(user).assertVisible();
    }

    public void openSearchApplication() {
        this.toolbarSearchButtonElement().click();
    }

    public void search(String text) {
        this.openSearchApplication();
        this.searchInputElement().setTextValue(text);
        this.waitFor(300).milliseconds();
        Utils.waitForLoading();
    }

    public void searchWithSelectedOptions(String text) {
        this.searchInputElement().setTextValue(text);
    }

    public void selectDropDown(String object) {
        this.shipFormAllElement().click();
        this.getObjectFromDropDown(object).click();
    }

    private ElementFacade elementAccessToSearchedActivityElement() {
        return this.findByXPathOrCSS("(//*[@class='v-list-item__content']//*[@class='v-list-item__title'])[1]");
    }

    private ElementFacade elementApplicationSearchPictureElement() {
        return this.findByXPathOrCSS("//*[@class='v-responsive v-image appImage']");
    }

    private ElementFacade favoritesBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class, 'searchConnectorsParent')]//i[contains(@class, 'fa-star')]//ancestor::*[contains(@class, 'v-chip--clickable')]");
    }

    private ElementFacade getActivitySearchTitle(String activity) {
        return this.findByXPathOrCSS(String.format("//*[contains(text(), '%s') or contains(@title, '%s')]//ancestor::*[contains(@class, 'searchCard')]", activity, activity));
    }

    private ElementFacade getApplicationSearchDescription(String appDesc) {
        return this.findByXPathOrCSS(String.format("//*[@title='%s']", appDesc));
    }

    private ElementFacade getApplicationSearchTitle(String appName) {
        return this.findByXPathOrCSS(String.format("//*[@title='%s']", appName));
    }

    private ElementFacade getFavoriteIconSearchedActivity(String activity) {
        return this.findByXPathOrCSS(String.format("(//*[contains(text(), '%s')]//ancestor::*[contains(@class, 'searchCard')]//*[contains(@class, 'fa-star')])[1]", activity));
    }

    private ElementFacade getObjectFromDropDown(String object) {
        return this.findByXPathOrCSS(String.format("//div[@class='v-input--selection-controls__input']//preceding::span[@class='subtitle-1'and contains(text(),'%s')]", object));
    }

    private ElementFacade getSpaceSearchTitle(String space) {
        return this.findByXPathOrCSS(String.format("//*[@id = 'spacesListBody']//*[contains(text(),'%s')]", space));
    }

    private ElementFacade getUserSearchTitle(String user) {
        return this.findByXPathOrCSS(String.format("//*[@id='searchDialog']//a[@title='%s']", user));
    }

    private TextBoxElementFacade searchInputElement() {
        return this.findTextBoxByXPathOrCSS("//*[@id='searchDialog']//input[@id='searchInput']");
    }

    private ElementFacade shipFormAllElement() {
        return this.findByXPathOrCSS("//span[@class='me-8' and contains(text(),'All')]");
    }

    private ElementFacade toolbarSearchButtonElement() {
        return this.findByXPathOrCSS("//*[@id='SearchApplication']//i[contains(@class,'fa-search')]//ancestor::button");
    }
}

