/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.pages;

import io.meeds.qa.ui.elements.ElementFacade;
import io.meeds.qa.ui.elements.TextBoxElementFacade;
import io.meeds.qa.ui.pages.GenericPage;
import io.meeds.qa.ui.utils.Utils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class UserProfilePage
extends GenericPage {
    private static final String PROFILE_CONTACT_INFORMATION_FORM_INPUTS = "(//*[contains(@class, 'profileContactInformationDrawer') and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerContent')]//input)";

    public UserProfilePage(WebDriver driver) {
        super(driver);
    }

    public void addWorkExperiences(String organization, String jobTitle, String jobDetails, String usedSkills) {
        ElementFacade addWorkExperiencesElement = this.addWorkExperiencesElement();
        addWorkExperiencesElement.click();
        this.waitForDrawerToOpen(".profileWorkExperiencesDrawer.v-navigation-drawer--open", true);
        if (!addWorkExperiencesElement.isCurrentlyVisible()) {
            this.closeWorkExperiencesDrawerBtnElement().click();
            this.editWorkExperiencesElement().click();
        }
        this.elementWorkExperiencesOrganizationElement().setTextValue(organization);
        this.elementWorkExperiencesJobTitleElement().setTextValue(jobTitle);
        this.elementWorkExperiencesJobDetailsElement().setTextValue(jobDetails);
        this.elementWorkExperiencesUsedSkillsElement().setTextValue(usedSkills);
        this.elementWorkExperiencesStartDateElement().click();
        this.elementWorkExperiencesStartDateGoToPreviousMonthElement().click();
        this.waitFor(200).milliseconds();
        ElementFacade elementWorkExperiencesStartDateFirstMonthDay = this.findByXPathOrCSS("(//*[contains(@class, 'profileWorkExperiencesDates')]//*[contains(@class, 'datePickerComponent')])[1]//*[contains(@class,'menuable__content__active')]//*[contains(@class,'v-date-picker-table')]//td//*[text() = '1']//ancestor::button");
        elementWorkExperiencesStartDateFirstMonthDay.click();
        this.waitFor(200).milliseconds();
        this.elementWorkExperiencesEndDateElement().click();
        this.elementWorkExperiencesEndDateTodayElement().click();
        this.saveWorkExperiencesElement().click();
        this.waitForDrawerToClose(".profileWorkExperiencesDrawer.v-navigation-drawer--open", true);
    }

    public void checkAvatarVisible() {
        this.profileAvatarElement().assertVisible();
    }

    public void checkCoverVisible() {
        this.profileCoverElement().assertVisible();
    }

    public void checkGainedCaurisVisible() {
        this.contactWalletOverviewRewardElement().assertVisible();
    }

    public void checkProfileAvatarUploaded() {
        this.uploadedProfileAvatarWidthElement().waitUntilVisible();
        Assert.assertEquals((Object)this.uploadedProfileAvatarElement().getAttribute("style"), (Object)"width: 860px;");
    }

    public void checkProfileContactCompanyVisible(String company) {
        this.profileContactInformationCompanyElement(company).waitUntilVisible();
    }

    public void checkProfileContactEmailVisible(String mail) {
        this.profileContactInformationEmailElement(mail).assertVisible();
    }

    public void checkProfileContactFullNameVisible(String title, String fullName) {
        this.profileContactInformationTitleElement(title).assertVisible();
        this.profileContactInformationFullnameElement(fullName).assertVisible();
    }

    public void checkProfileContactInstantMessagingVisible(String instantMessagingType, String instantMessaging) {
        this.profileContactInformationIMElement(instantMessagingType, instantMessaging).assertVisible();
    }

    public void checkProfileContactJobTitleVisible(String job) {
        this.profileJobElement(job).assertVisible();
    }

    public void checkProfileContactPhoneVisible(String phoneType, String phone) {
        this.profileContactInformationPhoneElement(phoneType, phone).assertVisible();
    }

    public void checkProfileContactUrlVisible(String profileUrl) {
        this.profileContactInformationURLElement(profileUrl).assertVisible();
    }

    public void checkWorkExperiencesSection(String jobTitle, String organization, String jobDetails, String usedSkills) {
        this.getJobDetailElement(jobTitle).assertVisible();
        this.getJobDetailElement(organization).assertVisible();
        this.getJobDetailElement(jobDetails).assertVisible();
        this.getJobDetailElement(usedSkills).assertVisible();
    }

    public void clickOnSendKudosBtn() {
        Utils.retryOnCondition(() -> {
            ElementFacade uiIconKudosElement = this.uiIconKudosElement();
            uiIconKudosElement.checkVisible();
            uiIconKudosElement.click();
            this.waitForDrawerToOpen(true);
            this.waitCKEditorLoading();
        });
    }

    public int getMyWeeklyPoint() {
        if (this.myWeeklyPointElement().isVisible()) {
            return Integer.valueOf(this.myWeeklyPointElement().getText());
        }
        return 0;
    }

    public void goToReceivedKudos() {
        this.contactReceivedKudosElement().click();
    }

    public void goToSentKudos() {
        Utils.refreshPage();
        this.contactSentKudosElement().click();
    }

    public void howToEarnPointsPageIsDisplayed() {
        this.howToEarnPointsPageElement().assertVisible();
    }

    public void receivedKudosSectionIsDisplayed(String kudosNumber) {
        this.getReceivedKudosNumber(kudosNumber).assertVisible();
    }

    public void checkNoSentKudos() {
        ElementFacade sentKudosNumber = this.getSentKudosNumber();
        if (sentKudosNumber.isCurrentlyVisible()) {
            String text = sentKudosNumber.getText();
            int count = Integer.parseInt(text.trim());
            Assertions.assertThat((int)count).isZero().as("Sent Kudos seems to be greated than 0: " + count, new Object[0]);
        }
    }

    public void checkNoReceivedKudos() {
        ElementFacade receivedKudosNumber = this.getReceivedKudosNumber();
        if (receivedKudosNumber.isCurrentlyVisible()) {
            String text = receivedKudosNumber.getText();
            int count = Integer.parseInt(text.trim());
            Assertions.assertThat((int)count).isZero().as("Received Kudos seems to be greated than 0: " + count, new Object[0]);
        }
    }

    public void receivedKudosUsersSectionIsDisplayed(String user) {
        this.getReceivedKudosUsers(user).assertVisible();
    }

    public void removeWorkExperience(String jobTitle) {
        this.editWorkExperiencesElement().click();
        this.openWorkExperience(jobTitle).click();
        this.removeWorkExperienceElement(jobTitle).click();
        JavascriptExecutor executor = (JavascriptExecutor)this.getDriver();
        executor.executeScript("arguments[0].click();", new Object[]{this.saveWorkExperiencesElement()});
        this.saveWorkExperiencesElement().waitUntilNotVisible();
    }

    public void selectInstantMessagingType(String instantMessagingType) {
        switch (instantMessagingType) {
            case "SKYPE": {
                this.contactIMTypeSelectButtonElement().selectByValue("skype");
                break;
            }
            case "MSN": {
                this.contactIMTypeSelectButtonElement().selectByValue("msn");
                break;
            }
            case "GITHUB": {
                this.contactIMTypeSelectButtonElement().selectByValue("github");
                break;
            }
            case "FACEBOOK": {
                this.contactIMTypeSelectButtonElement().selectByValue("facebook");
                break;
            }
            case "OTHER": {
                this.contactIMTypeSelectButtonElement().selectByValue("other");
                break;
            }
        }
    }

    public void selectPhoneType(String phoneType) {
        switch (phoneType) {
            case "WORK": {
                this.contactPhoneTypeSelectButtonElement().selectByValue("work");
                break;
            }
            case "HOME": {
                this.contactPhoneTypeSelectButtonElement().selectByValue("home");
                break;
            }
            case "OTHER": {
                this.contactPhoneTypeSelectButtonElement().selectByValue("other");
                break;
            }
        }
    }

    public void sentKudosSectionIsDisplayed(String kudosNumber) {
        this.getSentKudosNumber(kudosNumber).assertVisible();
    }

    public void sentKudosUsersSectionIsDisplayed(String user) {
        this.getSentKudosUsers(user).assertVisible();
    }

    public void updateBasicInformation(String firstName, String lastName, String email, String job) {
        this.contactInformationButtonElement().click();
        this.waitForDrawerToOpen();
        if (StringUtils.isNotBlank((CharSequence)firstName)) {
            ElementFacade contactFirstNameButtonElement = this.contactFirstNameButtonElement();
            this.$((WebElement)contactFirstNameButtonElement).clear();
            this.$((WebElement)contactFirstNameButtonElement).sendKeys(new CharSequence[]{firstName});
        }
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            ElementFacade contactLastNameButtonElement = this.contactLastNameButtonElement();
            this.$((WebElement)contactLastNameButtonElement).clear();
            this.$((WebElement)contactLastNameButtonElement).sendKeys(new CharSequence[]{lastName});
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            ElementFacade contactEmailButtonElement = this.contactEmailButtonElement();
            this.$((WebElement)contactEmailButtonElement).clear();
            this.$((WebElement)contactEmailButtonElement).sendKeys(new CharSequence[]{email});
        }
        if (StringUtils.isNotBlank((CharSequence)job)) {
            ElementFacade contactJobTitleButtonElement = this.contactJobTitleButtonElement();
            this.$((WebElement)contactJobTitleButtonElement).clear();
            this.$((WebElement)contactJobTitleButtonElement).sendKeys(new CharSequence[]{job});
        }
        this.contactEditSaveButtonElement().click();
        this.waitForDrawerToClose();
    }

    public void updateContactOtherInformations(String company, String phoneType, String phone, String instantMessagingType, String instantMessaging, String url) {
        ElementFacade contactInformationButtonElement = this.contactInformationButtonElement();
        contactInformationButtonElement.click();
        if (StringUtils.isNotBlank((CharSequence)company)) {
            ElementFacade contactCompanyTitleEditButtonElement = this.contactCompanyTitleEditButtonElement();
            contactCompanyTitleEditButtonElement.clear();
            contactCompanyTitleEditButtonElement.sendKeys(new CharSequence[]{company});
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            this.selectPhoneType(phoneType);
            ElementFacade contactPhoneTitleButtonElement = this.contactPhoneTitleButtonElement();
            contactPhoneTitleButtonElement.clear();
            contactPhoneTitleButtonElement.sendKeys(new CharSequence[]{phone});
        }
        if (StringUtils.isNotBlank((CharSequence)instantMessaging)) {
            this.selectInstantMessagingType(instantMessagingType);
            ElementFacade contactIMTitleButtonElement = this.contactIMTitleButtonElement();
            contactIMTitleButtonElement.clear();
            contactIMTitleButtonElement.sendKeys(new CharSequence[]{instantMessaging});
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            ElementFacade contactUrlTitleButtonElement = this.contactUrlTitleButtonElement();
            contactUrlTitleButtonElement.clear();
            contactUrlTitleButtonElement.sendKeys(new CharSequence[]{url});
        }
        this.contactEditSaveButtonElement().click();
    }

    public void uploadProfileAvatar(String fileName) {
        Actions builder = new Actions(this.getDriver());
        builder.moveToElement((WebElement)this.profileAvatarElement()).build().perform();
        this.uploadProfileAvatarBtnElement().waitUntilVisible();
        WebElement elem = this.getDriver().findElement(By.xpath((String)"//*[contains(@class,'changeAvatarButton')]//*[@class='v-input__prepend-outer']//button/following::input[1]"));
        String js = "arguments[0].style.height='auto'; arguments[0].style.visibility='visible';";
        ((JavascriptExecutor)this.getDriver()).executeScript(js, new Object[]{elem});
        this.upload(UPLOAD_DIRECTORY_PATH + fileName).fromLocalMachine().to(elem);
    }

    public void checkMyPointIncrease(int originalWeeklyPoint) {
        Utils.waitForPageLoading();
        Utils.retryOnCondition(() -> {
            int myWeeklyPoint = this.getMyWeeklyPoint();
            if (myWeeklyPoint <= originalWeeklyPoint) {
                throw new IllegalStateException(String.format("Weekly points %s wasn't increased, original points = %s", myWeeklyPoint, originalWeeklyPoint));
            }
        }, () -> {
            this.waitFor(2).seconds();
            Utils.refreshPage(true);
        }, 10L);
    }

    private ElementFacade addWorkExperiencesElement() {
        return this.findByXPathOrCSS("//*[@id='ProfileWorkExperience']//*[contains(@class,' fa-plus')]");
    }

    private ElementFacade closeWorkExperiencesDrawerBtnElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'drawerParent profileWorkExperiencesDrawer')]//*[contains(@class,'mdi mdi-close')]");
    }

    private ElementFacade contactCompanyTitleEditButtonElement() {
        return this.findByXPathOrCSS("(//*[@class='v-card__text d-flex positionField py-0']//input)[2]");
    }

    private ElementFacade contactEditSaveButtonElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'btn-primary')]");
    }

    private ElementFacade contactFirstNameButtonElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'profileContactInformationDrawer') and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerContent')]//input)[1]");
    }

    private ElementFacade contactLastNameButtonElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'profileContactInformationDrawer') and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerContent')]//input)[2]");
    }

    private ElementFacade contactEmailButtonElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'profileContactInformationDrawer') and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerContent')]//input)[3]");
    }

    private ElementFacade contactJobTitleButtonElement() {
        return this.findByXPathOrCSS("(//*[contains(@class, 'profileContactInformationDrawer') and contains(@class, 'v-navigation-drawer--open')]//*[contains(@class, 'drawerContent')]//input)[4]");
    }

    private ElementFacade contactIMTitleButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text d-flex positionField py-0'][8]/following::input[2]");
    }

    private ElementFacade contactIMTypeSelectButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text d-flex positionField py-0'][8]/following::select[2]");
    }

    private ElementFacade contactInformationButtonElement() {
        return this.findByXPathOrCSS("//*[@id='profileContactEditButton']");
    }

    private ElementFacade contactPhoneTitleButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text d-flex positionField py-0'][8]/following::input[1]");
    }

    private ElementFacade contactPhoneTypeSelectButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text d-flex positionField py-0'][8]/following::select[1]");
    }

    private ElementFacade contactReceivedKudosElement() {
        return this.findByXPathOrCSS("//*[@id='kudosOverviewCardsParent']//*[contains(@class, 'kudosOverviewCard')][1]//*[contains(@class, 'kudosOverviewCount')]");
    }

    private ElementFacade contactSentKudosElement() {
        return this.findByXPathOrCSS("//*[@id='kudosOverviewCardsParent']//*[contains(@class, 'kudosOverviewCard')][2]//*[contains(@class, 'kudosOverviewCount')]");
    }

    private ElementFacade contactUrlTitleButtonElement() {
        return this.findByXPathOrCSS("//*[@class='v-card__text d-flex positionField py-0'][8]/following::input[3]");
    }

    private ElementFacade contactWalletOverviewRewardElement() {
        return this.findByXPathOrCSS("(//*[@id='WalletOverview']//div)[8]");
    }

    private ElementFacade editWorkExperiencesElement() {
        return this.findByXPathOrCSS("//*[@id='ProfileWorkExperience']//*[contains(@class,'fa-edit')]");
    }

    private TextBoxElementFacade elementWorkExperiencesEndDateElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@id,'DatePicker')])[2]//input");
    }

    private TextBoxElementFacade elementWorkExperiencesEndDateTodayElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class, 'profileWorkExperiencesDates')]//*[contains(@class, 'datePickerComponent')])[2]//*[contains(@class,'menuable__content__active')]//*[contains(@class,'v-date-picker-table__current')]");
    }

    private TextBoxElementFacade elementWorkExperiencesJobDetailsElement() {
        return this.findTextBoxByXPathOrCSS("//*[@class='v-expansion-panel-content']//textarea");
    }

    private TextBoxElementFacade elementWorkExperiencesJobTitleElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-expansion-panel-content']//input)[2]");
    }

    private TextBoxElementFacade elementWorkExperiencesOrganizationElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-expansion-panel-content']//input)[1]");
    }

    private TextBoxElementFacade elementWorkExperiencesStartDateElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@id,'DatePicker')])[1]//input");
    }

    private TextBoxElementFacade elementWorkExperiencesStartDateGoToPreviousMonthElement() {
        return this.findTextBoxByXPathOrCSS("(//*[contains(@class, 'profileWorkExperiencesDates')]//*[contains(@class, 'datePickerComponent')])[1]//*[contains(@class,'menuable__content__active')]//*[contains(@class,'v-date-picker-header')]//button[1]");
    }

    private TextBoxElementFacade elementWorkExperiencesUsedSkillsElement() {
        return this.findTextBoxByXPathOrCSS("(//*[@class='v-expansion-panel-content']//input)[3]");
    }

    private ElementFacade getJobDetailElement(String jobDetails) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'v-timeline-item')]//*[contains (text(),'%s')]", jobDetails));
    }

    private ElementFacade getReceivedKudosNumber() {
        return this.findByXPathOrCSS("//*[@id='kudosOverviewCardsParent']//*[contains(@class,'kudosReceivedOverviewPeriod')]//*[contains(@class,'kudosOverviewCount')]");
    }

    private ElementFacade getReceivedKudosNumber(String kudosNumber) {
        return this.findByXPathOrCSS(String.format("//*[@id='kudosOverviewCardsParent']//*[contains(@class,'kudosReceivedOverviewPeriod')]//*[contains(@class,'kudosOverviewCount') and contains(text(),'%s')]", kudosNumber));
    }

    private ElementFacade getReceivedKudosUsers(String user) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'kudosOverviewDrawer')]//*[contains(text(),'%s')]", user));
    }

    private ElementFacade getSentKudosNumber() {
        return this.findByXPathOrCSS("//*[@id='kudosOverviewCardsParent']//*[contains(@class,'kudosSentOverviewPeriod')]//*[contains(@class,'kudosOverviewCount')]");
    }

    private ElementFacade getSentKudosNumber(String kudosNumber) {
        return this.findByXPathOrCSS(String.format("//*[@id='kudosOverviewCardsParent']//*[contains(@class,'kudosSentOverviewPeriod')]//*[contains(@class,'kudosOverviewCount') and contains(text(),'%s')]", kudosNumber));
    }

    private ElementFacade getSentKudosUsers(String user) {
        return this.findByXPathOrCSS(String.format("//*[contains(@class,'kudosOverviewDrawer')]//*[contains(text(),'%s')]", user));
    }

    private ElementFacade howToEarnPointsPageElement() {
        return this.findByXPathOrCSS("//*[@id='GamificationEarnPoints']//*[@id='uiHowEarnPoint']//*[contains(text(),'How can I earn points?')]");
    }

    private ElementFacade myWeeklyPointElement() {
        return this.findByXPathOrCSS("//div[@id='profile-stats-portlet']//span[contains(text(),'points') or contains(text(),'Points')]//preceding::span[1]");
    }

    private ElementFacade openWorkExperience(String jobTitle) {
        return this.findByXPathOrCSS(String.format("//button//*[@class='truncate-text']//*[contains(text(),'%s')]", jobTitle));
    }

    private ElementFacade profileAvatarElement() {
        return this.findByXPathOrCSS("//*[@id='profileAvatar']");
    }

    private ElementFacade profileContactInformationTitleElement(String title) {
        return this.findByXPathOrCSS("//*[@id='ProfileContactInformation']/parent::*//*[contains(text(), '" + title + "')]");
    }

    private ElementFacade profileContactInformationCompanyElement(String company) {
        return this.profileContactInformationElement("company", company);
    }

    private ElementFacade profileContactInformationEmailElement(String email) {
        return this.profileContactInformationElement("email", email);
    }

    private ElementFacade profileContactInformationFullnameElement(String fullName) {
        return this.profileContactInformationElement("fullName", fullName);
    }

    private ElementFacade profileContactInformationIMElement(String instantMessagingType, String instantMessaging) {
        return this.profileContactInformationElement("ims", instantMessagingType, instantMessaging);
    }

    private ElementFacade profileContactInformationPhoneElement(String phoneType, String phone) {
        return this.profileContactInformationElement("phones", phoneType, phone);
    }

    private ElementFacade profileContactInformationURLElement(String profileUrl) {
        return this.profileContactInformationElement("urls", profileUrl);
    }

    private ElementFacade profileJobElement(String jobTitle) {
        return this.profileContactInformationElement("position", jobTitle);
    }

    private ElementFacade profileContactInformationElement(String name, String value) {
        return this.findByXPathOrCSS(String.format("//*[@id='profileContactInformation-%s']/parent::*//*[contains(text(), '%s')]", name, value));
    }

    private ElementFacade profileContactInformationElement(String name, String multiFieldName, String multiFieldValue) {
        return this.findByXPathOrCSS(String.format("//*[@id='profileContactInformation-%s']/parent::*//*[contains(text(), '%s')]/parent::*//*[contains(text(), '%s')]", name, multiFieldValue, multiFieldName));
    }

    private ElementFacade profileCoverElement() {
        return this.findByXPathOrCSS("(//*[@id='ProfileHeader']//*[@class='v-image__image v-image__image--cover'])[1]");
    }

    private WebElement removeWorkExperienceElement(String jobTitle) {
        return this.findButtonByXPathOrCSS(String.format("//*[contains(text(),'%s')]//ancestor::*[contains(@class,'profileWorkExperiencesEditItem')]//*[contains(@class,'uiIconTrash')]//ancestor::button", jobTitle));
    }

    private ElementFacade saveWorkExperiencesElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'v-navigation-drawer--open')]//*[contains(@class,'drawerFooter')]//button[contains(@class,'btn-primary')]");
    }

    private ElementFacade uiIconKudosElement() {
        return this.findByXPathOrCSS("//*[contains(@class,'profileHeaderOtherActions')]//button//i[contains(@class,'uiIconKudos')]");
    }

    private ElementFacade uploadedProfileAvatarElement() {
        return this.findByXPathOrCSS("//*[@class='v-image v-responsive theme--light']//*[@class='v-responsive__content']");
    }

    private ElementFacade uploadedProfileAvatarWidthElement() {
        return this.findByXPathOrCSS("//*[@class='v-image v-responsive theme--light']//*[@class='v-responsive__content' and @style='width: 860px;']");
    }

    private ElementFacade uploadProfileAvatarBtnElement() {
        return this.findByXPathOrCSS("(//*[contains(@class,'v-input__icon--prepend')]//button)[1]");
    }
}

