/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.utils;

import io.meeds.qa.ui.utils.ExceptionLauncher;
import io.meeds.qa.ui.utils.IOMeedsTraceException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SystemTimeouts;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Utils {
    public static final String DEFAULT_SPACE_TEMPLATE = "000 Automatic Test Template";
    public static final int DEFAULT_WAIT_PAGE_LOADING = Integer.parseInt(System.getProperty("io.meeds.page.loading.wait", "10"));
    public static final int MAX_WAIT_RETRIES = Integer.parseInt(System.getProperty("io.meeds.retry.max", "3"));
    private static final Random RANDOM = new Random();
    public static final long DEFAULT_WAIT_FOR_TIMEOUT = SystemTimeouts.forTheCurrentTest().getWaitForTimeout();
    public static final long DEFAULT_IMPLICIT_WAIT_FOR_TIMEOUT = SystemTimeouts.forTheCurrentTest().getImplicitTimeout();
    public static final int SHORT_WAIT_DURATION_MILLIS = Integer.parseInt(System.getProperty("io.meeds.retry.wait.millis", "300"));
    public static final Duration SHORT_WAIT_DURATION = Duration.ofMillis(SHORT_WAIT_DURATION_MILLIS);

    public static String getRandomNumber() {
        char[] chars = "0123456789".toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            char c = chars[RANDOM.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getRandomString() {
        return Utils.getRandomString("");
    }

    public static String getRandomString(String base) {
        return Utils.getRandomString(base, 8);
    }

    public static String getRandomString(String base, int length) {
        char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        StringBuilder sb = new StringBuilder(base);
        for (int i = 0; i < length; ++i) {
            char c = chars[RANDOM.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isStaleElementException(Throwable e) {
        return e instanceof StaleElementReferenceException || e.getCause() != null && Utils.isStaleElementException(e.getCause());
    }

    public static void refreshPage() {
        Utils.refreshPage(true);
    }

    public static void refreshPage(boolean waitAppsLoading) {
        Serenity.getDriver().navigate().refresh();
        try {
            Serenity.getDriver().switchTo().alert().accept();
        }
        catch (NoAlertPresentException noAlertPresentException) {
            // empty catch block
        }
        if (waitAppsLoading) {
            Utils.waitForLoading();
        } else {
            Utils.waitForPageLoading();
        }
    }

    public static void retryOnCondition(Runnable task) {
        Utils.retryGetOnCondition(() -> Utils.runTask(task), null);
    }

    public static void retryOnCondition(Runnable task, long retry) {
        Utils.retryGetOnCondition(() -> Utils.runTask(task), null, retry);
    }

    public static void retryOnCondition(Runnable task, Runnable onError) {
        Utils.retryGetOnCondition(() -> Utils.runTask(task), onError);
    }

    public static void retryOnCondition(Runnable task, Runnable onError, long retry) {
        Utils.retryGetOnCondition(() -> Utils.runTask(task), onError, retry);
    }

    public static <T> T retryGetOnCondition(Supplier<T> supplier) {
        return Utils.retryGetOnCondition(supplier, null);
    }

    public static <T> T retryGetOnCondition(Supplier<T> supplier, long retry) {
        return Utils.retryGetOnCondition(supplier, null, retry);
    }

    public static <T> T retryGetOnCondition(Supplier<T> supplier, Runnable onError) {
        return Utils.retryGetOnCondition(supplier, onError, MAX_WAIT_RETRIES);
    }

    public static <T> T retryGetOnCondition(Supplier<T> supplier, Runnable onError, long retry) {
        long retryIndex = retry;
        while (true) {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                if (--retryIndex <= 0L) {
                    if (e instanceof RuntimeException) {
                        throw e;
                    }
                    throw new IllegalStateException("Unable to process on element after " + retry + " retries", e);
                }
                ExceptionLauncher.LOGGER.info("Error executing tentative {}/{}", new Object[]{retry - retryIndex, retry, new IOMeedsTraceException(e)});
                if (onError == null) continue;
                Utils.runTask(onError);
                if (retryIndex > 0L) continue;
                return null;
            }
            break;
        }
    }

    public static void switchToTabByIndex(WebDriver driver, int index) {
        ArrayList newTab = new ArrayList(driver.getWindowHandles());
        driver.switchTo().window((String)newTab.get(index));
    }

    public static void waitForInMillis(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void waitForLoading() {
        Utils.waitForLoading(DEFAULT_WAIT_PAGE_LOADING, true);
    }

    public static void waitForLoading(int loadingWait, boolean includeApps) {
        Utils.waitForLoading(loadingWait, includeApps, 1);
    }

    public static void waitForLoading(int loadingWait, boolean includeApps, int retries) {
        long start = System.currentTimeMillis();
        try {
            WebDriverWait wait = new WebDriverWait(Serenity.getDriver(), Duration.ofSeconds(loadingWait), Duration.ofMillis(SHORT_WAIT_DURATION_MILLIS));
            wait.until(webDriver -> ((JavascriptExecutor)webDriver).executeScript(Utils.getPageLoadingScript(includeApps), new Object[0]).toString().equals("true"));
        }
        catch (TimeoutException | JsonException e) {
            if (++retries > MAX_WAIT_RETRIES) {
                throw new IllegalStateException(String.format("Loading effect is still displayed on page after %s retries with timeout interval %s", retries - 1, loadingWait));
            }
            ExceptionLauncher.LOGGER.info("Loading wait timed out. Retry {}/{}. Refresh page to try again.", new Object[]{retries, MAX_WAIT_RETRIES, e});
            if (!includeApps) {
                Utils.refreshPage(false);
            }
            Utils.waitForLoading(loadingWait, includeApps, retries);
        }
        catch (Throwable e) {
            Utils.waitRemainingTime((long)loadingWait * 1000L, start);
        }
    }

    public static int getIndexFomName(String appSettingPosition) {
        return switch (appSettingPosition) {
            case "first" -> 1;
            case "second" -> 2;
            case "third" -> 3;
            case "fourth" -> 4;
            case "fifth" -> 5;
            case "sixth" -> 6;
            default -> throw new IllegalArgumentException("Unexpected value: " + appSettingPosition);
        };
    }

    public static void waitForPageLoading() {
    }

    public static void waitRemainingTime(long loadingWaitMilliseconds, long start) {
        long remainingTime = loadingWaitMilliseconds - (System.currentTimeMillis() - start);
        if (remainingTime > 10L) {
            ExceptionLauncher.LOGGER.debug("Waiting on element to refresh state within {}ms", (Object)remainingTime);
            Utils.waitForInMillis(remainingTime);
        } else {
            ExceptionLauncher.LOGGER.debug("Refresh element right away since the timeout is already elasped since {}ms", (Object)(-remainingTime));
        }
    }

    private static String getPageLoadingScript(boolean includeApps) {
        String pageLoadingScript = "return document.readyState === 'complete'";
        return includeApps ? pageLoadingScript + " && (!document.getElementById('TopbarLoadingContainer') || !!document.querySelector('.TopbarLoadingContainer.hidden')) && !document.querySelector('.v-card .v-progress-linear__indeterminate') && !document.querySelector('.v-navigation-drawer--open .v-progress-linear__indeterminate') && !document.querySelector('.v-card .v-progress-circular--indeterminate') && !document.querySelector('.v-navigation-drawer--open .v-progress-circular--indeterminate')" : pageLoadingScript;
    }

    private static Object runTask(Runnable task) {
        task.run();
        return null;
    }

    private Utils() {
    }
}

