/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;

public class SpaceFilter
implements Cloneable {
    private String spaceNameSearchCondition;
    private List<Space> includeSpaces;
    private List<Space> exclusions;
    private String remoteId;
    private String appId;
    private String template;
    private Set<SpaceMembershipStatus> status;
    private Sorting sorting;
    private boolean favorite;

    public SpaceFilter() {
        this.spaceNameSearchCondition = null;
    }

    public SpaceFilter(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public SpaceFilter(String remoteId, String appId) {
        this.appId = appId;
        this.remoteId = remoteId;
    }

    public List<Space> getIncludeSpaces() {
        return this.includeSpaces;
    }

    public void setIncludeSpaces(List<Space> includeSpaces) {
        this.includeSpaces = includeSpaces;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    public void setSpaceNameSearchCondition(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = Utils.processUnifiedSearchCondition(spaceNameSearchCondition);
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            this.sorting = new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC);
        }
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    public List<Space> getExclusions() {
        return this.exclusions;
    }

    public void addExclusions(List<Space> exclusions) {
        this.exclusions = exclusions;
    }

    public void setIsFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public SpaceFilter clone() {
        return new SpaceFilter(this.spaceNameSearchCondition, this.includeSpaces, this.exclusions, this.remoteId, this.appId, this.template, this.status, this.sorting, this.favorite);
    }

    @Generated
    public SpaceFilter(String spaceNameSearchCondition, List<Space> includeSpaces, List<Space> exclusions, String remoteId, String appId, String template, Set<SpaceMembershipStatus> status, Sorting sorting, boolean favorite) {
        this.spaceNameSearchCondition = spaceNameSearchCondition;
        this.includeSpaces = includeSpaces;
        this.exclusions = exclusions;
        this.remoteId = remoteId;
        this.appId = appId;
        this.template = template;
        this.status = status;
        this.sorting = sorting;
        this.favorite = favorite;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceFilter)) {
            return false;
        }
        SpaceFilter other = (SpaceFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFavorite() != other.isFavorite()) {
            return false;
        }
        String this$spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        String other$spaceNameSearchCondition = other.getSpaceNameSearchCondition();
        if (this$spaceNameSearchCondition == null ? other$spaceNameSearchCondition != null : !this$spaceNameSearchCondition.equals(other$spaceNameSearchCondition)) {
            return false;
        }
        List<Space> this$includeSpaces = this.getIncludeSpaces();
        List<Space> other$includeSpaces = other.getIncludeSpaces();
        if (this$includeSpaces == null ? other$includeSpaces != null : !((Object)this$includeSpaces).equals(other$includeSpaces)) {
            return false;
        }
        List<Space> this$exclusions = this.getExclusions();
        List<Space> other$exclusions = other.getExclusions();
        if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
            return false;
        }
        String this$remoteId = this.getRemoteId();
        String other$remoteId = other.getRemoteId();
        if (this$remoteId == null ? other$remoteId != null : !this$remoteId.equals(other$remoteId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Set<SpaceMembershipStatus> this$status = this.getStatus();
        Set<SpaceMembershipStatus> other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Sorting this$sorting = this.getSorting();
        Sorting other$sorting = other.getSorting();
        return !(this$sorting == null ? other$sorting != null : !((Object)this$sorting).equals(other$sorting));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpaceFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFavorite() ? 79 : 97);
        String $spaceNameSearchCondition = this.getSpaceNameSearchCondition();
        result = result * 59 + ($spaceNameSearchCondition == null ? 43 : $spaceNameSearchCondition.hashCode());
        List<Space> $includeSpaces = this.getIncludeSpaces();
        result = result * 59 + ($includeSpaces == null ? 43 : ((Object)$includeSpaces).hashCode());
        List<Space> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        String $remoteId = this.getRemoteId();
        result = result * 59 + ($remoteId == null ? 43 : $remoteId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Set<SpaceMembershipStatus> $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Sorting $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)$sorting).hashCode());
        return result;
    }

    @Generated
    public Set<SpaceMembershipStatus> getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(Set<SpaceMembershipStatus> status) {
        this.status = status;
    }
}

