/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.util.Arrays;

public class ExoSocialException
extends RuntimeException {
    private String messageKey;
    private String[] messageArguments;
    private String dataInput;

    public ExoSocialException(String msgKey) {
        this.messageKey = msgKey;
    }

    public ExoSocialException(String msgKey, String[] msgArgs) {
        this.messageKey = msgKey;
        this.messageArguments = Arrays.copyOf(msgArgs, msgArgs.length);
    }

    public ExoSocialException(String msgKey, String msg) {
        super(msg);
        this.messageKey = msgKey;
    }

    public ExoSocialException(String msgKey, Throwable cause) {
        super(cause);
        this.messageKey = msgKey;
    }

    public ExoSocialException(String msgKey, String msg, Throwable cause) {
        super(msg, cause);
        this.messageKey = msgKey;
    }

    public ExoSocialException(String msgKey, String[] msgArgs, String msg, Throwable cause) {
        super(msg, cause);
        this.messageKey = msgKey;
        this.messageArguments = Arrays.copyOf(msgArgs, msgArgs.length);
    }

    public final String getMessageKey() {
        return this.messageKey;
    }

    public final void setMessageKey(String msgKey) {
        this.messageKey = msgKey;
    }

    public final String[] getMessageArguments() {
        if (this.messageArguments != null) {
            return Arrays.copyOf(this.messageArguments, this.messageArguments.length);
        }
        return this.messageArguments;
    }

    public final void setMessageArguments(String[] msgArgs) {
        this.messageArguments = Arrays.copyOf(msgArgs, msgArgs.length);
    }

    public final String getDataInput() {
        return this.dataInput;
    }

    public final void setDataInput(String jsonDataInput) {
        this.dataInput = jsonDataInput;
    }
}

