/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.search.Sorting;

public class ProfileFilter
implements Cloneable {
    private String name;
    private String position;
    private String company;
    private String skills;
    private boolean searchEmail;
    private boolean searchUserName;
    private String all;
    private List<Identity> excludedIdentityList;
    private List<String> onlineRemoteIds;
    private Identity viewerIdentity;
    private String userType;
    private String enrollmentStatus;
    private Boolean isConnected;
    private List<String> remoteIds = null;
    private List<String> groupIds = null;
    private Sorting sorting;
    private Map<String, String> profileSettings;
    private List<String> spaceIdentityIds;
    private boolean isEnabled = true;
    private boolean wildcardSearch = true;

    public ProfileFilter() {
        this("");
    }

    public ProfileFilter(String query) {
        this.name = query;
        this.position = "";
        this.company = "";
        this.skills = "";
        this.excludedIdentityList = new ArrayList<Identity>();
        this.onlineRemoteIds = new ArrayList<String>();
        this.all = "";
        this.profileSettings = new HashMap<String, String>();
    }

    public void setSearchEmail(boolean searchEmail) {
        this.searchEmail = searchEmail;
    }

    public boolean isSearchEmail() {
        return this.searchEmail;
    }

    public void setSearchUserName(boolean searchUserName) {
        this.searchUserName = searchUserName;
    }

    public boolean isSearchUserName() {
        return this.searchUserName;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getSkills() {
        return this.skills;
    }

    public void setSkills(String skills) {
        this.skills = skills;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExcludedIdentityList(List<Identity> excludedIdentityList) {
        this.excludedIdentityList = excludedIdentityList;
    }

    public List<Identity> getExcludedIdentityList() {
        return this.excludedIdentityList;
    }

    public void setOnlineRemoteIds(List<String> onlineRemoteIds) {
        this.onlineRemoteIds = onlineRemoteIds;
    }

    public List<String> getOnlineRemoteIds() {
        return this.onlineRemoteIds;
    }

    public String getAll() {
        return this.all;
    }

    public void setAll(String all) {
        this.all = Utils.processUnifiedSearchCondition(all);
    }

    public boolean isSortingEmpty() {
        return this.sorting == null;
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            return new Sorting(Sorting.SortBy.LASTNAME, Sorting.OrderBy.ASC);
        }
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getEnrollmentStatus() {
        return this.enrollmentStatus;
    }

    public void setEnrollmentStatus(String enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public Boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(Boolean isConnected) {
        this.isConnected = isConnected;
    }

    public Identity getViewerIdentity() {
        return this.viewerIdentity;
    }

    public void setViewerIdentity(Identity currentIdentity) {
        if (currentIdentity == null && this.viewerIdentity != null && this.excludedIdentityList != null) {
            this.excludedIdentityList.remove(this.viewerIdentity);
        }
        this.viewerIdentity = currentIdentity;
        if (currentIdentity == null) {
            return;
        }
        if (this.excludedIdentityList == null) {
            this.excludedIdentityList = new ArrayList<Identity>();
        }
        if (!this.excludedIdentityList.contains(currentIdentity)) {
            this.excludedIdentityList.add(this.viewerIdentity);
        }
    }

    public void setRemoteIds(List<String> remoteIds) {
        this.remoteIds = remoteIds;
    }

    public List<String> getRemoteIds() {
        return this.remoteIds;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isWildcardSearch() {
        return this.wildcardSearch;
    }

    public void setWildcardSearch(boolean exactSearch) {
        this.wildcardSearch = exactSearch;
    }

    public Map<String, String> getProfileSettings() {
        return this.profileSettings;
    }

    public void setProfileSettings(Map<String, String> profileSettings) {
        this.profileSettings = profileSettings;
    }

    public List<String> getSpaceIdentityIds() {
        return this.spaceIdentityIds;
    }

    public void setSpaceIdentityIds(List<String> spaceIdentityIds) {
        this.spaceIdentityIds = spaceIdentityIds;
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.all) && StringUtils.isBlank((CharSequence)this.name) && StringUtils.isBlank((CharSequence)this.company) && StringUtils.isBlank((CharSequence)this.position) && StringUtils.isBlank((CharSequence)this.skills) && (this.profileSettings == null || this.profileSettings.isEmpty());
    }

    public ProfileFilter clone() throws CloneNotSupportedException {
        return (ProfileFilter)super.clone();
    }
}

