/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class DOMParserTest
extends TestCase {
    public void testCreateDOMTreeListOfString() {
        List<String> input = Arrays.asList("");
        Node rootNode = DOMParser.createDOMTree(input);
        DOMParserTest.assertEquals((int)1, (int)rootNode.getChildNodes().size());
        DOMParserTest.assertEquals((String)"", (String)((Node)rootNode.getChildNodes().get(0)).getContent());
        input = Arrays.asList("<a>", " b ", "</a>", "<i>", "e", "<h>", "</i>");
        rootNode = DOMParser.createDOMTree(input);
        DOMParserTest.assertEquals((int)5, (int)rootNode.getChildNodes().size());
        DOMParserTest.assertEquals((int)1, (int)((Node)rootNode.getChildNodes().get(0)).getChildNodes().size());
        DOMParserTest.assertEquals((String)"a", (String)((Node)rootNode.getChildNodes().get(0)).getTitle());
        DOMParserTest.assertEquals((String)" b ", (String)((Node)((Node)rootNode.getChildNodes().get(0)).getChildNodes().get(0)).getContent());
        DOMParserTest.assertEquals((String)"<i>", (String)((Node)rootNode.getChildNodes().get(1)).getContent());
        DOMParserTest.assertEquals((String)"e", (String)((Node)rootNode.getChildNodes().get(2)).getContent());
        DOMParserTest.assertEquals((String)"<h>", (String)((Node)rootNode.getChildNodes().get(3)).getContent());
        DOMParserTest.assertEquals((String)"</i>", (String)((Node)rootNode.getChildNodes().get(4)).getContent());
    }

    public void testCreateDOMTreeNodeListOfString() {
        List<String> input = Arrays.asList("");
        Node rootNode = new Node();
        DOMParser.createDOMTree((Node)rootNode, input);
        DOMParserTest.assertEquals((int)1, (int)rootNode.getChildNodes().size());
        DOMParserTest.assertEquals((String)"", (String)((Node)rootNode.getChildNodes().get(0)).getContent());
        rootNode = new Node();
        input = Arrays.asList("<a>", " b ", "</a>", "<i>", "e", "<h>", "</i>");
        DOMParser.createDOMTree((Node)rootNode, input);
        DOMParserTest.assertEquals((int)5, (int)rootNode.getChildNodes().size());
        DOMParserTest.assertEquals((int)1, (int)((Node)rootNode.getChildNodes().get(0)).getChildNodes().size());
        DOMParserTest.assertEquals((String)"a", (String)((Node)rootNode.getChildNodes().get(0)).getTitle());
        DOMParserTest.assertEquals((String)" b ", (String)((Node)((Node)rootNode.getChildNodes().get(0)).getChildNodes().get(0)).getContent());
        DOMParserTest.assertEquals((String)"<i>", (String)((Node)rootNode.getChildNodes().get(1)).getContent());
        DOMParserTest.assertEquals((String)"e", (String)((Node)rootNode.getChildNodes().get(2)).getContent());
        DOMParserTest.assertEquals((String)"<h>", (String)((Node)rootNode.getChildNodes().get(3)).getContent());
        DOMParserTest.assertEquals((String)"</i>", (String)((Node)rootNode.getChildNodes().get(4)).getContent());
    }

    public void testSpecialCase() {
        String input = "<b></b>";
        List xmlTokens = Tokenizer.tokenize((String)input);
        Node rootNode = DOMParser.createDOMTree((List)xmlTokens);
        DOMParserTest.assertEquals((String)"<b></b>", (String)rootNode.toString());
    }

    public void testBrCase() {
        String input = "<br></br>";
        List xmlTokens = Tokenizer.tokenize((String)input);
        Node rootNode = DOMParser.createDOMTree((List)xmlTokens);
        DOMParserTest.assertEquals((String)"<br />", (String)rootNode.toString());
    }
}

