/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.model;

import java.util.Iterator;
import junit.framework.TestCase;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;

public class AttributesTest
extends TestCase {
    public void testGetAndPut() {
        Attributes attributes = new Attributes();
        AttributesTest.assertEquals((String)"attributes.get(\"foo\") must be \"\"", (String)"", (String)attributes.get("foo"));
        attributes.put("foo", "bar");
        AttributesTest.assertEquals((String)"attributes.get(\"foo\") must return \"bar\"", (String)"bar", (String)attributes.get("foo"));
    }

    public void testRemove() {
        Attributes attributes = new Attributes();
        attributes.put("foo", "bar");
        attributes.remove("foo");
        AttributesTest.assertEquals((String)"attributes.get(\"foo\") must be empty string", (String)"", (String)attributes.get("foo"));
    }

    public void testHasKey() {
        Attributes attributes = new Attributes();
        AttributesTest.assertFalse((String)"attributes.hasKey(\"foo\") must return false", (boolean)attributes.hasKey("foo"));
        attributes.put("foo", "bar");
        AttributesTest.assertTrue((String)"attributes.hasKey(\"foo\") must return true", (boolean)attributes.hasKey("foo"));
    }

    public void testSize() {
        Attributes attributes = new Attributes();
        AttributesTest.assertEquals((String)"attributes.size() must return 0", (int)0, (int)attributes.size());
        attributes.put("foo", "bar");
        AttributesTest.assertEquals((String)"attributes.size() must return 1", (int)1, (int)attributes.size());
    }

    public void testGetKeyIterator() {
        Attributes attributes = new Attributes();
        Iterator keyIterator = attributes.getKeyIterator();
        AttributesTest.assertFalse((String)"keyIterator.hasNext() must return false", (boolean)keyIterator.hasNext());
        attributes.put("foo", "bar");
        keyIterator = attributes.getKeyIterator();
        AttributesTest.assertTrue((String)"keyIterator.hasNext() must return true", (boolean)keyIterator.hasNext());
        AttributesTest.assertEquals((String)"keyIterator.next() must be \"foo\"", (String)"foo", (String)((String)keyIterator.next()));
    }

    public void testToString() {
        Attributes attributes = new Attributes();
        AttributesTest.assertEquals((String)"attributes.xml() must be empty string", (String)"", (String)attributes.toString());
        attributes.put("foo", "bar");
        AttributesTest.assertEquals((String)"attributes.xml() must be foo=\"bar\"", (String)" foo=\"bar\"", (String)attributes.toString());
        attributes.put("foo", "bar1");
        AttributesTest.assertEquals((String)"attributes.xml() must be foo=\"bar1\"", (String)" foo=\"bar1\"", (String)attributes.toString());
        attributes.put("foo1", "bar1");
        AttributesTest.assertEquals((String)"attributes.xml() must be foo=\"bar1\" foo1=\"bar1\"", (String)" foo=\"bar1\" foo1=\"bar1\"", (String)attributes.toString());
    }
}

