/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.exoplatform.social.common.AbstractCommonTest;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.SocialServiceExecutor;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;

public class TestSocialServiceContext
extends AbstractCommonTest {
    private SocialServiceContext context;
    private SocialServiceExecutor serviceExecutor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createDefaultContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.context = null;
        this.serviceExecutor = null;
    }

    protected void createDefaultContext() {
        this.context = SocialServiceContextImpl.getInstance();
        this.serviceExecutor = this.context.getServiceExecutor();
    }

    protected SocialServiceContext getContext() {
        return this.context;
    }

    protected SocialServiceExecutor getExecutor() {
        return this.serviceExecutor;
    }

    protected void config() {
    }

    protected AsyncProcessor createAsyncProcessor() {
        return null;
    }

    protected ProcessContext serviceExecute(ProcessContext processContext) throws ExecutionException, InterruptedException, TimeoutException {
        return this.getExecutor().async(this.createAsyncProcessor(), processContext);
    }

    protected ProcessContext serviceExecute(ProcessContext processContext, AsyncCallback callback) throws ExecutionException, InterruptedException, TimeoutException {
        return this.getExecutor().async(this.createAsyncProcessor(), processContext, callback);
    }

    protected ProcessContext serviceProcess(ProcessContext processContext) throws ExecutionException, InterruptedException, TimeoutException {
        Future future = this.getExecutor().asyncProcess(this.createAsyncProcessor(), processContext);
        future.get(10L, TimeUnit.SECONDS);
        TestSocialServiceContext.assertTrue((boolean)future.isDone());
        return (ProcessContext)future.get();
    }
}

